/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geomaps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStaticMapRequest extends GeoMapsRequest implements
        ToCopyableBuilder<GetStaticMapRequest.Builder, GetStaticMapRequest> {
    private static final SdkField<String> BOUNDING_BOX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BoundingBox").getter(getter(GetStaticMapRequest::boundingBox)).setter(setter(Builder::boundingBox))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("bounding-box").build()).build();

    private static final SdkField<String> BOUNDED_POSITIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BoundedPositions").getter(getter(GetStaticMapRequest::boundedPositions))
            .setter(setter(Builder::boundedPositions))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("bounded-positions").build())
            .build();

    private static final SdkField<String> CENTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Center")
            .getter(getter(GetStaticMapRequest::center)).setter(setter(Builder::center))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("center").build()).build();

    private static final SdkField<String> COLOR_SCHEME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColorScheme").getter(getter(GetStaticMapRequest::colorSchemeAsString))
            .setter(setter(Builder::colorScheme))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("color-scheme").build()).build();

    private static final SdkField<String> COMPACT_OVERLAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompactOverlay").getter(getter(GetStaticMapRequest::compactOverlay))
            .setter(setter(Builder::compactOverlay))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("compact-overlay").build())
            .build();

    private static final SdkField<Boolean> CROP_LABELS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CropLabels").getter(getter(GetStaticMapRequest::cropLabels)).setter(setter(Builder::cropLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("crop-labels").build()).build();

    private static final SdkField<String> GEO_JSON_OVERLAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeoJsonOverlay").getter(getter(GetStaticMapRequest::geoJsonOverlay))
            .setter(setter(Builder::geoJsonOverlay))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("geojson-overlay").build())
            .build();

    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Height").getter(getter(GetStaticMapRequest::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("height").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(GetStaticMapRequest::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()).build();

    private static final SdkField<String> LABEL_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelSize").getter(getter(GetStaticMapRequest::labelSizeAsString)).setter(setter(Builder::labelSize))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("label-size").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Language").getter(getter(GetStaticMapRequest::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("lang").build()).build();

    private static final SdkField<Integer> PADDING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Padding").getter(getter(GetStaticMapRequest::padding)).setter(setter(Builder::padding))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("padding").build()).build();

    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoliticalView").getter(getter(GetStaticMapRequest::politicalView))
            .setter(setter(Builder::politicalView))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("political-view").build())
            .build();

    private static final SdkField<String> POINTS_OF_INTERESTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PointsOfInterests").getter(getter(GetStaticMapRequest::pointsOfInterestsAsString))
            .setter(setter(Builder::pointsOfInterests))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("pois").build()).build();

    private static final SdkField<Long> RADIUS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Radius")
            .getter(getter(GetStaticMapRequest::radius)).setter(setter(Builder::radius))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("radius").build()).build();

    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileName").getter(getter(GetStaticMapRequest::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FileName").build()).build();

    private static final SdkField<String> SCALE_BAR_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScaleBarUnit").getter(getter(GetStaticMapRequest::scaleBarUnitAsString))
            .setter(setter(Builder::scaleBarUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("scale-unit").build()).build();

    private static final SdkField<String> STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Style")
            .getter(getter(GetStaticMapRequest::styleAsString)).setter(setter(Builder::style))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("style").build()).build();

    private static final SdkField<Integer> WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Width")
            .getter(getter(GetStaticMapRequest::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("width").build()).build();

    private static final SdkField<Float> ZOOM_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Zoom")
            .getter(getter(GetStaticMapRequest::zoom)).setter(setter(Builder::zoom))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("zoom").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDING_BOX_FIELD,
            BOUNDED_POSITIONS_FIELD, CENTER_FIELD, COLOR_SCHEME_FIELD, COMPACT_OVERLAY_FIELD, CROP_LABELS_FIELD,
            GEO_JSON_OVERLAY_FIELD, HEIGHT_FIELD, KEY_FIELD, LABEL_SIZE_FIELD, LANGUAGE_FIELD, PADDING_FIELD,
            POLITICAL_VIEW_FIELD, POINTS_OF_INTERESTS_FIELD, RADIUS_FIELD, FILE_NAME_FIELD, SCALE_BAR_UNIT_FIELD, STYLE_FIELD,
            WIDTH_FIELD, ZOOM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String boundingBox;

    private final String boundedPositions;

    private final String center;

    private final String colorScheme;

    private final String compactOverlay;

    private final Boolean cropLabels;

    private final String geoJsonOverlay;

    private final Integer height;

    private final String key;

    private final String labelSize;

    private final String language;

    private final Integer padding;

    private final String politicalView;

    private final String pointsOfInterests;

    private final Long radius;

    private final String fileName;

    private final String scaleBarUnit;

    private final String style;

    private final Integer width;

    private final Float zoom;

    private GetStaticMapRequest(BuilderImpl builder) {
        super(builder);
        this.boundingBox = builder.boundingBox;
        this.boundedPositions = builder.boundedPositions;
        this.center = builder.center;
        this.colorScheme = builder.colorScheme;
        this.compactOverlay = builder.compactOverlay;
        this.cropLabels = builder.cropLabels;
        this.geoJsonOverlay = builder.geoJsonOverlay;
        this.height = builder.height;
        this.key = builder.key;
        this.labelSize = builder.labelSize;
        this.language = builder.language;
        this.padding = builder.padding;
        this.politicalView = builder.politicalView;
        this.pointsOfInterests = builder.pointsOfInterests;
        this.radius = builder.radius;
        this.fileName = builder.fileName;
        this.scaleBarUnit = builder.scaleBarUnit;
        this.style = builder.style;
        this.width = builder.width;
        this.zoom = builder.zoom;
    }

    /**
     * <p>
     * Takes in two pairs of coordinates, [Lon, Lat], denoting south-westerly and north-easterly edges of the image. The
     * underlying area becomes the view of the image.
     * </p>
     * <p>
     * Example: -123.17075,49.26959,-123.08125,49.31429
     * </p>
     * 
     * @return Takes in two pairs of coordinates, [Lon, Lat], denoting south-westerly and north-easterly edges of the
     *         image. The underlying area becomes the view of the image. </p>
     *         <p>
     *         Example: -123.17075,49.26959,-123.08125,49.31429
     */
    public final String boundingBox() {
        return boundingBox;
    }

    /**
     * <p>
     * Takes in two or more pair of coordinates, [Lon, Lat], with each coordinate separated by a comma. The API will
     * generate an image to encompass all of the provided coordinates.
     * </p>
     * <note>
     * <p>
     * Cannot be used with <code>Zoom</code> and or <code>Radius</code>
     * </p>
     * </note>
     * <p>
     * Example: 97.170451,78.039098,99.045536,27.176178
     * </p>
     * 
     * @return Takes in two or more pair of coordinates, [Lon, Lat], with each coordinate separated by a comma. The API
     *         will generate an image to encompass all of the provided coordinates. </p> <note>
     *         <p>
     *         Cannot be used with <code>Zoom</code> and or <code>Radius</code>
     *         </p>
     *         </note>
     *         <p>
     *         Example: 97.170451,78.039098,99.045536,27.176178
     */
    public final String boundedPositions() {
        return boundedPositions;
    }

    /**
     * <p>
     * Takes in a pair of coordinates, [Lon, Lat], which becomes the center point of the image. This parameter requires
     * that either zoom or radius is set.
     * </p>
     * <note>
     * <p>
     * Cannot be used with <code>Zoom</code> and or <code>Radius</code>
     * </p>
     * </note>
     * <p>
     * Example: 49.295,-123.108
     * </p>
     * 
     * @return Takes in a pair of coordinates, [Lon, Lat], which becomes the center point of the image. This parameter
     *         requires that either zoom or radius is set.</p> <note>
     *         <p>
     *         Cannot be used with <code>Zoom</code> and or <code>Radius</code>
     *         </p>
     *         </note>
     *         <p>
     *         Example: 49.295,-123.108
     */
    public final String center() {
        return center;
    }

    /**
     * <p>
     * Sets color tone for map, such as dark and light for specific map styles. It only applies to vector map styles,
     * such as Standard.
     * </p>
     * <p>
     * Example: <code>Light</code>
     * </p>
     * <p>
     * Default value: <code>Light</code>
     * </p>
     * <note>
     * <p>
     * Valid values for <code>ColorScheme</code> are case sensitive.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorScheme} will
     * return {@link ColorScheme#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #colorSchemeAsString}.
     * </p>
     * 
     * @return Sets color tone for map, such as dark and light for specific map styles. It only applies to vector map
     *         styles, such as Standard.</p>
     *         <p>
     *         Example: <code>Light</code>
     *         </p>
     *         <p>
     *         Default value: <code>Light</code>
     *         </p>
     *         <note>
     *         <p>
     *         Valid values for <code>ColorScheme</code> are case sensitive.
     *         </p>
     * @see ColorScheme
     */
    public final ColorScheme colorScheme() {
        return ColorScheme.fromValue(colorScheme);
    }

    /**
     * <p>
     * Sets color tone for map, such as dark and light for specific map styles. It only applies to vector map styles,
     * such as Standard.
     * </p>
     * <p>
     * Example: <code>Light</code>
     * </p>
     * <p>
     * Default value: <code>Light</code>
     * </p>
     * <note>
     * <p>
     * Valid values for <code>ColorScheme</code> are case sensitive.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorScheme} will
     * return {@link ColorScheme#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #colorSchemeAsString}.
     * </p>
     * 
     * @return Sets color tone for map, such as dark and light for specific map styles. It only applies to vector map
     *         styles, such as Standard.</p>
     *         <p>
     *         Example: <code>Light</code>
     *         </p>
     *         <p>
     *         Default value: <code>Light</code>
     *         </p>
     *         <note>
     *         <p>
     *         Valid values for <code>ColorScheme</code> are case sensitive.
     *         </p>
     * @see ColorScheme
     */
    public final String colorSchemeAsString() {
        return colorScheme;
    }

    /**
     * <p>
     * Takes in a string to draw geometries on the image. The input is a comma separated format as follows format:
     * <code>[Lon, Lat]</code>
     * </p>
     * <p>
     * Example:
     * <code>line:-122.407653,37.798557,-122.413291,37.802443;color=%23DD0000;width=7;outline-color=#00DD00;outline-width=5yd|point:-122.40572,37.80004;label=Fog Hill Market;size=large;text-color=%23DD0000;color=#EE4B2B</code>
     * </p>
     * <note>
     * <p>
     * Currently it supports the following geometry types: point, line and polygon. It does not support multiPoint ,
     * multiLine and multiPolgyon.
     * </p>
     * </note>
     * 
     * @return Takes in a string to draw geometries on the image. The input is a comma separated format as follows
     *         format: <code>[Lon, Lat]</code> </p>
     *         <p>
     *         Example:
     *         <code>line:-122.407653,37.798557,-122.413291,37.802443;color=%23DD0000;width=7;outline-color=#00DD00;outline-width=5yd|point:-122.40572,37.80004;label=Fog Hill Market;size=large;text-color=%23DD0000;color=#EE4B2B</code>
     *         </p>
     *         <note>
     *         <p>
     *         Currently it supports the following geometry types: point, line and polygon. It does not support
     *         multiPoint , multiLine and multiPolgyon.
     *         </p>
     */
    public final String compactOverlay() {
        return compactOverlay;
    }

    /**
     * <p>
     * It is a flag that takes in true or false. It prevents the labels that are on the edge of the image from being cut
     * or obscured.
     * </p>
     * 
     * @return It is a flag that takes in true or false. It prevents the labels that are on the edge of the image from
     *         being cut or obscured.
     */
    public final Boolean cropLabels() {
        return cropLabels;
    }

    /**
     * <p>
     * Takes in a string to draw geometries on the image. The input is a valid GeoJSON collection object.
     * </p>
     * <p>
     * Example:
     * <code>{"type":"FeatureCollection","features": [{"type":"Feature","geometry":{"type":"MultiPoint","coordinates": [[-90.076345,51.504107],[-0.074451,51.506892]]},"properties": {"color":"#00DD00"}}]}</code>
     * </p>
     * 
     * @return Takes in a string to draw geometries on the image. The input is a valid GeoJSON collection object. </p>
     *         <p>
     *         Example:
     *         <code>{"type":"FeatureCollection","features": [{"type":"Feature","geometry":{"type":"MultiPoint","coordinates": [[-90.076345,51.504107],[-0.074451,51.506892]]},"properties": {"color":"#00DD00"}}]}</code>
     */
    public final String geoJsonOverlay() {
        return geoJsonOverlay;
    }

    /**
     * <p>
     * Specifies the height of the map image.
     * </p>
     * 
     * @return Specifies the height of the map image.
     */
    public final Integer height() {
        return height;
    }

    /**
     * <p>
     * Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be provided
     * when making a request.
     * </p>
     * 
     * @return Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
     *         provided when making a request.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * Overrides the label size auto-calculated by <code>FileName</code>. Takes in one of the values -
     * <code>Small</code> or <code>Large</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #labelSize} will
     * return {@link LabelSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #labelSizeAsString}.
     * </p>
     * 
     * @return Overrides the label size auto-calculated by <code>FileName</code>. Takes in one of the values -
     *         <code>Small</code> or <code>Large</code>.
     * @see LabelSize
     */
    public final LabelSize labelSize() {
        return LabelSize.fromValue(labelSize);
    }

    /**
     * <p>
     * Overrides the label size auto-calculated by <code>FileName</code>. Takes in one of the values -
     * <code>Small</code> or <code>Large</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #labelSize} will
     * return {@link LabelSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #labelSizeAsString}.
     * </p>
     * 
     * @return Overrides the label size auto-calculated by <code>FileName</code>. Takes in one of the values -
     *         <code>Small</code> or <code>Large</code>.
     * @see LabelSize
     */
    public final String labelSizeAsString() {
        return labelSize;
    }

    /**
     * <p>
     * Specifies the language on the map labels using the BCP 47 language tag, limited to ISO 639-1 two-letter language
     * codes. If the specified language data isn't available for the map image, the labels will default to the regional
     * primary language.
     * </p>
     * <p>
     * Supported codes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ar</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>as</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>az</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>be</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>bg</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>bn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>bs</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ca</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cs</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>da</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>de</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>el</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>en</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>es</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>et</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>eu</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fi</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fo</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fr</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ga</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>gl</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>gn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>gu</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>he</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>hi</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>hr</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>hu</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>hy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>is</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>it</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ja</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ka</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kk</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>km</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ko</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ky</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>lt</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>lv</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mk</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ml</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mr</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ms</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mt</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>my</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>nl</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>no</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>or</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pa</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pl</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pt</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ro</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ru</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sk</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sl</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sq</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sr</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sv</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ta</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>te</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>th</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tr</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>uk</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>uz</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vi</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies the language on the map labels using the BCP 47 language tag, limited to ISO 639-1 two-letter
     *         language codes. If the specified language data isn't available for the map image, the labels will default
     *         to the regional primary language.</p>
     *         <p>
     *         Supported codes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ar</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>as</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>az</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>be</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>bg</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>bn</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>bs</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ca</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cs</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>da</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>de</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>el</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>en</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>es</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>et</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>eu</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fi</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fo</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fr</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ga</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>gl</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>gn</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>gu</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>he</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>hi</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>hr</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>hu</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>hy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>is</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>it</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ja</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ka</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kk</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>km</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kn</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ko</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ky</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>lt</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>lv</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mk</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ml</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mr</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ms</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mt</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>my</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>nl</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>no</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>or</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pa</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pl</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pt</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ro</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ru</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sk</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sl</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sq</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sr</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sv</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ta</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>te</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>th</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tr</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>uk</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>uz</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vi</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code>
     *         </p>
     *         </li>
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * Applies additional space (in pixels) around overlay feature to prevent them from being cut or obscured.
     * </p>
     * <note>
     * <p>
     * Value for max and min is determined by:
     * </p>
     * <p>
     * Min: <code>1</code>
     * </p>
     * <p>
     * Max: <code>min(height, width)/4</code>
     * </p>
     * </note>
     * <p>
     * Example: <code>100</code>
     * </p>
     * 
     * @return Applies additional space (in pixels) around overlay feature to prevent them from being cut or
     *         obscured.</p> <note>
     *         <p>
     *         Value for max and min is determined by:
     *         </p>
     *         <p>
     *         Min: <code>1</code>
     *         </p>
     *         <p>
     *         Max: <code>min(height, width)/4</code>
     *         </p>
     *         </note>
     *         <p>
     *         Example: <code>100</code>
     */
    public final Integer padding() {
        return padding;
    }

    /**
     * <p>
     * Specifies the political view, using ISO 3166-2 or ISO 3166-3 country code format.
     * </p>
     * <p>
     * The following political views are currently supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ARG</code>: Argentina's view on the Southern Patagonian Ice Field and Tierra Del Fuego, including the
     * Falkland Islands, South Georgia, and South Sandwich Islands
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EGY</code>: Egypt's view on Bir Tawil
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IND</code>: India's view on Gilgit-Baltistan
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KEN</code>: Kenya's view on the Ilemi Triangle
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MAR</code>: Morocco's view on Western Sahara
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUS</code>: Russia's view on Crimea
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SDN</code>: Sudan's view on the Halaib Triangle
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SRB</code>: Serbia's view on Kosovo, Vukovar, and Sarengrad Islands
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUR</code>: Suriname's view on the Courantyne Headwaters and Lawa Headwaters
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SYR</code>: Syria's view on the Golan Heights
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TUR</code>: Turkey's view on Cyprus and Northern Cyprus
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TZA</code>: Tanzania's view on Lake Malawi
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>URY</code>: Uruguay's view on Rincon de Artigas
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VNM</code>: Vietnam's view on the Paracel Islands and Spratly Islands
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies the political view, using ISO 3166-2 or ISO 3166-3 country code format.</p>
     *         <p>
     *         The following political views are currently supported:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ARG</code>: Argentina's view on the Southern Patagonian Ice Field and Tierra Del Fuego, including
     *         the Falkland Islands, South Georgia, and South Sandwich Islands
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EGY</code>: Egypt's view on Bir Tawil
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IND</code>: India's view on Gilgit-Baltistan
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KEN</code>: Kenya's view on the Ilemi Triangle
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MAR</code>: Morocco's view on Western Sahara
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUS</code>: Russia's view on Crimea
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SDN</code>: Sudan's view on the Halaib Triangle
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SRB</code>: Serbia's view on Kosovo, Vukovar, and Sarengrad Islands
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUR</code>: Suriname's view on the Courantyne Headwaters and Lawa Headwaters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SYR</code>: Syria's view on the Golan Heights
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TUR</code>: Turkey's view on Cyprus and Northern Cyprus
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TZA</code>: Tanzania's view on Lake Malawi
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>URY</code>: Uruguay's view on Rincon de Artigas
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VNM</code>: Vietnam's view on the Paracel Islands and Spratly Islands
     *         </p>
     *         </li>
     */
    public final String politicalView() {
        return politicalView;
    }

    /**
     * <p>
     * Determines if the result image will display icons representing points of interest on the map.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pointsOfInterests}
     * will return {@link MapFeatureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #pointsOfInterestsAsString}.
     * </p>
     * 
     * @return Determines if the result image will display icons representing points of interest on the map.
     * @see MapFeatureMode
     */
    public final MapFeatureMode pointsOfInterests() {
        return MapFeatureMode.fromValue(pointsOfInterests);
    }

    /**
     * <p>
     * Determines if the result image will display icons representing points of interest on the map.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pointsOfInterests}
     * will return {@link MapFeatureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #pointsOfInterestsAsString}.
     * </p>
     * 
     * @return Determines if the result image will display icons representing points of interest on the map.
     * @see MapFeatureMode
     */
    public final String pointsOfInterestsAsString() {
        return pointsOfInterests;
    }

    /**
     * <p>
     * Used with center parameter, it specifies the zoom of the image where you can control it on a granular level.
     * Takes in any value <code>&gt;= 1</code>.
     * </p>
     * <p>
     * Example: <code>1500</code>
     * </p>
     * <note>
     * <p>
     * Cannot be used with <code>Zoom</code>.
     * </p>
     * </note>
     * <p>
     * <b>Unit</b>: <code>Meters</code>
     * </p>
     * <p/>
     * 
     * @return Used with center parameter, it specifies the zoom of the image where you can control it on a granular
     *         level. Takes in any value <code>&gt;= 1</code>.
     *         </p>
     *         <p>
     *         Example: <code>1500</code>
     *         </p>
     *         <note>
     *         <p>
     *         Cannot be used with <code>Zoom</code>.
     *         </p>
     *         </note>
     *         <p>
     *         <b>Unit</b>: <code>Meters</code>
     *         </p>
     */
    public final Long radius() {
        return radius;
    }

    /**
     * <p>
     * The map scaling parameter to size the image, icons, and labels. It follows the pattern of
     * <code>^map(@2x)?$</code>.
     * </p>
     * <p>
     * Example: <code>map, map@2x</code>
     * </p>
     * 
     * @return The map scaling parameter to size the image, icons, and labels. It follows the pattern of
     *         <code>^map(@2x)?$</code>.</p>
     *         <p>
     *         Example: <code>map, map@2x</code>
     */
    public final String fileName() {
        return fileName;
    }

    /**
     * <p>
     * Displays a scale on the bottom right of the map image with the unit specified in the input.
     * </p>
     * <p>
     * Example: <code>KilometersMiles, Miles, Kilometers, MilesKilometers</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scaleBarUnit} will
     * return {@link ScaleBarUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scaleBarUnitAsString}.
     * </p>
     * 
     * @return Displays a scale on the bottom right of the map image with the unit specified in the input. </p>
     *         <p>
     *         Example: <code>KilometersMiles, Miles, Kilometers, MilesKilometers</code>
     * @see ScaleBarUnit
     */
    public final ScaleBarUnit scaleBarUnit() {
        return ScaleBarUnit.fromValue(scaleBarUnit);
    }

    /**
     * <p>
     * Displays a scale on the bottom right of the map image with the unit specified in the input.
     * </p>
     * <p>
     * Example: <code>KilometersMiles, Miles, Kilometers, MilesKilometers</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scaleBarUnit} will
     * return {@link ScaleBarUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scaleBarUnitAsString}.
     * </p>
     * 
     * @return Displays a scale on the bottom right of the map image with the unit specified in the input. </p>
     *         <p>
     *         Example: <code>KilometersMiles, Miles, Kilometers, MilesKilometers</code>
     * @see ScaleBarUnit
     */
    public final String scaleBarUnitAsString() {
        return scaleBarUnit;
    }

    /**
     * <p>
     * <code>Style</code> specifies the desired map style.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #style} will return
     * {@link StaticMapStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #styleAsString}.
     * </p>
     * 
     * @return <code>Style</code> specifies the desired map style.
     * @see StaticMapStyle
     */
    public final StaticMapStyle style() {
        return StaticMapStyle.fromValue(style);
    }

    /**
     * <p>
     * <code>Style</code> specifies the desired map style.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #style} will return
     * {@link StaticMapStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #styleAsString}.
     * </p>
     * 
     * @return <code>Style</code> specifies the desired map style.
     * @see StaticMapStyle
     */
    public final String styleAsString() {
        return style;
    }

    /**
     * <p>
     * Specifies the width of the map image.
     * </p>
     * 
     * @return Specifies the width of the map image.
     */
    public final Integer width() {
        return width;
    }

    /**
     * <p>
     * Specifies the zoom level of the map image.
     * </p>
     * <note>
     * <p>
     * Cannot be used with <code>Radius</code>.
     * </p>
     * </note>
     * 
     * @return Specifies the zoom level of the map image.</p> <note>
     *         <p>
     *         Cannot be used with <code>Radius</code>.
     *         </p>
     */
    public final Float zoom() {
        return zoom;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(boundedPositions());
        hashCode = 31 * hashCode + Objects.hashCode(center());
        hashCode = 31 * hashCode + Objects.hashCode(colorSchemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(compactOverlay());
        hashCode = 31 * hashCode + Objects.hashCode(cropLabels());
        hashCode = 31 * hashCode + Objects.hashCode(geoJsonOverlay());
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(labelSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(padding());
        hashCode = 31 * hashCode + Objects.hashCode(politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(pointsOfInterestsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(radius());
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        hashCode = 31 * hashCode + Objects.hashCode(scaleBarUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(styleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(width());
        hashCode = 31 * hashCode + Objects.hashCode(zoom());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStaticMapRequest)) {
            return false;
        }
        GetStaticMapRequest other = (GetStaticMapRequest) obj;
        return Objects.equals(boundingBox(), other.boundingBox()) && Objects.equals(boundedPositions(), other.boundedPositions())
                && Objects.equals(center(), other.center()) && Objects.equals(colorSchemeAsString(), other.colorSchemeAsString())
                && Objects.equals(compactOverlay(), other.compactOverlay()) && Objects.equals(cropLabels(), other.cropLabels())
                && Objects.equals(geoJsonOverlay(), other.geoJsonOverlay()) && Objects.equals(height(), other.height())
                && Objects.equals(key(), other.key()) && Objects.equals(labelSizeAsString(), other.labelSizeAsString())
                && Objects.equals(language(), other.language()) && Objects.equals(padding(), other.padding())
                && Objects.equals(politicalView(), other.politicalView())
                && Objects.equals(pointsOfInterestsAsString(), other.pointsOfInterestsAsString())
                && Objects.equals(radius(), other.radius()) && Objects.equals(fileName(), other.fileName())
                && Objects.equals(scaleBarUnitAsString(), other.scaleBarUnitAsString())
                && Objects.equals(styleAsString(), other.styleAsString()) && Objects.equals(width(), other.width())
                && Objects.equals(zoom(), other.zoom());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStaticMapRequest")
                .add("BoundingBox", boundingBox() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BoundedPositions", boundedPositions() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Center", center() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ColorScheme", colorSchemeAsString())
                .add("CompactOverlay", compactOverlay() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CropLabels", cropLabels())
                .add("GeoJsonOverlay", geoJsonOverlay() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Height", height() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Key", key() == null ? null : "*** Sensitive Data Redacted ***").add("LabelSize", labelSizeAsString())
                .add("Language", language()).add("Padding", padding() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PoliticalView", politicalView() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PointsOfInterests", pointsOfInterestsAsString())
                .add("Radius", radius() == null ? null : "*** Sensitive Data Redacted ***").add("FileName", fileName())
                .add("ScaleBarUnit", scaleBarUnitAsString()).add("Style", styleAsString())
                .add("Width", width() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Zoom", zoom() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BoundingBox":
            return Optional.ofNullable(clazz.cast(boundingBox()));
        case "BoundedPositions":
            return Optional.ofNullable(clazz.cast(boundedPositions()));
        case "Center":
            return Optional.ofNullable(clazz.cast(center()));
        case "ColorScheme":
            return Optional.ofNullable(clazz.cast(colorSchemeAsString()));
        case "CompactOverlay":
            return Optional.ofNullable(clazz.cast(compactOverlay()));
        case "CropLabels":
            return Optional.ofNullable(clazz.cast(cropLabels()));
        case "GeoJsonOverlay":
            return Optional.ofNullable(clazz.cast(geoJsonOverlay()));
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "LabelSize":
            return Optional.ofNullable(clazz.cast(labelSizeAsString()));
        case "Language":
            return Optional.ofNullable(clazz.cast(language()));
        case "Padding":
            return Optional.ofNullable(clazz.cast(padding()));
        case "PoliticalView":
            return Optional.ofNullable(clazz.cast(politicalView()));
        case "PointsOfInterests":
            return Optional.ofNullable(clazz.cast(pointsOfInterestsAsString()));
        case "Radius":
            return Optional.ofNullable(clazz.cast(radius()));
        case "FileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        case "ScaleBarUnit":
            return Optional.ofNullable(clazz.cast(scaleBarUnitAsString()));
        case "Style":
            return Optional.ofNullable(clazz.cast(styleAsString()));
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        case "Zoom":
            return Optional.ofNullable(clazz.cast(zoom()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bounding-box", BOUNDING_BOX_FIELD);
        map.put("bounded-positions", BOUNDED_POSITIONS_FIELD);
        map.put("center", CENTER_FIELD);
        map.put("color-scheme", COLOR_SCHEME_FIELD);
        map.put("compact-overlay", COMPACT_OVERLAY_FIELD);
        map.put("crop-labels", CROP_LABELS_FIELD);
        map.put("geojson-overlay", GEO_JSON_OVERLAY_FIELD);
        map.put("height", HEIGHT_FIELD);
        map.put("key", KEY_FIELD);
        map.put("label-size", LABEL_SIZE_FIELD);
        map.put("lang", LANGUAGE_FIELD);
        map.put("padding", PADDING_FIELD);
        map.put("political-view", POLITICAL_VIEW_FIELD);
        map.put("pois", POINTS_OF_INTERESTS_FIELD);
        map.put("radius", RADIUS_FIELD);
        map.put("FileName", FILE_NAME_FIELD);
        map.put("scale-unit", SCALE_BAR_UNIT_FIELD);
        map.put("style", STYLE_FIELD);
        map.put("width", WIDTH_FIELD);
        map.put("zoom", ZOOM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStaticMapRequest, T> g) {
        return obj -> g.apply((GetStaticMapRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GeoMapsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetStaticMapRequest> {
        /**
         * <p>
         * Takes in two pairs of coordinates, [Lon, Lat], denoting south-westerly and north-easterly edges of the image.
         * The underlying area becomes the view of the image.
         * </p>
         * <p>
         * Example: -123.17075,49.26959,-123.08125,49.31429
         * </p>
         * 
         * @param boundingBox
         *        Takes in two pairs of coordinates, [Lon, Lat], denoting south-westerly and north-easterly edges of the
         *        image. The underlying area becomes the view of the image. </p>
         *        <p>
         *        Example: -123.17075,49.26959,-123.08125,49.31429
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(String boundingBox);

        /**
         * <p>
         * Takes in two or more pair of coordinates, [Lon, Lat], with each coordinate separated by a comma. The API will
         * generate an image to encompass all of the provided coordinates.
         * </p>
         * <note>
         * <p>
         * Cannot be used with <code>Zoom</code> and or <code>Radius</code>
         * </p>
         * </note>
         * <p>
         * Example: 97.170451,78.039098,99.045536,27.176178
         * </p>
         * 
         * @param boundedPositions
         *        Takes in two or more pair of coordinates, [Lon, Lat], with each coordinate separated by a comma. The
         *        API will generate an image to encompass all of the provided coordinates. </p> <note>
         *        <p>
         *        Cannot be used with <code>Zoom</code> and or <code>Radius</code>
         *        </p>
         *        </note>
         *        <p>
         *        Example: 97.170451,78.039098,99.045536,27.176178
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundedPositions(String boundedPositions);

        /**
         * <p>
         * Takes in a pair of coordinates, [Lon, Lat], which becomes the center point of the image. This parameter
         * requires that either zoom or radius is set.
         * </p>
         * <note>
         * <p>
         * Cannot be used with <code>Zoom</code> and or <code>Radius</code>
         * </p>
         * </note>
         * <p>
         * Example: 49.295,-123.108
         * </p>
         * 
         * @param center
         *        Takes in a pair of coordinates, [Lon, Lat], which becomes the center point of the image. This
         *        parameter requires that either zoom or radius is set.</p> <note>
         *        <p>
         *        Cannot be used with <code>Zoom</code> and or <code>Radius</code>
         *        </p>
         *        </note>
         *        <p>
         *        Example: 49.295,-123.108
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder center(String center);

        /**
         * <p>
         * Sets color tone for map, such as dark and light for specific map styles. It only applies to vector map
         * styles, such as Standard.
         * </p>
         * <p>
         * Example: <code>Light</code>
         * </p>
         * <p>
         * Default value: <code>Light</code>
         * </p>
         * <note>
         * <p>
         * Valid values for <code>ColorScheme</code> are case sensitive.
         * </p>
         * </note>
         * 
         * @param colorScheme
         *        Sets color tone for map, such as dark and light for specific map styles. It only applies to vector map
         *        styles, such as Standard.</p>
         *        <p>
         *        Example: <code>Light</code>
         *        </p>
         *        <p>
         *        Default value: <code>Light</code>
         *        </p>
         *        <note>
         *        <p>
         *        Valid values for <code>ColorScheme</code> are case sensitive.
         *        </p>
         * @see ColorScheme
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorScheme
         */
        Builder colorScheme(String colorScheme);

        /**
         * <p>
         * Sets color tone for map, such as dark and light for specific map styles. It only applies to vector map
         * styles, such as Standard.
         * </p>
         * <p>
         * Example: <code>Light</code>
         * </p>
         * <p>
         * Default value: <code>Light</code>
         * </p>
         * <note>
         * <p>
         * Valid values for <code>ColorScheme</code> are case sensitive.
         * </p>
         * </note>
         * 
         * @param colorScheme
         *        Sets color tone for map, such as dark and light for specific map styles. It only applies to vector map
         *        styles, such as Standard.</p>
         *        <p>
         *        Example: <code>Light</code>
         *        </p>
         *        <p>
         *        Default value: <code>Light</code>
         *        </p>
         *        <note>
         *        <p>
         *        Valid values for <code>ColorScheme</code> are case sensitive.
         *        </p>
         * @see ColorScheme
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorScheme
         */
        Builder colorScheme(ColorScheme colorScheme);

        /**
         * <p>
         * Takes in a string to draw geometries on the image. The input is a comma separated format as follows format:
         * <code>[Lon, Lat]</code>
         * </p>
         * <p>
         * Example:
         * <code>line:-122.407653,37.798557,-122.413291,37.802443;color=%23DD0000;width=7;outline-color=#00DD00;outline-width=5yd|point:-122.40572,37.80004;label=Fog Hill Market;size=large;text-color=%23DD0000;color=#EE4B2B</code>
         * </p>
         * <note>
         * <p>
         * Currently it supports the following geometry types: point, line and polygon. It does not support multiPoint ,
         * multiLine and multiPolgyon.
         * </p>
         * </note>
         * 
         * @param compactOverlay
         *        Takes in a string to draw geometries on the image. The input is a comma separated format as follows
         *        format: <code>[Lon, Lat]</code> </p>
         *        <p>
         *        Example:
         *        <code>line:-122.407653,37.798557,-122.413291,37.802443;color=%23DD0000;width=7;outline-color=#00DD00;outline-width=5yd|point:-122.40572,37.80004;label=Fog Hill Market;size=large;text-color=%23DD0000;color=#EE4B2B</code>
         *        </p>
         *        <note>
         *        <p>
         *        Currently it supports the following geometry types: point, line and polygon. It does not support
         *        multiPoint , multiLine and multiPolgyon.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compactOverlay(String compactOverlay);

        /**
         * <p>
         * It is a flag that takes in true or false. It prevents the labels that are on the edge of the image from being
         * cut or obscured.
         * </p>
         * 
         * @param cropLabels
         *        It is a flag that takes in true or false. It prevents the labels that are on the edge of the image
         *        from being cut or obscured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cropLabels(Boolean cropLabels);

        /**
         * <p>
         * Takes in a string to draw geometries on the image. The input is a valid GeoJSON collection object.
         * </p>
         * <p>
         * Example:
         * <code>{"type":"FeatureCollection","features": [{"type":"Feature","geometry":{"type":"MultiPoint","coordinates": [[-90.076345,51.504107],[-0.074451,51.506892]]},"properties": {"color":"#00DD00"}}]}</code>
         * </p>
         * 
         * @param geoJsonOverlay
         *        Takes in a string to draw geometries on the image. The input is a valid GeoJSON collection object.
         *        </p>
         *        <p>
         *        Example:
         *        <code>{"type":"FeatureCollection","features": [{"type":"Feature","geometry":{"type":"MultiPoint","coordinates": [[-90.076345,51.504107],[-0.074451,51.506892]]},"properties": {"color":"#00DD00"}}]}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoJsonOverlay(String geoJsonOverlay);

        /**
         * <p>
         * Specifies the height of the map image.
         * </p>
         * 
         * @param height
         *        Specifies the height of the map image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Integer height);

        /**
         * <p>
         * Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
         * provided when making a request.
         * </p>
         * 
         * @param key
         *        Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
         *        provided when making a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * Overrides the label size auto-calculated by <code>FileName</code>. Takes in one of the values -
         * <code>Small</code> or <code>Large</code>.
         * </p>
         * 
         * @param labelSize
         *        Overrides the label size auto-calculated by <code>FileName</code>. Takes in one of the values -
         *        <code>Small</code> or <code>Large</code>.
         * @see LabelSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelSize
         */
        Builder labelSize(String labelSize);

        /**
         * <p>
         * Overrides the label size auto-calculated by <code>FileName</code>. Takes in one of the values -
         * <code>Small</code> or <code>Large</code>.
         * </p>
         * 
         * @param labelSize
         *        Overrides the label size auto-calculated by <code>FileName</code>. Takes in one of the values -
         *        <code>Small</code> or <code>Large</code>.
         * @see LabelSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelSize
         */
        Builder labelSize(LabelSize labelSize);

        /**
         * <p>
         * Specifies the language on the map labels using the BCP 47 language tag, limited to ISO 639-1 two-letter
         * language codes. If the specified language data isn't available for the map image, the labels will default to
         * the regional primary language.
         * </p>
         * <p>
         * Supported codes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ar</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>as</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>az</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>be</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>bg</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>bn</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>bs</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ca</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cs</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>da</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>de</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>el</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>en</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>es</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>et</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>eu</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fi</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fo</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fr</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ga</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>gl</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>gn</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>gu</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>he</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hi</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hr</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hu</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>id</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>is</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>it</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ja</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ka</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kk</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>km</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kn</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ko</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ky</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>lt</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>lv</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mk</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ml</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mr</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ms</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mt</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>my</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>nl</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>no</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>or</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pa</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pl</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pt</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ro</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ru</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sk</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sl</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sq</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sr</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sv</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ta</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>te</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>th</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tr</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>uk</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>uz</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vi</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param language
         *        Specifies the language on the map labels using the BCP 47 language tag, limited to ISO 639-1
         *        two-letter language codes. If the specified language data isn't available for the map image, the
         *        labels will default to the regional primary language.</p>
         *        <p>
         *        Supported codes:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ar</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>as</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>az</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>be</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>bg</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>bn</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>bs</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ca</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cs</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>da</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>de</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>el</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>en</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>es</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>et</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>eu</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fi</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fo</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fr</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ga</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>gl</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>gn</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>gu</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>he</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hi</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hr</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hu</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>id</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>is</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>it</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ja</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ka</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kk</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>km</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kn</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ko</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ky</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>lt</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>lv</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mk</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ml</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mr</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ms</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mt</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>my</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>nl</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>no</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>or</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pa</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pl</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pt</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ro</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ru</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sk</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sl</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sq</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sr</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sv</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ta</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>te</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>th</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tr</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>uk</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>uz</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vi</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * Applies additional space (in pixels) around overlay feature to prevent them from being cut or obscured.
         * </p>
         * <note>
         * <p>
         * Value for max and min is determined by:
         * </p>
         * <p>
         * Min: <code>1</code>
         * </p>
         * <p>
         * Max: <code>min(height, width)/4</code>
         * </p>
         * </note>
         * <p>
         * Example: <code>100</code>
         * </p>
         * 
         * @param padding
         *        Applies additional space (in pixels) around overlay feature to prevent them from being cut or
         *        obscured.</p> <note>
         *        <p>
         *        Value for max and min is determined by:
         *        </p>
         *        <p>
         *        Min: <code>1</code>
         *        </p>
         *        <p>
         *        Max: <code>min(height, width)/4</code>
         *        </p>
         *        </note>
         *        <p>
         *        Example: <code>100</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder padding(Integer padding);

        /**
         * <p>
         * Specifies the political view, using ISO 3166-2 or ISO 3166-3 country code format.
         * </p>
         * <p>
         * The following political views are currently supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ARG</code>: Argentina's view on the Southern Patagonian Ice Field and Tierra Del Fuego, including the
         * Falkland Islands, South Georgia, and South Sandwich Islands
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EGY</code>: Egypt's view on Bir Tawil
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IND</code>: India's view on Gilgit-Baltistan
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KEN</code>: Kenya's view on the Ilemi Triangle
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MAR</code>: Morocco's view on Western Sahara
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUS</code>: Russia's view on Crimea
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SDN</code>: Sudan's view on the Halaib Triangle
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SRB</code>: Serbia's view on Kosovo, Vukovar, and Sarengrad Islands
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUR</code>: Suriname's view on the Courantyne Headwaters and Lawa Headwaters
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SYR</code>: Syria's view on the Golan Heights
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TUR</code>: Turkey's view on Cyprus and Northern Cyprus
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TZA</code>: Tanzania's view on Lake Malawi
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>URY</code>: Uruguay's view on Rincon de Artigas
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VNM</code>: Vietnam's view on the Paracel Islands and Spratly Islands
         * </p>
         * </li>
         * </ul>
         * 
         * @param politicalView
         *        Specifies the political view, using ISO 3166-2 or ISO 3166-3 country code format.</p>
         *        <p>
         *        The following political views are currently supported:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ARG</code>: Argentina's view on the Southern Patagonian Ice Field and Tierra Del Fuego,
         *        including the Falkland Islands, South Georgia, and South Sandwich Islands
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EGY</code>: Egypt's view on Bir Tawil
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IND</code>: India's view on Gilgit-Baltistan
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KEN</code>: Kenya's view on the Ilemi Triangle
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MAR</code>: Morocco's view on Western Sahara
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUS</code>: Russia's view on Crimea
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SDN</code>: Sudan's view on the Halaib Triangle
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SRB</code>: Serbia's view on Kosovo, Vukovar, and Sarengrad Islands
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUR</code>: Suriname's view on the Courantyne Headwaters and Lawa Headwaters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SYR</code>: Syria's view on the Golan Heights
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TUR</code>: Turkey's view on Cyprus and Northern Cyprus
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TZA</code>: Tanzania's view on Lake Malawi
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>URY</code>: Uruguay's view on Rincon de Artigas
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VNM</code>: Vietnam's view on the Paracel Islands and Spratly Islands
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder politicalView(String politicalView);

        /**
         * <p>
         * Determines if the result image will display icons representing points of interest on the map.
         * </p>
         * 
         * @param pointsOfInterests
         *        Determines if the result image will display icons representing points of interest on the map.
         * @see MapFeatureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MapFeatureMode
         */
        Builder pointsOfInterests(String pointsOfInterests);

        /**
         * <p>
         * Determines if the result image will display icons representing points of interest on the map.
         * </p>
         * 
         * @param pointsOfInterests
         *        Determines if the result image will display icons representing points of interest on the map.
         * @see MapFeatureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MapFeatureMode
         */
        Builder pointsOfInterests(MapFeatureMode pointsOfInterests);

        /**
         * <p>
         * Used with center parameter, it specifies the zoom of the image where you can control it on a granular level.
         * Takes in any value <code>&gt;= 1</code>.
         * </p>
         * <p>
         * Example: <code>1500</code>
         * </p>
         * <note>
         * <p>
         * Cannot be used with <code>Zoom</code>.
         * </p>
         * </note>
         * <p>
         * <b>Unit</b>: <code>Meters</code>
         * </p>
         * <p/>
         * 
         * @param radius
         *        Used with center parameter, it specifies the zoom of the image where you can control it on a granular
         *        level. Takes in any value <code>&gt;= 1</code>.
         *        </p>
         *        <p>
         *        Example: <code>1500</code>
         *        </p>
         *        <note>
         *        <p>
         *        Cannot be used with <code>Zoom</code>.
         *        </p>
         *        </note>
         *        <p>
         *        <b>Unit</b>: <code>Meters</code>
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radius(Long radius);

        /**
         * <p>
         * The map scaling parameter to size the image, icons, and labels. It follows the pattern of
         * <code>^map(@2x)?$</code>.
         * </p>
         * <p>
         * Example: <code>map, map@2x</code>
         * </p>
         * 
         * @param fileName
         *        The map scaling parameter to size the image, icons, and labels. It follows the pattern of
         *        <code>^map(@2x)?$</code>.</p>
         *        <p>
         *        Example: <code>map, map@2x</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        /**
         * <p>
         * Displays a scale on the bottom right of the map image with the unit specified in the input.
         * </p>
         * <p>
         * Example: <code>KilometersMiles, Miles, Kilometers, MilesKilometers</code>
         * </p>
         * 
         * @param scaleBarUnit
         *        Displays a scale on the bottom right of the map image with the unit specified in the input. </p>
         *        <p>
         *        Example: <code>KilometersMiles, Miles, Kilometers, MilesKilometers</code>
         * @see ScaleBarUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScaleBarUnit
         */
        Builder scaleBarUnit(String scaleBarUnit);

        /**
         * <p>
         * Displays a scale on the bottom right of the map image with the unit specified in the input.
         * </p>
         * <p>
         * Example: <code>KilometersMiles, Miles, Kilometers, MilesKilometers</code>
         * </p>
         * 
         * @param scaleBarUnit
         *        Displays a scale on the bottom right of the map image with the unit specified in the input. </p>
         *        <p>
         *        Example: <code>KilometersMiles, Miles, Kilometers, MilesKilometers</code>
         * @see ScaleBarUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScaleBarUnit
         */
        Builder scaleBarUnit(ScaleBarUnit scaleBarUnit);

        /**
         * <p>
         * <code>Style</code> specifies the desired map style.
         * </p>
         * 
         * @param style
         *        <code>Style</code> specifies the desired map style.
         * @see StaticMapStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StaticMapStyle
         */
        Builder style(String style);

        /**
         * <p>
         * <code>Style</code> specifies the desired map style.
         * </p>
         * 
         * @param style
         *        <code>Style</code> specifies the desired map style.
         * @see StaticMapStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StaticMapStyle
         */
        Builder style(StaticMapStyle style);

        /**
         * <p>
         * Specifies the width of the map image.
         * </p>
         * 
         * @param width
         *        Specifies the width of the map image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Integer width);

        /**
         * <p>
         * Specifies the zoom level of the map image.
         * </p>
         * <note>
         * <p>
         * Cannot be used with <code>Radius</code>.
         * </p>
         * </note>
         * 
         * @param zoom
         *        Specifies the zoom level of the map image.</p> <note>
         *        <p>
         *        Cannot be used with <code>Radius</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoom(Float zoom);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GeoMapsRequest.BuilderImpl implements Builder {
        private String boundingBox;

        private String boundedPositions;

        private String center;

        private String colorScheme;

        private String compactOverlay;

        private Boolean cropLabels;

        private String geoJsonOverlay;

        private Integer height;

        private String key;

        private String labelSize;

        private String language;

        private Integer padding;

        private String politicalView;

        private String pointsOfInterests;

        private Long radius;

        private String fileName;

        private String scaleBarUnit;

        private String style;

        private Integer width;

        private Float zoom;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStaticMapRequest model) {
            super(model);
            boundingBox(model.boundingBox);
            boundedPositions(model.boundedPositions);
            center(model.center);
            colorScheme(model.colorScheme);
            compactOverlay(model.compactOverlay);
            cropLabels(model.cropLabels);
            geoJsonOverlay(model.geoJsonOverlay);
            height(model.height);
            key(model.key);
            labelSize(model.labelSize);
            language(model.language);
            padding(model.padding);
            politicalView(model.politicalView);
            pointsOfInterests(model.pointsOfInterests);
            radius(model.radius);
            fileName(model.fileName);
            scaleBarUnit(model.scaleBarUnit);
            style(model.style);
            width(model.width);
            zoom(model.zoom);
        }

        public final String getBoundingBox() {
            return boundingBox;
        }

        public final void setBoundingBox(String boundingBox) {
            this.boundingBox = boundingBox;
        }

        @Override
        public final Builder boundingBox(String boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final String getBoundedPositions() {
            return boundedPositions;
        }

        public final void setBoundedPositions(String boundedPositions) {
            this.boundedPositions = boundedPositions;
        }

        @Override
        public final Builder boundedPositions(String boundedPositions) {
            this.boundedPositions = boundedPositions;
            return this;
        }

        public final String getCenter() {
            return center;
        }

        public final void setCenter(String center) {
            this.center = center;
        }

        @Override
        public final Builder center(String center) {
            this.center = center;
            return this;
        }

        public final String getColorScheme() {
            return colorScheme;
        }

        public final void setColorScheme(String colorScheme) {
            this.colorScheme = colorScheme;
        }

        @Override
        public final Builder colorScheme(String colorScheme) {
            this.colorScheme = colorScheme;
            return this;
        }

        @Override
        public final Builder colorScheme(ColorScheme colorScheme) {
            this.colorScheme(colorScheme == null ? null : colorScheme.toString());
            return this;
        }

        public final String getCompactOverlay() {
            return compactOverlay;
        }

        public final void setCompactOverlay(String compactOverlay) {
            this.compactOverlay = compactOverlay;
        }

        @Override
        public final Builder compactOverlay(String compactOverlay) {
            this.compactOverlay = compactOverlay;
            return this;
        }

        public final Boolean getCropLabels() {
            return cropLabels;
        }

        public final void setCropLabels(Boolean cropLabels) {
            this.cropLabels = cropLabels;
        }

        @Override
        public final Builder cropLabels(Boolean cropLabels) {
            this.cropLabels = cropLabels;
            return this;
        }

        public final String getGeoJsonOverlay() {
            return geoJsonOverlay;
        }

        public final void setGeoJsonOverlay(String geoJsonOverlay) {
            this.geoJsonOverlay = geoJsonOverlay;
        }

        @Override
        public final Builder geoJsonOverlay(String geoJsonOverlay) {
            this.geoJsonOverlay = geoJsonOverlay;
            return this;
        }

        public final Integer getHeight() {
            return height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getLabelSize() {
            return labelSize;
        }

        public final void setLabelSize(String labelSize) {
            this.labelSize = labelSize;
        }

        @Override
        public final Builder labelSize(String labelSize) {
            this.labelSize = labelSize;
            return this;
        }

        @Override
        public final Builder labelSize(LabelSize labelSize) {
            this.labelSize(labelSize == null ? null : labelSize.toString());
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final Integer getPadding() {
            return padding;
        }

        public final void setPadding(Integer padding) {
            this.padding = padding;
        }

        @Override
        public final Builder padding(Integer padding) {
            this.padding = padding;
            return this;
        }

        public final String getPoliticalView() {
            return politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final String getPointsOfInterests() {
            return pointsOfInterests;
        }

        public final void setPointsOfInterests(String pointsOfInterests) {
            this.pointsOfInterests = pointsOfInterests;
        }

        @Override
        public final Builder pointsOfInterests(String pointsOfInterests) {
            this.pointsOfInterests = pointsOfInterests;
            return this;
        }

        @Override
        public final Builder pointsOfInterests(MapFeatureMode pointsOfInterests) {
            this.pointsOfInterests(pointsOfInterests == null ? null : pointsOfInterests.toString());
            return this;
        }

        public final Long getRadius() {
            return radius;
        }

        public final void setRadius(Long radius) {
            this.radius = radius;
        }

        @Override
        public final Builder radius(Long radius) {
            this.radius = radius;
            return this;
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getScaleBarUnit() {
            return scaleBarUnit;
        }

        public final void setScaleBarUnit(String scaleBarUnit) {
            this.scaleBarUnit = scaleBarUnit;
        }

        @Override
        public final Builder scaleBarUnit(String scaleBarUnit) {
            this.scaleBarUnit = scaleBarUnit;
            return this;
        }

        @Override
        public final Builder scaleBarUnit(ScaleBarUnit scaleBarUnit) {
            this.scaleBarUnit(scaleBarUnit == null ? null : scaleBarUnit.toString());
            return this;
        }

        public final String getStyle() {
            return style;
        }

        public final void setStyle(String style) {
            this.style = style;
        }

        @Override
        public final Builder style(String style) {
            this.style = style;
            return this;
        }

        @Override
        public final Builder style(StaticMapStyle style) {
            this.style(style == null ? null : style.toString());
            return this;
        }

        public final Integer getWidth() {
            return width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final Float getZoom() {
            return zoom;
        }

        public final void setZoom(Float zoom) {
            this.zoom = zoom;
        }

        @Override
        public final Builder zoom(Float zoom) {
            this.zoom = zoom;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetStaticMapRequest build() {
            return new GetStaticMapRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
