/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geomaps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGlyphsRequest extends GeoMapsRequest implements
        ToCopyableBuilder<GetGlyphsRequest.Builder, GetGlyphsRequest> {
    private static final SdkField<String> FONT_STACK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FontStack").getter(getter(GetGlyphsRequest::fontStack)).setter(setter(Builder::fontStack))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FontStack").build()).build();

    private static final SdkField<String> FONT_UNICODE_RANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FontUnicodeRange").getter(getter(GetGlyphsRequest::fontUnicodeRange))
            .setter(setter(Builder::fontUnicodeRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FontUnicodeRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FONT_STACK_FIELD,
            FONT_UNICODE_RANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fontStack;

    private final String fontUnicodeRange;

    private GetGlyphsRequest(BuilderImpl builder) {
        super(builder);
        this.fontStack = builder.fontStack;
        this.fontUnicodeRange = builder.fontUnicodeRange;
    }

    /**
     * <p>
     * Name of the <code>FontStack</code> to retrieve.
     * </p>
     * <p>
     * Example: <code>Amazon Ember Bold,Noto Sans Bold</code>.
     * </p>
     * <p>
     * The supported font stacks are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Ember Bold
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Bold Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Bold,Noto Sans Bold
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Bold,Noto Sans Bold,Noto Sans Arabic Bold
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Condensed RC BdItalic
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Condensed RC Bold
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Condensed RC Bold Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Condensed RC Bold,Noto Sans Bold
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Condensed RC Bold,Noto Sans Bold,Noto Sans Arabic Condensed Bold
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Condensed RC Light
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Condensed RC Light Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Condensed RC LtItalic
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Condensed RC Regular
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Condensed RC Regular Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Condensed RC Regular,Noto Sans Regular
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Condensed RC Regular,Noto Sans Regular,Noto Sans Arabic Condensed Regular
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Condensed RC RgItalic
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Condensed RC ThItalic
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Condensed RC Thin
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Condensed RC Thin Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Heavy
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Heavy Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Light
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Light Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Medium
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Medium Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Medium,Noto Sans Medium
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Medium,Noto Sans Medium,Noto Sans Arabic Medium
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Regular
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Regular Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Regular Italic,Noto Sans Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Regular Italic,Noto Sans Italic,Noto Sans Arabic Regular
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Regular,Noto Sans Regular
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Regular,Noto Sans Regular,Noto Sans Arabic Regular
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Thin
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Ember Thin Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmberCdRC_Bd
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmberCdRC_BdIt
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmberCdRC_Lt
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmberCdRC_LtIt
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmberCdRC_Rg
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmberCdRC_RgIt
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmberCdRC_Th
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmberCdRC_ThIt
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmber_Bd
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmber_BdIt
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmber_He
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmber_HeIt
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmber_Lt
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmber_LtIt
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmber_Md
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmber_MdIt
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmber_Rg
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmber_RgIt
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmber_Th
     * </p>
     * </li>
     * <li>
     * <p>
     * AmazonEmber_ThIt
     * </p>
     * </li>
     * <li>
     * <p>
     * Noto Sans Black
     * </p>
     * </li>
     * <li>
     * <p>
     * Noto Sans Black Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * Noto Sans Bold
     * </p>
     * </li>
     * <li>
     * <p>
     * Noto Sans Bold Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * Noto Sans Extra Bold
     * </p>
     * </li>
     * <li>
     * <p>
     * Noto Sans Extra Bold Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * Noto Sans Extra Light
     * </p>
     * </li>
     * <li>
     * <p>
     * Noto Sans Extra Light Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * Noto Sans Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * Noto Sans Light
     * </p>
     * </li>
     * <li>
     * <p>
     * Noto Sans Light Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * Noto Sans Medium
     * </p>
     * </li>
     * <li>
     * <p>
     * Noto Sans Medium Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * Noto Sans Regular
     * </p>
     * </li>
     * <li>
     * <p>
     * Noto Sans Semi Bold
     * </p>
     * </li>
     * <li>
     * <p>
     * Noto Sans Semi Bold Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * Noto Sans Thin
     * </p>
     * </li>
     * <li>
     * <p>
     * Noto Sans Thin Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * NotoSans-Bold
     * </p>
     * </li>
     * <li>
     * <p>
     * NotoSans-Italic
     * </p>
     * </li>
     * <li>
     * <p>
     * NotoSans-Medium
     * </p>
     * </li>
     * <li>
     * <p>
     * NotoSans-Regular
     * </p>
     * </li>
     * <li>
     * <p>
     * Open Sans Regular,Arial Unicode MS Regular
     * </p>
     * </li>
     * </ul>
     * 
     * @return Name of the <code>FontStack</code> to retrieve. </p>
     *         <p>
     *         Example: <code>Amazon Ember Bold,Noto Sans Bold</code>.
     *         </p>
     *         <p>
     *         The supported font stacks are as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Amazon Ember Bold
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Bold Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Bold,Noto Sans Bold
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Bold,Noto Sans Bold,Noto Sans Arabic Bold
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Condensed RC BdItalic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Condensed RC Bold
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Condensed RC Bold Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Condensed RC Bold,Noto Sans Bold
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Condensed RC Bold,Noto Sans Bold,Noto Sans Arabic Condensed Bold
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Condensed RC Light
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Condensed RC Light Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Condensed RC LtItalic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Condensed RC Regular
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Condensed RC Regular Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Condensed RC Regular,Noto Sans Regular
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Condensed RC Regular,Noto Sans Regular,Noto Sans Arabic Condensed Regular
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Condensed RC RgItalic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Condensed RC ThItalic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Condensed RC Thin
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Condensed RC Thin Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Heavy
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Heavy Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Light
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Light Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Medium
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Medium Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Medium,Noto Sans Medium
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Medium,Noto Sans Medium,Noto Sans Arabic Medium
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Regular
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Regular Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Regular Italic,Noto Sans Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Regular Italic,Noto Sans Italic,Noto Sans Arabic Regular
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Regular,Noto Sans Regular
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Regular,Noto Sans Regular,Noto Sans Arabic Regular
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Thin
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Ember Thin Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmberCdRC_Bd
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmberCdRC_BdIt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmberCdRC_Lt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmberCdRC_LtIt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmberCdRC_Rg
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmberCdRC_RgIt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmberCdRC_Th
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmberCdRC_ThIt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmber_Bd
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmber_BdIt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmber_He
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmber_HeIt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmber_Lt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmber_LtIt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmber_Md
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmber_MdIt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmber_Rg
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmber_RgIt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmber_Th
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AmazonEmber_ThIt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Noto Sans Black
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Noto Sans Black Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Noto Sans Bold
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Noto Sans Bold Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Noto Sans Extra Bold
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Noto Sans Extra Bold Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Noto Sans Extra Light
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Noto Sans Extra Light Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Noto Sans Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Noto Sans Light
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Noto Sans Light Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Noto Sans Medium
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Noto Sans Medium Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Noto Sans Regular
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Noto Sans Semi Bold
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Noto Sans Semi Bold Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Noto Sans Thin
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Noto Sans Thin Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NotoSans-Bold
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NotoSans-Italic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NotoSans-Medium
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NotoSans-Regular
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Open Sans Regular,Arial Unicode MS Regular
     *         </p>
     *         </li>
     */
    public final String fontStack() {
        return fontStack;
    }

    /**
     * <p>
     * A Unicode range of characters to download glyphs for. This must be aligned to multiples of 256.
     * </p>
     * <p>
     * Example: <code>0-255.pbf</code>
     * </p>
     * 
     * @return A Unicode range of characters to download glyphs for. This must be aligned to multiples of 256. </p>
     *         <p>
     *         Example: <code>0-255.pbf</code>
     */
    public final String fontUnicodeRange() {
        return fontUnicodeRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fontStack());
        hashCode = 31 * hashCode + Objects.hashCode(fontUnicodeRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGlyphsRequest)) {
            return false;
        }
        GetGlyphsRequest other = (GetGlyphsRequest) obj;
        return Objects.equals(fontStack(), other.fontStack()) && Objects.equals(fontUnicodeRange(), other.fontUnicodeRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGlyphsRequest").add("FontStack", fontStack()).add("FontUnicodeRange", fontUnicodeRange())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FontStack":
            return Optional.ofNullable(clazz.cast(fontStack()));
        case "FontUnicodeRange":
            return Optional.ofNullable(clazz.cast(fontUnicodeRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FontStack", FONT_STACK_FIELD);
        map.put("FontUnicodeRange", FONT_UNICODE_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetGlyphsRequest, T> g) {
        return obj -> g.apply((GetGlyphsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GeoMapsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetGlyphsRequest> {
        /**
         * <p>
         * Name of the <code>FontStack</code> to retrieve.
         * </p>
         * <p>
         * Example: <code>Amazon Ember Bold,Noto Sans Bold</code>.
         * </p>
         * <p>
         * The supported font stacks are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Amazon Ember Bold
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Bold Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Bold,Noto Sans Bold
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Bold,Noto Sans Bold,Noto Sans Arabic Bold
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Condensed RC BdItalic
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Condensed RC Bold
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Condensed RC Bold Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Condensed RC Bold,Noto Sans Bold
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Condensed RC Bold,Noto Sans Bold,Noto Sans Arabic Condensed Bold
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Condensed RC Light
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Condensed RC Light Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Condensed RC LtItalic
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Condensed RC Regular
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Condensed RC Regular Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Condensed RC Regular,Noto Sans Regular
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Condensed RC Regular,Noto Sans Regular,Noto Sans Arabic Condensed Regular
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Condensed RC RgItalic
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Condensed RC ThItalic
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Condensed RC Thin
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Condensed RC Thin Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Heavy
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Heavy Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Light
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Light Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Medium
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Medium Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Medium,Noto Sans Medium
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Medium,Noto Sans Medium,Noto Sans Arabic Medium
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Regular
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Regular Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Regular Italic,Noto Sans Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Regular Italic,Noto Sans Italic,Noto Sans Arabic Regular
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Regular,Noto Sans Regular
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Regular,Noto Sans Regular,Noto Sans Arabic Regular
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Thin
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Ember Thin Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmberCdRC_Bd
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmberCdRC_BdIt
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmberCdRC_Lt
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmberCdRC_LtIt
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmberCdRC_Rg
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmberCdRC_RgIt
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmberCdRC_Th
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmberCdRC_ThIt
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmber_Bd
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmber_BdIt
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmber_He
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmber_HeIt
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmber_Lt
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmber_LtIt
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmber_Md
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmber_MdIt
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmber_Rg
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmber_RgIt
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmber_Th
         * </p>
         * </li>
         * <li>
         * <p>
         * AmazonEmber_ThIt
         * </p>
         * </li>
         * <li>
         * <p>
         * Noto Sans Black
         * </p>
         * </li>
         * <li>
         * <p>
         * Noto Sans Black Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * Noto Sans Bold
         * </p>
         * </li>
         * <li>
         * <p>
         * Noto Sans Bold Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * Noto Sans Extra Bold
         * </p>
         * </li>
         * <li>
         * <p>
         * Noto Sans Extra Bold Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * Noto Sans Extra Light
         * </p>
         * </li>
         * <li>
         * <p>
         * Noto Sans Extra Light Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * Noto Sans Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * Noto Sans Light
         * </p>
         * </li>
         * <li>
         * <p>
         * Noto Sans Light Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * Noto Sans Medium
         * </p>
         * </li>
         * <li>
         * <p>
         * Noto Sans Medium Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * Noto Sans Regular
         * </p>
         * </li>
         * <li>
         * <p>
         * Noto Sans Semi Bold
         * </p>
         * </li>
         * <li>
         * <p>
         * Noto Sans Semi Bold Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * Noto Sans Thin
         * </p>
         * </li>
         * <li>
         * <p>
         * Noto Sans Thin Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * NotoSans-Bold
         * </p>
         * </li>
         * <li>
         * <p>
         * NotoSans-Italic
         * </p>
         * </li>
         * <li>
         * <p>
         * NotoSans-Medium
         * </p>
         * </li>
         * <li>
         * <p>
         * NotoSans-Regular
         * </p>
         * </li>
         * <li>
         * <p>
         * Open Sans Regular,Arial Unicode MS Regular
         * </p>
         * </li>
         * </ul>
         * 
         * @param fontStack
         *        Name of the <code>FontStack</code> to retrieve. </p>
         *        <p>
         *        Example: <code>Amazon Ember Bold,Noto Sans Bold</code>.
         *        </p>
         *        <p>
         *        The supported font stacks are as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Amazon Ember Bold
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Bold Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Bold,Noto Sans Bold
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Bold,Noto Sans Bold,Noto Sans Arabic Bold
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Condensed RC BdItalic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Condensed RC Bold
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Condensed RC Bold Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Condensed RC Bold,Noto Sans Bold
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Condensed RC Bold,Noto Sans Bold,Noto Sans Arabic Condensed Bold
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Condensed RC Light
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Condensed RC Light Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Condensed RC LtItalic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Condensed RC Regular
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Condensed RC Regular Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Condensed RC Regular,Noto Sans Regular
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Condensed RC Regular,Noto Sans Regular,Noto Sans Arabic Condensed Regular
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Condensed RC RgItalic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Condensed RC ThItalic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Condensed RC Thin
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Condensed RC Thin Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Heavy
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Heavy Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Light
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Light Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Medium
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Medium Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Medium,Noto Sans Medium
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Medium,Noto Sans Medium,Noto Sans Arabic Medium
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Regular
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Regular Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Regular Italic,Noto Sans Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Regular Italic,Noto Sans Italic,Noto Sans Arabic Regular
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Regular,Noto Sans Regular
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Regular,Noto Sans Regular,Noto Sans Arabic Regular
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Thin
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Ember Thin Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmberCdRC_Bd
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmberCdRC_BdIt
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmberCdRC_Lt
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmberCdRC_LtIt
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmberCdRC_Rg
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmberCdRC_RgIt
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmberCdRC_Th
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmberCdRC_ThIt
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmber_Bd
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmber_BdIt
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmber_He
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmber_HeIt
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmber_Lt
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmber_LtIt
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmber_Md
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmber_MdIt
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmber_Rg
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmber_RgIt
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmber_Th
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AmazonEmber_ThIt
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Noto Sans Black
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Noto Sans Black Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Noto Sans Bold
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Noto Sans Bold Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Noto Sans Extra Bold
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Noto Sans Extra Bold Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Noto Sans Extra Light
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Noto Sans Extra Light Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Noto Sans Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Noto Sans Light
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Noto Sans Light Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Noto Sans Medium
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Noto Sans Medium Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Noto Sans Regular
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Noto Sans Semi Bold
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Noto Sans Semi Bold Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Noto Sans Thin
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Noto Sans Thin Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NotoSans-Bold
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NotoSans-Italic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NotoSans-Medium
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NotoSans-Regular
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Open Sans Regular,Arial Unicode MS Regular
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontStack(String fontStack);

        /**
         * <p>
         * A Unicode range of characters to download glyphs for. This must be aligned to multiples of 256.
         * </p>
         * <p>
         * Example: <code>0-255.pbf</code>
         * </p>
         * 
         * @param fontUnicodeRange
         *        A Unicode range of characters to download glyphs for. This must be aligned to multiples of 256. </p>
         *        <p>
         *        Example: <code>0-255.pbf</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontUnicodeRange(String fontUnicodeRange);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GeoMapsRequest.BuilderImpl implements Builder {
        private String fontStack;

        private String fontUnicodeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGlyphsRequest model) {
            super(model);
            fontStack(model.fontStack);
            fontUnicodeRange(model.fontUnicodeRange);
        }

        public final String getFontStack() {
            return fontStack;
        }

        public final void setFontStack(String fontStack) {
            this.fontStack = fontStack;
        }

        @Override
        public final Builder fontStack(String fontStack) {
            this.fontStack = fontStack;
            return this;
        }

        public final String getFontUnicodeRange() {
            return fontUnicodeRange;
        }

        public final void setFontUnicodeRange(String fontUnicodeRange) {
            this.fontUnicodeRange = fontUnicodeRange;
        }

        @Override
        public final Builder fontUnicodeRange(String fontUnicodeRange) {
            this.fontUnicodeRange = fontUnicodeRange;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetGlyphsRequest build() {
            return new GetGlyphsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
