/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.BoundingBoxCopier;
import software.amazon.awssdk.services.geoplaces.model.CountryCodeListCopier;
import software.amazon.awssdk.services.geoplaces.model.FilterCircle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchTextFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchTextFilter> {
    private static final SdkField<List<Double>> BOUNDING_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BoundingBox").getter(SearchTextFilter.getter(SearchTextFilter::boundingBox)).setter(SearchTextFilter.setter(Builder::boundingBox)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FilterCircle> CIRCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Circle").getter(SearchTextFilter.getter(SearchTextFilter::circle)).setter(SearchTextFilter.setter(Builder::circle)).constructor(FilterCircle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Circle").build()}).build();
    private static final SdkField<List<String>> INCLUDE_COUNTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludeCountries").getter(SearchTextFilter.getter(SearchTextFilter::includeCountries)).setter(SearchTextFilter.setter(Builder::includeCountries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeCountries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDING_BOX_FIELD, CIRCLE_FIELD, INCLUDE_COUNTRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BoundingBox", BOUNDING_BOX_FIELD);
            this.put("Circle", CIRCLE_FIELD);
            this.put("IncludeCountries", INCLUDE_COUNTRIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<Double> boundingBox;
    private final FilterCircle circle;
    private final List<String> includeCountries;

    private SearchTextFilter(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.circle = builder.circle;
        this.includeCountries = builder.includeCountries;
    }

    public final boolean hasBoundingBox() {
        return this.boundingBox != null && !(this.boundingBox instanceof SdkAutoConstructList);
    }

    public final List<Double> boundingBox() {
        return this.boundingBox;
    }

    public final FilterCircle circle() {
        return this.circle;
    }

    public final boolean hasIncludeCountries() {
        return this.includeCountries != null && !(this.includeCountries instanceof SdkAutoConstructList);
    }

    public final List<String> includeCountries() {
        return this.includeCountries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBoundingBox() ? this.boundingBox() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.circle());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeCountries() ? this.includeCountries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTextFilter)) {
            return false;
        }
        SearchTextFilter other = (SearchTextFilter)obj;
        return this.hasBoundingBox() == other.hasBoundingBox() && Objects.equals(this.boundingBox(), other.boundingBox()) && Objects.equals(this.circle(), other.circle()) && this.hasIncludeCountries() == other.hasIncludeCountries() && Objects.equals(this.includeCountries(), other.includeCountries());
    }

    public final String toString() {
        return ToString.builder((String)"SearchTextFilter").add("BoundingBox", (Object)(this.boundingBox() == null ? null : "*** Sensitive Data Redacted ***")).add("Circle", (Object)(this.circle() == null ? null : "*** Sensitive Data Redacted ***")).add("IncludeCountries", this.hasIncludeCountries() ? this.includeCountries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BoundingBox": {
                return Optional.ofNullable(clazz.cast(this.boundingBox()));
            }
            case "Circle": {
                return Optional.ofNullable(clazz.cast(this.circle()));
            }
            case "IncludeCountries": {
                return Optional.ofNullable(clazz.cast(this.includeCountries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchTextFilter, T> g) {
        return obj -> g.apply((SearchTextFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Double> boundingBox = DefaultSdkAutoConstructList.getInstance();
        private FilterCircle circle;
        private List<String> includeCountries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTextFilter model) {
            this.boundingBox(model.boundingBox);
            this.circle(model.circle);
            this.includeCountries(model.includeCountries);
        }

        public final Collection<Double> getBoundingBox() {
            if (this.boundingBox instanceof SdkAutoConstructList) {
                return null;
            }
            return this.boundingBox;
        }

        public final void setBoundingBox(Collection<Double> boundingBox) {
            this.boundingBox = BoundingBoxCopier.copy(boundingBox);
        }

        @Override
        public final Builder boundingBox(Collection<Double> boundingBox) {
            this.boundingBox = BoundingBoxCopier.copy(boundingBox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder boundingBox(Double ... boundingBox) {
            this.boundingBox(Arrays.asList(boundingBox));
            return this;
        }

        public final FilterCircle.Builder getCircle() {
            return this.circle != null ? this.circle.toBuilder() : null;
        }

        public final void setCircle(FilterCircle.BuilderImpl circle) {
            this.circle = circle != null ? circle.build() : null;
        }

        @Override
        public final Builder circle(FilterCircle circle) {
            this.circle = circle;
            return this;
        }

        public final Collection<String> getIncludeCountries() {
            if (this.includeCountries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includeCountries;
        }

        public final void setIncludeCountries(Collection<String> includeCountries) {
            this.includeCountries = CountryCodeListCopier.copy(includeCountries);
        }

        @Override
        public final Builder includeCountries(Collection<String> includeCountries) {
            this.includeCountries = CountryCodeListCopier.copy(includeCountries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeCountries(String ... includeCountries) {
            this.includeCountries(Arrays.asList(includeCountries));
            return this;
        }

        public SearchTextFilter build() {
            return new SearchTextFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchTextFilter> {
        public Builder boundingBox(Collection<Double> var1);

        public Builder boundingBox(Double ... var1);

        public Builder circle(FilterCircle var1);

        default public Builder circle(Consumer<FilterCircle.Builder> circle) {
            return this.circle((FilterCircle)((FilterCircle.Builder)FilterCircle.builder().applyMutation(circle)).build());
        }

        public Builder includeCountries(Collection<String> var1);

        public Builder includeCountries(String ... var1);
    }
}

