/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.CountryHighlights;
import software.amazon.awssdk.services.geoplaces.model.Highlight;
import software.amazon.awssdk.services.geoplaces.model.HighlightListCopier;
import software.amazon.awssdk.services.geoplaces.model.IntersectionHighlightsListCopier;
import software.amazon.awssdk.services.geoplaces.model.RegionHighlights;
import software.amazon.awssdk.services.geoplaces.model.SubRegionHighlights;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutocompleteAddressHighlights
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutocompleteAddressHighlights> {
    private static final SdkField<List<Highlight>> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Label").getter(AutocompleteAddressHighlights.getter(AutocompleteAddressHighlights::label)).setter(AutocompleteAddressHighlights.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Highlight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CountryHighlights> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Country").getter(AutocompleteAddressHighlights.getter(AutocompleteAddressHighlights::country)).setter(AutocompleteAddressHighlights.setter(Builder::country)).constructor(CountryHighlights::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<RegionHighlights> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Region").getter(AutocompleteAddressHighlights.getter(AutocompleteAddressHighlights::region)).setter(AutocompleteAddressHighlights.setter(Builder::region)).constructor(RegionHighlights::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<SubRegionHighlights> SUB_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SubRegion").getter(AutocompleteAddressHighlights.getter(AutocompleteAddressHighlights::subRegion)).setter(AutocompleteAddressHighlights.setter(Builder::subRegion)).constructor(SubRegionHighlights::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubRegion").build()}).build();
    private static final SdkField<List<Highlight>> LOCALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Locality").getter(AutocompleteAddressHighlights.getter(AutocompleteAddressHighlights::locality)).setter(AutocompleteAddressHighlights.setter(Builder::locality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locality").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Highlight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Highlight>> DISTRICT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("District").getter(AutocompleteAddressHighlights.getter(AutocompleteAddressHighlights::district)).setter(AutocompleteAddressHighlights.setter(Builder::district)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("District").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Highlight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Highlight>> SUB_DISTRICT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubDistrict").getter(AutocompleteAddressHighlights.getter(AutocompleteAddressHighlights::subDistrict)).setter(AutocompleteAddressHighlights.setter(Builder::subDistrict)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubDistrict").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Highlight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Highlight>> STREET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Street").getter(AutocompleteAddressHighlights.getter(AutocompleteAddressHighlights::street)).setter(AutocompleteAddressHighlights.setter(Builder::street)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Street").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Highlight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Highlight>> BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Block").getter(AutocompleteAddressHighlights.getter(AutocompleteAddressHighlights::block)).setter(AutocompleteAddressHighlights.setter(Builder::block)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Block").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Highlight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Highlight>> SUB_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubBlock").getter(AutocompleteAddressHighlights.getter(AutocompleteAddressHighlights::subBlock)).setter(AutocompleteAddressHighlights.setter(Builder::subBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubBlock").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Highlight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<List<Highlight>>> INTERSECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Intersection").getter(AutocompleteAddressHighlights.getter(AutocompleteAddressHighlights::intersection)).setter(AutocompleteAddressHighlights.setter(Builder::intersection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Intersection").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Highlight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<Highlight>> POSTAL_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PostalCode").getter(AutocompleteAddressHighlights.getter(AutocompleteAddressHighlights::postalCode)).setter(AutocompleteAddressHighlights.setter(Builder::postalCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Highlight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Highlight>> ADDRESS_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddressNumber").getter(AutocompleteAddressHighlights.getter(AutocompleteAddressHighlights::addressNumber)).setter(AutocompleteAddressHighlights.setter(Builder::addressNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressNumber").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Highlight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Highlight>> BUILDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Building").getter(AutocompleteAddressHighlights.getter(AutocompleteAddressHighlights::building)).setter(AutocompleteAddressHighlights.setter(Builder::building)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Building").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Highlight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_FIELD, COUNTRY_FIELD, REGION_FIELD, SUB_REGION_FIELD, LOCALITY_FIELD, DISTRICT_FIELD, SUB_DISTRICT_FIELD, STREET_FIELD, BLOCK_FIELD, SUB_BLOCK_FIELD, INTERSECTION_FIELD, POSTAL_CODE_FIELD, ADDRESS_NUMBER_FIELD, BUILDING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Label", LABEL_FIELD);
            this.put("Country", COUNTRY_FIELD);
            this.put("Region", REGION_FIELD);
            this.put("SubRegion", SUB_REGION_FIELD);
            this.put("Locality", LOCALITY_FIELD);
            this.put("District", DISTRICT_FIELD);
            this.put("SubDistrict", SUB_DISTRICT_FIELD);
            this.put("Street", STREET_FIELD);
            this.put("Block", BLOCK_FIELD);
            this.put("SubBlock", SUB_BLOCK_FIELD);
            this.put("Intersection", INTERSECTION_FIELD);
            this.put("PostalCode", POSTAL_CODE_FIELD);
            this.put("AddressNumber", ADDRESS_NUMBER_FIELD);
            this.put("Building", BUILDING_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<Highlight> label;
    private final CountryHighlights country;
    private final RegionHighlights region;
    private final SubRegionHighlights subRegion;
    private final List<Highlight> locality;
    private final List<Highlight> district;
    private final List<Highlight> subDistrict;
    private final List<Highlight> street;
    private final List<Highlight> block;
    private final List<Highlight> subBlock;
    private final List<List<Highlight>> intersection;
    private final List<Highlight> postalCode;
    private final List<Highlight> addressNumber;
    private final List<Highlight> building;

    private AutocompleteAddressHighlights(BuilderImpl builder) {
        this.label = builder.label;
        this.country = builder.country;
        this.region = builder.region;
        this.subRegion = builder.subRegion;
        this.locality = builder.locality;
        this.district = builder.district;
        this.subDistrict = builder.subDistrict;
        this.street = builder.street;
        this.block = builder.block;
        this.subBlock = builder.subBlock;
        this.intersection = builder.intersection;
        this.postalCode = builder.postalCode;
        this.addressNumber = builder.addressNumber;
        this.building = builder.building;
    }

    public final boolean hasLabel() {
        return this.label != null && !(this.label instanceof SdkAutoConstructList);
    }

    public final List<Highlight> label() {
        return this.label;
    }

    public final CountryHighlights country() {
        return this.country;
    }

    public final RegionHighlights region() {
        return this.region;
    }

    public final SubRegionHighlights subRegion() {
        return this.subRegion;
    }

    public final boolean hasLocality() {
        return this.locality != null && !(this.locality instanceof SdkAutoConstructList);
    }

    public final List<Highlight> locality() {
        return this.locality;
    }

    public final boolean hasDistrict() {
        return this.district != null && !(this.district instanceof SdkAutoConstructList);
    }

    public final List<Highlight> district() {
        return this.district;
    }

    public final boolean hasSubDistrict() {
        return this.subDistrict != null && !(this.subDistrict instanceof SdkAutoConstructList);
    }

    public final List<Highlight> subDistrict() {
        return this.subDistrict;
    }

    public final boolean hasStreet() {
        return this.street != null && !(this.street instanceof SdkAutoConstructList);
    }

    public final List<Highlight> street() {
        return this.street;
    }

    public final boolean hasBlock() {
        return this.block != null && !(this.block instanceof SdkAutoConstructList);
    }

    public final List<Highlight> block() {
        return this.block;
    }

    public final boolean hasSubBlock() {
        return this.subBlock != null && !(this.subBlock instanceof SdkAutoConstructList);
    }

    public final List<Highlight> subBlock() {
        return this.subBlock;
    }

    public final boolean hasIntersection() {
        return this.intersection != null && !(this.intersection instanceof SdkAutoConstructList);
    }

    public final List<List<Highlight>> intersection() {
        return this.intersection;
    }

    public final boolean hasPostalCode() {
        return this.postalCode != null && !(this.postalCode instanceof SdkAutoConstructList);
    }

    public final List<Highlight> postalCode() {
        return this.postalCode;
    }

    public final boolean hasAddressNumber() {
        return this.addressNumber != null && !(this.addressNumber instanceof SdkAutoConstructList);
    }

    public final List<Highlight> addressNumber() {
        return this.addressNumber;
    }

    public final boolean hasBuilding() {
        return this.building != null && !(this.building instanceof SdkAutoConstructList);
    }

    public final List<Highlight> building() {
        return this.building;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabel() ? this.label() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.subRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocality() ? this.locality() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDistrict() ? this.district() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubDistrict() ? this.subDistrict() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStreet() ? this.street() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlock() ? this.block() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubBlock() ? this.subBlock() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntersection() ? this.intersection() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPostalCode() ? this.postalCode() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddressNumber() ? this.addressNumber() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBuilding() ? this.building() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutocompleteAddressHighlights)) {
            return false;
        }
        AutocompleteAddressHighlights other = (AutocompleteAddressHighlights)obj;
        return this.hasLabel() == other.hasLabel() && Objects.equals(this.label(), other.label()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.subRegion(), other.subRegion()) && this.hasLocality() == other.hasLocality() && Objects.equals(this.locality(), other.locality()) && this.hasDistrict() == other.hasDistrict() && Objects.equals(this.district(), other.district()) && this.hasSubDistrict() == other.hasSubDistrict() && Objects.equals(this.subDistrict(), other.subDistrict()) && this.hasStreet() == other.hasStreet() && Objects.equals(this.street(), other.street()) && this.hasBlock() == other.hasBlock() && Objects.equals(this.block(), other.block()) && this.hasSubBlock() == other.hasSubBlock() && Objects.equals(this.subBlock(), other.subBlock()) && this.hasIntersection() == other.hasIntersection() && Objects.equals(this.intersection(), other.intersection()) && this.hasPostalCode() == other.hasPostalCode() && Objects.equals(this.postalCode(), other.postalCode()) && this.hasAddressNumber() == other.hasAddressNumber() && Objects.equals(this.addressNumber(), other.addressNumber()) && this.hasBuilding() == other.hasBuilding() && Objects.equals(this.building(), other.building());
    }

    public final String toString() {
        return ToString.builder((String)"AutocompleteAddressHighlights").add("Label", this.hasLabel() ? this.label() : null).add("Country", (Object)this.country()).add("Region", (Object)this.region()).add("SubRegion", (Object)this.subRegion()).add("Locality", this.hasLocality() ? this.locality() : null).add("District", this.hasDistrict() ? this.district() : null).add("SubDistrict", this.hasSubDistrict() ? this.subDistrict() : null).add("Street", this.hasStreet() ? this.street() : null).add("Block", this.hasBlock() ? this.block() : null).add("SubBlock", this.hasSubBlock() ? this.subBlock() : null).add("Intersection", this.hasIntersection() ? this.intersection() : null).add("PostalCode", this.hasPostalCode() ? this.postalCode() : null).add("AddressNumber", this.hasAddressNumber() ? this.addressNumber() : null).add("Building", this.hasBuilding() ? this.building() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "SubRegion": {
                return Optional.ofNullable(clazz.cast(this.subRegion()));
            }
            case "Locality": {
                return Optional.ofNullable(clazz.cast(this.locality()));
            }
            case "District": {
                return Optional.ofNullable(clazz.cast(this.district()));
            }
            case "SubDistrict": {
                return Optional.ofNullable(clazz.cast(this.subDistrict()));
            }
            case "Street": {
                return Optional.ofNullable(clazz.cast(this.street()));
            }
            case "Block": {
                return Optional.ofNullable(clazz.cast(this.block()));
            }
            case "SubBlock": {
                return Optional.ofNullable(clazz.cast(this.subBlock()));
            }
            case "Intersection": {
                return Optional.ofNullable(clazz.cast(this.intersection()));
            }
            case "PostalCode": {
                return Optional.ofNullable(clazz.cast(this.postalCode()));
            }
            case "AddressNumber": {
                return Optional.ofNullable(clazz.cast(this.addressNumber()));
            }
            case "Building": {
                return Optional.ofNullable(clazz.cast(this.building()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AutocompleteAddressHighlights, T> g) {
        return obj -> g.apply((AutocompleteAddressHighlights)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Highlight> label = DefaultSdkAutoConstructList.getInstance();
        private CountryHighlights country;
        private RegionHighlights region;
        private SubRegionHighlights subRegion;
        private List<Highlight> locality = DefaultSdkAutoConstructList.getInstance();
        private List<Highlight> district = DefaultSdkAutoConstructList.getInstance();
        private List<Highlight> subDistrict = DefaultSdkAutoConstructList.getInstance();
        private List<Highlight> street = DefaultSdkAutoConstructList.getInstance();
        private List<Highlight> block = DefaultSdkAutoConstructList.getInstance();
        private List<Highlight> subBlock = DefaultSdkAutoConstructList.getInstance();
        private List<List<Highlight>> intersection = DefaultSdkAutoConstructList.getInstance();
        private List<Highlight> postalCode = DefaultSdkAutoConstructList.getInstance();
        private List<Highlight> addressNumber = DefaultSdkAutoConstructList.getInstance();
        private List<Highlight> building = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutocompleteAddressHighlights model) {
            this.label(model.label);
            this.country(model.country);
            this.region(model.region);
            this.subRegion(model.subRegion);
            this.locality(model.locality);
            this.district(model.district);
            this.subDistrict(model.subDistrict);
            this.street(model.street);
            this.block(model.block);
            this.subBlock(model.subBlock);
            this.intersection(model.intersection);
            this.postalCode(model.postalCode);
            this.addressNumber(model.addressNumber);
            this.building(model.building);
        }

        public final List<Highlight.Builder> getLabel() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.label);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLabel(Collection<Highlight.BuilderImpl> label) {
            this.label = HighlightListCopier.copyFromBuilder(label);
        }

        @Override
        public final Builder label(Collection<Highlight> label) {
            this.label = HighlightListCopier.copy(label);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder label(Highlight ... label) {
            this.label(Arrays.asList(label));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder label(Consumer<Highlight.Builder> ... label) {
            this.label(Stream.of(label).map(c -> (Highlight)((Highlight.Builder)Highlight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CountryHighlights.Builder getCountry() {
            return this.country != null ? this.country.toBuilder() : null;
        }

        public final void setCountry(CountryHighlights.BuilderImpl country) {
            this.country = country != null ? country.build() : null;
        }

        @Override
        public final Builder country(CountryHighlights country) {
            this.country = country;
            return this;
        }

        public final RegionHighlights.Builder getRegion() {
            return this.region != null ? this.region.toBuilder() : null;
        }

        public final void setRegion(RegionHighlights.BuilderImpl region) {
            this.region = region != null ? region.build() : null;
        }

        @Override
        public final Builder region(RegionHighlights region) {
            this.region = region;
            return this;
        }

        public final SubRegionHighlights.Builder getSubRegion() {
            return this.subRegion != null ? this.subRegion.toBuilder() : null;
        }

        public final void setSubRegion(SubRegionHighlights.BuilderImpl subRegion) {
            this.subRegion = subRegion != null ? subRegion.build() : null;
        }

        @Override
        public final Builder subRegion(SubRegionHighlights subRegion) {
            this.subRegion = subRegion;
            return this;
        }

        public final List<Highlight.Builder> getLocality() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.locality);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocality(Collection<Highlight.BuilderImpl> locality) {
            this.locality = HighlightListCopier.copyFromBuilder(locality);
        }

        @Override
        public final Builder locality(Collection<Highlight> locality) {
            this.locality = HighlightListCopier.copy(locality);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locality(Highlight ... locality) {
            this.locality(Arrays.asList(locality));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locality(Consumer<Highlight.Builder> ... locality) {
            this.locality(Stream.of(locality).map(c -> (Highlight)((Highlight.Builder)Highlight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Highlight.Builder> getDistrict() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.district);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDistrict(Collection<Highlight.BuilderImpl> district) {
            this.district = HighlightListCopier.copyFromBuilder(district);
        }

        @Override
        public final Builder district(Collection<Highlight> district) {
            this.district = HighlightListCopier.copy(district);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder district(Highlight ... district) {
            this.district(Arrays.asList(district));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder district(Consumer<Highlight.Builder> ... district) {
            this.district(Stream.of(district).map(c -> (Highlight)((Highlight.Builder)Highlight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Highlight.Builder> getSubDistrict() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.subDistrict);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubDistrict(Collection<Highlight.BuilderImpl> subDistrict) {
            this.subDistrict = HighlightListCopier.copyFromBuilder(subDistrict);
        }

        @Override
        public final Builder subDistrict(Collection<Highlight> subDistrict) {
            this.subDistrict = HighlightListCopier.copy(subDistrict);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subDistrict(Highlight ... subDistrict) {
            this.subDistrict(Arrays.asList(subDistrict));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subDistrict(Consumer<Highlight.Builder> ... subDistrict) {
            this.subDistrict(Stream.of(subDistrict).map(c -> (Highlight)((Highlight.Builder)Highlight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Highlight.Builder> getStreet() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.street);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreet(Collection<Highlight.BuilderImpl> street) {
            this.street = HighlightListCopier.copyFromBuilder(street);
        }

        @Override
        public final Builder street(Collection<Highlight> street) {
            this.street = HighlightListCopier.copy(street);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder street(Highlight ... street) {
            this.street(Arrays.asList(street));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder street(Consumer<Highlight.Builder> ... street) {
            this.street(Stream.of(street).map(c -> (Highlight)((Highlight.Builder)Highlight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Highlight.Builder> getBlock() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.block);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlock(Collection<Highlight.BuilderImpl> block) {
            this.block = HighlightListCopier.copyFromBuilder(block);
        }

        @Override
        public final Builder block(Collection<Highlight> block) {
            this.block = HighlightListCopier.copy(block);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder block(Highlight ... block) {
            this.block(Arrays.asList(block));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder block(Consumer<Highlight.Builder> ... block) {
            this.block(Stream.of(block).map(c -> (Highlight)((Highlight.Builder)Highlight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Highlight.Builder> getSubBlock() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.subBlock);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubBlock(Collection<Highlight.BuilderImpl> subBlock) {
            this.subBlock = HighlightListCopier.copyFromBuilder(subBlock);
        }

        @Override
        public final Builder subBlock(Collection<Highlight> subBlock) {
            this.subBlock = HighlightListCopier.copy(subBlock);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subBlock(Highlight ... subBlock) {
            this.subBlock(Arrays.asList(subBlock));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subBlock(Consumer<Highlight.Builder> ... subBlock) {
            this.subBlock(Stream.of(subBlock).map(c -> (Highlight)((Highlight.Builder)Highlight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<List<Highlight.Builder>> getIntersection() {
            List<List<Highlight.Builder>> result = IntersectionHighlightsListCopier.copyToBuilder(this.intersection);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntersection(Collection<? extends Collection<Highlight.BuilderImpl>> intersection) {
            this.intersection = IntersectionHighlightsListCopier.copyFromBuilder(intersection);
        }

        @Override
        public final Builder intersection(Collection<? extends Collection<Highlight>> intersection) {
            this.intersection = IntersectionHighlightsListCopier.copy(intersection);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intersection(Collection<Highlight> ... intersection) {
            this.intersection((Collection<? extends Collection<Highlight>>)Arrays.asList(intersection));
            return this;
        }

        public final List<Highlight.Builder> getPostalCode() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.postalCode);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPostalCode(Collection<Highlight.BuilderImpl> postalCode) {
            this.postalCode = HighlightListCopier.copyFromBuilder(postalCode);
        }

        @Override
        public final Builder postalCode(Collection<Highlight> postalCode) {
            this.postalCode = HighlightListCopier.copy(postalCode);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder postalCode(Highlight ... postalCode) {
            this.postalCode(Arrays.asList(postalCode));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder postalCode(Consumer<Highlight.Builder> ... postalCode) {
            this.postalCode(Stream.of(postalCode).map(c -> (Highlight)((Highlight.Builder)Highlight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Highlight.Builder> getAddressNumber() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.addressNumber);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddressNumber(Collection<Highlight.BuilderImpl> addressNumber) {
            this.addressNumber = HighlightListCopier.copyFromBuilder(addressNumber);
        }

        @Override
        public final Builder addressNumber(Collection<Highlight> addressNumber) {
            this.addressNumber = HighlightListCopier.copy(addressNumber);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressNumber(Highlight ... addressNumber) {
            this.addressNumber(Arrays.asList(addressNumber));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressNumber(Consumer<Highlight.Builder> ... addressNumber) {
            this.addressNumber(Stream.of(addressNumber).map(c -> (Highlight)((Highlight.Builder)Highlight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Highlight.Builder> getBuilding() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.building);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBuilding(Collection<Highlight.BuilderImpl> building) {
            this.building = HighlightListCopier.copyFromBuilder(building);
        }

        @Override
        public final Builder building(Collection<Highlight> building) {
            this.building = HighlightListCopier.copy(building);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder building(Highlight ... building) {
            this.building(Arrays.asList(building));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder building(Consumer<Highlight.Builder> ... building) {
            this.building(Stream.of(building).map(c -> (Highlight)((Highlight.Builder)Highlight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AutocompleteAddressHighlights build() {
            return new AutocompleteAddressHighlights(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutocompleteAddressHighlights> {
        public Builder label(Collection<Highlight> var1);

        public Builder label(Highlight ... var1);

        public Builder label(Consumer<Highlight.Builder> ... var1);

        public Builder country(CountryHighlights var1);

        default public Builder country(Consumer<CountryHighlights.Builder> country) {
            return this.country((CountryHighlights)((CountryHighlights.Builder)CountryHighlights.builder().applyMutation(country)).build());
        }

        public Builder region(RegionHighlights var1);

        default public Builder region(Consumer<RegionHighlights.Builder> region) {
            return this.region((RegionHighlights)((RegionHighlights.Builder)RegionHighlights.builder().applyMutation(region)).build());
        }

        public Builder subRegion(SubRegionHighlights var1);

        default public Builder subRegion(Consumer<SubRegionHighlights.Builder> subRegion) {
            return this.subRegion((SubRegionHighlights)((SubRegionHighlights.Builder)SubRegionHighlights.builder().applyMutation(subRegion)).build());
        }

        public Builder locality(Collection<Highlight> var1);

        public Builder locality(Highlight ... var1);

        public Builder locality(Consumer<Highlight.Builder> ... var1);

        public Builder district(Collection<Highlight> var1);

        public Builder district(Highlight ... var1);

        public Builder district(Consumer<Highlight.Builder> ... var1);

        public Builder subDistrict(Collection<Highlight> var1);

        public Builder subDistrict(Highlight ... var1);

        public Builder subDistrict(Consumer<Highlight.Builder> ... var1);

        public Builder street(Collection<Highlight> var1);

        public Builder street(Highlight ... var1);

        public Builder street(Consumer<Highlight.Builder> ... var1);

        public Builder block(Collection<Highlight> var1);

        public Builder block(Highlight ... var1);

        public Builder block(Consumer<Highlight.Builder> ... var1);

        public Builder subBlock(Collection<Highlight> var1);

        public Builder subBlock(Highlight ... var1);

        public Builder subBlock(Consumer<Highlight.Builder> ... var1);

        public Builder intersection(Collection<? extends Collection<Highlight>> var1);

        public Builder intersection(Collection<Highlight> ... var1);

        public Builder postalCode(Collection<Highlight> var1);

        public Builder postalCode(Highlight ... var1);

        public Builder postalCode(Consumer<Highlight.Builder> ... var1);

        public Builder addressNumber(Collection<Highlight> var1);

        public Builder addressNumber(Highlight ... var1);

        public Builder addressNumber(Consumer<Highlight.Builder> ... var1);

        public Builder building(Collection<Highlight> var1);

        public Builder building(Highlight ... var1);

        public Builder building(Consumer<Highlight.Builder> ... var1);
    }
}

