/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.GeoPlacesRequest;
import software.amazon.awssdk.services.geoplaces.model.PositionCopier;
import software.amazon.awssdk.services.geoplaces.model.SearchNearbyAdditionalFeature;
import software.amazon.awssdk.services.geoplaces.model.SearchNearbyAdditionalFeatureListCopier;
import software.amazon.awssdk.services.geoplaces.model.SearchNearbyFilter;
import software.amazon.awssdk.services.geoplaces.model.SearchNearbyIntendedUse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchNearbyRequest
extends GeoPlacesRequest
implements ToCopyableBuilder<Builder, SearchNearbyRequest> {
    private static final SdkField<List<Double>> QUERY_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueryPosition").getter(SearchNearbyRequest.getter(SearchNearbyRequest::queryPosition)).setter(SearchNearbyRequest.setter(Builder::queryPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryPosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> QUERY_RADIUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("QueryRadius").getter(SearchNearbyRequest.getter(SearchNearbyRequest::queryRadius)).setter(SearchNearbyRequest.setter(Builder::queryRadius)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryRadius").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(SearchNearbyRequest.getter(SearchNearbyRequest::maxResults)).setter(SearchNearbyRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<SearchNearbyFilter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(SearchNearbyRequest.getter(SearchNearbyRequest::filter)).setter(SearchNearbyRequest.setter(Builder::filter)).constructor(SearchNearbyFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalFeatures").getter(SearchNearbyRequest.getter(SearchNearbyRequest::additionalFeaturesAsStrings)).setter(SearchNearbyRequest.setter(Builder::additionalFeaturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalFeatures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Language").getter(SearchNearbyRequest.getter(SearchNearbyRequest::language)).setter(SearchNearbyRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()}).build();
    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoliticalView").getter(SearchNearbyRequest.getter(SearchNearbyRequest::politicalView)).setter(SearchNearbyRequest.setter(Builder::politicalView)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoliticalView").build()}).build();
    private static final SdkField<String> INTENDED_USE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntendedUse").getter(SearchNearbyRequest.getter(SearchNearbyRequest::intendedUseAsString)).setter(SearchNearbyRequest.setter(Builder::intendedUse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntendedUse").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchNearbyRequest.getter(SearchNearbyRequest::nextToken)).setter(SearchNearbyRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(SearchNearbyRequest.getter(SearchNearbyRequest::key)).setter(SearchNearbyRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_POSITION_FIELD, QUERY_RADIUS_FIELD, MAX_RESULTS_FIELD, FILTER_FIELD, ADDITIONAL_FEATURES_FIELD, LANGUAGE_FIELD, POLITICAL_VIEW_FIELD, INTENDED_USE_FIELD, NEXT_TOKEN_FIELD, KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("QueryPosition", QUERY_POSITION_FIELD);
            this.put("QueryRadius", QUERY_RADIUS_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("Filter", FILTER_FIELD);
            this.put("AdditionalFeatures", ADDITIONAL_FEATURES_FIELD);
            this.put("Language", LANGUAGE_FIELD);
            this.put("PoliticalView", POLITICAL_VIEW_FIELD);
            this.put("IntendedUse", INTENDED_USE_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("key", KEY_FIELD);
        }
    });
    private final List<Double> queryPosition;
    private final Long queryRadius;
    private final Integer maxResults;
    private final SearchNearbyFilter filter;
    private final List<String> additionalFeatures;
    private final String language;
    private final String politicalView;
    private final String intendedUse;
    private final String nextToken;
    private final String key;

    private SearchNearbyRequest(BuilderImpl builder) {
        super(builder);
        this.queryPosition = builder.queryPosition;
        this.queryRadius = builder.queryRadius;
        this.maxResults = builder.maxResults;
        this.filter = builder.filter;
        this.additionalFeatures = builder.additionalFeatures;
        this.language = builder.language;
        this.politicalView = builder.politicalView;
        this.intendedUse = builder.intendedUse;
        this.nextToken = builder.nextToken;
        this.key = builder.key;
    }

    public final boolean hasQueryPosition() {
        return this.queryPosition != null && !(this.queryPosition instanceof SdkAutoConstructList);
    }

    public final List<Double> queryPosition() {
        return this.queryPosition;
    }

    public final Long queryRadius() {
        return this.queryRadius;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final SearchNearbyFilter filter() {
        return this.filter;
    }

    public final List<SearchNearbyAdditionalFeature> additionalFeatures() {
        return SearchNearbyAdditionalFeatureListCopier.copyStringToEnum(this.additionalFeatures);
    }

    public final boolean hasAdditionalFeatures() {
        return this.additionalFeatures != null && !(this.additionalFeatures instanceof SdkAutoConstructList);
    }

    public final List<String> additionalFeaturesAsStrings() {
        return this.additionalFeatures;
    }

    public final String language() {
        return this.language;
    }

    public final String politicalView() {
        return this.politicalView;
    }

    public final SearchNearbyIntendedUse intendedUse() {
        return SearchNearbyIntendedUse.fromValue(this.intendedUse);
    }

    public final String intendedUseAsString() {
        return this.intendedUse;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String key() {
        return this.key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryPosition() ? this.queryPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.queryRadius());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalFeatures() ? this.additionalFeaturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(this.intendedUseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchNearbyRequest)) {
            return false;
        }
        SearchNearbyRequest other = (SearchNearbyRequest)((Object)obj);
        return this.hasQueryPosition() == other.hasQueryPosition() && Objects.equals(this.queryPosition(), other.queryPosition()) && Objects.equals(this.queryRadius(), other.queryRadius()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.filter(), other.filter()) && this.hasAdditionalFeatures() == other.hasAdditionalFeatures() && Objects.equals(this.additionalFeaturesAsStrings(), other.additionalFeaturesAsStrings()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.politicalView(), other.politicalView()) && Objects.equals(this.intendedUseAsString(), other.intendedUseAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.key(), other.key());
    }

    public final String toString() {
        return ToString.builder((String)"SearchNearbyRequest").add("QueryPosition", (Object)(this.queryPosition() == null ? null : "*** Sensitive Data Redacted ***")).add("QueryRadius", (Object)this.queryRadius()).add("MaxResults", (Object)this.maxResults()).add("Filter", (Object)this.filter()).add("AdditionalFeatures", this.hasAdditionalFeatures() ? this.additionalFeaturesAsStrings() : null).add("Language", (Object)this.language()).add("PoliticalView", (Object)this.politicalView()).add("IntendedUse", (Object)this.intendedUseAsString()).add("NextToken", (Object)this.nextToken()).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryPosition": {
                return Optional.ofNullable(clazz.cast(this.queryPosition()));
            }
            case "QueryRadius": {
                return Optional.ofNullable(clazz.cast(this.queryRadius()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "AdditionalFeatures": {
                return Optional.ofNullable(clazz.cast(this.additionalFeaturesAsStrings()));
            }
            case "Language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "PoliticalView": {
                return Optional.ofNullable(clazz.cast(this.politicalView()));
            }
            case "IntendedUse": {
                return Optional.ofNullable(clazz.cast(this.intendedUseAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchNearbyRequest, T> g) {
        return obj -> g.apply((SearchNearbyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoPlacesRequest.BuilderImpl
    implements Builder {
        private List<Double> queryPosition = DefaultSdkAutoConstructList.getInstance();
        private Long queryRadius;
        private Integer maxResults;
        private SearchNearbyFilter filter;
        private List<String> additionalFeatures = DefaultSdkAutoConstructList.getInstance();
        private String language;
        private String politicalView;
        private String intendedUse;
        private String nextToken;
        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchNearbyRequest model) {
            super(model);
            this.queryPosition(model.queryPosition);
            this.queryRadius(model.queryRadius);
            this.maxResults(model.maxResults);
            this.filter(model.filter);
            this.additionalFeaturesWithStrings(model.additionalFeatures);
            this.language(model.language);
            this.politicalView(model.politicalView);
            this.intendedUse(model.intendedUse);
            this.nextToken(model.nextToken);
            this.key(model.key);
        }

        public final Collection<Double> getQueryPosition() {
            if (this.queryPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queryPosition;
        }

        public final void setQueryPosition(Collection<Double> queryPosition) {
            this.queryPosition = PositionCopier.copy(queryPosition);
        }

        @Override
        public final Builder queryPosition(Collection<Double> queryPosition) {
            this.queryPosition = PositionCopier.copy(queryPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryPosition(Double ... queryPosition) {
            this.queryPosition(Arrays.asList(queryPosition));
            return this;
        }

        public final Long getQueryRadius() {
            return this.queryRadius;
        }

        public final void setQueryRadius(Long queryRadius) {
            this.queryRadius = queryRadius;
        }

        @Override
        public final Builder queryRadius(Long queryRadius) {
            this.queryRadius = queryRadius;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final SearchNearbyFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(SearchNearbyFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(SearchNearbyFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Collection<String> getAdditionalFeatures() {
            if (this.additionalFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalFeatures;
        }

        public final void setAdditionalFeatures(Collection<String> additionalFeatures) {
            this.additionalFeatures = SearchNearbyAdditionalFeatureListCopier.copy(additionalFeatures);
        }

        @Override
        public final Builder additionalFeaturesWithStrings(Collection<String> additionalFeatures) {
            this.additionalFeatures = SearchNearbyAdditionalFeatureListCopier.copy(additionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalFeaturesWithStrings(String ... additionalFeatures) {
            this.additionalFeaturesWithStrings(Arrays.asList(additionalFeatures));
            return this;
        }

        @Override
        public final Builder additionalFeatures(Collection<SearchNearbyAdditionalFeature> additionalFeatures) {
            this.additionalFeatures = SearchNearbyAdditionalFeatureListCopier.copyEnumToString(additionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalFeatures(SearchNearbyAdditionalFeature ... additionalFeatures) {
            this.additionalFeatures(Arrays.asList(additionalFeatures));
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getPoliticalView() {
            return this.politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final String getIntendedUse() {
            return this.intendedUse;
        }

        public final void setIntendedUse(String intendedUse) {
            this.intendedUse = intendedUse;
        }

        @Override
        public final Builder intendedUse(String intendedUse) {
            this.intendedUse = intendedUse;
            return this;
        }

        @Override
        public final Builder intendedUse(SearchNearbyIntendedUse intendedUse) {
            this.intendedUse(intendedUse == null ? null : intendedUse.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchNearbyRequest build() {
            return new SearchNearbyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GeoPlacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchNearbyRequest> {
        public Builder queryPosition(Collection<Double> var1);

        public Builder queryPosition(Double ... var1);

        public Builder queryRadius(Long var1);

        public Builder maxResults(Integer var1);

        public Builder filter(SearchNearbyFilter var1);

        default public Builder filter(Consumer<SearchNearbyFilter.Builder> filter) {
            return this.filter((SearchNearbyFilter)((SearchNearbyFilter.Builder)SearchNearbyFilter.builder().applyMutation(filter)).build());
        }

        public Builder additionalFeaturesWithStrings(Collection<String> var1);

        public Builder additionalFeaturesWithStrings(String ... var1);

        public Builder additionalFeatures(Collection<SearchNearbyAdditionalFeature> var1);

        public Builder additionalFeatures(SearchNearbyAdditionalFeature ... var1);

        public Builder language(String var1);

        public Builder politicalView(String var1);

        public Builder intendedUse(String var1);

        public Builder intendedUse(SearchNearbyIntendedUse var1);

        public Builder nextToken(String var1);

        public Builder key(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

