/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.geoplaces.model.AccessDeniedException;
import software.amazon.awssdk.services.geoplaces.model.AutocompleteRequest;
import software.amazon.awssdk.services.geoplaces.model.AutocompleteResponse;
import software.amazon.awssdk.services.geoplaces.model.GeoPlacesException;
import software.amazon.awssdk.services.geoplaces.model.GeocodeRequest;
import software.amazon.awssdk.services.geoplaces.model.GeocodeResponse;
import software.amazon.awssdk.services.geoplaces.model.GetPlaceRequest;
import software.amazon.awssdk.services.geoplaces.model.GetPlaceResponse;
import software.amazon.awssdk.services.geoplaces.model.InternalServerException;
import software.amazon.awssdk.services.geoplaces.model.ReverseGeocodeRequest;
import software.amazon.awssdk.services.geoplaces.model.ReverseGeocodeResponse;
import software.amazon.awssdk.services.geoplaces.model.SearchNearbyRequest;
import software.amazon.awssdk.services.geoplaces.model.SearchNearbyResponse;
import software.amazon.awssdk.services.geoplaces.model.SearchTextRequest;
import software.amazon.awssdk.services.geoplaces.model.SearchTextResponse;
import software.amazon.awssdk.services.geoplaces.model.SuggestRequest;
import software.amazon.awssdk.services.geoplaces.model.SuggestResponse;
import software.amazon.awssdk.services.geoplaces.model.ThrottlingException;
import software.amazon.awssdk.services.geoplaces.model.ValidationException;

/**
 * Service client for accessing Amazon Location Service Places V2. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * The Places API enables powerful location search and geocoding capabilities for your applications, offering global
 * coverage with rich, detailed information. Key features include:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Forward and reverse geocoding for addresses and coordinates
 * </p>
 * </li>
 * <li>
 * <p>
 * Comprehensive place searches with detailed information, including:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Business names and addresses
 * </p>
 * </li>
 * <li>
 * <p>
 * Contact information
 * </p>
 * </li>
 * <li>
 * <p>
 * Hours of operation
 * </p>
 * </li>
 * <li>
 * <p>
 * POI (Points of Interest) categories
 * </p>
 * </li>
 * <li>
 * <p>
 * Food types for restaurants
 * </p>
 * </li>
 * <li>
 * <p>
 * Chain affiliation for relevant businesses
 * </p>
 * </li>
 * </ul>
 * </li>
 * <li>
 * <p>
 * Global data coverage with a wide range of POI categories
 * </p>
 * </li>
 * <li>
 * <p>
 * Regular data updates to ensure accuracy and relevance
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GeoPlacesClient extends AwsClient {
    String SERVICE_NAME = "geo-places";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "geo-places";

    /**
     * <p>
     * The autocomplete operation speeds up and increases the accuracy of entering addresses by providing a list of
     * address candidates matching a partially entered address. Results are sorted from most to least matching.
     * Filtering and biasing can be used to increase the relevance of the results if additional search context is known
     * </p>
     *
     * @param autocompleteRequest
     * @return Result of the Autocomplete operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoPlacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoPlacesClient.Autocomplete
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-places-2020-11-19/Autocomplete" target="_top">AWS API
     *      Documentation</a>
     */
    default AutocompleteResponse autocomplete(AutocompleteRequest autocompleteRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            GeoPlacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The autocomplete operation speeds up and increases the accuracy of entering addresses by providing a list of
     * address candidates matching a partially entered address. Results are sorted from most to least matching.
     * Filtering and biasing can be used to increase the relevance of the results if additional search context is known
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AutocompleteRequest.Builder} avoiding the need to
     * create one manually via {@link AutocompleteRequest#builder()}
     * </p>
     *
     * @param autocompleteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.geoplaces.model.AutocompleteRequest.Builder} to create a request.
     * @return Result of the Autocomplete operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoPlacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoPlacesClient.Autocomplete
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-places-2020-11-19/Autocomplete" target="_top">AWS API
     *      Documentation</a>
     */
    default AutocompleteResponse autocomplete(Consumer<AutocompleteRequest.Builder> autocompleteRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, GeoPlacesException {
        return autocomplete(AutocompleteRequest.builder().applyMutation(autocompleteRequest).build());
    }

    /**
     * <p>
     * The <code>Geocode</code> action allows you to obtain coordinates, addresses, and other information about places.
     * </p>
     *
     * @param geocodeRequest
     * @return Result of the Geocode operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoPlacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoPlacesClient.Geocode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-places-2020-11-19/Geocode" target="_top">AWS API
     *      Documentation</a>
     */
    default GeocodeResponse geocode(GeocodeRequest geocodeRequest) throws InternalServerException, AccessDeniedException,
            ValidationException, ThrottlingException, AwsServiceException, SdkClientException, GeoPlacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>Geocode</code> action allows you to obtain coordinates, addresses, and other information about places.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GeocodeRequest.Builder} avoiding the need to create
     * one manually via {@link GeocodeRequest#builder()}
     * </p>
     *
     * @param geocodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.geoplaces.model.GeocodeRequest.Builder} to create a request.
     * @return Result of the Geocode operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoPlacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoPlacesClient.Geocode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-places-2020-11-19/Geocode" target="_top">AWS API
     *      Documentation</a>
     */
    default GeocodeResponse geocode(Consumer<GeocodeRequest.Builder> geocodeRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            GeoPlacesException {
        return geocode(GeocodeRequest.builder().applyMutation(geocodeRequest).build());
    }

    /**
     * <p>
     * Finds a place by its unique ID. A <code>PlaceId</code> is returned by other place operations.
     * </p>
     *
     * @param getPlaceRequest
     * @return Result of the GetPlace operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoPlacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoPlacesClient.GetPlace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-places-2020-11-19/GetPlace" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPlaceResponse getPlace(GetPlaceRequest getPlaceRequest) throws InternalServerException, AccessDeniedException,
            ValidationException, ThrottlingException, AwsServiceException, SdkClientException, GeoPlacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Finds a place by its unique ID. A <code>PlaceId</code> is returned by other place operations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPlaceRequest.Builder} avoiding the need to
     * create one manually via {@link GetPlaceRequest#builder()}
     * </p>
     *
     * @param getPlaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.geoplaces.model.GetPlaceRequest.Builder} to create a request.
     * @return Result of the GetPlace operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoPlacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoPlacesClient.GetPlace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-places-2020-11-19/GetPlace" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPlaceResponse getPlace(Consumer<GetPlaceRequest.Builder> getPlaceRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            GeoPlacesException {
        return getPlace(GetPlaceRequest.builder().applyMutation(getPlaceRequest).build());
    }

    /**
     * <p>
     * The <code>ReverseGeocode</code> operation allows you to retrieve addresses and place information from
     * coordinates.
     * </p>
     *
     * @param reverseGeocodeRequest
     * @return Result of the ReverseGeocode operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoPlacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoPlacesClient.ReverseGeocode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-places-2020-11-19/ReverseGeocode" target="_top">AWS API
     *      Documentation</a>
     */
    default ReverseGeocodeResponse reverseGeocode(ReverseGeocodeRequest reverseGeocodeRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            GeoPlacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>ReverseGeocode</code> operation allows you to retrieve addresses and place information from
     * coordinates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReverseGeocodeRequest.Builder} avoiding the need to
     * create one manually via {@link ReverseGeocodeRequest#builder()}
     * </p>
     *
     * @param reverseGeocodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.geoplaces.model.ReverseGeocodeRequest.Builder} to create a request.
     * @return Result of the ReverseGeocode operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoPlacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoPlacesClient.ReverseGeocode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-places-2020-11-19/ReverseGeocode" target="_top">AWS API
     *      Documentation</a>
     */
    default ReverseGeocodeResponse reverseGeocode(Consumer<ReverseGeocodeRequest.Builder> reverseGeocodeRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, GeoPlacesException {
        return reverseGeocode(ReverseGeocodeRequest.builder().applyMutation(reverseGeocodeRequest).build());
    }

    /**
     * <p>
     * Search nearby a specified location.
     * </p>
     *
     * @param searchNearbyRequest
     * @return Result of the SearchNearby operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoPlacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoPlacesClient.SearchNearby
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-places-2020-11-19/SearchNearby" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchNearbyResponse searchNearby(SearchNearbyRequest searchNearbyRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            GeoPlacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Search nearby a specified location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchNearbyRequest.Builder} avoiding the need to
     * create one manually via {@link SearchNearbyRequest#builder()}
     * </p>
     *
     * @param searchNearbyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.geoplaces.model.SearchNearbyRequest.Builder} to create a request.
     * @return Result of the SearchNearby operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoPlacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoPlacesClient.SearchNearby
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-places-2020-11-19/SearchNearby" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchNearbyResponse searchNearby(Consumer<SearchNearbyRequest.Builder> searchNearbyRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, GeoPlacesException {
        return searchNearby(SearchNearbyRequest.builder().applyMutation(searchNearbyRequest).build());
    }

    /**
     * <p>
     * Use the <code>SearchText</code> operation to search for geocode and place information. You can then complete a
     * follow-up query suggested from the <code>Suggest</code> API via a query id.
     * </p>
     *
     * @param searchTextRequest
     * @return Result of the SearchText operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoPlacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoPlacesClient.SearchText
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-places-2020-11-19/SearchText" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchTextResponse searchText(SearchTextRequest searchTextRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            GeoPlacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use the <code>SearchText</code> operation to search for geocode and place information. You can then complete a
     * follow-up query suggested from the <code>Suggest</code> API via a query id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchTextRequest.Builder} avoiding the need to
     * create one manually via {@link SearchTextRequest#builder()}
     * </p>
     *
     * @param searchTextRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.geoplaces.model.SearchTextRequest.Builder} to create a request.
     * @return Result of the SearchText operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoPlacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoPlacesClient.SearchText
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-places-2020-11-19/SearchText" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchTextResponse searchText(Consumer<SearchTextRequest.Builder> searchTextRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            GeoPlacesException {
        return searchText(SearchTextRequest.builder().applyMutation(searchTextRequest).build());
    }

    /**
     * <p>
     * The <code>Suggest</code> operation finds addresses or place candidates based on incomplete or misspelled queries.
     * You then select the best query to submit based on the returned results.
     * </p>
     *
     * @param suggestRequest
     * @return Result of the Suggest operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoPlacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoPlacesClient.Suggest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-places-2020-11-19/Suggest" target="_top">AWS API
     *      Documentation</a>
     */
    default SuggestResponse suggest(SuggestRequest suggestRequest) throws InternalServerException, AccessDeniedException,
            ValidationException, ThrottlingException, AwsServiceException, SdkClientException, GeoPlacesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>Suggest</code> operation finds addresses or place candidates based on incomplete or misspelled queries.
     * You then select the best query to submit based on the returned results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SuggestRequest.Builder} avoiding the need to create
     * one manually via {@link SuggestRequest#builder()}
     * </p>
     *
     * @param suggestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.geoplaces.model.SuggestRequest.Builder} to create a request.
     * @return Result of the Suggest operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoPlacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoPlacesClient.Suggest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-places-2020-11-19/Suggest" target="_top">AWS API
     *      Documentation</a>
     */
    default SuggestResponse suggest(Consumer<SuggestRequest.Builder> suggestRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            GeoPlacesException {
        return suggest(SuggestRequest.builder().applyMutation(suggestRequest).build());
    }

    /**
     * Create a {@link GeoPlacesClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GeoPlacesClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GeoPlacesClient}.
     */
    static GeoPlacesClientBuilder builder() {
        return new DefaultGeoPlacesClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default GeoPlacesServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
