/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes how the parts of the response element matched the input query by returning the sections of the response
 * which matched to input query terms.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutocompleteAddressHighlights implements SdkPojo, Serializable,
        ToCopyableBuilder<AutocompleteAddressHighlights.Builder, AutocompleteAddressHighlights> {
    private static final SdkField<List<Highlight>> LABEL_FIELD = SdkField
            .<List<Highlight>> builder(MarshallingType.LIST)
            .memberName("Label")
            .getter(getter(AutocompleteAddressHighlights::label))
            .setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Highlight> builder(MarshallingType.SDK_POJO)
                                            .constructor(Highlight::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CountryHighlights> COUNTRY_FIELD = SdkField
            .<CountryHighlights> builder(MarshallingType.SDK_POJO).memberName("Country")
            .getter(getter(AutocompleteAddressHighlights::country)).setter(setter(Builder::country))
            .constructor(CountryHighlights::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<RegionHighlights> REGION_FIELD = SdkField.<RegionHighlights> builder(MarshallingType.SDK_POJO)
            .memberName("Region").getter(getter(AutocompleteAddressHighlights::region)).setter(setter(Builder::region))
            .constructor(RegionHighlights::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<SubRegionHighlights> SUB_REGION_FIELD = SdkField
            .<SubRegionHighlights> builder(MarshallingType.SDK_POJO).memberName("SubRegion")
            .getter(getter(AutocompleteAddressHighlights::subRegion)).setter(setter(Builder::subRegion))
            .constructor(SubRegionHighlights::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubRegion").build()).build();

    private static final SdkField<List<Highlight>> LOCALITY_FIELD = SdkField
            .<List<Highlight>> builder(MarshallingType.LIST)
            .memberName("Locality")
            .getter(getter(AutocompleteAddressHighlights::locality))
            .setter(setter(Builder::locality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locality").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Highlight> builder(MarshallingType.SDK_POJO)
                                            .constructor(Highlight::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Highlight>> DISTRICT_FIELD = SdkField
            .<List<Highlight>> builder(MarshallingType.LIST)
            .memberName("District")
            .getter(getter(AutocompleteAddressHighlights::district))
            .setter(setter(Builder::district))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("District").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Highlight> builder(MarshallingType.SDK_POJO)
                                            .constructor(Highlight::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Highlight>> SUB_DISTRICT_FIELD = SdkField
            .<List<Highlight>> builder(MarshallingType.LIST)
            .memberName("SubDistrict")
            .getter(getter(AutocompleteAddressHighlights::subDistrict))
            .setter(setter(Builder::subDistrict))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubDistrict").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Highlight> builder(MarshallingType.SDK_POJO)
                                            .constructor(Highlight::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Highlight>> STREET_FIELD = SdkField
            .<List<Highlight>> builder(MarshallingType.LIST)
            .memberName("Street")
            .getter(getter(AutocompleteAddressHighlights::street))
            .setter(setter(Builder::street))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Street").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Highlight> builder(MarshallingType.SDK_POJO)
                                            .constructor(Highlight::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Highlight>> BLOCK_FIELD = SdkField
            .<List<Highlight>> builder(MarshallingType.LIST)
            .memberName("Block")
            .getter(getter(AutocompleteAddressHighlights::block))
            .setter(setter(Builder::block))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Block").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Highlight> builder(MarshallingType.SDK_POJO)
                                            .constructor(Highlight::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Highlight>> SUB_BLOCK_FIELD = SdkField
            .<List<Highlight>> builder(MarshallingType.LIST)
            .memberName("SubBlock")
            .getter(getter(AutocompleteAddressHighlights::subBlock))
            .setter(setter(Builder::subBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubBlock").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Highlight> builder(MarshallingType.SDK_POJO)
                                            .constructor(Highlight::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<List<Highlight>>> INTERSECTION_FIELD = SdkField
            .<List<List<Highlight>>> builder(MarshallingType.LIST)
            .memberName("Intersection")
            .getter(getter(AutocompleteAddressHighlights::intersection))
            .setter(setter(Builder::intersection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Intersection").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<Highlight>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<Highlight> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(Highlight::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<Highlight>> POSTAL_CODE_FIELD = SdkField
            .<List<Highlight>> builder(MarshallingType.LIST)
            .memberName("PostalCode")
            .getter(getter(AutocompleteAddressHighlights::postalCode))
            .setter(setter(Builder::postalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Highlight> builder(MarshallingType.SDK_POJO)
                                            .constructor(Highlight::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Highlight>> ADDRESS_NUMBER_FIELD = SdkField
            .<List<Highlight>> builder(MarshallingType.LIST)
            .memberName("AddressNumber")
            .getter(getter(AutocompleteAddressHighlights::addressNumber))
            .setter(setter(Builder::addressNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressNumber").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Highlight> builder(MarshallingType.SDK_POJO)
                                            .constructor(Highlight::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Highlight>> BUILDING_FIELD = SdkField
            .<List<Highlight>> builder(MarshallingType.LIST)
            .memberName("Building")
            .getter(getter(AutocompleteAddressHighlights::building))
            .setter(setter(Builder::building))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Building").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Highlight> builder(MarshallingType.SDK_POJO)
                                            .constructor(Highlight::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_FIELD, COUNTRY_FIELD,
            REGION_FIELD, SUB_REGION_FIELD, LOCALITY_FIELD, DISTRICT_FIELD, SUB_DISTRICT_FIELD, STREET_FIELD, BLOCK_FIELD,
            SUB_BLOCK_FIELD, INTERSECTION_FIELD, POSTAL_CODE_FIELD, ADDRESS_NUMBER_FIELD, BUILDING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Label", LABEL_FIELD);
                    put("Country", COUNTRY_FIELD);
                    put("Region", REGION_FIELD);
                    put("SubRegion", SUB_REGION_FIELD);
                    put("Locality", LOCALITY_FIELD);
                    put("District", DISTRICT_FIELD);
                    put("SubDistrict", SUB_DISTRICT_FIELD);
                    put("Street", STREET_FIELD);
                    put("Block", BLOCK_FIELD);
                    put("SubBlock", SUB_BLOCK_FIELD);
                    put("Intersection", INTERSECTION_FIELD);
                    put("PostalCode", POSTAL_CODE_FIELD);
                    put("AddressNumber", ADDRESS_NUMBER_FIELD);
                    put("Building", BUILDING_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<Highlight> label;

    private final CountryHighlights country;

    private final RegionHighlights region;

    private final SubRegionHighlights subRegion;

    private final List<Highlight> locality;

    private final List<Highlight> district;

    private final List<Highlight> subDistrict;

    private final List<Highlight> street;

    private final List<Highlight> block;

    private final List<Highlight> subBlock;

    private final List<List<Highlight>> intersection;

    private final List<Highlight> postalCode;

    private final List<Highlight> addressNumber;

    private final List<Highlight> building;

    private AutocompleteAddressHighlights(BuilderImpl builder) {
        this.label = builder.label;
        this.country = builder.country;
        this.region = builder.region;
        this.subRegion = builder.subRegion;
        this.locality = builder.locality;
        this.district = builder.district;
        this.subDistrict = builder.subDistrict;
        this.street = builder.street;
        this.block = builder.block;
        this.subBlock = builder.subBlock;
        this.intersection = builder.intersection;
        this.postalCode = builder.postalCode;
        this.addressNumber = builder.addressNumber;
        this.building = builder.building;
    }

    /**
     * For responses, this returns true if the service returned a value for the Label property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasLabel() {
        return label != null && !(label instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the starting and ending indexes for result items where they are identified to match the input query.
     * This should be used to provide emphasis to output display to make selecting the correct result from a list easier
     * for end users.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabel} method.
     * </p>
     * 
     * @return Indicates the starting and ending indexes for result items where they are identified to match the input
     *         query. This should be used to provide emphasis to output display to make selecting the correct result
     *         from a list easier for end users.
     */
    public final List<Highlight> label() {
        return label;
    }

    /**
     * <p>
     * The alpha-2 or alpha-3 character code for the country that the results will be present in.
     * </p>
     * 
     * @return The alpha-2 or alpha-3 character code for the country that the results will be present in.
     */
    public final CountryHighlights country() {
        return country;
    }

    /**
     * <p>
     * The region or state results should be to be present in.
     * </p>
     * <p>
     * Example: <code>North Rhine-Westphalia</code>.
     * </p>
     * 
     * @return The region or state results should be to be present in. </p>
     *         <p>
     *         Example: <code>North Rhine-Westphalia</code>.
     */
    public final RegionHighlights region() {
        return region;
    }

    /**
     * <p>
     * The sub-region or county for which results should be present in.
     * </p>
     * 
     * @return The sub-region or county for which results should be present in.
     */
    public final SubRegionHighlights subRegion() {
        return subRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Locality property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLocality() {
        return locality != null && !(locality instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The city or locality results should be present in.
     * </p>
     * <p>
     * Example: <code>Vancouver</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocality} method.
     * </p>
     * 
     * @return The city or locality results should be present in. </p>
     *         <p>
     *         Example: <code>Vancouver</code>.
     */
    public final List<Highlight> locality() {
        return locality;
    }

    /**
     * For responses, this returns true if the service returned a value for the District property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDistrict() {
        return district != null && !(district instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The district or division of a city the results should be present in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDistrict} method.
     * </p>
     * 
     * @return The district or division of a city the results should be present in.
     */
    public final List<Highlight> district() {
        return district;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubDistrict property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubDistrict() {
        return subDistrict != null && !(subDistrict instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the starting and ending index of the title in the text query that match the found title.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubDistrict} method.
     * </p>
     * 
     * @return Indicates the starting and ending index of the title in the text query that match the found title.
     */
    public final List<Highlight> subDistrict() {
        return subDistrict;
    }

    /**
     * For responses, this returns true if the service returned a value for the Street property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStreet() {
        return street != null && !(street instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the street results should be present in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStreet} method.
     * </p>
     * 
     * @return The name of the street results should be present in.
     */
    public final List<Highlight> street() {
        return street;
    }

    /**
     * For responses, this returns true if the service returned a value for the Block property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasBlock() {
        return block != null && !(block instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Name of the block. Example: Sunny Mansion 203 block: 2 Chome
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlock} method.
     * </p>
     * 
     * @return Name of the block. Example: Sunny Mansion 203 block: 2 Chome
     */
    public final List<Highlight> block() {
        return block;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubBlock property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubBlock() {
        return subBlock != null && !(subBlock instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Name of sub-block. Example Sunny Mansion 203 sub-block: 4
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubBlock} method.
     * </p>
     * 
     * @return Name of sub-block. Example Sunny Mansion 203 sub-block: 4
     */
    public final List<Highlight> subBlock() {
        return subBlock;
    }

    /**
     * For responses, this returns true if the service returned a value for the Intersection property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIntersection() {
        return intersection != null && !(intersection instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Name of the streets in the intersection. For example: e.g. ["Friedrichstraße","Unter den Linden"]
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntersection} method.
     * </p>
     * 
     * @return Name of the streets in the intersection. For example: e.g. ["Friedrichstraße","Unter den Linden"]
     */
    public final List<List<Highlight>> intersection() {
        return intersection;
    }

    /**
     * For responses, this returns true if the service returned a value for the PostalCode property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPostalCode() {
        return postalCode != null && !(postalCode instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An alphanumeric string included in a postal address to facilitate mail sorting, such as post code, postcode, or
     * ZIP code for which the result should posses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPostalCode} method.
     * </p>
     * 
     * @return An alphanumeric string included in a postal address to facilitate mail sorting, such as post code,
     *         postcode, or ZIP code for which the result should posses.
     */
    public final List<Highlight> postalCode() {
        return postalCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddressNumber property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddressNumber() {
        return addressNumber != null && !(addressNumber instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The house number or address results should have.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddressNumber} method.
     * </p>
     * 
     * @return The house number or address results should have.
     */
    public final List<Highlight> addressNumber() {
        return addressNumber;
    }

    /**
     * For responses, this returns true if the service returned a value for the Building property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBuilding() {
        return building != null && !(building instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the building at the address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBuilding} method.
     * </p>
     * 
     * @return The name of the building at the address.
     */
    public final List<Highlight> building() {
        return building;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLabel() ? label() : null);
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(subRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocality() ? locality() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDistrict() ? district() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubDistrict() ? subDistrict() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStreet() ? street() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBlock() ? block() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubBlock() ? subBlock() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIntersection() ? intersection() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPostalCode() ? postalCode() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddressNumber() ? addressNumber() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBuilding() ? building() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutocompleteAddressHighlights)) {
            return false;
        }
        AutocompleteAddressHighlights other = (AutocompleteAddressHighlights) obj;
        return hasLabel() == other.hasLabel() && Objects.equals(label(), other.label())
                && Objects.equals(country(), other.country()) && Objects.equals(region(), other.region())
                && Objects.equals(subRegion(), other.subRegion()) && hasLocality() == other.hasLocality()
                && Objects.equals(locality(), other.locality()) && hasDistrict() == other.hasDistrict()
                && Objects.equals(district(), other.district()) && hasSubDistrict() == other.hasSubDistrict()
                && Objects.equals(subDistrict(), other.subDistrict()) && hasStreet() == other.hasStreet()
                && Objects.equals(street(), other.street()) && hasBlock() == other.hasBlock()
                && Objects.equals(block(), other.block()) && hasSubBlock() == other.hasSubBlock()
                && Objects.equals(subBlock(), other.subBlock()) && hasIntersection() == other.hasIntersection()
                && Objects.equals(intersection(), other.intersection()) && hasPostalCode() == other.hasPostalCode()
                && Objects.equals(postalCode(), other.postalCode()) && hasAddressNumber() == other.hasAddressNumber()
                && Objects.equals(addressNumber(), other.addressNumber()) && hasBuilding() == other.hasBuilding()
                && Objects.equals(building(), other.building());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutocompleteAddressHighlights").add("Label", hasLabel() ? label() : null)
                .add("Country", country()).add("Region", region()).add("SubRegion", subRegion())
                .add("Locality", hasLocality() ? locality() : null).add("District", hasDistrict() ? district() : null)
                .add("SubDistrict", hasSubDistrict() ? subDistrict() : null).add("Street", hasStreet() ? street() : null)
                .add("Block", hasBlock() ? block() : null).add("SubBlock", hasSubBlock() ? subBlock() : null)
                .add("Intersection", hasIntersection() ? intersection() : null)
                .add("PostalCode", hasPostalCode() ? postalCode() : null)
                .add("AddressNumber", hasAddressNumber() ? addressNumber() : null)
                .add("Building", hasBuilding() ? building() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "SubRegion":
            return Optional.ofNullable(clazz.cast(subRegion()));
        case "Locality":
            return Optional.ofNullable(clazz.cast(locality()));
        case "District":
            return Optional.ofNullable(clazz.cast(district()));
        case "SubDistrict":
            return Optional.ofNullable(clazz.cast(subDistrict()));
        case "Street":
            return Optional.ofNullable(clazz.cast(street()));
        case "Block":
            return Optional.ofNullable(clazz.cast(block()));
        case "SubBlock":
            return Optional.ofNullable(clazz.cast(subBlock()));
        case "Intersection":
            return Optional.ofNullable(clazz.cast(intersection()));
        case "PostalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        case "AddressNumber":
            return Optional.ofNullable(clazz.cast(addressNumber()));
        case "Building":
            return Optional.ofNullable(clazz.cast(building()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AutocompleteAddressHighlights, T> g) {
        return obj -> g.apply((AutocompleteAddressHighlights) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutocompleteAddressHighlights> {
        /**
         * <p>
         * Indicates the starting and ending indexes for result items where they are identified to match the input
         * query. This should be used to provide emphasis to output display to make selecting the correct result from a
         * list easier for end users.
         * </p>
         * 
         * @param label
         *        Indicates the starting and ending indexes for result items where they are identified to match the
         *        input query. This should be used to provide emphasis to output display to make selecting the correct
         *        result from a list easier for end users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(Collection<Highlight> label);

        /**
         * <p>
         * Indicates the starting and ending indexes for result items where they are identified to match the input
         * query. This should be used to provide emphasis to output display to make selecting the correct result from a
         * list easier for end users.
         * </p>
         * 
         * @param label
         *        Indicates the starting and ending indexes for result items where they are identified to match the
         *        input query. This should be used to provide emphasis to output display to make selecting the correct
         *        result from a list easier for end users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(Highlight... label);

        /**
         * <p>
         * Indicates the starting and ending indexes for result items where they are identified to match the input
         * query. This should be used to provide emphasis to output display to make selecting the correct result from a
         * list easier for end users.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.Highlight#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder#build()} is called immediately and
         * its result is passed to {@link #label(List<Highlight>)}.
         * 
         * @param label
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #label(java.util.Collection<Highlight>)
         */
        Builder label(Consumer<Highlight.Builder>... label);

        /**
         * <p>
         * The alpha-2 or alpha-3 character code for the country that the results will be present in.
         * </p>
         * 
         * @param country
         *        The alpha-2 or alpha-3 character code for the country that the results will be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(CountryHighlights country);

        /**
         * <p>
         * The alpha-2 or alpha-3 character code for the country that the results will be present in.
         * </p>
         * This is a convenience method that creates an instance of the {@link CountryHighlights.Builder} avoiding the
         * need to create one manually via {@link CountryHighlights#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CountryHighlights.Builder#build()} is called immediately and its
         * result is passed to {@link #country(CountryHighlights)}.
         * 
         * @param country
         *        a consumer that will call methods on {@link CountryHighlights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #country(CountryHighlights)
         */
        default Builder country(Consumer<CountryHighlights.Builder> country) {
            return country(CountryHighlights.builder().applyMutation(country).build());
        }

        /**
         * <p>
         * The region or state results should be to be present in.
         * </p>
         * <p>
         * Example: <code>North Rhine-Westphalia</code>.
         * </p>
         * 
         * @param region
         *        The region or state results should be to be present in. </p>
         *        <p>
         *        Example: <code>North Rhine-Westphalia</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(RegionHighlights region);

        /**
         * <p>
         * The region or state results should be to be present in.
         * </p>
         * <p>
         * Example: <code>North Rhine-Westphalia</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RegionHighlights.Builder} avoiding the
         * need to create one manually via {@link RegionHighlights#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RegionHighlights.Builder#build()} is called immediately and its
         * result is passed to {@link #region(RegionHighlights)}.
         * 
         * @param region
         *        a consumer that will call methods on {@link RegionHighlights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #region(RegionHighlights)
         */
        default Builder region(Consumer<RegionHighlights.Builder> region) {
            return region(RegionHighlights.builder().applyMutation(region).build());
        }

        /**
         * <p>
         * The sub-region or county for which results should be present in.
         * </p>
         * 
         * @param subRegion
         *        The sub-region or county for which results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subRegion(SubRegionHighlights subRegion);

        /**
         * <p>
         * The sub-region or county for which results should be present in.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubRegionHighlights.Builder} avoiding the
         * need to create one manually via {@link SubRegionHighlights#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubRegionHighlights.Builder#build()} is called immediately and
         * its result is passed to {@link #subRegion(SubRegionHighlights)}.
         * 
         * @param subRegion
         *        a consumer that will call methods on {@link SubRegionHighlights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subRegion(SubRegionHighlights)
         */
        default Builder subRegion(Consumer<SubRegionHighlights.Builder> subRegion) {
            return subRegion(SubRegionHighlights.builder().applyMutation(subRegion).build());
        }

        /**
         * <p>
         * The city or locality results should be present in.
         * </p>
         * <p>
         * Example: <code>Vancouver</code>.
         * </p>
         * 
         * @param locality
         *        The city or locality results should be present in. </p>
         *        <p>
         *        Example: <code>Vancouver</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locality(Collection<Highlight> locality);

        /**
         * <p>
         * The city or locality results should be present in.
         * </p>
         * <p>
         * Example: <code>Vancouver</code>.
         * </p>
         * 
         * @param locality
         *        The city or locality results should be present in. </p>
         *        <p>
         *        Example: <code>Vancouver</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locality(Highlight... locality);

        /**
         * <p>
         * The city or locality results should be present in.
         * </p>
         * <p>
         * Example: <code>Vancouver</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.Highlight#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder#build()} is called immediately and
         * its result is passed to {@link #locality(List<Highlight>)}.
         * 
         * @param locality
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #locality(java.util.Collection<Highlight>)
         */
        Builder locality(Consumer<Highlight.Builder>... locality);

        /**
         * <p>
         * The district or division of a city the results should be present in.
         * </p>
         * 
         * @param district
         *        The district or division of a city the results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder district(Collection<Highlight> district);

        /**
         * <p>
         * The district or division of a city the results should be present in.
         * </p>
         * 
         * @param district
         *        The district or division of a city the results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder district(Highlight... district);

        /**
         * <p>
         * The district or division of a city the results should be present in.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.Highlight#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder#build()} is called immediately and
         * its result is passed to {@link #district(List<Highlight>)}.
         * 
         * @param district
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #district(java.util.Collection<Highlight>)
         */
        Builder district(Consumer<Highlight.Builder>... district);

        /**
         * <p>
         * Indicates the starting and ending index of the title in the text query that match the found title.
         * </p>
         * 
         * @param subDistrict
         *        Indicates the starting and ending index of the title in the text query that match the found title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subDistrict(Collection<Highlight> subDistrict);

        /**
         * <p>
         * Indicates the starting and ending index of the title in the text query that match the found title.
         * </p>
         * 
         * @param subDistrict
         *        Indicates the starting and ending index of the title in the text query that match the found title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subDistrict(Highlight... subDistrict);

        /**
         * <p>
         * Indicates the starting and ending index of the title in the text query that match the found title.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.Highlight#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder#build()} is called immediately and
         * its result is passed to {@link #subDistrict(List<Highlight>)}.
         * 
         * @param subDistrict
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subDistrict(java.util.Collection<Highlight>)
         */
        Builder subDistrict(Consumer<Highlight.Builder>... subDistrict);

        /**
         * <p>
         * The name of the street results should be present in.
         * </p>
         * 
         * @param street
         *        The name of the street results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder street(Collection<Highlight> street);

        /**
         * <p>
         * The name of the street results should be present in.
         * </p>
         * 
         * @param street
         *        The name of the street results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder street(Highlight... street);

        /**
         * <p>
         * The name of the street results should be present in.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.Highlight#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder#build()} is called immediately and
         * its result is passed to {@link #street(List<Highlight>)}.
         * 
         * @param street
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #street(java.util.Collection<Highlight>)
         */
        Builder street(Consumer<Highlight.Builder>... street);

        /**
         * <p>
         * Name of the block. Example: Sunny Mansion 203 block: 2 Chome
         * </p>
         * 
         * @param block
         *        Name of the block. Example: Sunny Mansion 203 block: 2 Chome
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder block(Collection<Highlight> block);

        /**
         * <p>
         * Name of the block. Example: Sunny Mansion 203 block: 2 Chome
         * </p>
         * 
         * @param block
         *        Name of the block. Example: Sunny Mansion 203 block: 2 Chome
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder block(Highlight... block);

        /**
         * <p>
         * Name of the block. Example: Sunny Mansion 203 block: 2 Chome
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.Highlight#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder#build()} is called immediately and
         * its result is passed to {@link #block(List<Highlight>)}.
         * 
         * @param block
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #block(java.util.Collection<Highlight>)
         */
        Builder block(Consumer<Highlight.Builder>... block);

        /**
         * <p>
         * Name of sub-block. Example Sunny Mansion 203 sub-block: 4
         * </p>
         * 
         * @param subBlock
         *        Name of sub-block. Example Sunny Mansion 203 sub-block: 4
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subBlock(Collection<Highlight> subBlock);

        /**
         * <p>
         * Name of sub-block. Example Sunny Mansion 203 sub-block: 4
         * </p>
         * 
         * @param subBlock
         *        Name of sub-block. Example Sunny Mansion 203 sub-block: 4
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subBlock(Highlight... subBlock);

        /**
         * <p>
         * Name of sub-block. Example Sunny Mansion 203 sub-block: 4
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.Highlight#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder#build()} is called immediately and
         * its result is passed to {@link #subBlock(List<Highlight>)}.
         * 
         * @param subBlock
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subBlock(java.util.Collection<Highlight>)
         */
        Builder subBlock(Consumer<Highlight.Builder>... subBlock);

        /**
         * <p>
         * Name of the streets in the intersection. For example: e.g. ["Friedrichstraße","Unter den Linden"]
         * </p>
         * 
         * @param intersection
         *        Name of the streets in the intersection. For example: e.g. ["Friedrichstraße","Unter den Linden"]
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intersection(Collection<? extends Collection<Highlight>> intersection);

        /**
         * <p>
         * Name of the streets in the intersection. For example: e.g. ["Friedrichstraße","Unter den Linden"]
         * </p>
         * 
         * @param intersection
         *        Name of the streets in the intersection. For example: e.g. ["Friedrichstraße","Unter den Linden"]
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intersection(Collection<Highlight>... intersection);

        /**
         * <p>
         * An alphanumeric string included in a postal address to facilitate mail sorting, such as post code, postcode,
         * or ZIP code for which the result should posses.
         * </p>
         * 
         * @param postalCode
         *        An alphanumeric string included in a postal address to facilitate mail sorting, such as post code,
         *        postcode, or ZIP code for which the result should posses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(Collection<Highlight> postalCode);

        /**
         * <p>
         * An alphanumeric string included in a postal address to facilitate mail sorting, such as post code, postcode,
         * or ZIP code for which the result should posses.
         * </p>
         * 
         * @param postalCode
         *        An alphanumeric string included in a postal address to facilitate mail sorting, such as post code,
         *        postcode, or ZIP code for which the result should posses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(Highlight... postalCode);

        /**
         * <p>
         * An alphanumeric string included in a postal address to facilitate mail sorting, such as post code, postcode,
         * or ZIP code for which the result should posses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.Highlight#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder#build()} is called immediately and
         * its result is passed to {@link #postalCode(List<Highlight>)}.
         * 
         * @param postalCode
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postalCode(java.util.Collection<Highlight>)
         */
        Builder postalCode(Consumer<Highlight.Builder>... postalCode);

        /**
         * <p>
         * The house number or address results should have.
         * </p>
         * 
         * @param addressNumber
         *        The house number or address results should have.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressNumber(Collection<Highlight> addressNumber);

        /**
         * <p>
         * The house number or address results should have.
         * </p>
         * 
         * @param addressNumber
         *        The house number or address results should have.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressNumber(Highlight... addressNumber);

        /**
         * <p>
         * The house number or address results should have.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.Highlight#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder#build()} is called immediately and
         * its result is passed to {@link #addressNumber(List<Highlight>)}.
         * 
         * @param addressNumber
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addressNumber(java.util.Collection<Highlight>)
         */
        Builder addressNumber(Consumer<Highlight.Builder>... addressNumber);

        /**
         * <p>
         * The name of the building at the address.
         * </p>
         * 
         * @param building
         *        The name of the building at the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder building(Collection<Highlight> building);

        /**
         * <p>
         * The name of the building at the address.
         * </p>
         * 
         * @param building
         *        The name of the building at the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder building(Highlight... building);

        /**
         * <p>
         * The name of the building at the address.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.Highlight#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder#build()} is called immediately and
         * its result is passed to {@link #building(List<Highlight>)}.
         * 
         * @param building
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #building(java.util.Collection<Highlight>)
         */
        Builder building(Consumer<Highlight.Builder>... building);
    }

    static final class BuilderImpl implements Builder {
        private List<Highlight> label = DefaultSdkAutoConstructList.getInstance();

        private CountryHighlights country;

        private RegionHighlights region;

        private SubRegionHighlights subRegion;

        private List<Highlight> locality = DefaultSdkAutoConstructList.getInstance();

        private List<Highlight> district = DefaultSdkAutoConstructList.getInstance();

        private List<Highlight> subDistrict = DefaultSdkAutoConstructList.getInstance();

        private List<Highlight> street = DefaultSdkAutoConstructList.getInstance();

        private List<Highlight> block = DefaultSdkAutoConstructList.getInstance();

        private List<Highlight> subBlock = DefaultSdkAutoConstructList.getInstance();

        private List<List<Highlight>> intersection = DefaultSdkAutoConstructList.getInstance();

        private List<Highlight> postalCode = DefaultSdkAutoConstructList.getInstance();

        private List<Highlight> addressNumber = DefaultSdkAutoConstructList.getInstance();

        private List<Highlight> building = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutocompleteAddressHighlights model) {
            label(model.label);
            country(model.country);
            region(model.region);
            subRegion(model.subRegion);
            locality(model.locality);
            district(model.district);
            subDistrict(model.subDistrict);
            street(model.street);
            block(model.block);
            subBlock(model.subBlock);
            intersection(model.intersection);
            postalCode(model.postalCode);
            addressNumber(model.addressNumber);
            building(model.building);
        }

        public final List<Highlight.Builder> getLabel() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.label);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLabel(Collection<Highlight.BuilderImpl> label) {
            this.label = HighlightListCopier.copyFromBuilder(label);
        }

        @Override
        public final Builder label(Collection<Highlight> label) {
            this.label = HighlightListCopier.copy(label);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder label(Highlight... label) {
            label(Arrays.asList(label));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder label(Consumer<Highlight.Builder>... label) {
            label(Stream.of(label).map(c -> Highlight.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final CountryHighlights.Builder getCountry() {
            return country != null ? country.toBuilder() : null;
        }

        public final void setCountry(CountryHighlights.BuilderImpl country) {
            this.country = country != null ? country.build() : null;
        }

        @Override
        public final Builder country(CountryHighlights country) {
            this.country = country;
            return this;
        }

        public final RegionHighlights.Builder getRegion() {
            return region != null ? region.toBuilder() : null;
        }

        public final void setRegion(RegionHighlights.BuilderImpl region) {
            this.region = region != null ? region.build() : null;
        }

        @Override
        public final Builder region(RegionHighlights region) {
            this.region = region;
            return this;
        }

        public final SubRegionHighlights.Builder getSubRegion() {
            return subRegion != null ? subRegion.toBuilder() : null;
        }

        public final void setSubRegion(SubRegionHighlights.BuilderImpl subRegion) {
            this.subRegion = subRegion != null ? subRegion.build() : null;
        }

        @Override
        public final Builder subRegion(SubRegionHighlights subRegion) {
            this.subRegion = subRegion;
            return this;
        }

        public final List<Highlight.Builder> getLocality() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.locality);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocality(Collection<Highlight.BuilderImpl> locality) {
            this.locality = HighlightListCopier.copyFromBuilder(locality);
        }

        @Override
        public final Builder locality(Collection<Highlight> locality) {
            this.locality = HighlightListCopier.copy(locality);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locality(Highlight... locality) {
            locality(Arrays.asList(locality));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locality(Consumer<Highlight.Builder>... locality) {
            locality(Stream.of(locality).map(c -> Highlight.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Highlight.Builder> getDistrict() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.district);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDistrict(Collection<Highlight.BuilderImpl> district) {
            this.district = HighlightListCopier.copyFromBuilder(district);
        }

        @Override
        public final Builder district(Collection<Highlight> district) {
            this.district = HighlightListCopier.copy(district);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder district(Highlight... district) {
            district(Arrays.asList(district));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder district(Consumer<Highlight.Builder>... district) {
            district(Stream.of(district).map(c -> Highlight.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Highlight.Builder> getSubDistrict() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.subDistrict);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubDistrict(Collection<Highlight.BuilderImpl> subDistrict) {
            this.subDistrict = HighlightListCopier.copyFromBuilder(subDistrict);
        }

        @Override
        public final Builder subDistrict(Collection<Highlight> subDistrict) {
            this.subDistrict = HighlightListCopier.copy(subDistrict);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subDistrict(Highlight... subDistrict) {
            subDistrict(Arrays.asList(subDistrict));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subDistrict(Consumer<Highlight.Builder>... subDistrict) {
            subDistrict(Stream.of(subDistrict).map(c -> Highlight.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Highlight.Builder> getStreet() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.street);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreet(Collection<Highlight.BuilderImpl> street) {
            this.street = HighlightListCopier.copyFromBuilder(street);
        }

        @Override
        public final Builder street(Collection<Highlight> street) {
            this.street = HighlightListCopier.copy(street);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder street(Highlight... street) {
            street(Arrays.asList(street));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder street(Consumer<Highlight.Builder>... street) {
            street(Stream.of(street).map(c -> Highlight.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Highlight.Builder> getBlock() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.block);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlock(Collection<Highlight.BuilderImpl> block) {
            this.block = HighlightListCopier.copyFromBuilder(block);
        }

        @Override
        public final Builder block(Collection<Highlight> block) {
            this.block = HighlightListCopier.copy(block);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder block(Highlight... block) {
            block(Arrays.asList(block));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder block(Consumer<Highlight.Builder>... block) {
            block(Stream.of(block).map(c -> Highlight.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Highlight.Builder> getSubBlock() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.subBlock);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubBlock(Collection<Highlight.BuilderImpl> subBlock) {
            this.subBlock = HighlightListCopier.copyFromBuilder(subBlock);
        }

        @Override
        public final Builder subBlock(Collection<Highlight> subBlock) {
            this.subBlock = HighlightListCopier.copy(subBlock);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subBlock(Highlight... subBlock) {
            subBlock(Arrays.asList(subBlock));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subBlock(Consumer<Highlight.Builder>... subBlock) {
            subBlock(Stream.of(subBlock).map(c -> Highlight.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<List<Highlight.Builder>> getIntersection() {
            List<List<Highlight.Builder>> result = IntersectionHighlightsListCopier.copyToBuilder(this.intersection);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntersection(Collection<? extends Collection<Highlight.BuilderImpl>> intersection) {
            this.intersection = IntersectionHighlightsListCopier.copyFromBuilder(intersection);
        }

        @Override
        public final Builder intersection(Collection<? extends Collection<Highlight>> intersection) {
            this.intersection = IntersectionHighlightsListCopier.copy(intersection);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intersection(Collection<Highlight>... intersection) {
            intersection(Arrays.asList(intersection));
            return this;
        }

        public final List<Highlight.Builder> getPostalCode() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.postalCode);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPostalCode(Collection<Highlight.BuilderImpl> postalCode) {
            this.postalCode = HighlightListCopier.copyFromBuilder(postalCode);
        }

        @Override
        public final Builder postalCode(Collection<Highlight> postalCode) {
            this.postalCode = HighlightListCopier.copy(postalCode);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder postalCode(Highlight... postalCode) {
            postalCode(Arrays.asList(postalCode));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder postalCode(Consumer<Highlight.Builder>... postalCode) {
            postalCode(Stream.of(postalCode).map(c -> Highlight.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Highlight.Builder> getAddressNumber() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.addressNumber);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddressNumber(Collection<Highlight.BuilderImpl> addressNumber) {
            this.addressNumber = HighlightListCopier.copyFromBuilder(addressNumber);
        }

        @Override
        public final Builder addressNumber(Collection<Highlight> addressNumber) {
            this.addressNumber = HighlightListCopier.copy(addressNumber);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressNumber(Highlight... addressNumber) {
            addressNumber(Arrays.asList(addressNumber));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressNumber(Consumer<Highlight.Builder>... addressNumber) {
            addressNumber(Stream.of(addressNumber).map(c -> Highlight.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Highlight.Builder> getBuilding() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.building);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBuilding(Collection<Highlight.BuilderImpl> building) {
            this.building = HighlightListCopier.copyFromBuilder(building);
        }

        @Override
        public final Builder building(Collection<Highlight> building) {
            this.building = HighlightListCopier.copy(building);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder building(Highlight... building) {
            building(Arrays.asList(building));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder building(Consumer<Highlight.Builder>... building) {
            building(Stream.of(building).map(c -> Highlight.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AutocompleteAddressHighlights build() {
            return new AutocompleteAddressHighlights(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
