/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutocompleteRequest extends GeoPlacesRequest implements
        ToCopyableBuilder<AutocompleteRequest.Builder, AutocompleteRequest> {
    private static final SdkField<String> QUERY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryText").getter(getter(AutocompleteRequest::queryText)).setter(setter(Builder::queryText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryText").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(AutocompleteRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<List<Double>> BIAS_POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("BiasPosition")
            .getter(getter(AutocompleteRequest::biasPosition))
            .setter(setter(Builder::biasPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BiasPosition").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutocompleteFilter> FILTER_FIELD = SdkField
            .<AutocompleteFilter> builder(MarshallingType.SDK_POJO).memberName("Filter")
            .getter(getter(AutocompleteRequest::filter)).setter(setter(Builder::filter)).constructor(AutocompleteFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<String> POSTAL_CODE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostalCodeMode").getter(getter(AutocompleteRequest::postalCodeModeAsString))
            .setter(setter(Builder::postalCodeMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCodeMode").build()).build();

    private static final SdkField<List<String>> ADDITIONAL_FEATURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalFeatures")
            .getter(getter(AutocompleteRequest::additionalFeaturesAsStrings))
            .setter(setter(Builder::additionalFeaturesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Language").getter(getter(AutocompleteRequest::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()).build();

    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoliticalView").getter(getter(AutocompleteRequest::politicalView))
            .setter(setter(Builder::politicalView))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoliticalView").build()).build();

    private static final SdkField<String> INTENDED_USE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntendedUse").getter(getter(AutocompleteRequest::intendedUseAsString))
            .setter(setter(Builder::intendedUse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntendedUse").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(AutocompleteRequest::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_TEXT_FIELD,
            MAX_RESULTS_FIELD, BIAS_POSITION_FIELD, FILTER_FIELD, POSTAL_CODE_MODE_FIELD, ADDITIONAL_FEATURES_FIELD,
            LANGUAGE_FIELD, POLITICAL_VIEW_FIELD, INTENDED_USE_FIELD, KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("QueryText", QUERY_TEXT_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                    put("BiasPosition", BIAS_POSITION_FIELD);
                    put("Filter", FILTER_FIELD);
                    put("PostalCodeMode", POSTAL_CODE_MODE_FIELD);
                    put("AdditionalFeatures", ADDITIONAL_FEATURES_FIELD);
                    put("Language", LANGUAGE_FIELD);
                    put("PoliticalView", POLITICAL_VIEW_FIELD);
                    put("IntendedUse", INTENDED_USE_FIELD);
                    put("key", KEY_FIELD);
                }
            });

    private final String queryText;

    private final Integer maxResults;

    private final List<Double> biasPosition;

    private final AutocompleteFilter filter;

    private final String postalCodeMode;

    private final List<String> additionalFeatures;

    private final String language;

    private final String politicalView;

    private final String intendedUse;

    private final String key;

    private AutocompleteRequest(BuilderImpl builder) {
        super(builder);
        this.queryText = builder.queryText;
        this.maxResults = builder.maxResults;
        this.biasPosition = builder.biasPosition;
        this.filter = builder.filter;
        this.postalCodeMode = builder.postalCodeMode;
        this.additionalFeatures = builder.additionalFeatures;
        this.language = builder.language;
        this.politicalView = builder.politicalView;
        this.intendedUse = builder.intendedUse;
        this.key = builder.key;
    }

    /**
     * <p>
     * The free-form text query to match addresses against. This is usually a partially typed address from an end user
     * in an address box or form.
     * </p>
     * 
     * @return The free-form text query to match addresses against. This is usually a partially typed address from an
     *         end user in an address box or form.
     */
    public final String queryText() {
        return queryText;
    }

    /**
     * <p>
     * An optional limit for the number of results returned in a single call.
     * </p>
     * 
     * @return An optional limit for the number of results returned in a single call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the BiasPosition property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBiasPosition() {
        return biasPosition != null && !(biasPosition instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The position in longitude and latitude that the results should be close to. Typically, place results returned are
     * ranked higher the closer they are to this position. Stored in <code>[lng, lat]</code> and in the WSG84 format.
     * </p>
     * <note>
     * <p>
     * The fields <code>BiasPosition</code>, <code>FilterBoundingBox</code>, and <code>FilterCircle</code> are mutually
     * exclusive.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBiasPosition} method.
     * </p>
     * 
     * @return The position in longitude and latitude that the results should be close to. Typically, place results
     *         returned are ranked higher the closer they are to this position. Stored in <code>[lng, lat]</code> and in
     *         the WSG84 format.</p> <note>
     *         <p>
     *         The fields <code>BiasPosition</code>, <code>FilterBoundingBox</code>, and <code>FilterCircle</code> are
     *         mutually exclusive.
     *         </p>
     */
    public final List<Double> biasPosition() {
        return biasPosition;
    }

    /**
     * <p>
     * A structure which contains a set of inclusion/exclusion properties that results must posses in order to be
     * returned as a result.
     * </p>
     * 
     * @return A structure which contains a set of inclusion/exclusion properties that results must posses in order to
     *         be returned as a result.
     */
    public final AutocompleteFilter filter() {
        return filter;
    }

    /**
     * <p>
     * The <code>PostalCodeMode</code> affects how postal code results are returned. If a postal code spans multiple
     * localities and this value is empty, partial district or locality information may be returned under a single
     * postal code result entry. If it's populated with the value <code>cityLookup</code>, all cities in that postal
     * code are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #postalCodeMode}
     * will return {@link PostalCodeMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #postalCodeModeAsString}.
     * </p>
     * 
     * @return The <code>PostalCodeMode</code> affects how postal code results are returned. If a postal code spans
     *         multiple localities and this value is empty, partial district or locality information may be returned
     *         under a single postal code result entry. If it's populated with the value <code>cityLookup</code>, all
     *         cities in that postal code are returned.
     * @see PostalCodeMode
     */
    public final PostalCodeMode postalCodeMode() {
        return PostalCodeMode.fromValue(postalCodeMode);
    }

    /**
     * <p>
     * The <code>PostalCodeMode</code> affects how postal code results are returned. If a postal code spans multiple
     * localities and this value is empty, partial district or locality information may be returned under a single
     * postal code result entry. If it's populated with the value <code>cityLookup</code>, all cities in that postal
     * code are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #postalCodeMode}
     * will return {@link PostalCodeMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #postalCodeModeAsString}.
     * </p>
     * 
     * @return The <code>PostalCodeMode</code> affects how postal code results are returned. If a postal code spans
     *         multiple localities and this value is empty, partial district or locality information may be returned
     *         under a single postal code result entry. If it's populated with the value <code>cityLookup</code>, all
     *         cities in that postal code are returned.
     * @see PostalCodeMode
     */
    public final String postalCodeModeAsString() {
        return postalCodeMode;
    }

    /**
     * <p>
     * A list of optional additional parameters that can be requested for each result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalFeatures} method.
     * </p>
     * 
     * @return A list of optional additional parameters that can be requested for each result.
     */
    public final List<AutocompleteAdditionalFeature> additionalFeatures() {
        return AutocompleteAdditionalFeatureListCopier.copyStringToEnum(additionalFeatures);
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalFeatures property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalFeatures() {
        return additionalFeatures != null && !(additionalFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of optional additional parameters that can be requested for each result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalFeatures} method.
     * </p>
     * 
     * @return A list of optional additional parameters that can be requested for each result.
     */
    public final List<String> additionalFeaturesAsStrings() {
        return additionalFeatures;
    }

    /**
     * <p>
     * A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language codes for the
     * results to be rendered in. If there is no data for the result in the requested language, data will be returned in
     * the default language for the entry.
     * </p>
     * 
     * @return A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language codes
     *         for the results to be rendered in. If there is no data for the result in the requested language, data
     *         will be returned in the default language for the entry.
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * The alpha-2 or alpha-3 character code for the political view of a country. The political view applies to the
     * results of the request to represent unresolved territorial claims through the point of view of the specified
     * country.
     * </p>
     * 
     * @return The alpha-2 or alpha-3 character code for the political view of a country. The political view applies to
     *         the results of the request to represent unresolved territorial claims through the point of view of the
     *         specified country.
     */
    public final String politicalView() {
        return politicalView;
    }

    /**
     * <p>
     * Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intendedUse} will
     * return {@link AutocompleteIntendedUse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #intendedUseAsString}.
     * </p>
     * 
     * @return Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
     * @see AutocompleteIntendedUse
     */
    public final AutocompleteIntendedUse intendedUse() {
        return AutocompleteIntendedUse.fromValue(intendedUse);
    }

    /**
     * <p>
     * Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intendedUse} will
     * return {@link AutocompleteIntendedUse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #intendedUseAsString}.
     * </p>
     * 
     * @return Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
     * @see AutocompleteIntendedUse
     */
    public final String intendedUseAsString() {
        return intendedUse;
    }

    /**
     * <p>
     * Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be provided
     * when making a request.
     * </p>
     * 
     * @return Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
     *         provided when making a request.
     */
    public final String key() {
        return key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryText());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasBiasPosition() ? biasPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(postalCodeModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalFeatures() ? additionalFeaturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(intendedUseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutocompleteRequest)) {
            return false;
        }
        AutocompleteRequest other = (AutocompleteRequest) obj;
        return Objects.equals(queryText(), other.queryText()) && Objects.equals(maxResults(), other.maxResults())
                && hasBiasPosition() == other.hasBiasPosition() && Objects.equals(biasPosition(), other.biasPosition())
                && Objects.equals(filter(), other.filter())
                && Objects.equals(postalCodeModeAsString(), other.postalCodeModeAsString())
                && hasAdditionalFeatures() == other.hasAdditionalFeatures()
                && Objects.equals(additionalFeaturesAsStrings(), other.additionalFeaturesAsStrings())
                && Objects.equals(language(), other.language()) && Objects.equals(politicalView(), other.politicalView())
                && Objects.equals(intendedUseAsString(), other.intendedUseAsString()) && Objects.equals(key(), other.key());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutocompleteRequest")
                .add("QueryText", queryText() == null ? null : "*** Sensitive Data Redacted ***").add("MaxResults", maxResults())
                .add("BiasPosition", biasPosition() == null ? null : "*** Sensitive Data Redacted ***").add("Filter", filter())
                .add("PostalCodeMode", postalCodeModeAsString())
                .add("AdditionalFeatures", hasAdditionalFeatures() ? additionalFeaturesAsStrings() : null)
                .add("Language", language()).add("PoliticalView", politicalView()).add("IntendedUse", intendedUseAsString())
                .add("Key", key() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryText":
            return Optional.ofNullable(clazz.cast(queryText()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "BiasPosition":
            return Optional.ofNullable(clazz.cast(biasPosition()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "PostalCodeMode":
            return Optional.ofNullable(clazz.cast(postalCodeModeAsString()));
        case "AdditionalFeatures":
            return Optional.ofNullable(clazz.cast(additionalFeaturesAsStrings()));
        case "Language":
            return Optional.ofNullable(clazz.cast(language()));
        case "PoliticalView":
            return Optional.ofNullable(clazz.cast(politicalView()));
        case "IntendedUse":
            return Optional.ofNullable(clazz.cast(intendedUseAsString()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AutocompleteRequest, T> g) {
        return obj -> g.apply((AutocompleteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GeoPlacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, AutocompleteRequest> {
        /**
         * <p>
         * The free-form text query to match addresses against. This is usually a partially typed address from an end
         * user in an address box or form.
         * </p>
         * 
         * @param queryText
         *        The free-form text query to match addresses against. This is usually a partially typed address from an
         *        end user in an address box or form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryText(String queryText);

        /**
         * <p>
         * An optional limit for the number of results returned in a single call.
         * </p>
         * 
         * @param maxResults
         *        An optional limit for the number of results returned in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The position in longitude and latitude that the results should be close to. Typically, place results returned
         * are ranked higher the closer they are to this position. Stored in <code>[lng, lat]</code> and in the WSG84
         * format.
         * </p>
         * <note>
         * <p>
         * The fields <code>BiasPosition</code>, <code>FilterBoundingBox</code>, and <code>FilterCircle</code> are
         * mutually exclusive.
         * </p>
         * </note>
         * 
         * @param biasPosition
         *        The position in longitude and latitude that the results should be close to. Typically, place results
         *        returned are ranked higher the closer they are to this position. Stored in <code>[lng, lat]</code> and
         *        in the WSG84 format.</p> <note>
         *        <p>
         *        The fields <code>BiasPosition</code>, <code>FilterBoundingBox</code>, and <code>FilterCircle</code>
         *        are mutually exclusive.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder biasPosition(Collection<Double> biasPosition);

        /**
         * <p>
         * The position in longitude and latitude that the results should be close to. Typically, place results returned
         * are ranked higher the closer they are to this position. Stored in <code>[lng, lat]</code> and in the WSG84
         * format.
         * </p>
         * <note>
         * <p>
         * The fields <code>BiasPosition</code>, <code>FilterBoundingBox</code>, and <code>FilterCircle</code> are
         * mutually exclusive.
         * </p>
         * </note>
         * 
         * @param biasPosition
         *        The position in longitude and latitude that the results should be close to. Typically, place results
         *        returned are ranked higher the closer they are to this position. Stored in <code>[lng, lat]</code> and
         *        in the WSG84 format.</p> <note>
         *        <p>
         *        The fields <code>BiasPosition</code>, <code>FilterBoundingBox</code>, and <code>FilterCircle</code>
         *        are mutually exclusive.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder biasPosition(Double... biasPosition);

        /**
         * <p>
         * A structure which contains a set of inclusion/exclusion properties that results must posses in order to be
         * returned as a result.
         * </p>
         * 
         * @param filter
         *        A structure which contains a set of inclusion/exclusion properties that results must posses in order
         *        to be returned as a result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(AutocompleteFilter filter);

        /**
         * <p>
         * A structure which contains a set of inclusion/exclusion properties that results must posses in order to be
         * returned as a result.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutocompleteFilter.Builder} avoiding the
         * need to create one manually via {@link AutocompleteFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutocompleteFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(AutocompleteFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link AutocompleteFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(AutocompleteFilter)
         */
        default Builder filter(Consumer<AutocompleteFilter.Builder> filter) {
            return filter(AutocompleteFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The <code>PostalCodeMode</code> affects how postal code results are returned. If a postal code spans multiple
         * localities and this value is empty, partial district or locality information may be returned under a single
         * postal code result entry. If it's populated with the value <code>cityLookup</code>, all cities in that postal
         * code are returned.
         * </p>
         * 
         * @param postalCodeMode
         *        The <code>PostalCodeMode</code> affects how postal code results are returned. If a postal code spans
         *        multiple localities and this value is empty, partial district or locality information may be returned
         *        under a single postal code result entry. If it's populated with the value <code>cityLookup</code>, all
         *        cities in that postal code are returned.
         * @see PostalCodeMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PostalCodeMode
         */
        Builder postalCodeMode(String postalCodeMode);

        /**
         * <p>
         * The <code>PostalCodeMode</code> affects how postal code results are returned. If a postal code spans multiple
         * localities and this value is empty, partial district or locality information may be returned under a single
         * postal code result entry. If it's populated with the value <code>cityLookup</code>, all cities in that postal
         * code are returned.
         * </p>
         * 
         * @param postalCodeMode
         *        The <code>PostalCodeMode</code> affects how postal code results are returned. If a postal code spans
         *        multiple localities and this value is empty, partial district or locality information may be returned
         *        under a single postal code result entry. If it's populated with the value <code>cityLookup</code>, all
         *        cities in that postal code are returned.
         * @see PostalCodeMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PostalCodeMode
         */
        Builder postalCodeMode(PostalCodeMode postalCodeMode);

        /**
         * <p>
         * A list of optional additional parameters that can be requested for each result.
         * </p>
         * 
         * @param additionalFeatures
         *        A list of optional additional parameters that can be requested for each result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalFeaturesWithStrings(Collection<String> additionalFeatures);

        /**
         * <p>
         * A list of optional additional parameters that can be requested for each result.
         * </p>
         * 
         * @param additionalFeatures
         *        A list of optional additional parameters that can be requested for each result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalFeaturesWithStrings(String... additionalFeatures);

        /**
         * <p>
         * A list of optional additional parameters that can be requested for each result.
         * </p>
         * 
         * @param additionalFeatures
         *        A list of optional additional parameters that can be requested for each result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalFeatures(Collection<AutocompleteAdditionalFeature> additionalFeatures);

        /**
         * <p>
         * A list of optional additional parameters that can be requested for each result.
         * </p>
         * 
         * @param additionalFeatures
         *        A list of optional additional parameters that can be requested for each result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalFeatures(AutocompleteAdditionalFeature... additionalFeatures);

        /**
         * <p>
         * A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language codes for
         * the results to be rendered in. If there is no data for the result in the requested language, data will be
         * returned in the default language for the entry.
         * </p>
         * 
         * @param language
         *        A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language
         *        codes for the results to be rendered in. If there is no data for the result in the requested language,
         *        data will be returned in the default language for the entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * The alpha-2 or alpha-3 character code for the political view of a country. The political view applies to the
         * results of the request to represent unresolved territorial claims through the point of view of the specified
         * country.
         * </p>
         * 
         * @param politicalView
         *        The alpha-2 or alpha-3 character code for the political view of a country. The political view applies
         *        to the results of the request to represent unresolved territorial claims through the point of view of
         *        the specified country.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder politicalView(String politicalView);

        /**
         * <p>
         * Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
         * </p>
         * 
         * @param intendedUse
         *        Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
         * @see AutocompleteIntendedUse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutocompleteIntendedUse
         */
        Builder intendedUse(String intendedUse);

        /**
         * <p>
         * Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
         * </p>
         * 
         * @param intendedUse
         *        Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
         * @see AutocompleteIntendedUse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutocompleteIntendedUse
         */
        Builder intendedUse(AutocompleteIntendedUse intendedUse);

        /**
         * <p>
         * Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
         * provided when making a request.
         * </p>
         * 
         * @param key
         *        Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
         *        provided when making a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GeoPlacesRequest.BuilderImpl implements Builder {
        private String queryText;

        private Integer maxResults;

        private List<Double> biasPosition = DefaultSdkAutoConstructList.getInstance();

        private AutocompleteFilter filter;

        private String postalCodeMode;

        private List<String> additionalFeatures = DefaultSdkAutoConstructList.getInstance();

        private String language;

        private String politicalView;

        private String intendedUse;

        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(AutocompleteRequest model) {
            super(model);
            queryText(model.queryText);
            maxResults(model.maxResults);
            biasPosition(model.biasPosition);
            filter(model.filter);
            postalCodeMode(model.postalCodeMode);
            additionalFeaturesWithStrings(model.additionalFeatures);
            language(model.language);
            politicalView(model.politicalView);
            intendedUse(model.intendedUse);
            key(model.key);
        }

        public final String getQueryText() {
            return queryText;
        }

        public final void setQueryText(String queryText) {
            this.queryText = queryText;
        }

        @Override
        public final Builder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<Double> getBiasPosition() {
            if (biasPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return biasPosition;
        }

        public final void setBiasPosition(Collection<Double> biasPosition) {
            this.biasPosition = PositionCopier.copy(biasPosition);
        }

        @Override
        public final Builder biasPosition(Collection<Double> biasPosition) {
            this.biasPosition = PositionCopier.copy(biasPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder biasPosition(Double... biasPosition) {
            biasPosition(Arrays.asList(biasPosition));
            return this;
        }

        public final AutocompleteFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(AutocompleteFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(AutocompleteFilter filter) {
            this.filter = filter;
            return this;
        }

        public final String getPostalCodeMode() {
            return postalCodeMode;
        }

        public final void setPostalCodeMode(String postalCodeMode) {
            this.postalCodeMode = postalCodeMode;
        }

        @Override
        public final Builder postalCodeMode(String postalCodeMode) {
            this.postalCodeMode = postalCodeMode;
            return this;
        }

        @Override
        public final Builder postalCodeMode(PostalCodeMode postalCodeMode) {
            this.postalCodeMode(postalCodeMode == null ? null : postalCodeMode.toString());
            return this;
        }

        public final Collection<String> getAdditionalFeatures() {
            if (additionalFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalFeatures;
        }

        public final void setAdditionalFeatures(Collection<String> additionalFeatures) {
            this.additionalFeatures = AutocompleteAdditionalFeatureListCopier.copy(additionalFeatures);
        }

        @Override
        public final Builder additionalFeaturesWithStrings(Collection<String> additionalFeatures) {
            this.additionalFeatures = AutocompleteAdditionalFeatureListCopier.copy(additionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalFeaturesWithStrings(String... additionalFeatures) {
            additionalFeaturesWithStrings(Arrays.asList(additionalFeatures));
            return this;
        }

        @Override
        public final Builder additionalFeatures(Collection<AutocompleteAdditionalFeature> additionalFeatures) {
            this.additionalFeatures = AutocompleteAdditionalFeatureListCopier.copyEnumToString(additionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalFeatures(AutocompleteAdditionalFeature... additionalFeatures) {
            additionalFeatures(Arrays.asList(additionalFeatures));
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getPoliticalView() {
            return politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final String getIntendedUse() {
            return intendedUse;
        }

        public final void setIntendedUse(String intendedUse) {
            this.intendedUse = intendedUse;
        }

        @Override
        public final Builder intendedUse(String intendedUse) {
            this.intendedUse = intendedUse;
            return this;
        }

        @Override
        public final Builder intendedUse(AutocompleteIntendedUse intendedUse) {
            this.intendedUse(intendedUse == null ? null : intendedUse.toString());
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AutocompleteRequest build() {
            return new AutocompleteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
