/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Category of the <code>Place</code> returned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Category implements SdkPojo, Serializable, ToCopyableBuilder<Category.Builder, Category> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Category::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Category::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> LOCALIZED_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocalizedName").getter(getter(Category::localizedName)).setter(setter(Builder::localizedName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalizedName").build()).build();

    private static final SdkField<Boolean> PRIMARY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Primary").getter(getter(Category::primary)).setter(setter(Builder::primary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Primary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            LOCALIZED_NAME_FIELD, PRIMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Id", ID_FIELD);
                    put("Name", NAME_FIELD);
                    put("LocalizedName", LOCALIZED_NAME_FIELD);
                    put("Primary", PRIMARY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String localizedName;

    private final Boolean primary;

    private Category(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.localizedName = builder.localizedName;
        this.primary = builder.primary;
    }

    /**
     * <p>
     * The category ID.
     * </p>
     * 
     * @return The category ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The category name.
     * </p>
     * 
     * @return The category name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Localized name of the category type.
     * </p>
     * 
     * @return Localized name of the category type.
     */
    public final String localizedName() {
        return localizedName;
    }

    /**
     * <p>
     * Boolean which indicates if this category is the primary offered by the place.
     * </p>
     * 
     * @return Boolean which indicates if this category is the primary offered by the place.
     */
    public final Boolean primary() {
        return primary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(localizedName());
        hashCode = 31 * hashCode + Objects.hashCode(primary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Category)) {
            return false;
        }
        Category other = (Category) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(localizedName(), other.localizedName()) && Objects.equals(primary(), other.primary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Category").add("Id", id()).add("Name", name()).add("LocalizedName", localizedName())
                .add("Primary", primary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "LocalizedName":
            return Optional.ofNullable(clazz.cast(localizedName()));
        case "Primary":
            return Optional.ofNullable(clazz.cast(primary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Category, T> g) {
        return obj -> g.apply((Category) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Category> {
        /**
         * <p>
         * The category ID.
         * </p>
         * 
         * @param id
         *        The category ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The category name.
         * </p>
         * 
         * @param name
         *        The category name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Localized name of the category type.
         * </p>
         * 
         * @param localizedName
         *        Localized name of the category type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localizedName(String localizedName);

        /**
         * <p>
         * Boolean which indicates if this category is the primary offered by the place.
         * </p>
         * 
         * @param primary
         *        Boolean which indicates if this category is the primary offered by the place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primary(Boolean primary);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String localizedName;

        private Boolean primary;

        private BuilderImpl() {
        }

        private BuilderImpl(Category model) {
            id(model.id);
            name(model.name);
            localizedName(model.localizedName);
            primary(model.primary);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLocalizedName() {
            return localizedName;
        }

        public final void setLocalizedName(String localizedName) {
            this.localizedName = localizedName;
        }

        @Override
        public final Builder localizedName(String localizedName) {
            this.localizedName = localizedName;
            return this;
        }

        public final Boolean getPrimary() {
            return primary;
        }

        public final void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        @Override
        public final Builder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        @Override
        public Category build() {
            return new Category(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
