/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The alpha-2 or alpha-3 character code for the country that the results will be present in.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Country implements SdkPojo, Serializable, ToCopyableBuilder<Country.Builder, Country> {
    private static final SdkField<String> CODE2_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code2")
            .getter(getter(Country::code2)).setter(setter(Builder::code2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code2").build()).build();

    private static final SdkField<String> CODE3_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code3")
            .getter(getter(Country::code3)).setter(setter(Builder::code3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code3").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Country::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE2_FIELD, CODE3_FIELD,
            NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Code2", CODE2_FIELD);
                    put("Code3", CODE3_FIELD);
                    put("Name", NAME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String code2;

    private final String code3;

    private final String name;

    private Country(BuilderImpl builder) {
        this.code2 = builder.code2;
        this.code3 = builder.code3;
        this.name = builder.name;
    }

    /**
     * <p>
     * Country, represented by its alpha 2-character code.
     * </p>
     * 
     * @return Country, represented by its alpha 2-character code.
     */
    public final String code2() {
        return code2;
    }

    /**
     * <p>
     * Country, represented by its alpha t-character code.
     * </p>
     * 
     * @return Country, represented by its alpha t-character code.
     */
    public final String code3() {
        return code3;
    }

    /**
     * <p>
     * Name of the country.
     * </p>
     * 
     * @return Name of the country.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code2());
        hashCode = 31 * hashCode + Objects.hashCode(code3());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Country)) {
            return false;
        }
        Country other = (Country) obj;
        return Objects.equals(code2(), other.code2()) && Objects.equals(code3(), other.code3())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Country").add("Code2", code2()).add("Code3", code3()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code2":
            return Optional.ofNullable(clazz.cast(code2()));
        case "Code3":
            return Optional.ofNullable(clazz.cast(code3()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Country, T> g) {
        return obj -> g.apply((Country) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Country> {
        /**
         * <p>
         * Country, represented by its alpha 2-character code.
         * </p>
         * 
         * @param code2
         *        Country, represented by its alpha 2-character code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code2(String code2);

        /**
         * <p>
         * Country, represented by its alpha t-character code.
         * </p>
         * 
         * @param code3
         *        Country, represented by its alpha t-character code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code3(String code3);

        /**
         * <p>
         * Name of the country.
         * </p>
         * 
         * @param name
         *        Name of the country.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String code2;

        private String code3;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(Country model) {
            code2(model.code2);
            code3(model.code3);
            name(model.name);
        }

        public final String getCode2() {
            return code2;
        }

        public final void setCode2(String code2) {
            this.code2 = code2;
        }

        @Override
        public final Builder code2(String code2) {
            this.code2 = code2;
            return this;
        }

        public final String getCode3() {
            return code3;
        }

        public final void setCode3(String code3) {
            this.code3 = code3;
        }

        @Override
        public final Builder code3(String code3) {
            this.code3 = code3;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Country build() {
            return new Country(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
