/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structured free text query allows you to search for places by the name or text representation of specific
 * properties of the place.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeocodeQueryComponents implements SdkPojo, Serializable,
        ToCopyableBuilder<GeocodeQueryComponents.Builder, GeocodeQueryComponents> {
    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(GeocodeQueryComponents::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(GeocodeQueryComponents::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> SUB_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubRegion").getter(getter(GeocodeQueryComponents::subRegion)).setter(setter(Builder::subRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubRegion").build()).build();

    private static final SdkField<String> LOCALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Locality").getter(getter(GeocodeQueryComponents::locality)).setter(setter(Builder::locality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locality").build()).build();

    private static final SdkField<String> DISTRICT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("District").getter(getter(GeocodeQueryComponents::district)).setter(setter(Builder::district))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("District").build()).build();

    private static final SdkField<String> STREET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Street")
            .getter(getter(GeocodeQueryComponents::street)).setter(setter(Builder::street))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Street").build()).build();

    private static final SdkField<String> ADDRESS_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressNumber").getter(getter(GeocodeQueryComponents::addressNumber))
            .setter(setter(Builder::addressNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressNumber").build()).build();

    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostalCode").getter(getter(GeocodeQueryComponents::postalCode)).setter(setter(Builder::postalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_FIELD, REGION_FIELD,
            SUB_REGION_FIELD, LOCALITY_FIELD, DISTRICT_FIELD, STREET_FIELD, ADDRESS_NUMBER_FIELD, POSTAL_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Country", COUNTRY_FIELD);
                    put("Region", REGION_FIELD);
                    put("SubRegion", SUB_REGION_FIELD);
                    put("Locality", LOCALITY_FIELD);
                    put("District", DISTRICT_FIELD);
                    put("Street", STREET_FIELD);
                    put("AddressNumber", ADDRESS_NUMBER_FIELD);
                    put("PostalCode", POSTAL_CODE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String country;

    private final String region;

    private final String subRegion;

    private final String locality;

    private final String district;

    private final String street;

    private final String addressNumber;

    private final String postalCode;

    private GeocodeQueryComponents(BuilderImpl builder) {
        this.country = builder.country;
        this.region = builder.region;
        this.subRegion = builder.subRegion;
        this.locality = builder.locality;
        this.district = builder.district;
        this.street = builder.street;
        this.addressNumber = builder.addressNumber;
        this.postalCode = builder.postalCode;
    }

    /**
     * <p>
     * The alpha-2 or alpha-3 character code for the country that the results will be present in.
     * </p>
     * 
     * @return The alpha-2 or alpha-3 character code for the country that the results will be present in.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * The region or state results should be to be present in.
     * </p>
     * <p>
     * Example: <code>North Rhine-Westphalia</code>.
     * </p>
     * 
     * @return The region or state results should be to be present in. </p>
     *         <p>
     *         Example: <code>North Rhine-Westphalia</code>.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The sub-region or county for which results should be present in.
     * </p>
     * 
     * @return The sub-region or county for which results should be present in.
     */
    public final String subRegion() {
        return subRegion;
    }

    /**
     * <p>
     * City or locality results should be present in.
     * </p>
     * <p>
     * Example: <code>Vancouver</code>.
     * </p>
     * 
     * @return City or locality results should be present in. </p>
     *         <p>
     *         Example: <code>Vancouver</code>.
     */
    public final String locality() {
        return locality;
    }

    /**
     * <p>
     * The district or division of a city the results should be present in.
     * </p>
     * 
     * @return The district or division of a city the results should be present in.
     */
    public final String district() {
        return district;
    }

    /**
     * <p>
     * The name of the street results should be present in.
     * </p>
     * 
     * @return The name of the street results should be present in.
     */
    public final String street() {
        return street;
    }

    /**
     * <p>
     * The house number or address results should have.
     * </p>
     * 
     * @return The house number or address results should have.
     */
    public final String addressNumber() {
        return addressNumber;
    }

    /**
     * <p>
     * An alphanumeric string included in a postal address to facilitate mail sorting, such as post code, postcode, or
     * ZIP code for which the result should posses.
     * </p>
     * 
     * @return An alphanumeric string included in a postal address to facilitate mail sorting, such as post code,
     *         postcode, or ZIP code for which the result should posses.
     */
    public final String postalCode() {
        return postalCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(subRegion());
        hashCode = 31 * hashCode + Objects.hashCode(locality());
        hashCode = 31 * hashCode + Objects.hashCode(district());
        hashCode = 31 * hashCode + Objects.hashCode(street());
        hashCode = 31 * hashCode + Objects.hashCode(addressNumber());
        hashCode = 31 * hashCode + Objects.hashCode(postalCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeocodeQueryComponents)) {
            return false;
        }
        GeocodeQueryComponents other = (GeocodeQueryComponents) obj;
        return Objects.equals(country(), other.country()) && Objects.equals(region(), other.region())
                && Objects.equals(subRegion(), other.subRegion()) && Objects.equals(locality(), other.locality())
                && Objects.equals(district(), other.district()) && Objects.equals(street(), other.street())
                && Objects.equals(addressNumber(), other.addressNumber()) && Objects.equals(postalCode(), other.postalCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeocodeQueryComponents")
                .add("Country", country() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Region", region() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SubRegion", subRegion() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Locality", locality() == null ? null : "*** Sensitive Data Redacted ***")
                .add("District", district() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Street", street() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AddressNumber", addressNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PostalCode", postalCode() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "SubRegion":
            return Optional.ofNullable(clazz.cast(subRegion()));
        case "Locality":
            return Optional.ofNullable(clazz.cast(locality()));
        case "District":
            return Optional.ofNullable(clazz.cast(district()));
        case "Street":
            return Optional.ofNullable(clazz.cast(street()));
        case "AddressNumber":
            return Optional.ofNullable(clazz.cast(addressNumber()));
        case "PostalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GeocodeQueryComponents, T> g) {
        return obj -> g.apply((GeocodeQueryComponents) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeocodeQueryComponents> {
        /**
         * <p>
         * The alpha-2 or alpha-3 character code for the country that the results will be present in.
         * </p>
         * 
         * @param country
         *        The alpha-2 or alpha-3 character code for the country that the results will be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * The region or state results should be to be present in.
         * </p>
         * <p>
         * Example: <code>North Rhine-Westphalia</code>.
         * </p>
         * 
         * @param region
         *        The region or state results should be to be present in. </p>
         *        <p>
         *        Example: <code>North Rhine-Westphalia</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The sub-region or county for which results should be present in.
         * </p>
         * 
         * @param subRegion
         *        The sub-region or county for which results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subRegion(String subRegion);

        /**
         * <p>
         * City or locality results should be present in.
         * </p>
         * <p>
         * Example: <code>Vancouver</code>.
         * </p>
         * 
         * @param locality
         *        City or locality results should be present in. </p>
         *        <p>
         *        Example: <code>Vancouver</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locality(String locality);

        /**
         * <p>
         * The district or division of a city the results should be present in.
         * </p>
         * 
         * @param district
         *        The district or division of a city the results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder district(String district);

        /**
         * <p>
         * The name of the street results should be present in.
         * </p>
         * 
         * @param street
         *        The name of the street results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder street(String street);

        /**
         * <p>
         * The house number or address results should have.
         * </p>
         * 
         * @param addressNumber
         *        The house number or address results should have.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressNumber(String addressNumber);

        /**
         * <p>
         * An alphanumeric string included in a postal address to facilitate mail sorting, such as post code, postcode,
         * or ZIP code for which the result should posses.
         * </p>
         * 
         * @param postalCode
         *        An alphanumeric string included in a postal address to facilitate mail sorting, such as post code,
         *        postcode, or ZIP code for which the result should posses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(String postalCode);
    }

    static final class BuilderImpl implements Builder {
        private String country;

        private String region;

        private String subRegion;

        private String locality;

        private String district;

        private String street;

        private String addressNumber;

        private String postalCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GeocodeQueryComponents model) {
            country(model.country);
            region(model.region);
            subRegion(model.subRegion);
            locality(model.locality);
            district(model.district);
            street(model.street);
            addressNumber(model.addressNumber);
            postalCode(model.postalCode);
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getSubRegion() {
            return subRegion;
        }

        public final void setSubRegion(String subRegion) {
            this.subRegion = subRegion;
        }

        @Override
        public final Builder subRegion(String subRegion) {
            this.subRegion = subRegion;
            return this;
        }

        public final String getLocality() {
            return locality;
        }

        public final void setLocality(String locality) {
            this.locality = locality;
        }

        @Override
        public final Builder locality(String locality) {
            this.locality = locality;
            return this;
        }

        public final String getDistrict() {
            return district;
        }

        public final void setDistrict(String district) {
            this.district = district;
        }

        @Override
        public final Builder district(String district) {
            this.district = district;
            return this;
        }

        public final String getStreet() {
            return street;
        }

        public final void setStreet(String street) {
            this.street = street;
        }

        @Override
        public final Builder street(String street) {
            this.street = street;
            return this;
        }

        public final String getAddressNumber() {
            return addressNumber;
        }

        public final void setAddressNumber(String addressNumber) {
            this.addressNumber = addressNumber;
        }

        @Override
        public final Builder addressNumber(String addressNumber) {
            this.addressNumber = addressNumber;
            return this;
        }

        public final String getPostalCode() {
            return postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        @Override
        public GeocodeQueryComponents build() {
            return new GeocodeQueryComponents(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
