/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Geocoded result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeocodeResultItem implements SdkPojo, Serializable,
        ToCopyableBuilder<GeocodeResultItem.Builder, GeocodeResultItem> {
    private static final SdkField<String> PLACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaceId").getter(getter(GeocodeResultItem::placeId)).setter(setter(Builder::placeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceId").build()).build();

    private static final SdkField<String> PLACE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaceType").getter(getter(GeocodeResultItem::placeTypeAsString)).setter(setter(Builder::placeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceType").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(GeocodeResultItem::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<Address> ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("Address").getter(getter(GeocodeResultItem::address)).setter(setter(Builder::address))
            .constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<Boolean> ADDRESS_NUMBER_CORRECTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AddressNumberCorrected").getter(getter(GeocodeResultItem::addressNumberCorrected))
            .setter(setter(Builder::addressNumberCorrected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressNumberCorrected").build())
            .build();

    private static final SdkField<List<PostalCodeDetails>> POSTAL_CODE_DETAILS_FIELD = SdkField
            .<List<PostalCodeDetails>> builder(MarshallingType.LIST)
            .memberName("PostalCodeDetails")
            .getter(getter(GeocodeResultItem::postalCodeDetails))
            .setter(setter(Builder::postalCodeDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCodeDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PostalCodeDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(PostalCodeDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Double>> POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Position")
            .getter(getter(GeocodeResultItem::position))
            .setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> DISTANCE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Distance")
            .getter(getter(GeocodeResultItem::distance)).setter(setter(Builder::distance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()).build();

    private static final SdkField<List<Double>> MAP_VIEW_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("MapView")
            .getter(getter(GeocodeResultItem::mapView))
            .setter(setter(Builder::mapView))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapView").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Category>> CATEGORIES_FIELD = SdkField
            .<List<Category>> builder(MarshallingType.LIST)
            .memberName("Categories")
            .getter(getter(GeocodeResultItem::categories))
            .setter(setter(Builder::categories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Category> builder(MarshallingType.SDK_POJO)
                                            .constructor(Category::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FoodType>> FOOD_TYPES_FIELD = SdkField
            .<List<FoodType>> builder(MarshallingType.LIST)
            .memberName("FoodTypes")
            .getter(getter(GeocodeResultItem::foodTypes))
            .setter(setter(Builder::foodTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FoodTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FoodType> builder(MarshallingType.SDK_POJO)
                                            .constructor(FoodType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AccessPoint>> ACCESS_POINTS_FIELD = SdkField
            .<List<AccessPoint>> builder(MarshallingType.LIST)
            .memberName("AccessPoints")
            .getter(getter(GeocodeResultItem::accessPoints))
            .setter(setter(Builder::accessPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessPoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessPoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TimeZone> TIME_ZONE_FIELD = SdkField.<TimeZone> builder(MarshallingType.SDK_POJO)
            .memberName("TimeZone").getter(getter(GeocodeResultItem::timeZone)).setter(setter(Builder::timeZone))
            .constructor(TimeZone::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()).build();

    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoliticalView").getter(getter(GeocodeResultItem::politicalView)).setter(setter(Builder::politicalView))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoliticalView").build()).build();

    private static final SdkField<MatchScoreDetails> MATCH_SCORES_FIELD = SdkField
            .<MatchScoreDetails> builder(MarshallingType.SDK_POJO).memberName("MatchScores")
            .getter(getter(GeocodeResultItem::matchScores)).setter(setter(Builder::matchScores))
            .constructor(MatchScoreDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchScores").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACE_ID_FIELD,
            PLACE_TYPE_FIELD, TITLE_FIELD, ADDRESS_FIELD, ADDRESS_NUMBER_CORRECTED_FIELD, POSTAL_CODE_DETAILS_FIELD,
            POSITION_FIELD, DISTANCE_FIELD, MAP_VIEW_FIELD, CATEGORIES_FIELD, FOOD_TYPES_FIELD, ACCESS_POINTS_FIELD,
            TIME_ZONE_FIELD, POLITICAL_VIEW_FIELD, MATCH_SCORES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("PlaceId", PLACE_ID_FIELD);
                    put("PlaceType", PLACE_TYPE_FIELD);
                    put("Title", TITLE_FIELD);
                    put("Address", ADDRESS_FIELD);
                    put("AddressNumberCorrected", ADDRESS_NUMBER_CORRECTED_FIELD);
                    put("PostalCodeDetails", POSTAL_CODE_DETAILS_FIELD);
                    put("Position", POSITION_FIELD);
                    put("Distance", DISTANCE_FIELD);
                    put("MapView", MAP_VIEW_FIELD);
                    put("Categories", CATEGORIES_FIELD);
                    put("FoodTypes", FOOD_TYPES_FIELD);
                    put("AccessPoints", ACCESS_POINTS_FIELD);
                    put("TimeZone", TIME_ZONE_FIELD);
                    put("PoliticalView", POLITICAL_VIEW_FIELD);
                    put("MatchScores", MATCH_SCORES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String placeId;

    private final String placeType;

    private final String title;

    private final Address address;

    private final Boolean addressNumberCorrected;

    private final List<PostalCodeDetails> postalCodeDetails;

    private final List<Double> position;

    private final Long distance;

    private final List<Double> mapView;

    private final List<Category> categories;

    private final List<FoodType> foodTypes;

    private final List<AccessPoint> accessPoints;

    private final TimeZone timeZone;

    private final String politicalView;

    private final MatchScoreDetails matchScores;

    private GeocodeResultItem(BuilderImpl builder) {
        this.placeId = builder.placeId;
        this.placeType = builder.placeType;
        this.title = builder.title;
        this.address = builder.address;
        this.addressNumberCorrected = builder.addressNumberCorrected;
        this.postalCodeDetails = builder.postalCodeDetails;
        this.position = builder.position;
        this.distance = builder.distance;
        this.mapView = builder.mapView;
        this.categories = builder.categories;
        this.foodTypes = builder.foodTypes;
        this.accessPoints = builder.accessPoints;
        this.timeZone = builder.timeZone;
        this.politicalView = builder.politicalView;
        this.matchScores = builder.matchScores;
    }

    /**
     * <p>
     * The <code>PlaceId</code> of the place you wish to receive the information for.
     * </p>
     * 
     * @return The <code>PlaceId</code> of the place you wish to receive the information for.
     */
    public final String placeId() {
        return placeId;
    }

    /**
     * <p>
     * A <code>PlaceType</code> is a category that the result place must belong to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #placeType} will
     * return {@link PlaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #placeTypeAsString}.
     * </p>
     * 
     * @return A <code>PlaceType</code> is a category that the result place must belong to.
     * @see PlaceType
     */
    public final PlaceType placeType() {
        return PlaceType.fromValue(placeType);
    }

    /**
     * <p>
     * A <code>PlaceType</code> is a category that the result place must belong to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #placeType} will
     * return {@link PlaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #placeTypeAsString}.
     * </p>
     * 
     * @return A <code>PlaceType</code> is a category that the result place must belong to.
     * @see PlaceType
     */
    public final String placeTypeAsString() {
        return placeType;
    }

    /**
     * <p>
     * The localized display name of this result item based on request parameter <code>language</code>.
     * </p>
     * 
     * @return The localized display name of this result item based on request parameter <code>language</code>.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The place's address.
     * </p>
     * 
     * @return The place's address.
     */
    public final Address address() {
        return address;
    }

    /**
     * <p>
     * Boolean indicating if the address provided has been corrected.
     * </p>
     * 
     * @return Boolean indicating if the address provided has been corrected.
     */
    public final Boolean addressNumberCorrected() {
        return addressNumberCorrected;
    }

    /**
     * For responses, this returns true if the service returned a value for the PostalCodeDetails property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPostalCodeDetails() {
        return postalCodeDetails != null && !(postalCodeDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains details about the postal code of the place/result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPostalCodeDetails} method.
     * </p>
     * 
     * @return Contains details about the postal code of the place/result.
     */
    public final List<PostalCodeDetails> postalCodeDetails() {
        return postalCodeDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Position property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPosition() {
        return position != null && !(position instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The position in longitude and latitude.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPosition} method.
     * </p>
     * 
     * @return The position in longitude and latitude.
     */
    public final List<Double> position() {
        return position;
    }

    /**
     * <p>
     * The distance in meters from the QueryPosition.
     * </p>
     * 
     * @return The distance in meters from the QueryPosition.
     */
    public final Long distance() {
        return distance;
    }

    /**
     * For responses, this returns true if the service returned a value for the MapView property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMapView() {
        return mapView != null && !(mapView instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The bounding box enclosing the geometric shape (area or line) that an individual result covers.
     * </p>
     * <p>
     * The bounding box formed is defined as a set 4 coordinates:
     * <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMapView} method.
     * </p>
     * 
     * @return The bounding box enclosing the geometric shape (area or line) that an individual result covers.</p>
     *         <p>
     *         The bounding box formed is defined as a set 4 coordinates:
     *         <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
     */
    public final List<Double> mapView() {
        return mapView;
    }

    /**
     * For responses, this returns true if the service returned a value for the Categories property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCategories() {
        return categories != null && !(categories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Categories of results that results must belong to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategories} method.
     * </p>
     * 
     * @return Categories of results that results must belong to.
     */
    public final List<Category> categories() {
        return categories;
    }

    /**
     * For responses, this returns true if the service returned a value for the FoodTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFoodTypes() {
        return foodTypes != null && !(foodTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of food types offered by this result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFoodTypes} method.
     * </p>
     * 
     * @return List of food types offered by this result.
     */
    public final List<FoodType> foodTypes() {
        return foodTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessPoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessPoints() {
        return accessPoints != null && !(accessPoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Position of the access point represent by longitude and latitude.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessPoints} method.
     * </p>
     * 
     * @return Position of the access point represent by longitude and latitude.
     */
    public final List<AccessPoint> accessPoints() {
        return accessPoints;
    }

    /**
     * <p>
     * The time zone in which the place is located.
     * </p>
     * 
     * @return The time zone in which the place is located.
     */
    public final TimeZone timeZone() {
        return timeZone;
    }

    /**
     * <p>
     * The alpha-2 or alpha-3 character code for the political view of a country. The political view applies to the
     * results of the request to represent unresolved territorial claims through the point of view of the specified
     * country.
     * </p>
     * 
     * @return The alpha-2 or alpha-3 character code for the political view of a country. The political view applies to
     *         the results of the request to represent unresolved territorial claims through the point of view of the
     *         specified country.
     */
    public final String politicalView() {
        return politicalView;
    }

    /**
     * <p>
     * Indicates how well the entire input matches the returned. It is equal to 1 if all input tokens are recognized and
     * matched.
     * </p>
     * 
     * @return Indicates how well the entire input matches the returned. It is equal to 1 if all input tokens are
     *         recognized and matched.
     */
    public final MatchScoreDetails matchScores() {
        return matchScores;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(placeId());
        hashCode = 31 * hashCode + Objects.hashCode(placeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(addressNumberCorrected());
        hashCode = 31 * hashCode + Objects.hashCode(hasPostalCodeDetails() ? postalCodeDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPosition() ? position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(distance());
        hashCode = 31 * hashCode + Objects.hashCode(hasMapView() ? mapView() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCategories() ? categories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFoodTypes() ? foodTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessPoints() ? accessPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(matchScores());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeocodeResultItem)) {
            return false;
        }
        GeocodeResultItem other = (GeocodeResultItem) obj;
        return Objects.equals(placeId(), other.placeId()) && Objects.equals(placeTypeAsString(), other.placeTypeAsString())
                && Objects.equals(title(), other.title()) && Objects.equals(address(), other.address())
                && Objects.equals(addressNumberCorrected(), other.addressNumberCorrected())
                && hasPostalCodeDetails() == other.hasPostalCodeDetails()
                && Objects.equals(postalCodeDetails(), other.postalCodeDetails()) && hasPosition() == other.hasPosition()
                && Objects.equals(position(), other.position()) && Objects.equals(distance(), other.distance())
                && hasMapView() == other.hasMapView() && Objects.equals(mapView(), other.mapView())
                && hasCategories() == other.hasCategories() && Objects.equals(categories(), other.categories())
                && hasFoodTypes() == other.hasFoodTypes() && Objects.equals(foodTypes(), other.foodTypes())
                && hasAccessPoints() == other.hasAccessPoints() && Objects.equals(accessPoints(), other.accessPoints())
                && Objects.equals(timeZone(), other.timeZone()) && Objects.equals(politicalView(), other.politicalView())
                && Objects.equals(matchScores(), other.matchScores());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeocodeResultItem").add("PlaceId", placeId()).add("PlaceType", placeTypeAsString())
                .add("Title", title()).add("Address", address()).add("AddressNumberCorrected", addressNumberCorrected())
                .add("PostalCodeDetails", hasPostalCodeDetails() ? postalCodeDetails() : null)
                .add("Position", position() == null ? null : "*** Sensitive Data Redacted ***").add("Distance", distance())
                .add("MapView", mapView() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Categories", hasCategories() ? categories() : null).add("FoodTypes", hasFoodTypes() ? foodTypes() : null)
                .add("AccessPoints", hasAccessPoints() ? accessPoints() : null).add("TimeZone", timeZone())
                .add("PoliticalView", politicalView()).add("MatchScores", matchScores()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlaceId":
            return Optional.ofNullable(clazz.cast(placeId()));
        case "PlaceType":
            return Optional.ofNullable(clazz.cast(placeTypeAsString()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "AddressNumberCorrected":
            return Optional.ofNullable(clazz.cast(addressNumberCorrected()));
        case "PostalCodeDetails":
            return Optional.ofNullable(clazz.cast(postalCodeDetails()));
        case "Position":
            return Optional.ofNullable(clazz.cast(position()));
        case "Distance":
            return Optional.ofNullable(clazz.cast(distance()));
        case "MapView":
            return Optional.ofNullable(clazz.cast(mapView()));
        case "Categories":
            return Optional.ofNullable(clazz.cast(categories()));
        case "FoodTypes":
            return Optional.ofNullable(clazz.cast(foodTypes()));
        case "AccessPoints":
            return Optional.ofNullable(clazz.cast(accessPoints()));
        case "TimeZone":
            return Optional.ofNullable(clazz.cast(timeZone()));
        case "PoliticalView":
            return Optional.ofNullable(clazz.cast(politicalView()));
        case "MatchScores":
            return Optional.ofNullable(clazz.cast(matchScores()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GeocodeResultItem, T> g) {
        return obj -> g.apply((GeocodeResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeocodeResultItem> {
        /**
         * <p>
         * The <code>PlaceId</code> of the place you wish to receive the information for.
         * </p>
         * 
         * @param placeId
         *        The <code>PlaceId</code> of the place you wish to receive the information for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placeId(String placeId);

        /**
         * <p>
         * A <code>PlaceType</code> is a category that the result place must belong to.
         * </p>
         * 
         * @param placeType
         *        A <code>PlaceType</code> is a category that the result place must belong to.
         * @see PlaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlaceType
         */
        Builder placeType(String placeType);

        /**
         * <p>
         * A <code>PlaceType</code> is a category that the result place must belong to.
         * </p>
         * 
         * @param placeType
         *        A <code>PlaceType</code> is a category that the result place must belong to.
         * @see PlaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlaceType
         */
        Builder placeType(PlaceType placeType);

        /**
         * <p>
         * The localized display name of this result item based on request parameter <code>language</code>.
         * </p>
         * 
         * @param title
         *        The localized display name of this result item based on request parameter <code>language</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The place's address.
         * </p>
         * 
         * @param address
         *        The place's address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(Address address);

        /**
         * <p>
         * The place's address.
         * </p>
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #address(Address)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(Address)
         */
        default Builder address(Consumer<Address.Builder> address) {
            return address(Address.builder().applyMutation(address).build());
        }

        /**
         * <p>
         * Boolean indicating if the address provided has been corrected.
         * </p>
         * 
         * @param addressNumberCorrected
         *        Boolean indicating if the address provided has been corrected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressNumberCorrected(Boolean addressNumberCorrected);

        /**
         * <p>
         * Contains details about the postal code of the place/result.
         * </p>
         * 
         * @param postalCodeDetails
         *        Contains details about the postal code of the place/result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCodeDetails(Collection<PostalCodeDetails> postalCodeDetails);

        /**
         * <p>
         * Contains details about the postal code of the place/result.
         * </p>
         * 
         * @param postalCodeDetails
         *        Contains details about the postal code of the place/result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCodeDetails(PostalCodeDetails... postalCodeDetails);

        /**
         * <p>
         * Contains details about the postal code of the place/result.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.PostalCodeDetails.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.geoplaces.model.PostalCodeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.PostalCodeDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #postalCodeDetails(List<PostalCodeDetails>)}.
         * 
         * @param postalCodeDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.PostalCodeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postalCodeDetails(java.util.Collection<PostalCodeDetails>)
         */
        Builder postalCodeDetails(Consumer<PostalCodeDetails.Builder>... postalCodeDetails);

        /**
         * <p>
         * The position in longitude and latitude.
         * </p>
         * 
         * @param position
         *        The position in longitude and latitude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Collection<Double> position);

        /**
         * <p>
         * The position in longitude and latitude.
         * </p>
         * 
         * @param position
         *        The position in longitude and latitude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Double... position);

        /**
         * <p>
         * The distance in meters from the QueryPosition.
         * </p>
         * 
         * @param distance
         *        The distance in meters from the QueryPosition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distance(Long distance);

        /**
         * <p>
         * The bounding box enclosing the geometric shape (area or line) that an individual result covers.
         * </p>
         * <p>
         * The bounding box formed is defined as a set 4 coordinates:
         * <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
         * </p>
         * 
         * @param mapView
         *        The bounding box enclosing the geometric shape (area or line) that an individual result covers.</p>
         *        <p>
         *        The bounding box formed is defined as a set 4 coordinates:
         *        <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapView(Collection<Double> mapView);

        /**
         * <p>
         * The bounding box enclosing the geometric shape (area or line) that an individual result covers.
         * </p>
         * <p>
         * The bounding box formed is defined as a set 4 coordinates:
         * <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
         * </p>
         * 
         * @param mapView
         *        The bounding box enclosing the geometric shape (area or line) that an individual result covers.</p>
         *        <p>
         *        The bounding box formed is defined as a set 4 coordinates:
         *        <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapView(Double... mapView);

        /**
         * <p>
         * Categories of results that results must belong to.
         * </p>
         * 
         * @param categories
         *        Categories of results that results must belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Collection<Category> categories);

        /**
         * <p>
         * Categories of results that results must belong to.
         * </p>
         * 
         * @param categories
         *        Categories of results that results must belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Category... categories);

        /**
         * <p>
         * Categories of results that results must belong to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.Category.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.Category#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.Category.Builder#build()} is called immediately and
         * its result is passed to {@link #categories(List<Category>)}.
         * 
         * @param categories
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.Category.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categories(java.util.Collection<Category>)
         */
        Builder categories(Consumer<Category.Builder>... categories);

        /**
         * <p>
         * List of food types offered by this result.
         * </p>
         * 
         * @param foodTypes
         *        List of food types offered by this result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder foodTypes(Collection<FoodType> foodTypes);

        /**
         * <p>
         * List of food types offered by this result.
         * </p>
         * 
         * @param foodTypes
         *        List of food types offered by this result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder foodTypes(FoodType... foodTypes);

        /**
         * <p>
         * List of food types offered by this result.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.FoodType.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.FoodType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.FoodType.Builder#build()} is called immediately and
         * its result is passed to {@link #foodTypes(List<FoodType>)}.
         * 
         * @param foodTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.FoodType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #foodTypes(java.util.Collection<FoodType>)
         */
        Builder foodTypes(Consumer<FoodType.Builder>... foodTypes);

        /**
         * <p>
         * Position of the access point represent by longitude and latitude.
         * </p>
         * 
         * @param accessPoints
         *        Position of the access point represent by longitude and latitude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPoints(Collection<AccessPoint> accessPoints);

        /**
         * <p>
         * Position of the access point represent by longitude and latitude.
         * </p>
         * 
         * @param accessPoints
         *        Position of the access point represent by longitude and latitude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPoints(AccessPoint... accessPoints);

        /**
         * <p>
         * Position of the access point represent by longitude and latitude.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.AccessPoint.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.AccessPoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.AccessPoint.Builder#build()} is called immediately and
         * its result is passed to {@link #accessPoints(List<AccessPoint>)}.
         * 
         * @param accessPoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.AccessPoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPoints(java.util.Collection<AccessPoint>)
         */
        Builder accessPoints(Consumer<AccessPoint.Builder>... accessPoints);

        /**
         * <p>
         * The time zone in which the place is located.
         * </p>
         * 
         * @param timeZone
         *        The time zone in which the place is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZone(TimeZone timeZone);

        /**
         * <p>
         * The time zone in which the place is located.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeZone.Builder} avoiding the need to
         * create one manually via {@link TimeZone#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeZone.Builder#build()} is called immediately and its result is
         * passed to {@link #timeZone(TimeZone)}.
         * 
         * @param timeZone
         *        a consumer that will call methods on {@link TimeZone.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeZone(TimeZone)
         */
        default Builder timeZone(Consumer<TimeZone.Builder> timeZone) {
            return timeZone(TimeZone.builder().applyMutation(timeZone).build());
        }

        /**
         * <p>
         * The alpha-2 or alpha-3 character code for the political view of a country. The political view applies to the
         * results of the request to represent unresolved territorial claims through the point of view of the specified
         * country.
         * </p>
         * 
         * @param politicalView
         *        The alpha-2 or alpha-3 character code for the political view of a country. The political view applies
         *        to the results of the request to represent unresolved territorial claims through the point of view of
         *        the specified country.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder politicalView(String politicalView);

        /**
         * <p>
         * Indicates how well the entire input matches the returned. It is equal to 1 if all input tokens are recognized
         * and matched.
         * </p>
         * 
         * @param matchScores
         *        Indicates how well the entire input matches the returned. It is equal to 1 if all input tokens are
         *        recognized and matched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchScores(MatchScoreDetails matchScores);

        /**
         * <p>
         * Indicates how well the entire input matches the returned. It is equal to 1 if all input tokens are recognized
         * and matched.
         * </p>
         * This is a convenience method that creates an instance of the {@link MatchScoreDetails.Builder} avoiding the
         * need to create one manually via {@link MatchScoreDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MatchScoreDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #matchScores(MatchScoreDetails)}.
         * 
         * @param matchScores
         *        a consumer that will call methods on {@link MatchScoreDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchScores(MatchScoreDetails)
         */
        default Builder matchScores(Consumer<MatchScoreDetails.Builder> matchScores) {
            return matchScores(MatchScoreDetails.builder().applyMutation(matchScores).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String placeId;

        private String placeType;

        private String title;

        private Address address;

        private Boolean addressNumberCorrected;

        private List<PostalCodeDetails> postalCodeDetails = DefaultSdkAutoConstructList.getInstance();

        private List<Double> position = DefaultSdkAutoConstructList.getInstance();

        private Long distance;

        private List<Double> mapView = DefaultSdkAutoConstructList.getInstance();

        private List<Category> categories = DefaultSdkAutoConstructList.getInstance();

        private List<FoodType> foodTypes = DefaultSdkAutoConstructList.getInstance();

        private List<AccessPoint> accessPoints = DefaultSdkAutoConstructList.getInstance();

        private TimeZone timeZone;

        private String politicalView;

        private MatchScoreDetails matchScores;

        private BuilderImpl() {
        }

        private BuilderImpl(GeocodeResultItem model) {
            placeId(model.placeId);
            placeType(model.placeType);
            title(model.title);
            address(model.address);
            addressNumberCorrected(model.addressNumberCorrected);
            postalCodeDetails(model.postalCodeDetails);
            position(model.position);
            distance(model.distance);
            mapView(model.mapView);
            categories(model.categories);
            foodTypes(model.foodTypes);
            accessPoints(model.accessPoints);
            timeZone(model.timeZone);
            politicalView(model.politicalView);
            matchScores(model.matchScores);
        }

        public final String getPlaceId() {
            return placeId;
        }

        public final void setPlaceId(String placeId) {
            this.placeId = placeId;
        }

        @Override
        public final Builder placeId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        public final String getPlaceType() {
            return placeType;
        }

        public final void setPlaceType(String placeType) {
            this.placeType = placeType;
        }

        @Override
        public final Builder placeType(String placeType) {
            this.placeType = placeType;
            return this;
        }

        @Override
        public final Builder placeType(PlaceType placeType) {
            this.placeType(placeType == null ? null : placeType.toString());
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Address.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final Boolean getAddressNumberCorrected() {
            return addressNumberCorrected;
        }

        public final void setAddressNumberCorrected(Boolean addressNumberCorrected) {
            this.addressNumberCorrected = addressNumberCorrected;
        }

        @Override
        public final Builder addressNumberCorrected(Boolean addressNumberCorrected) {
            this.addressNumberCorrected = addressNumberCorrected;
            return this;
        }

        public final List<PostalCodeDetails.Builder> getPostalCodeDetails() {
            List<PostalCodeDetails.Builder> result = PostalCodeDetailsListCopier.copyToBuilder(this.postalCodeDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPostalCodeDetails(Collection<PostalCodeDetails.BuilderImpl> postalCodeDetails) {
            this.postalCodeDetails = PostalCodeDetailsListCopier.copyFromBuilder(postalCodeDetails);
        }

        @Override
        public final Builder postalCodeDetails(Collection<PostalCodeDetails> postalCodeDetails) {
            this.postalCodeDetails = PostalCodeDetailsListCopier.copy(postalCodeDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder postalCodeDetails(PostalCodeDetails... postalCodeDetails) {
            postalCodeDetails(Arrays.asList(postalCodeDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder postalCodeDetails(Consumer<PostalCodeDetails.Builder>... postalCodeDetails) {
            postalCodeDetails(Stream.of(postalCodeDetails).map(c -> PostalCodeDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<Double> getPosition() {
            if (position instanceof SdkAutoConstructList) {
                return null;
            }
            return position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double... position) {
            position(Arrays.asList(position));
            return this;
        }

        public final Long getDistance() {
            return distance;
        }

        public final void setDistance(Long distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Long distance) {
            this.distance = distance;
            return this;
        }

        public final Collection<Double> getMapView() {
            if (mapView instanceof SdkAutoConstructList) {
                return null;
            }
            return mapView;
        }

        public final void setMapView(Collection<Double> mapView) {
            this.mapView = BoundingBoxCopier.copy(mapView);
        }

        @Override
        public final Builder mapView(Collection<Double> mapView) {
            this.mapView = BoundingBoxCopier.copy(mapView);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapView(Double... mapView) {
            mapView(Arrays.asList(mapView));
            return this;
        }

        public final List<Category.Builder> getCategories() {
            List<Category.Builder> result = CategoryListCopier.copyToBuilder(this.categories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategories(Collection<Category.BuilderImpl> categories) {
            this.categories = CategoryListCopier.copyFromBuilder(categories);
        }

        @Override
        public final Builder categories(Collection<Category> categories) {
            this.categories = CategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Category... categories) {
            categories(Arrays.asList(categories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Consumer<Category.Builder>... categories) {
            categories(Stream.of(categories).map(c -> Category.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FoodType.Builder> getFoodTypes() {
            List<FoodType.Builder> result = FoodTypeListCopier.copyToBuilder(this.foodTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFoodTypes(Collection<FoodType.BuilderImpl> foodTypes) {
            this.foodTypes = FoodTypeListCopier.copyFromBuilder(foodTypes);
        }

        @Override
        public final Builder foodTypes(Collection<FoodType> foodTypes) {
            this.foodTypes = FoodTypeListCopier.copy(foodTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder foodTypes(FoodType... foodTypes) {
            foodTypes(Arrays.asList(foodTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder foodTypes(Consumer<FoodType.Builder>... foodTypes) {
            foodTypes(Stream.of(foodTypes).map(c -> FoodType.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AccessPoint.Builder> getAccessPoints() {
            List<AccessPoint.Builder> result = AccessPointListCopier.copyToBuilder(this.accessPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessPoints(Collection<AccessPoint.BuilderImpl> accessPoints) {
            this.accessPoints = AccessPointListCopier.copyFromBuilder(accessPoints);
        }

        @Override
        public final Builder accessPoints(Collection<AccessPoint> accessPoints) {
            this.accessPoints = AccessPointListCopier.copy(accessPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPoints(AccessPoint... accessPoints) {
            accessPoints(Arrays.asList(accessPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPoints(Consumer<AccessPoint.Builder>... accessPoints) {
            accessPoints(Stream.of(accessPoints).map(c -> AccessPoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TimeZone.Builder getTimeZone() {
            return timeZone != null ? timeZone.toBuilder() : null;
        }

        public final void setTimeZone(TimeZone.BuilderImpl timeZone) {
            this.timeZone = timeZone != null ? timeZone.build() : null;
        }

        @Override
        public final Builder timeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final String getPoliticalView() {
            return politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final MatchScoreDetails.Builder getMatchScores() {
            return matchScores != null ? matchScores.toBuilder() : null;
        }

        public final void setMatchScores(MatchScoreDetails.BuilderImpl matchScores) {
            this.matchScores = matchScores != null ? matchScores.build() : null;
        }

        @Override
        public final Builder matchScores(MatchScoreDetails matchScores) {
            this.matchScores = matchScores;
            return this;
        }

        @Override
        public GeocodeResultItem build() {
            return new GeocodeResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
