/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes how parts of the result response match the input query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Highlight implements SdkPojo, Serializable, ToCopyableBuilder<Highlight.Builder, Highlight> {
    private static final SdkField<Integer> START_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartIndex").getter(getter(Highlight::startIndex)).setter(setter(Builder::startIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartIndex").build()).build();

    private static final SdkField<Integer> END_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndIndex").getter(getter(Highlight::endIndex)).setter(setter(Builder::endIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndIndex").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(Highlight::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_INDEX_FIELD,
            END_INDEX_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("StartIndex", START_INDEX_FIELD);
                    put("EndIndex", END_INDEX_FIELD);
                    put("Value", VALUE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer startIndex;

    private final Integer endIndex;

    private final String value;

    private Highlight(BuilderImpl builder) {
        this.startIndex = builder.startIndex;
        this.endIndex = builder.endIndex;
        this.value = builder.value;
    }

    /**
     * <p>
     * Start index of the highlight.
     * </p>
     * 
     * @return Start index of the highlight.
     */
    public final Integer startIndex() {
        return startIndex;
    }

    /**
     * <p>
     * End index of the highlight.
     * </p>
     * 
     * @return End index of the highlight.
     */
    public final Integer endIndex() {
        return endIndex;
    }

    /**
     * <p>
     * The highlight's value.
     * </p>
     * 
     * @return The highlight's value.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startIndex());
        hashCode = 31 * hashCode + Objects.hashCode(endIndex());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Highlight)) {
            return false;
        }
        Highlight other = (Highlight) obj;
        return Objects.equals(startIndex(), other.startIndex()) && Objects.equals(endIndex(), other.endIndex())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Highlight").add("StartIndex", startIndex()).add("EndIndex", endIndex()).add("Value", value())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartIndex":
            return Optional.ofNullable(clazz.cast(startIndex()));
        case "EndIndex":
            return Optional.ofNullable(clazz.cast(endIndex()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Highlight, T> g) {
        return obj -> g.apply((Highlight) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Highlight> {
        /**
         * <p>
         * Start index of the highlight.
         * </p>
         * 
         * @param startIndex
         *        Start index of the highlight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startIndex(Integer startIndex);

        /**
         * <p>
         * End index of the highlight.
         * </p>
         * 
         * @param endIndex
         *        End index of the highlight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endIndex(Integer endIndex);

        /**
         * <p>
         * The highlight's value.
         * </p>
         * 
         * @param value
         *        The highlight's value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private Integer startIndex;

        private Integer endIndex;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Highlight model) {
            startIndex(model.startIndex);
            endIndex(model.endIndex);
            value(model.value);
        }

        public final Integer getStartIndex() {
            return startIndex;
        }

        public final void setStartIndex(Integer startIndex) {
            this.startIndex = startIndex;
        }

        @Override
        public final Builder startIndex(Integer startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public final Integer getEndIndex() {
            return endIndex;
        }

        public final void setEndIndex(Integer endIndex) {
            this.endIndex = endIndex;
        }

        @Override
        public final Builder endIndex(Integer endIndex) {
            this.endIndex = endIndex;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public Highlight build() {
            return new Highlight(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
