/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Components of the opening hours object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpeningHoursComponents implements SdkPojo, Serializable,
        ToCopyableBuilder<OpeningHoursComponents.Builder, OpeningHoursComponents> {
    private static final SdkField<String> OPEN_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpenTime").getter(getter(OpeningHoursComponents::openTime)).setter(setter(Builder::openTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenTime").build()).build();

    private static final SdkField<String> OPEN_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpenDuration").getter(getter(OpeningHoursComponents::openDuration))
            .setter(setter(Builder::openDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenDuration").build()).build();

    private static final SdkField<String> RECURRENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Recurrence").getter(getter(OpeningHoursComponents::recurrence)).setter(setter(Builder::recurrence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPEN_TIME_FIELD,
            OPEN_DURATION_FIELD, RECURRENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("OpenTime", OPEN_TIME_FIELD);
                    put("OpenDuration", OPEN_DURATION_FIELD);
                    put("Recurrence", RECURRENCE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String openTime;

    private final String openDuration;

    private final String recurrence;

    private OpeningHoursComponents(BuilderImpl builder) {
        this.openTime = builder.openTime;
        this.openDuration = builder.openDuration;
        this.recurrence = builder.recurrence;
    }

    /**
     * <p>
     * String which represents the opening hours, such as <code>"T070000"</code>.
     * </p>
     * 
     * @return String which represents the opening hours, such as <code>"T070000"</code>.
     */
    public final String openTime() {
        return openTime;
    }

    /**
     * <p>
     * String which represents the duration of the opening period, such as <code>"PT12H00M"</code>.
     * </p>
     * 
     * @return String which represents the duration of the opening period, such as <code>"PT12H00M"</code>.
     */
    public final String openDuration() {
        return openDuration;
    }

    /**
     * <p>
     * Days or periods when the provided opening hours are in affect.
     * </p>
     * <p>
     * Example: <code>FREQ:DAILY;BYDAY:MO,TU,WE,TH,SU</code>
     * </p>
     * 
     * @return Days or periods when the provided opening hours are in affect. </p>
     *         <p>
     *         Example: <code>FREQ:DAILY;BYDAY:MO,TU,WE,TH,SU</code>
     */
    public final String recurrence() {
        return recurrence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(openTime());
        hashCode = 31 * hashCode + Objects.hashCode(openDuration());
        hashCode = 31 * hashCode + Objects.hashCode(recurrence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpeningHoursComponents)) {
            return false;
        }
        OpeningHoursComponents other = (OpeningHoursComponents) obj;
        return Objects.equals(openTime(), other.openTime()) && Objects.equals(openDuration(), other.openDuration())
                && Objects.equals(recurrence(), other.recurrence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpeningHoursComponents").add("OpenTime", openTime()).add("OpenDuration", openDuration())
                .add("Recurrence", recurrence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpenTime":
            return Optional.ofNullable(clazz.cast(openTime()));
        case "OpenDuration":
            return Optional.ofNullable(clazz.cast(openDuration()));
        case "Recurrence":
            return Optional.ofNullable(clazz.cast(recurrence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OpeningHoursComponents, T> g) {
        return obj -> g.apply((OpeningHoursComponents) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpeningHoursComponents> {
        /**
         * <p>
         * String which represents the opening hours, such as <code>"T070000"</code>.
         * </p>
         * 
         * @param openTime
         *        String which represents the opening hours, such as <code>"T070000"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openTime(String openTime);

        /**
         * <p>
         * String which represents the duration of the opening period, such as <code>"PT12H00M"</code>.
         * </p>
         * 
         * @param openDuration
         *        String which represents the duration of the opening period, such as <code>"PT12H00M"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openDuration(String openDuration);

        /**
         * <p>
         * Days or periods when the provided opening hours are in affect.
         * </p>
         * <p>
         * Example: <code>FREQ:DAILY;BYDAY:MO,TU,WE,TH,SU</code>
         * </p>
         * 
         * @param recurrence
         *        Days or periods when the provided opening hours are in affect. </p>
         *        <p>
         *        Example: <code>FREQ:DAILY;BYDAY:MO,TU,WE,TH,SU</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrence(String recurrence);
    }

    static final class BuilderImpl implements Builder {
        private String openTime;

        private String openDuration;

        private String recurrence;

        private BuilderImpl() {
        }

        private BuilderImpl(OpeningHoursComponents model) {
            openTime(model.openTime);
            openDuration(model.openDuration);
            recurrence(model.recurrence);
        }

        public final String getOpenTime() {
            return openTime;
        }

        public final void setOpenTime(String openTime) {
            this.openTime = openTime;
        }

        @Override
        public final Builder openTime(String openTime) {
            this.openTime = openTime;
            return this;
        }

        public final String getOpenDuration() {
            return openDuration;
        }

        public final void setOpenDuration(String openDuration) {
            this.openDuration = openDuration;
        }

        @Override
        public final Builder openDuration(String openDuration) {
            this.openDuration = openDuration;
            return this;
        }

        public final String getRecurrence() {
            return recurrence;
        }

        public final void setRecurrence(String recurrence) {
            this.recurrence = recurrence;
        }

        @Override
        public final Builder recurrence(String recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        @Override
        public OpeningHoursComponents build() {
            return new OpeningHoursComponents(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
