/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Suggestions for refining individual query terms. Suggestions are returned as objects which note the term, suggested
 * replacement, and its index in the query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryRefinement implements SdkPojo, Serializable, ToCopyableBuilder<QueryRefinement.Builder, QueryRefinement> {
    private static final SdkField<String> REFINED_TERM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RefinedTerm").getter(getter(QueryRefinement::refinedTerm)).setter(setter(Builder::refinedTerm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefinedTerm").build()).build();

    private static final SdkField<String> ORIGINAL_TERM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginalTerm").getter(getter(QueryRefinement::originalTerm)).setter(setter(Builder::originalTerm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalTerm").build()).build();

    private static final SdkField<Integer> START_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartIndex").getter(getter(QueryRefinement::startIndex)).setter(setter(Builder::startIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartIndex").build()).build();

    private static final SdkField<Integer> END_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndIndex").getter(getter(QueryRefinement::endIndex)).setter(setter(Builder::endIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFINED_TERM_FIELD,
            ORIGINAL_TERM_FIELD, START_INDEX_FIELD, END_INDEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("RefinedTerm", REFINED_TERM_FIELD);
                    put("OriginalTerm", ORIGINAL_TERM_FIELD);
                    put("StartIndex", START_INDEX_FIELD);
                    put("EndIndex", END_INDEX_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String refinedTerm;

    private final String originalTerm;

    private final Integer startIndex;

    private final Integer endIndex;

    private QueryRefinement(BuilderImpl builder) {
        this.refinedTerm = builder.refinedTerm;
        this.originalTerm = builder.originalTerm;
        this.startIndex = builder.startIndex;
        this.endIndex = builder.endIndex;
    }

    /**
     * <p>
     * The term that will be suggested to the user.
     * </p>
     * 
     * @return The term that will be suggested to the user.
     */
    public final String refinedTerm() {
        return refinedTerm;
    }

    /**
     * <p>
     * The sub-string of the original query that is replaced by this query term.
     * </p>
     * 
     * @return The sub-string of the original query that is replaced by this query term.
     */
    public final String originalTerm() {
        return originalTerm;
    }

    /**
     * <p>
     * Start index of the parsed component.
     * </p>
     * 
     * @return Start index of the parsed component.
     */
    public final Integer startIndex() {
        return startIndex;
    }

    /**
     * <p>
     * End index of the parsed query.
     * </p>
     * 
     * @return End index of the parsed query.
     */
    public final Integer endIndex() {
        return endIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(refinedTerm());
        hashCode = 31 * hashCode + Objects.hashCode(originalTerm());
        hashCode = 31 * hashCode + Objects.hashCode(startIndex());
        hashCode = 31 * hashCode + Objects.hashCode(endIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRefinement)) {
            return false;
        }
        QueryRefinement other = (QueryRefinement) obj;
        return Objects.equals(refinedTerm(), other.refinedTerm()) && Objects.equals(originalTerm(), other.originalTerm())
                && Objects.equals(startIndex(), other.startIndex()) && Objects.equals(endIndex(), other.endIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryRefinement").add("RefinedTerm", refinedTerm()).add("OriginalTerm", originalTerm())
                .add("StartIndex", startIndex()).add("EndIndex", endIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RefinedTerm":
            return Optional.ofNullable(clazz.cast(refinedTerm()));
        case "OriginalTerm":
            return Optional.ofNullable(clazz.cast(originalTerm()));
        case "StartIndex":
            return Optional.ofNullable(clazz.cast(startIndex()));
        case "EndIndex":
            return Optional.ofNullable(clazz.cast(endIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QueryRefinement, T> g) {
        return obj -> g.apply((QueryRefinement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryRefinement> {
        /**
         * <p>
         * The term that will be suggested to the user.
         * </p>
         * 
         * @param refinedTerm
         *        The term that will be suggested to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refinedTerm(String refinedTerm);

        /**
         * <p>
         * The sub-string of the original query that is replaced by this query term.
         * </p>
         * 
         * @param originalTerm
         *        The sub-string of the original query that is replaced by this query term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalTerm(String originalTerm);

        /**
         * <p>
         * Start index of the parsed component.
         * </p>
         * 
         * @param startIndex
         *        Start index of the parsed component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startIndex(Integer startIndex);

        /**
         * <p>
         * End index of the parsed query.
         * </p>
         * 
         * @param endIndex
         *        End index of the parsed query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endIndex(Integer endIndex);
    }

    static final class BuilderImpl implements Builder {
        private String refinedTerm;

        private String originalTerm;

        private Integer startIndex;

        private Integer endIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryRefinement model) {
            refinedTerm(model.refinedTerm);
            originalTerm(model.originalTerm);
            startIndex(model.startIndex);
            endIndex(model.endIndex);
        }

        public final String getRefinedTerm() {
            return refinedTerm;
        }

        public final void setRefinedTerm(String refinedTerm) {
            this.refinedTerm = refinedTerm;
        }

        @Override
        public final Builder refinedTerm(String refinedTerm) {
            this.refinedTerm = refinedTerm;
            return this;
        }

        public final String getOriginalTerm() {
            return originalTerm;
        }

        public final void setOriginalTerm(String originalTerm) {
            this.originalTerm = originalTerm;
        }

        @Override
        public final Builder originalTerm(String originalTerm) {
            this.originalTerm = originalTerm;
            return this;
        }

        public final Integer getStartIndex() {
            return startIndex;
        }

        public final void setStartIndex(Integer startIndex) {
            this.startIndex = startIndex;
        }

        @Override
        public final Builder startIndex(Integer startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public final Integer getEndIndex() {
            return endIndex;
        }

        public final void setEndIndex(Integer endIndex) {
            this.endIndex = endIndex;
        }

        @Override
        public final Builder endIndex(Integer endIndex) {
            this.endIndex = endIndex;
            return this;
        }

        @Override
        public QueryRefinement build() {
            return new QueryRefinement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
