/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchNearbyResponse extends GeoPlacesResponse implements
        ToCopyableBuilder<SearchNearbyResponse.Builder, SearchNearbyResponse> {
    private static final SdkField<String> PRICING_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingBucket").getter(getter(SearchNearbyResponse::pricingBucket))
            .setter(setter(Builder::pricingBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-geo-pricing-bucket").build())
            .build();

    private static final SdkField<List<SearchNearbyResultItem>> RESULT_ITEMS_FIELD = SdkField
            .<List<SearchNearbyResultItem>> builder(MarshallingType.LIST)
            .memberName("ResultItems")
            .getter(getter(SearchNearbyResponse::resultItems))
            .setter(setter(Builder::resultItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchNearbyResultItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchNearbyResultItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchNearbyResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICING_BUCKET_FIELD,
            RESULT_ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("x-amz-geo-pricing-bucket", PRICING_BUCKET_FIELD);
                    put("ResultItems", RESULT_ITEMS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final String pricingBucket;

    private final List<SearchNearbyResultItem> resultItems;

    private final String nextToken;

    private SearchNearbyResponse(BuilderImpl builder) {
        super(builder);
        this.pricingBucket = builder.pricingBucket;
        this.resultItems = builder.resultItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The pricing bucket for which the query is charged at.
     * </p>
     * <p>
     * For more inforamtion on pricing, please visit <a href="https://aws.amazon.com/location/pricing/">Amazon Location
     * Service Pricing</a>.
     * </p>
     * 
     * @return The pricing bucket for which the query is charged at.</p>
     *         <p>
     *         For more inforamtion on pricing, please visit <a href="https://aws.amazon.com/location/pricing/">Amazon
     *         Location Service Pricing</a>.
     */
    public final String pricingBucket() {
        return pricingBucket;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResultItems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResultItems() {
        return resultItems != null && !(resultItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of places or results returned for a query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResultItems} method.
     * </p>
     * 
     * @return List of places or results returned for a query.
     */
    public final List<SearchNearbyResultItem> resultItems() {
        return resultItems;
    }

    /**
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page.
     * </p>
     * 
     * @return If <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pricingBucket());
        hashCode = 31 * hashCode + Objects.hashCode(hasResultItems() ? resultItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchNearbyResponse)) {
            return false;
        }
        SearchNearbyResponse other = (SearchNearbyResponse) obj;
        return Objects.equals(pricingBucket(), other.pricingBucket()) && hasResultItems() == other.hasResultItems()
                && Objects.equals(resultItems(), other.resultItems()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchNearbyResponse").add("PricingBucket", pricingBucket())
                .add("ResultItems", hasResultItems() ? resultItems() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PricingBucket":
            return Optional.ofNullable(clazz.cast(pricingBucket()));
        case "ResultItems":
            return Optional.ofNullable(clazz.cast(resultItems()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchNearbyResponse, T> g) {
        return obj -> g.apply((SearchNearbyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GeoPlacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchNearbyResponse> {
        /**
         * <p>
         * The pricing bucket for which the query is charged at.
         * </p>
         * <p>
         * For more inforamtion on pricing, please visit <a href="https://aws.amazon.com/location/pricing/">Amazon
         * Location Service Pricing</a>.
         * </p>
         * 
         * @param pricingBucket
         *        The pricing bucket for which the query is charged at.</p>
         *        <p>
         *        For more inforamtion on pricing, please visit <a
         *        href="https://aws.amazon.com/location/pricing/">Amazon Location Service Pricing</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingBucket(String pricingBucket);

        /**
         * <p>
         * List of places or results returned for a query.
         * </p>
         * 
         * @param resultItems
         *        List of places or results returned for a query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultItems(Collection<SearchNearbyResultItem> resultItems);

        /**
         * <p>
         * List of places or results returned for a query.
         * </p>
         * 
         * @param resultItems
         *        List of places or results returned for a query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultItems(SearchNearbyResultItem... resultItems);

        /**
         * <p>
         * List of places or results returned for a query.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.SearchNearbyResultItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.SearchNearbyResultItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.SearchNearbyResultItem.Builder#build()} is called
         * immediately and its result is passed to {@link #resultItems(List<SearchNearbyResultItem>)}.
         * 
         * @param resultItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.SearchNearbyResultItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultItems(java.util.Collection<SearchNearbyResultItem>)
         */
        Builder resultItems(Consumer<SearchNearbyResultItem.Builder>... resultItems);

        /**
         * <p>
         * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code>
         * is a unique pagination token for each page.
         * </p>
         * 
         * @param nextToken
         *        If <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GeoPlacesResponse.BuilderImpl implements Builder {
        private String pricingBucket;

        private List<SearchNearbyResultItem> resultItems = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchNearbyResponse model) {
            super(model);
            pricingBucket(model.pricingBucket);
            resultItems(model.resultItems);
            nextToken(model.nextToken);
        }

        public final String getPricingBucket() {
            return pricingBucket;
        }

        public final void setPricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
        }

        @Override
        public final Builder pricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
            return this;
        }

        public final List<SearchNearbyResultItem.Builder> getResultItems() {
            List<SearchNearbyResultItem.Builder> result = SearchNearbyResultItemListCopier.copyToBuilder(this.resultItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultItems(Collection<SearchNearbyResultItem.BuilderImpl> resultItems) {
            this.resultItems = SearchNearbyResultItemListCopier.copyFromBuilder(resultItems);
        }

        @Override
        public final Builder resultItems(Collection<SearchNearbyResultItem> resultItems) {
            this.resultItems = SearchNearbyResultItemListCopier.copy(resultItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(SearchNearbyResultItem... resultItems) {
            resultItems(Arrays.asList(resultItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(Consumer<SearchNearbyResultItem.Builder>... resultItems) {
            resultItems(Stream.of(resultItems).map(c -> SearchNearbyResultItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SearchNearbyResponse build() {
            return new SearchNearbyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
