/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes how the parts of the textQuery matched the input query by returning the sections of the response which
 * matched to textQuery terms.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuggestHighlights implements SdkPojo, Serializable,
        ToCopyableBuilder<SuggestHighlights.Builder, SuggestHighlights> {
    private static final SdkField<List<Highlight>> TITLE_FIELD = SdkField
            .<List<Highlight>> builder(MarshallingType.LIST)
            .memberName("Title")
            .getter(getter(SuggestHighlights::title))
            .setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Highlight> builder(MarshallingType.SDK_POJO)
                                            .constructor(Highlight::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SuggestAddressHighlights> ADDRESS_FIELD = SdkField
            .<SuggestAddressHighlights> builder(MarshallingType.SDK_POJO).memberName("Address")
            .getter(getter(SuggestHighlights::address)).setter(setter(Builder::address))
            .constructor(SuggestAddressHighlights::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Title", TITLE_FIELD);
                    put("Address", ADDRESS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<Highlight> title;

    private final SuggestAddressHighlights address;

    private SuggestHighlights(BuilderImpl builder) {
        this.title = builder.title;
        this.address = builder.address;
    }

    /**
     * For responses, this returns true if the service returned a value for the Title property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTitle() {
        return title != null && !(title instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the starting and ending index of the title in the text query that match the found title.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTitle} method.
     * </p>
     * 
     * @return Indicates the starting and ending index of the title in the text query that match the found title.
     */
    public final List<Highlight> title() {
        return title;
    }

    /**
     * <p>
     * The place's address.
     * </p>
     * 
     * @return The place's address.
     */
    public final SuggestAddressHighlights address() {
        return address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTitle() ? title() : null);
        hashCode = 31 * hashCode + Objects.hashCode(address());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestHighlights)) {
            return false;
        }
        SuggestHighlights other = (SuggestHighlights) obj;
        return hasTitle() == other.hasTitle() && Objects.equals(title(), other.title())
                && Objects.equals(address(), other.address());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuggestHighlights").add("Title", hasTitle() ? title() : null).add("Address", address()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SuggestHighlights, T> g) {
        return obj -> g.apply((SuggestHighlights) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuggestHighlights> {
        /**
         * <p>
         * Indicates the starting and ending index of the title in the text query that match the found title.
         * </p>
         * 
         * @param title
         *        Indicates the starting and ending index of the title in the text query that match the found title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(Collection<Highlight> title);

        /**
         * <p>
         * Indicates the starting and ending index of the title in the text query that match the found title.
         * </p>
         * 
         * @param title
         *        Indicates the starting and ending index of the title in the text query that match the found title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(Highlight... title);

        /**
         * <p>
         * Indicates the starting and ending index of the title in the text query that match the found title.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.Highlight#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder#build()} is called immediately and
         * its result is passed to {@link #title(List<Highlight>)}.
         * 
         * @param title
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #title(java.util.Collection<Highlight>)
         */
        Builder title(Consumer<Highlight.Builder>... title);

        /**
         * <p>
         * The place's address.
         * </p>
         * 
         * @param address
         *        The place's address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(SuggestAddressHighlights address);

        /**
         * <p>
         * The place's address.
         * </p>
         * This is a convenience method that creates an instance of the {@link SuggestAddressHighlights.Builder}
         * avoiding the need to create one manually via {@link SuggestAddressHighlights#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SuggestAddressHighlights.Builder#build()} is called immediately
         * and its result is passed to {@link #address(SuggestAddressHighlights)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link SuggestAddressHighlights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(SuggestAddressHighlights)
         */
        default Builder address(Consumer<SuggestAddressHighlights.Builder> address) {
            return address(SuggestAddressHighlights.builder().applyMutation(address).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<Highlight> title = DefaultSdkAutoConstructList.getInstance();

        private SuggestAddressHighlights address;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestHighlights model) {
            title(model.title);
            address(model.address);
        }

        public final List<Highlight.Builder> getTitle() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.title);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTitle(Collection<Highlight.BuilderImpl> title) {
            this.title = HighlightListCopier.copyFromBuilder(title);
        }

        @Override
        public final Builder title(Collection<Highlight> title) {
            this.title = HighlightListCopier.copy(title);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder title(Highlight... title) {
            title(Arrays.asList(title));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder title(Consumer<Highlight.Builder>... title) {
            title(Stream.of(title).map(c -> Highlight.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final SuggestAddressHighlights.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        public final void setAddress(SuggestAddressHighlights.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(SuggestAddressHighlights address) {
            this.address = address;
            return this;
        }

        @Override
        public SuggestHighlights build() {
            return new SuggestHighlights(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
