/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The suggested query results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuggestQueryResult implements SdkPojo, Serializable,
        ToCopyableBuilder<SuggestQueryResult.Builder, SuggestQueryResult> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryId").getter(getter(SuggestQueryResult::queryId)).setter(setter(Builder::queryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()).build();

    private static final SdkField<String> QUERY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryType").getter(getter(SuggestQueryResult::queryTypeAsString)).setter(setter(Builder::queryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD,
            QUERY_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("QueryId", QUERY_ID_FIELD);
                    put("QueryType", QUERY_TYPE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String queryId;

    private final String queryType;

    private SuggestQueryResult(BuilderImpl builder) {
        this.queryId = builder.queryId;
        this.queryType = builder.queryType;
    }

    /**
     * <p>
     * QueryId can be used to complete a follow up query through the SearchText API. The QueryId retains context from
     * the original Suggest request such as filters, political view and language. See the SearchText API documentation
     * for more details <a
     * href="https://docs.aws.amazon.com/latest/APIReference/API_geoplaces_SearchText.html">SearchText API docs</a>.
     * </p>
     * 
     * @return QueryId can be used to complete a follow up query through the SearchText API. The QueryId retains context
     *         from the original Suggest request such as filters, political view and language. See the SearchText API
     *         documentation for more details <a
     *         href="https://docs.aws.amazon.com/latest/APIReference/API_geoplaces_SearchText.html">SearchText API
     *         docs</a>.
     */
    public final String queryId() {
        return queryId;
    }

    /**
     * <p>
     * The query type. Category qeuries will search for places which have an entry matching the given category, for
     * example "doctor office". BusinessChain queries will search for instances of a given business.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryType} will
     * return {@link QueryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryTypeAsString}.
     * </p>
     * 
     * @return The query type. Category qeuries will search for places which have an entry matching the given category,
     *         for example "doctor office". BusinessChain queries will search for instances of a given business.
     * @see QueryType
     */
    public final QueryType queryType() {
        return QueryType.fromValue(queryType);
    }

    /**
     * <p>
     * The query type. Category qeuries will search for places which have an entry matching the given category, for
     * example "doctor office". BusinessChain queries will search for instances of a given business.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryType} will
     * return {@link QueryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryTypeAsString}.
     * </p>
     * 
     * @return The query type. Category qeuries will search for places which have an entry matching the given category,
     *         for example "doctor office". BusinessChain queries will search for instances of a given business.
     * @see QueryType
     */
    public final String queryTypeAsString() {
        return queryType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryId());
        hashCode = 31 * hashCode + Objects.hashCode(queryTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestQueryResult)) {
            return false;
        }
        SuggestQueryResult other = (SuggestQueryResult) obj;
        return Objects.equals(queryId(), other.queryId()) && Objects.equals(queryTypeAsString(), other.queryTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuggestQueryResult").add("QueryId", queryId()).add("QueryType", queryTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryId":
            return Optional.ofNullable(clazz.cast(queryId()));
        case "QueryType":
            return Optional.ofNullable(clazz.cast(queryTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SuggestQueryResult, T> g) {
        return obj -> g.apply((SuggestQueryResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuggestQueryResult> {
        /**
         * <p>
         * QueryId can be used to complete a follow up query through the SearchText API. The QueryId retains context
         * from the original Suggest request such as filters, political view and language. See the SearchText API
         * documentation for more details <a
         * href="https://docs.aws.amazon.com/latest/APIReference/API_geoplaces_SearchText.html">SearchText API docs</a>.
         * </p>
         * 
         * @param queryId
         *        QueryId can be used to complete a follow up query through the SearchText API. The QueryId retains
         *        context from the original Suggest request such as filters, political view and language. See the
         *        SearchText API documentation for more details <a
         *        href="https://docs.aws.amazon.com/latest/APIReference/API_geoplaces_SearchText.html">SearchText API
         *        docs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryId(String queryId);

        /**
         * <p>
         * The query type. Category qeuries will search for places which have an entry matching the given category, for
         * example "doctor office". BusinessChain queries will search for instances of a given business.
         * </p>
         * 
         * @param queryType
         *        The query type. Category qeuries will search for places which have an entry matching the given
         *        category, for example "doctor office". BusinessChain queries will search for instances of a given
         *        business.
         * @see QueryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryType
         */
        Builder queryType(String queryType);

        /**
         * <p>
         * The query type. Category qeuries will search for places which have an entry matching the given category, for
         * example "doctor office". BusinessChain queries will search for instances of a given business.
         * </p>
         * 
         * @param queryType
         *        The query type. Category qeuries will search for places which have an entry matching the given
         *        category, for example "doctor office". BusinessChain queries will search for instances of a given
         *        business.
         * @see QueryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryType
         */
        Builder queryType(QueryType queryType);
    }

    static final class BuilderImpl implements Builder {
        private String queryId;

        private String queryType;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestQueryResult model) {
            queryId(model.queryId);
            queryType(model.queryType);
        }

        public final String getQueryId() {
            return queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getQueryType() {
            return queryType;
        }

        public final void setQueryType(String queryType) {
            this.queryType = queryType;
        }

        @Override
        public final Builder queryType(String queryType) {
            this.queryType = queryType;
            return this;
        }

        @Override
        public final Builder queryType(QueryType queryType) {
            this.queryType(queryType == null ? null : queryType.toString());
            return this;
        }

        @Override
        public SuggestQueryResult build() {
            return new SuggestQueryResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
