/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resulting item from the suggested query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuggestResultItem implements SdkPojo, Serializable,
        ToCopyableBuilder<SuggestResultItem.Builder, SuggestResultItem> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(SuggestResultItem::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> SUGGEST_RESULT_ITEM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SuggestResultItemType").getter(getter(SuggestResultItem::suggestResultItemTypeAsString))
            .setter(setter(Builder::suggestResultItemType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestResultItemType").build())
            .build();

    private static final SdkField<SuggestPlaceResult> PLACE_FIELD = SdkField
            .<SuggestPlaceResult> builder(MarshallingType.SDK_POJO).memberName("Place").getter(getter(SuggestResultItem::place))
            .setter(setter(Builder::place)).constructor(SuggestPlaceResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Place").build()).build();

    private static final SdkField<SuggestQueryResult> QUERY_FIELD = SdkField
            .<SuggestQueryResult> builder(MarshallingType.SDK_POJO).memberName("Query").getter(getter(SuggestResultItem::query))
            .setter(setter(Builder::query)).constructor(SuggestQueryResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Query").build()).build();

    private static final SdkField<SuggestHighlights> HIGHLIGHTS_FIELD = SdkField
            .<SuggestHighlights> builder(MarshallingType.SDK_POJO).memberName("Highlights")
            .getter(getter(SuggestResultItem::highlights)).setter(setter(Builder::highlights))
            .constructor(SuggestHighlights::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Highlights").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD,
            SUGGEST_RESULT_ITEM_TYPE_FIELD, PLACE_FIELD, QUERY_FIELD, HIGHLIGHTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Title", TITLE_FIELD);
                    put("SuggestResultItemType", SUGGEST_RESULT_ITEM_TYPE_FIELD);
                    put("Place", PLACE_FIELD);
                    put("Query", QUERY_FIELD);
                    put("Highlights", HIGHLIGHTS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String title;

    private final String suggestResultItemType;

    private final SuggestPlaceResult place;

    private final SuggestQueryResult query;

    private final SuggestHighlights highlights;

    private SuggestResultItem(BuilderImpl builder) {
        this.title = builder.title;
        this.suggestResultItemType = builder.suggestResultItemType;
        this.place = builder.place;
        this.query = builder.query;
        this.highlights = builder.highlights;
    }

    /**
     * <p>
     * The display title that should be used when presenting this option to the end user.
     * </p>
     * 
     * @return The display title that should be used when presenting this option to the end user.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The result type. Place results represent the final result for a point of interest, Query results represent a
     * follow up query which can be completed through the SearchText operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #suggestResultItemType} will return {@link SuggestResultItemType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #suggestResultItemTypeAsString}.
     * </p>
     * 
     * @return The result type. Place results represent the final result for a point of interest, Query results
     *         represent a follow up query which can be completed through the SearchText operation.
     * @see SuggestResultItemType
     */
    public final SuggestResultItemType suggestResultItemType() {
        return SuggestResultItemType.fromValue(suggestResultItemType);
    }

    /**
     * <p>
     * The result type. Place results represent the final result for a point of interest, Query results represent a
     * follow up query which can be completed through the SearchText operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #suggestResultItemType} will return {@link SuggestResultItemType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #suggestResultItemTypeAsString}.
     * </p>
     * 
     * @return The result type. Place results represent the final result for a point of interest, Query results
     *         represent a follow up query which can be completed through the SearchText operation.
     * @see SuggestResultItemType
     */
    public final String suggestResultItemTypeAsString() {
        return suggestResultItemType;
    }

    /**
     * <p>
     * The suggested place by its unique ID.
     * </p>
     * 
     * @return The suggested place by its unique ID.
     */
    public final SuggestPlaceResult place() {
        return place;
    }

    /**
     * Returns the value of the Query property for this object.
     * 
     * @return The value of the Query property for this object.
     */
    public final SuggestQueryResult query() {
        return query;
    }

    /**
     * <p>
     * Describes how the parts of the response element matched the input query by returning the sections of the response
     * which matched to input query terms.
     * </p>
     * 
     * @return Describes how the parts of the response element matched the input query by returning the sections of the
     *         response which matched to input query terms.
     */
    public final SuggestHighlights highlights() {
        return highlights;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(suggestResultItemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(place());
        hashCode = 31 * hashCode + Objects.hashCode(query());
        hashCode = 31 * hashCode + Objects.hashCode(highlights());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestResultItem)) {
            return false;
        }
        SuggestResultItem other = (SuggestResultItem) obj;
        return Objects.equals(title(), other.title())
                && Objects.equals(suggestResultItemTypeAsString(), other.suggestResultItemTypeAsString())
                && Objects.equals(place(), other.place()) && Objects.equals(query(), other.query())
                && Objects.equals(highlights(), other.highlights());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuggestResultItem").add("Title", title())
                .add("SuggestResultItemType", suggestResultItemTypeAsString()).add("Place", place()).add("Query", query())
                .add("Highlights", highlights()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "SuggestResultItemType":
            return Optional.ofNullable(clazz.cast(suggestResultItemTypeAsString()));
        case "Place":
            return Optional.ofNullable(clazz.cast(place()));
        case "Query":
            return Optional.ofNullable(clazz.cast(query()));
        case "Highlights":
            return Optional.ofNullable(clazz.cast(highlights()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SuggestResultItem, T> g) {
        return obj -> g.apply((SuggestResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuggestResultItem> {
        /**
         * <p>
         * The display title that should be used when presenting this option to the end user.
         * </p>
         * 
         * @param title
         *        The display title that should be used when presenting this option to the end user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The result type. Place results represent the final result for a point of interest, Query results represent a
         * follow up query which can be completed through the SearchText operation.
         * </p>
         * 
         * @param suggestResultItemType
         *        The result type. Place results represent the final result for a point of interest, Query results
         *        represent a follow up query which can be completed through the SearchText operation.
         * @see SuggestResultItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuggestResultItemType
         */
        Builder suggestResultItemType(String suggestResultItemType);

        /**
         * <p>
         * The result type. Place results represent the final result for a point of interest, Query results represent a
         * follow up query which can be completed through the SearchText operation.
         * </p>
         * 
         * @param suggestResultItemType
         *        The result type. Place results represent the final result for a point of interest, Query results
         *        represent a follow up query which can be completed through the SearchText operation.
         * @see SuggestResultItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuggestResultItemType
         */
        Builder suggestResultItemType(SuggestResultItemType suggestResultItemType);

        /**
         * <p>
         * The suggested place by its unique ID.
         * </p>
         * 
         * @param place
         *        The suggested place by its unique ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder place(SuggestPlaceResult place);

        /**
         * <p>
         * The suggested place by its unique ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link SuggestPlaceResult.Builder} avoiding the
         * need to create one manually via {@link SuggestPlaceResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SuggestPlaceResult.Builder#build()} is called immediately and its
         * result is passed to {@link #place(SuggestPlaceResult)}.
         * 
         * @param place
         *        a consumer that will call methods on {@link SuggestPlaceResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #place(SuggestPlaceResult)
         */
        default Builder place(Consumer<SuggestPlaceResult.Builder> place) {
            return place(SuggestPlaceResult.builder().applyMutation(place).build());
        }

        /**
         * Sets the value of the Query property for this object.
         *
         * @param query
         *        The new value for the Query property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder query(SuggestQueryResult query);

        /**
         * Sets the value of the Query property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SuggestQueryResult.Builder} avoiding the
         * need to create one manually via {@link SuggestQueryResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SuggestQueryResult.Builder#build()} is called immediately and its
         * result is passed to {@link #query(SuggestQueryResult)}.
         * 
         * @param query
         *        a consumer that will call methods on {@link SuggestQueryResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #query(SuggestQueryResult)
         */
        default Builder query(Consumer<SuggestQueryResult.Builder> query) {
            return query(SuggestQueryResult.builder().applyMutation(query).build());
        }

        /**
         * <p>
         * Describes how the parts of the response element matched the input query by returning the sections of the
         * response which matched to input query terms.
         * </p>
         * 
         * @param highlights
         *        Describes how the parts of the response element matched the input query by returning the sections of
         *        the response which matched to input query terms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder highlights(SuggestHighlights highlights);

        /**
         * <p>
         * Describes how the parts of the response element matched the input query by returning the sections of the
         * response which matched to input query terms.
         * </p>
         * This is a convenience method that creates an instance of the {@link SuggestHighlights.Builder} avoiding the
         * need to create one manually via {@link SuggestHighlights#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SuggestHighlights.Builder#build()} is called immediately and its
         * result is passed to {@link #highlights(SuggestHighlights)}.
         * 
         * @param highlights
         *        a consumer that will call methods on {@link SuggestHighlights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #highlights(SuggestHighlights)
         */
        default Builder highlights(Consumer<SuggestHighlights.Builder> highlights) {
            return highlights(SuggestHighlights.builder().applyMutation(highlights).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private String suggestResultItemType;

        private SuggestPlaceResult place;

        private SuggestQueryResult query;

        private SuggestHighlights highlights;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestResultItem model) {
            title(model.title);
            suggestResultItemType(model.suggestResultItemType);
            place(model.place);
            query(model.query);
            highlights(model.highlights);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSuggestResultItemType() {
            return suggestResultItemType;
        }

        public final void setSuggestResultItemType(String suggestResultItemType) {
            this.suggestResultItemType = suggestResultItemType;
        }

        @Override
        public final Builder suggestResultItemType(String suggestResultItemType) {
            this.suggestResultItemType = suggestResultItemType;
            return this;
        }

        @Override
        public final Builder suggestResultItemType(SuggestResultItemType suggestResultItemType) {
            this.suggestResultItemType(suggestResultItemType == null ? null : suggestResultItemType.toString());
            return this;
        }

        public final SuggestPlaceResult.Builder getPlace() {
            return place != null ? place.toBuilder() : null;
        }

        public final void setPlace(SuggestPlaceResult.BuilderImpl place) {
            this.place = place != null ? place.build() : null;
        }

        @Override
        public final Builder place(SuggestPlaceResult place) {
            this.place = place;
            return this;
        }

        public final SuggestQueryResult.Builder getQuery() {
            return query != null ? query.toBuilder() : null;
        }

        public final void setQuery(SuggestQueryResult.BuilderImpl query) {
            this.query = query != null ? query.build() : null;
        }

        @Override
        public final Builder query(SuggestQueryResult query) {
            this.query = query;
            return this;
        }

        public final SuggestHighlights.Builder getHighlights() {
            return highlights != null ? highlights.toBuilder() : null;
        }

        public final void setHighlights(SuggestHighlights.BuilderImpl highlights) {
            this.highlights = highlights != null ? highlights.build() : null;
        }

        @Override
        public final Builder highlights(SuggestHighlights highlights) {
            this.highlights = highlights;
            return this;
        }

        @Override
        public SuggestResultItem build() {
            return new SuggestResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
