/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The USPS zip+4 code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UspsZipPlus4 implements SdkPojo, Serializable, ToCopyableBuilder<UspsZipPlus4.Builder, UspsZipPlus4> {
    private static final SdkField<String> RECORD_TYPE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordTypeCode").getter(getter(UspsZipPlus4::recordTypeCodeAsString))
            .setter(setter(Builder::recordTypeCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordTypeCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_TYPE_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("RecordTypeCode", RECORD_TYPE_CODE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String recordTypeCode;

    private UspsZipPlus4(BuilderImpl builder) {
        this.recordTypeCode = builder.recordTypeCode;
    }

    /**
     * <p>
     * The USPS ZIP+4 Record Type Code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordTypeCode}
     * will return {@link RecordTypeCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recordTypeCodeAsString}.
     * </p>
     * 
     * @return The USPS ZIP+4 Record Type Code.
     * @see RecordTypeCode
     */
    public final RecordTypeCode recordTypeCode() {
        return RecordTypeCode.fromValue(recordTypeCode);
    }

    /**
     * <p>
     * The USPS ZIP+4 Record Type Code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordTypeCode}
     * will return {@link RecordTypeCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recordTypeCodeAsString}.
     * </p>
     * 
     * @return The USPS ZIP+4 Record Type Code.
     * @see RecordTypeCode
     */
    public final String recordTypeCodeAsString() {
        return recordTypeCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordTypeCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UspsZipPlus4)) {
            return false;
        }
        UspsZipPlus4 other = (UspsZipPlus4) obj;
        return Objects.equals(recordTypeCodeAsString(), other.recordTypeCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UspsZipPlus4").add("RecordTypeCode", recordTypeCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordTypeCode":
            return Optional.ofNullable(clazz.cast(recordTypeCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UspsZipPlus4, T> g) {
        return obj -> g.apply((UspsZipPlus4) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UspsZipPlus4> {
        /**
         * <p>
         * The USPS ZIP+4 Record Type Code.
         * </p>
         * 
         * @param recordTypeCode
         *        The USPS ZIP+4 Record Type Code.
         * @see RecordTypeCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordTypeCode
         */
        Builder recordTypeCode(String recordTypeCode);

        /**
         * <p>
         * The USPS ZIP+4 Record Type Code.
         * </p>
         * 
         * @param recordTypeCode
         *        The USPS ZIP+4 Record Type Code.
         * @see RecordTypeCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordTypeCode
         */
        Builder recordTypeCode(RecordTypeCode recordTypeCode);
    }

    static final class BuilderImpl implements Builder {
        private String recordTypeCode;

        private BuilderImpl() {
        }

        private BuilderImpl(UspsZipPlus4 model) {
            recordTypeCode(model.recordTypeCode);
        }

        public final String getRecordTypeCode() {
            return recordTypeCode;
        }

        public final void setRecordTypeCode(String recordTypeCode) {
            this.recordTypeCode = recordTypeCode;
        }

        @Override
        public final Builder recordTypeCode(String recordTypeCode) {
            this.recordTypeCode = recordTypeCode;
            return this;
        }

        @Override
        public final Builder recordTypeCode(RecordTypeCode recordTypeCode) {
            this.recordTypeCode(recordTypeCode == null ? null : recordTypeCode.toString());
            return this;
        }

        @Override
        public UspsZipPlus4 build() {
            return new UspsZipPlus4(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
