/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.Category;
import software.amazon.awssdk.services.geoplaces.model.CategoryListCopier;
import software.amazon.awssdk.services.geoplaces.model.OpeningHoursComponents;
import software.amazon.awssdk.services.geoplaces.model.OpeningHoursComponentsListCopier;
import software.amazon.awssdk.services.geoplaces.model.OpeningHoursDisplayListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpeningHours
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpeningHours> {
    private static final SdkField<List<String>> DISPLAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Display").getter(OpeningHours.getter(OpeningHours::display)).setter(OpeningHours.setter(Builder::display)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Display").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> OPEN_NOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OpenNow").getter(OpeningHours.getter(OpeningHours::openNow)).setter(OpeningHours.setter(Builder::openNow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenNow").build()}).build();
    private static final SdkField<List<OpeningHoursComponents>> COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Components").getter(OpeningHours.getter(OpeningHours::components)).setter(OpeningHours.setter(Builder::components)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Components").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpeningHoursComponents::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Category>> CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Categories").getter(OpeningHours.getter(OpeningHours::categories)).setter(OpeningHours.setter(Builder::categories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Category::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_FIELD, OPEN_NOW_FIELD, COMPONENTS_FIELD, CATEGORIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Display", DISPLAY_FIELD);
            this.put("OpenNow", OPEN_NOW_FIELD);
            this.put("Components", COMPONENTS_FIELD);
            this.put("Categories", CATEGORIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> display;
    private final Boolean openNow;
    private final List<OpeningHoursComponents> components;
    private final List<Category> categories;

    private OpeningHours(BuilderImpl builder) {
        this.display = builder.display;
        this.openNow = builder.openNow;
        this.components = builder.components;
        this.categories = builder.categories;
    }

    public final boolean hasDisplay() {
        return this.display != null && !(this.display instanceof SdkAutoConstructList);
    }

    public final List<String> display() {
        return this.display;
    }

    public final Boolean openNow() {
        return this.openNow;
    }

    public final boolean hasComponents() {
        return this.components != null && !(this.components instanceof SdkAutoConstructList);
    }

    public final List<OpeningHoursComponents> components() {
        return this.components;
    }

    public final boolean hasCategories() {
        return this.categories != null && !(this.categories instanceof SdkAutoConstructList);
    }

    public final List<Category> categories() {
        return this.categories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDisplay() ? this.display() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.openNow());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponents() ? this.components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategories() ? this.categories() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpeningHours)) {
            return false;
        }
        OpeningHours other = (OpeningHours)obj;
        return this.hasDisplay() == other.hasDisplay() && Objects.equals(this.display(), other.display()) && Objects.equals(this.openNow(), other.openNow()) && this.hasComponents() == other.hasComponents() && Objects.equals(this.components(), other.components()) && this.hasCategories() == other.hasCategories() && Objects.equals(this.categories(), other.categories());
    }

    public final String toString() {
        return ToString.builder((String)"OpeningHours").add("Display", this.hasDisplay() ? this.display() : null).add("OpenNow", (Object)this.openNow()).add("Components", this.hasComponents() ? this.components() : null).add("Categories", this.hasCategories() ? this.categories() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Display": {
                return Optional.ofNullable(clazz.cast(this.display()));
            }
            case "OpenNow": {
                return Optional.ofNullable(clazz.cast(this.openNow()));
            }
            case "Components": {
                return Optional.ofNullable(clazz.cast(this.components()));
            }
            case "Categories": {
                return Optional.ofNullable(clazz.cast(this.categories()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OpeningHours, T> g) {
        return obj -> g.apply((OpeningHours)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> display = DefaultSdkAutoConstructList.getInstance();
        private Boolean openNow;
        private List<OpeningHoursComponents> components = DefaultSdkAutoConstructList.getInstance();
        private List<Category> categories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpeningHours model) {
            this.display(model.display);
            this.openNow(model.openNow);
            this.components(model.components);
            this.categories(model.categories);
        }

        public final Collection<String> getDisplay() {
            if (this.display instanceof SdkAutoConstructList) {
                return null;
            }
            return this.display;
        }

        public final void setDisplay(Collection<String> display) {
            this.display = OpeningHoursDisplayListCopier.copy(display);
        }

        @Override
        public final Builder display(Collection<String> display) {
            this.display = OpeningHoursDisplayListCopier.copy(display);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder display(String ... display) {
            this.display(Arrays.asList(display));
            return this;
        }

        public final Boolean getOpenNow() {
            return this.openNow;
        }

        public final void setOpenNow(Boolean openNow) {
            this.openNow = openNow;
        }

        @Override
        public final Builder openNow(Boolean openNow) {
            this.openNow = openNow;
            return this;
        }

        public final List<OpeningHoursComponents.Builder> getComponents() {
            List<OpeningHoursComponents.Builder> result = OpeningHoursComponentsListCopier.copyToBuilder(this.components);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponents(Collection<OpeningHoursComponents.BuilderImpl> components) {
            this.components = OpeningHoursComponentsListCopier.copyFromBuilder(components);
        }

        @Override
        public final Builder components(Collection<OpeningHoursComponents> components) {
            this.components = OpeningHoursComponentsListCopier.copy(components);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(OpeningHoursComponents ... components) {
            this.components(Arrays.asList(components));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(Consumer<OpeningHoursComponents.Builder> ... components) {
            this.components(Stream.of(components).map(c -> (OpeningHoursComponents)((OpeningHoursComponents.Builder)OpeningHoursComponents.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Category.Builder> getCategories() {
            List<Category.Builder> result = CategoryListCopier.copyToBuilder(this.categories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategories(Collection<Category.BuilderImpl> categories) {
            this.categories = CategoryListCopier.copyFromBuilder(categories);
        }

        @Override
        public final Builder categories(Collection<Category> categories) {
            this.categories = CategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Category ... categories) {
            this.categories(Arrays.asList(categories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Consumer<Category.Builder> ... categories) {
            this.categories(Stream.of(categories).map(c -> (Category)((Category.Builder)Category.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public OpeningHours build() {
            return new OpeningHours(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpeningHours> {
        public Builder display(Collection<String> var1);

        public Builder display(String ... var1);

        public Builder openNow(Boolean var1);

        public Builder components(Collection<OpeningHoursComponents> var1);

        public Builder components(OpeningHoursComponents ... var1);

        public Builder components(Consumer<OpeningHoursComponents.Builder> ... var1);

        public Builder categories(Collection<Category> var1);

        public Builder categories(Category ... var1);

        public Builder categories(Consumer<Category.Builder> ... var1);
    }
}

