/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.GeoPlacesRequest;
import software.amazon.awssdk.services.geoplaces.model.PositionCopier;
import software.amazon.awssdk.services.geoplaces.model.SearchTextAdditionalFeature;
import software.amazon.awssdk.services.geoplaces.model.SearchTextAdditionalFeatureListCopier;
import software.amazon.awssdk.services.geoplaces.model.SearchTextFilter;
import software.amazon.awssdk.services.geoplaces.model.SearchTextIntendedUse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchTextRequest
extends GeoPlacesRequest
implements ToCopyableBuilder<Builder, SearchTextRequest> {
    private static final SdkField<String> QUERY_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryText").getter(SearchTextRequest.getter(SearchTextRequest::queryText)).setter(SearchTextRequest.setter(Builder::queryText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryText").build()}).build();
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryId").getter(SearchTextRequest.getter(SearchTextRequest::queryId)).setter(SearchTextRequest.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(SearchTextRequest.getter(SearchTextRequest::maxResults)).setter(SearchTextRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<List<Double>> BIAS_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BiasPosition").getter(SearchTextRequest.getter(SearchTextRequest::biasPosition)).setter(SearchTextRequest.setter(Builder::biasPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BiasPosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SearchTextFilter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(SearchTextRequest.getter(SearchTextRequest::filter)).setter(SearchTextRequest.setter(Builder::filter)).constructor(SearchTextFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalFeatures").getter(SearchTextRequest.getter(SearchTextRequest::additionalFeaturesAsStrings)).setter(SearchTextRequest.setter(Builder::additionalFeaturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalFeatures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Language").getter(SearchTextRequest.getter(SearchTextRequest::language)).setter(SearchTextRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()}).build();
    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoliticalView").getter(SearchTextRequest.getter(SearchTextRequest::politicalView)).setter(SearchTextRequest.setter(Builder::politicalView)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoliticalView").build()}).build();
    private static final SdkField<String> INTENDED_USE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntendedUse").getter(SearchTextRequest.getter(SearchTextRequest::intendedUseAsString)).setter(SearchTextRequest.setter(Builder::intendedUse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntendedUse").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchTextRequest.getter(SearchTextRequest::nextToken)).setter(SearchTextRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(SearchTextRequest.getter(SearchTextRequest::key)).setter(SearchTextRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_TEXT_FIELD, QUERY_ID_FIELD, MAX_RESULTS_FIELD, BIAS_POSITION_FIELD, FILTER_FIELD, ADDITIONAL_FEATURES_FIELD, LANGUAGE_FIELD, POLITICAL_VIEW_FIELD, INTENDED_USE_FIELD, NEXT_TOKEN_FIELD, KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("QueryText", QUERY_TEXT_FIELD);
            this.put("QueryId", QUERY_ID_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("BiasPosition", BIAS_POSITION_FIELD);
            this.put("Filter", FILTER_FIELD);
            this.put("AdditionalFeatures", ADDITIONAL_FEATURES_FIELD);
            this.put("Language", LANGUAGE_FIELD);
            this.put("PoliticalView", POLITICAL_VIEW_FIELD);
            this.put("IntendedUse", INTENDED_USE_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("key", KEY_FIELD);
        }
    });
    private final String queryText;
    private final String queryId;
    private final Integer maxResults;
    private final List<Double> biasPosition;
    private final SearchTextFilter filter;
    private final List<String> additionalFeatures;
    private final String language;
    private final String politicalView;
    private final String intendedUse;
    private final String nextToken;
    private final String key;

    private SearchTextRequest(BuilderImpl builder) {
        super(builder);
        this.queryText = builder.queryText;
        this.queryId = builder.queryId;
        this.maxResults = builder.maxResults;
        this.biasPosition = builder.biasPosition;
        this.filter = builder.filter;
        this.additionalFeatures = builder.additionalFeatures;
        this.language = builder.language;
        this.politicalView = builder.politicalView;
        this.intendedUse = builder.intendedUse;
        this.nextToken = builder.nextToken;
        this.key = builder.key;
    }

    public final String queryText() {
        return this.queryText;
    }

    public final String queryId() {
        return this.queryId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasBiasPosition() {
        return this.biasPosition != null && !(this.biasPosition instanceof SdkAutoConstructList);
    }

    public final List<Double> biasPosition() {
        return this.biasPosition;
    }

    public final SearchTextFilter filter() {
        return this.filter;
    }

    public final List<SearchTextAdditionalFeature> additionalFeatures() {
        return SearchTextAdditionalFeatureListCopier.copyStringToEnum(this.additionalFeatures);
    }

    public final boolean hasAdditionalFeatures() {
        return this.additionalFeatures != null && !(this.additionalFeatures instanceof SdkAutoConstructList);
    }

    public final List<String> additionalFeaturesAsStrings() {
        return this.additionalFeatures;
    }

    public final String language() {
        return this.language;
    }

    public final String politicalView() {
        return this.politicalView;
    }

    public final SearchTextIntendedUse intendedUse() {
        return SearchTextIntendedUse.fromValue(this.intendedUse);
    }

    public final String intendedUseAsString() {
        return this.intendedUse;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String key() {
        return this.key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryText());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBiasPosition() ? this.biasPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalFeatures() ? this.additionalFeaturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(this.intendedUseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTextRequest)) {
            return false;
        }
        SearchTextRequest other = (SearchTextRequest)((Object)obj);
        return Objects.equals(this.queryText(), other.queryText()) && Objects.equals(this.queryId(), other.queryId()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasBiasPosition() == other.hasBiasPosition() && Objects.equals(this.biasPosition(), other.biasPosition()) && Objects.equals(this.filter(), other.filter()) && this.hasAdditionalFeatures() == other.hasAdditionalFeatures() && Objects.equals(this.additionalFeaturesAsStrings(), other.additionalFeaturesAsStrings()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.politicalView(), other.politicalView()) && Objects.equals(this.intendedUseAsString(), other.intendedUseAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.key(), other.key());
    }

    public final String toString() {
        return ToString.builder((String)"SearchTextRequest").add("QueryText", (Object)(this.queryText() == null ? null : "*** Sensitive Data Redacted ***")).add("QueryId", (Object)(this.queryId() == null ? null : "*** Sensitive Data Redacted ***")).add("MaxResults", (Object)this.maxResults()).add("BiasPosition", (Object)(this.biasPosition() == null ? null : "*** Sensitive Data Redacted ***")).add("Filter", (Object)this.filter()).add("AdditionalFeatures", this.hasAdditionalFeatures() ? this.additionalFeaturesAsStrings() : null).add("Language", (Object)this.language()).add("PoliticalView", (Object)this.politicalView()).add("IntendedUse", (Object)this.intendedUseAsString()).add("NextToken", (Object)this.nextToken()).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryText": {
                return Optional.ofNullable(clazz.cast(this.queryText()));
            }
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "BiasPosition": {
                return Optional.ofNullable(clazz.cast(this.biasPosition()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "AdditionalFeatures": {
                return Optional.ofNullable(clazz.cast(this.additionalFeaturesAsStrings()));
            }
            case "Language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "PoliticalView": {
                return Optional.ofNullable(clazz.cast(this.politicalView()));
            }
            case "IntendedUse": {
                return Optional.ofNullable(clazz.cast(this.intendedUseAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchTextRequest, T> g) {
        return obj -> g.apply((SearchTextRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoPlacesRequest.BuilderImpl
    implements Builder {
        private String queryText;
        private String queryId;
        private Integer maxResults;
        private List<Double> biasPosition = DefaultSdkAutoConstructList.getInstance();
        private SearchTextFilter filter;
        private List<String> additionalFeatures = DefaultSdkAutoConstructList.getInstance();
        private String language;
        private String politicalView;
        private String intendedUse;
        private String nextToken;
        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTextRequest model) {
            super(model);
            this.queryText(model.queryText);
            this.queryId(model.queryId);
            this.maxResults(model.maxResults);
            this.biasPosition(model.biasPosition);
            this.filter(model.filter);
            this.additionalFeaturesWithStrings(model.additionalFeatures);
            this.language(model.language);
            this.politicalView(model.politicalView);
            this.intendedUse(model.intendedUse);
            this.nextToken(model.nextToken);
            this.key(model.key);
        }

        public final String getQueryText() {
            return this.queryText;
        }

        public final void setQueryText(String queryText) {
            this.queryText = queryText;
        }

        @Override
        public final Builder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<Double> getBiasPosition() {
            if (this.biasPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.biasPosition;
        }

        public final void setBiasPosition(Collection<Double> biasPosition) {
            this.biasPosition = PositionCopier.copy(biasPosition);
        }

        @Override
        public final Builder biasPosition(Collection<Double> biasPosition) {
            this.biasPosition = PositionCopier.copy(biasPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder biasPosition(Double ... biasPosition) {
            this.biasPosition(Arrays.asList(biasPosition));
            return this;
        }

        public final SearchTextFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(SearchTextFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(SearchTextFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Collection<String> getAdditionalFeatures() {
            if (this.additionalFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalFeatures;
        }

        public final void setAdditionalFeatures(Collection<String> additionalFeatures) {
            this.additionalFeatures = SearchTextAdditionalFeatureListCopier.copy(additionalFeatures);
        }

        @Override
        public final Builder additionalFeaturesWithStrings(Collection<String> additionalFeatures) {
            this.additionalFeatures = SearchTextAdditionalFeatureListCopier.copy(additionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalFeaturesWithStrings(String ... additionalFeatures) {
            this.additionalFeaturesWithStrings(Arrays.asList(additionalFeatures));
            return this;
        }

        @Override
        public final Builder additionalFeatures(Collection<SearchTextAdditionalFeature> additionalFeatures) {
            this.additionalFeatures = SearchTextAdditionalFeatureListCopier.copyEnumToString(additionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalFeatures(SearchTextAdditionalFeature ... additionalFeatures) {
            this.additionalFeatures(Arrays.asList(additionalFeatures));
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getPoliticalView() {
            return this.politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final String getIntendedUse() {
            return this.intendedUse;
        }

        public final void setIntendedUse(String intendedUse) {
            this.intendedUse = intendedUse;
        }

        @Override
        public final Builder intendedUse(String intendedUse) {
            this.intendedUse = intendedUse;
            return this;
        }

        @Override
        public final Builder intendedUse(SearchTextIntendedUse intendedUse) {
            this.intendedUse(intendedUse == null ? null : intendedUse.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchTextRequest build() {
            return new SearchTextRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GeoPlacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchTextRequest> {
        public Builder queryText(String var1);

        public Builder queryId(String var1);

        public Builder maxResults(Integer var1);

        public Builder biasPosition(Collection<Double> var1);

        public Builder biasPosition(Double ... var1);

        public Builder filter(SearchTextFilter var1);

        default public Builder filter(Consumer<SearchTextFilter.Builder> filter) {
            return this.filter((SearchTextFilter)((SearchTextFilter.Builder)SearchTextFilter.builder().applyMutation(filter)).build());
        }

        public Builder additionalFeaturesWithStrings(Collection<String> var1);

        public Builder additionalFeaturesWithStrings(String ... var1);

        public Builder additionalFeatures(Collection<SearchTextAdditionalFeature> var1);

        public Builder additionalFeatures(SearchTextAdditionalFeature ... var1);

        public Builder language(String var1);

        public Builder politicalView(String var1);

        public Builder intendedUse(String var1);

        public Builder intendedUse(SearchTextIntendedUse var1);

        public Builder nextToken(String var1);

        public Builder key(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

