/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates if the access location is restricted. Index correlates to that of an access point and indicates if access
 * through this point has some form of restriction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessRestriction implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessRestriction.Builder, AccessRestriction> {
    private static final SdkField<Boolean> RESTRICTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Restricted").getter(getter(AccessRestriction::restricted)).setter(setter(Builder::restricted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Restricted").build()).build();

    private static final SdkField<List<Category>> CATEGORIES_FIELD = SdkField
            .<List<Category>> builder(MarshallingType.LIST)
            .memberName("Categories")
            .getter(getter(AccessRestriction::categories))
            .setter(setter(Builder::categories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Category> builder(MarshallingType.SDK_POJO)
                                            .constructor(Category::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTRICTED_FIELD,
            CATEGORIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean restricted;

    private final List<Category> categories;

    private AccessRestriction(BuilderImpl builder) {
        this.restricted = builder.restricted;
        this.categories = builder.categories;
    }

    /**
     * <p>
     * The restriction.
     * </p>
     * 
     * @return The restriction.
     */
    public final Boolean restricted() {
        return restricted;
    }

    /**
     * For responses, this returns true if the service returned a value for the Categories property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCategories() {
        return categories != null && !(categories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Categories of results that results must belong too.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategories} method.
     * </p>
     * 
     * @return Categories of results that results must belong too.
     */
    public final List<Category> categories() {
        return categories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restricted());
        hashCode = 31 * hashCode + Objects.hashCode(hasCategories() ? categories() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessRestriction)) {
            return false;
        }
        AccessRestriction other = (AccessRestriction) obj;
        return Objects.equals(restricted(), other.restricted()) && hasCategories() == other.hasCategories()
                && Objects.equals(categories(), other.categories());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessRestriction").add("Restricted", restricted())
                .add("Categories", hasCategories() ? categories() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Restricted":
            return Optional.ofNullable(clazz.cast(restricted()));
        case "Categories":
            return Optional.ofNullable(clazz.cast(categories()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Restricted", RESTRICTED_FIELD);
        map.put("Categories", CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessRestriction, T> g) {
        return obj -> g.apply((AccessRestriction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessRestriction> {
        /**
         * <p>
         * The restriction.
         * </p>
         * 
         * @param restricted
         *        The restriction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restricted(Boolean restricted);

        /**
         * <p>
         * Categories of results that results must belong too.
         * </p>
         * 
         * @param categories
         *        Categories of results that results must belong too.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Collection<Category> categories);

        /**
         * <p>
         * Categories of results that results must belong too.
         * </p>
         * 
         * @param categories
         *        Categories of results that results must belong too.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Category... categories);

        /**
         * <p>
         * Categories of results that results must belong too.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.Category.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.Category#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.Category.Builder#build()} is called immediately and
         * its result is passed to {@link #categories(List<Category>)}.
         * 
         * @param categories
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.Category.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categories(java.util.Collection<Category>)
         */
        Builder categories(Consumer<Category.Builder>... categories);
    }

    static final class BuilderImpl implements Builder {
        private Boolean restricted;

        private List<Category> categories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccessRestriction model) {
            restricted(model.restricted);
            categories(model.categories);
        }

        public final Boolean getRestricted() {
            return restricted;
        }

        public final void setRestricted(Boolean restricted) {
            this.restricted = restricted;
        }

        @Override
        public final Builder restricted(Boolean restricted) {
            this.restricted = restricted;
            return this;
        }

        public final List<Category.Builder> getCategories() {
            List<Category.Builder> result = CategoryListCopier.copyToBuilder(this.categories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategories(Collection<Category.BuilderImpl> categories) {
            this.categories = CategoryListCopier.copyFromBuilder(categories);
        }

        @Override
        public final Builder categories(Collection<Category> categories) {
            this.categories = CategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Category... categories) {
            categories(Arrays.asList(categories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Consumer<Category.Builder>... categories) {
            categories(Stream.of(categories).map(c -> Category.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AccessRestriction build() {
            return new AccessRestriction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
