/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * How to pronounce the various components of the address or place.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddressComponentPhonemes implements SdkPojo, Serializable,
        ToCopyableBuilder<AddressComponentPhonemes.Builder, AddressComponentPhonemes> {
    private static final SdkField<List<PhonemeTranscription>> COUNTRY_FIELD = SdkField
            .<List<PhonemeTranscription>> builder(MarshallingType.LIST)
            .memberName("Country")
            .getter(getter(AddressComponentPhonemes::country))
            .setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhonemeTranscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhonemeTranscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PhonemeTranscription>> REGION_FIELD = SdkField
            .<List<PhonemeTranscription>> builder(MarshallingType.LIST)
            .memberName("Region")
            .getter(getter(AddressComponentPhonemes::region))
            .setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhonemeTranscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhonemeTranscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PhonemeTranscription>> SUB_REGION_FIELD = SdkField
            .<List<PhonemeTranscription>> builder(MarshallingType.LIST)
            .memberName("SubRegion")
            .getter(getter(AddressComponentPhonemes::subRegion))
            .setter(setter(Builder::subRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubRegion").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhonemeTranscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhonemeTranscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PhonemeTranscription>> LOCALITY_FIELD = SdkField
            .<List<PhonemeTranscription>> builder(MarshallingType.LIST)
            .memberName("Locality")
            .getter(getter(AddressComponentPhonemes::locality))
            .setter(setter(Builder::locality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locality").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhonemeTranscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhonemeTranscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PhonemeTranscription>> DISTRICT_FIELD = SdkField
            .<List<PhonemeTranscription>> builder(MarshallingType.LIST)
            .memberName("District")
            .getter(getter(AddressComponentPhonemes::district))
            .setter(setter(Builder::district))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("District").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhonemeTranscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhonemeTranscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PhonemeTranscription>> SUB_DISTRICT_FIELD = SdkField
            .<List<PhonemeTranscription>> builder(MarshallingType.LIST)
            .memberName("SubDistrict")
            .getter(getter(AddressComponentPhonemes::subDistrict))
            .setter(setter(Builder::subDistrict))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubDistrict").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhonemeTranscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhonemeTranscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PhonemeTranscription>> BLOCK_FIELD = SdkField
            .<List<PhonemeTranscription>> builder(MarshallingType.LIST)
            .memberName("Block")
            .getter(getter(AddressComponentPhonemes::block))
            .setter(setter(Builder::block))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Block").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhonemeTranscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhonemeTranscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PhonemeTranscription>> SUB_BLOCK_FIELD = SdkField
            .<List<PhonemeTranscription>> builder(MarshallingType.LIST)
            .memberName("SubBlock")
            .getter(getter(AddressComponentPhonemes::subBlock))
            .setter(setter(Builder::subBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubBlock").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhonemeTranscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhonemeTranscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PhonemeTranscription>> STREET_FIELD = SdkField
            .<List<PhonemeTranscription>> builder(MarshallingType.LIST)
            .memberName("Street")
            .getter(getter(AddressComponentPhonemes::street))
            .setter(setter(Builder::street))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Street").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhonemeTranscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhonemeTranscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_FIELD, REGION_FIELD,
            SUB_REGION_FIELD, LOCALITY_FIELD, DISTRICT_FIELD, SUB_DISTRICT_FIELD, BLOCK_FIELD, SUB_BLOCK_FIELD, STREET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<PhonemeTranscription> country;

    private final List<PhonemeTranscription> region;

    private final List<PhonemeTranscription> subRegion;

    private final List<PhonemeTranscription> locality;

    private final List<PhonemeTranscription> district;

    private final List<PhonemeTranscription> subDistrict;

    private final List<PhonemeTranscription> block;

    private final List<PhonemeTranscription> subBlock;

    private final List<PhonemeTranscription> street;

    private AddressComponentPhonemes(BuilderImpl builder) {
        this.country = builder.country;
        this.region = builder.region;
        this.subRegion = builder.subRegion;
        this.locality = builder.locality;
        this.district = builder.district;
        this.subDistrict = builder.subDistrict;
        this.block = builder.block;
        this.subBlock = builder.subBlock;
        this.street = builder.street;
    }

    /**
     * For responses, this returns true if the service returned a value for the Country property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCountry() {
        return country != null && !(country instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The alpha-2 or alpha-3 character code for the country that the results will be present in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCountry} method.
     * </p>
     * 
     * @return The alpha-2 or alpha-3 character code for the country that the results will be present in.
     */
    public final List<PhonemeTranscription> country() {
        return country;
    }

    /**
     * For responses, this returns true if the service returned a value for the Region property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegion() {
        return region != null && !(region instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * How to pronounce the region or state results should be to be present in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegion} method.
     * </p>
     * 
     * @return How to pronounce the region or state results should be to be present in.
     */
    public final List<PhonemeTranscription> region() {
        return region;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubRegion property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubRegion() {
        return subRegion != null && !(subRegion instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * How to pronounce the sub-region or county for which results should be present in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubRegion} method.
     * </p>
     * 
     * @return How to pronounce the sub-region or county for which results should be present in.
     */
    public final List<PhonemeTranscription> subRegion() {
        return subRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Locality property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLocality() {
        return locality != null && !(locality instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * How to pronounce the city or locality results should be present in.
     * </p>
     * <p>
     * Example: <code>Vancouver</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocality} method.
     * </p>
     * 
     * @return How to pronounce the city or locality results should be present in. </p>
     *         <p>
     *         Example: <code>Vancouver</code>.
     */
    public final List<PhonemeTranscription> locality() {
        return locality;
    }

    /**
     * For responses, this returns true if the service returned a value for the District property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDistrict() {
        return district != null && !(district instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * How to pronounce the district or division of a city results should be present in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDistrict} method.
     * </p>
     * 
     * @return How to pronounce the district or division of a city results should be present in.
     */
    public final List<PhonemeTranscription> district() {
        return district;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubDistrict property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubDistrict() {
        return subDistrict != null && !(subDistrict instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * How to pronounce the sub-district or division of a city results should be present in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubDistrict} method.
     * </p>
     * 
     * @return How to pronounce the sub-district or division of a city results should be present in.
     */
    public final List<PhonemeTranscription> subDistrict() {
        return subDistrict;
    }

    /**
     * For responses, this returns true if the service returned a value for the Block property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasBlock() {
        return block != null && !(block instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * How to pronounce the name of the block.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlock} method.
     * </p>
     * 
     * @return How to pronounce the name of the block.
     */
    public final List<PhonemeTranscription> block() {
        return block;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubBlock property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubBlock() {
        return subBlock != null && !(subBlock instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * How to pronounce the name of the sub-block.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubBlock} method.
     * </p>
     * 
     * @return How to pronounce the name of the sub-block.
     */
    public final List<PhonemeTranscription> subBlock() {
        return subBlock;
    }

    /**
     * For responses, this returns true if the service returned a value for the Street property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStreet() {
        return street != null && !(street instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * How to pronounce the name of the street results should be present in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStreet} method.
     * </p>
     * 
     * @return How to pronounce the name of the street results should be present in.
     */
    public final List<PhonemeTranscription> street() {
        return street;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCountry() ? country() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRegion() ? region() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubRegion() ? subRegion() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLocality() ? locality() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDistrict() ? district() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubDistrict() ? subDistrict() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBlock() ? block() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubBlock() ? subBlock() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStreet() ? street() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressComponentPhonemes)) {
            return false;
        }
        AddressComponentPhonemes other = (AddressComponentPhonemes) obj;
        return hasCountry() == other.hasCountry() && Objects.equals(country(), other.country())
                && hasRegion() == other.hasRegion() && Objects.equals(region(), other.region())
                && hasSubRegion() == other.hasSubRegion() && Objects.equals(subRegion(), other.subRegion())
                && hasLocality() == other.hasLocality() && Objects.equals(locality(), other.locality())
                && hasDistrict() == other.hasDistrict() && Objects.equals(district(), other.district())
                && hasSubDistrict() == other.hasSubDistrict() && Objects.equals(subDistrict(), other.subDistrict())
                && hasBlock() == other.hasBlock() && Objects.equals(block(), other.block())
                && hasSubBlock() == other.hasSubBlock() && Objects.equals(subBlock(), other.subBlock())
                && hasStreet() == other.hasStreet() && Objects.equals(street(), other.street());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddressComponentPhonemes").add("Country", hasCountry() ? country() : null)
                .add("Region", hasRegion() ? region() : null).add("SubRegion", hasSubRegion() ? subRegion() : null)
                .add("Locality", hasLocality() ? locality() : null).add("District", hasDistrict() ? district() : null)
                .add("SubDistrict", hasSubDistrict() ? subDistrict() : null).add("Block", hasBlock() ? block() : null)
                .add("SubBlock", hasSubBlock() ? subBlock() : null).add("Street", hasStreet() ? street() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "SubRegion":
            return Optional.ofNullable(clazz.cast(subRegion()));
        case "Locality":
            return Optional.ofNullable(clazz.cast(locality()));
        case "District":
            return Optional.ofNullable(clazz.cast(district()));
        case "SubDistrict":
            return Optional.ofNullable(clazz.cast(subDistrict()));
        case "Block":
            return Optional.ofNullable(clazz.cast(block()));
        case "SubBlock":
            return Optional.ofNullable(clazz.cast(subBlock()));
        case "Street":
            return Optional.ofNullable(clazz.cast(street()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Country", COUNTRY_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("SubRegion", SUB_REGION_FIELD);
        map.put("Locality", LOCALITY_FIELD);
        map.put("District", DISTRICT_FIELD);
        map.put("SubDistrict", SUB_DISTRICT_FIELD);
        map.put("Block", BLOCK_FIELD);
        map.put("SubBlock", SUB_BLOCK_FIELD);
        map.put("Street", STREET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddressComponentPhonemes, T> g) {
        return obj -> g.apply((AddressComponentPhonemes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddressComponentPhonemes> {
        /**
         * <p>
         * The alpha-2 or alpha-3 character code for the country that the results will be present in.
         * </p>
         * 
         * @param country
         *        The alpha-2 or alpha-3 character code for the country that the results will be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(Collection<PhonemeTranscription> country);

        /**
         * <p>
         * The alpha-2 or alpha-3 character code for the country that the results will be present in.
         * </p>
         * 
         * @param country
         *        The alpha-2 or alpha-3 character code for the country that the results will be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(PhonemeTranscription... country);

        /**
         * <p>
         * The alpha-2 or alpha-3 character code for the country that the results will be present in.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder#build()} is called
         * immediately and its result is passed to {@link #country(List<PhonemeTranscription>)}.
         * 
         * @param country
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #country(java.util.Collection<PhonemeTranscription>)
         */
        Builder country(Consumer<PhonemeTranscription.Builder>... country);

        /**
         * <p>
         * How to pronounce the region or state results should be to be present in.
         * </p>
         * 
         * @param region
         *        How to pronounce the region or state results should be to be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(Collection<PhonemeTranscription> region);

        /**
         * <p>
         * How to pronounce the region or state results should be to be present in.
         * </p>
         * 
         * @param region
         *        How to pronounce the region or state results should be to be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(PhonemeTranscription... region);

        /**
         * <p>
         * How to pronounce the region or state results should be to be present in.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder#build()} is called
         * immediately and its result is passed to {@link #region(List<PhonemeTranscription>)}.
         * 
         * @param region
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #region(java.util.Collection<PhonemeTranscription>)
         */
        Builder region(Consumer<PhonemeTranscription.Builder>... region);

        /**
         * <p>
         * How to pronounce the sub-region or county for which results should be present in.
         * </p>
         * 
         * @param subRegion
         *        How to pronounce the sub-region or county for which results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subRegion(Collection<PhonemeTranscription> subRegion);

        /**
         * <p>
         * How to pronounce the sub-region or county for which results should be present in.
         * </p>
         * 
         * @param subRegion
         *        How to pronounce the sub-region or county for which results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subRegion(PhonemeTranscription... subRegion);

        /**
         * <p>
         * How to pronounce the sub-region or county for which results should be present in.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder#build()} is called
         * immediately and its result is passed to {@link #subRegion(List<PhonemeTranscription>)}.
         * 
         * @param subRegion
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subRegion(java.util.Collection<PhonemeTranscription>)
         */
        Builder subRegion(Consumer<PhonemeTranscription.Builder>... subRegion);

        /**
         * <p>
         * How to pronounce the city or locality results should be present in.
         * </p>
         * <p>
         * Example: <code>Vancouver</code>.
         * </p>
         * 
         * @param locality
         *        How to pronounce the city or locality results should be present in. </p>
         *        <p>
         *        Example: <code>Vancouver</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locality(Collection<PhonemeTranscription> locality);

        /**
         * <p>
         * How to pronounce the city or locality results should be present in.
         * </p>
         * <p>
         * Example: <code>Vancouver</code>.
         * </p>
         * 
         * @param locality
         *        How to pronounce the city or locality results should be present in. </p>
         *        <p>
         *        Example: <code>Vancouver</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locality(PhonemeTranscription... locality);

        /**
         * <p>
         * How to pronounce the city or locality results should be present in.
         * </p>
         * <p>
         * Example: <code>Vancouver</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder#build()} is called
         * immediately and its result is passed to {@link #locality(List<PhonemeTranscription>)}.
         * 
         * @param locality
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #locality(java.util.Collection<PhonemeTranscription>)
         */
        Builder locality(Consumer<PhonemeTranscription.Builder>... locality);

        /**
         * <p>
         * How to pronounce the district or division of a city results should be present in.
         * </p>
         * 
         * @param district
         *        How to pronounce the district or division of a city results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder district(Collection<PhonemeTranscription> district);

        /**
         * <p>
         * How to pronounce the district or division of a city results should be present in.
         * </p>
         * 
         * @param district
         *        How to pronounce the district or division of a city results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder district(PhonemeTranscription... district);

        /**
         * <p>
         * How to pronounce the district or division of a city results should be present in.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder#build()} is called
         * immediately and its result is passed to {@link #district(List<PhonemeTranscription>)}.
         * 
         * @param district
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #district(java.util.Collection<PhonemeTranscription>)
         */
        Builder district(Consumer<PhonemeTranscription.Builder>... district);

        /**
         * <p>
         * How to pronounce the sub-district or division of a city results should be present in.
         * </p>
         * 
         * @param subDistrict
         *        How to pronounce the sub-district or division of a city results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subDistrict(Collection<PhonemeTranscription> subDistrict);

        /**
         * <p>
         * How to pronounce the sub-district or division of a city results should be present in.
         * </p>
         * 
         * @param subDistrict
         *        How to pronounce the sub-district or division of a city results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subDistrict(PhonemeTranscription... subDistrict);

        /**
         * <p>
         * How to pronounce the sub-district or division of a city results should be present in.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder#build()} is called
         * immediately and its result is passed to {@link #subDistrict(List<PhonemeTranscription>)}.
         * 
         * @param subDistrict
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subDistrict(java.util.Collection<PhonemeTranscription>)
         */
        Builder subDistrict(Consumer<PhonemeTranscription.Builder>... subDistrict);

        /**
         * <p>
         * How to pronounce the name of the block.
         * </p>
         * 
         * @param block
         *        How to pronounce the name of the block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder block(Collection<PhonemeTranscription> block);

        /**
         * <p>
         * How to pronounce the name of the block.
         * </p>
         * 
         * @param block
         *        How to pronounce the name of the block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder block(PhonemeTranscription... block);

        /**
         * <p>
         * How to pronounce the name of the block.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder#build()} is called
         * immediately and its result is passed to {@link #block(List<PhonemeTranscription>)}.
         * 
         * @param block
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #block(java.util.Collection<PhonemeTranscription>)
         */
        Builder block(Consumer<PhonemeTranscription.Builder>... block);

        /**
         * <p>
         * How to pronounce the name of the sub-block.
         * </p>
         * 
         * @param subBlock
         *        How to pronounce the name of the sub-block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subBlock(Collection<PhonemeTranscription> subBlock);

        /**
         * <p>
         * How to pronounce the name of the sub-block.
         * </p>
         * 
         * @param subBlock
         *        How to pronounce the name of the sub-block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subBlock(PhonemeTranscription... subBlock);

        /**
         * <p>
         * How to pronounce the name of the sub-block.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder#build()} is called
         * immediately and its result is passed to {@link #subBlock(List<PhonemeTranscription>)}.
         * 
         * @param subBlock
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subBlock(java.util.Collection<PhonemeTranscription>)
         */
        Builder subBlock(Consumer<PhonemeTranscription.Builder>... subBlock);

        /**
         * <p>
         * How to pronounce the name of the street results should be present in.
         * </p>
         * 
         * @param street
         *        How to pronounce the name of the street results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder street(Collection<PhonemeTranscription> street);

        /**
         * <p>
         * How to pronounce the name of the street results should be present in.
         * </p>
         * 
         * @param street
         *        How to pronounce the name of the street results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder street(PhonemeTranscription... street);

        /**
         * <p>
         * How to pronounce the name of the street results should be present in.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder#build()} is called
         * immediately and its result is passed to {@link #street(List<PhonemeTranscription>)}.
         * 
         * @param street
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #street(java.util.Collection<PhonemeTranscription>)
         */
        Builder street(Consumer<PhonemeTranscription.Builder>... street);
    }

    static final class BuilderImpl implements Builder {
        private List<PhonemeTranscription> country = DefaultSdkAutoConstructList.getInstance();

        private List<PhonemeTranscription> region = DefaultSdkAutoConstructList.getInstance();

        private List<PhonemeTranscription> subRegion = DefaultSdkAutoConstructList.getInstance();

        private List<PhonemeTranscription> locality = DefaultSdkAutoConstructList.getInstance();

        private List<PhonemeTranscription> district = DefaultSdkAutoConstructList.getInstance();

        private List<PhonemeTranscription> subDistrict = DefaultSdkAutoConstructList.getInstance();

        private List<PhonemeTranscription> block = DefaultSdkAutoConstructList.getInstance();

        private List<PhonemeTranscription> subBlock = DefaultSdkAutoConstructList.getInstance();

        private List<PhonemeTranscription> street = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddressComponentPhonemes model) {
            country(model.country);
            region(model.region);
            subRegion(model.subRegion);
            locality(model.locality);
            district(model.district);
            subDistrict(model.subDistrict);
            block(model.block);
            subBlock(model.subBlock);
            street(model.street);
        }

        public final List<PhonemeTranscription.Builder> getCountry() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.country);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCountry(Collection<PhonemeTranscription.BuilderImpl> country) {
            this.country = PhonemeTranscriptionListCopier.copyFromBuilder(country);
        }

        @Override
        public final Builder country(Collection<PhonemeTranscription> country) {
            this.country = PhonemeTranscriptionListCopier.copy(country);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder country(PhonemeTranscription... country) {
            country(Arrays.asList(country));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder country(Consumer<PhonemeTranscription.Builder>... country) {
            country(Stream.of(country).map(c -> PhonemeTranscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PhonemeTranscription.Builder> getRegion() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.region);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegion(Collection<PhonemeTranscription.BuilderImpl> region) {
            this.region = PhonemeTranscriptionListCopier.copyFromBuilder(region);
        }

        @Override
        public final Builder region(Collection<PhonemeTranscription> region) {
            this.region = PhonemeTranscriptionListCopier.copy(region);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder region(PhonemeTranscription... region) {
            region(Arrays.asList(region));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder region(Consumer<PhonemeTranscription.Builder>... region) {
            region(Stream.of(region).map(c -> PhonemeTranscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PhonemeTranscription.Builder> getSubRegion() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.subRegion);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubRegion(Collection<PhonemeTranscription.BuilderImpl> subRegion) {
            this.subRegion = PhonemeTranscriptionListCopier.copyFromBuilder(subRegion);
        }

        @Override
        public final Builder subRegion(Collection<PhonemeTranscription> subRegion) {
            this.subRegion = PhonemeTranscriptionListCopier.copy(subRegion);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subRegion(PhonemeTranscription... subRegion) {
            subRegion(Arrays.asList(subRegion));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subRegion(Consumer<PhonemeTranscription.Builder>... subRegion) {
            subRegion(Stream.of(subRegion).map(c -> PhonemeTranscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PhonemeTranscription.Builder> getLocality() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.locality);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocality(Collection<PhonemeTranscription.BuilderImpl> locality) {
            this.locality = PhonemeTranscriptionListCopier.copyFromBuilder(locality);
        }

        @Override
        public final Builder locality(Collection<PhonemeTranscription> locality) {
            this.locality = PhonemeTranscriptionListCopier.copy(locality);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locality(PhonemeTranscription... locality) {
            locality(Arrays.asList(locality));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locality(Consumer<PhonemeTranscription.Builder>... locality) {
            locality(Stream.of(locality).map(c -> PhonemeTranscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PhonemeTranscription.Builder> getDistrict() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.district);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDistrict(Collection<PhonemeTranscription.BuilderImpl> district) {
            this.district = PhonemeTranscriptionListCopier.copyFromBuilder(district);
        }

        @Override
        public final Builder district(Collection<PhonemeTranscription> district) {
            this.district = PhonemeTranscriptionListCopier.copy(district);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder district(PhonemeTranscription... district) {
            district(Arrays.asList(district));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder district(Consumer<PhonemeTranscription.Builder>... district) {
            district(Stream.of(district).map(c -> PhonemeTranscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PhonemeTranscription.Builder> getSubDistrict() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.subDistrict);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubDistrict(Collection<PhonemeTranscription.BuilderImpl> subDistrict) {
            this.subDistrict = PhonemeTranscriptionListCopier.copyFromBuilder(subDistrict);
        }

        @Override
        public final Builder subDistrict(Collection<PhonemeTranscription> subDistrict) {
            this.subDistrict = PhonemeTranscriptionListCopier.copy(subDistrict);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subDistrict(PhonemeTranscription... subDistrict) {
            subDistrict(Arrays.asList(subDistrict));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subDistrict(Consumer<PhonemeTranscription.Builder>... subDistrict) {
            subDistrict(Stream.of(subDistrict).map(c -> PhonemeTranscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PhonemeTranscription.Builder> getBlock() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.block);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlock(Collection<PhonemeTranscription.BuilderImpl> block) {
            this.block = PhonemeTranscriptionListCopier.copyFromBuilder(block);
        }

        @Override
        public final Builder block(Collection<PhonemeTranscription> block) {
            this.block = PhonemeTranscriptionListCopier.copy(block);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder block(PhonemeTranscription... block) {
            block(Arrays.asList(block));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder block(Consumer<PhonemeTranscription.Builder>... block) {
            block(Stream.of(block).map(c -> PhonemeTranscription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PhonemeTranscription.Builder> getSubBlock() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.subBlock);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubBlock(Collection<PhonemeTranscription.BuilderImpl> subBlock) {
            this.subBlock = PhonemeTranscriptionListCopier.copyFromBuilder(subBlock);
        }

        @Override
        public final Builder subBlock(Collection<PhonemeTranscription> subBlock) {
            this.subBlock = PhonemeTranscriptionListCopier.copy(subBlock);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subBlock(PhonemeTranscription... subBlock) {
            subBlock(Arrays.asList(subBlock));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subBlock(Consumer<PhonemeTranscription.Builder>... subBlock) {
            subBlock(Stream.of(subBlock).map(c -> PhonemeTranscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PhonemeTranscription.Builder> getStreet() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.street);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreet(Collection<PhonemeTranscription.BuilderImpl> street) {
            this.street = PhonemeTranscriptionListCopier.copyFromBuilder(street);
        }

        @Override
        public final Builder street(Collection<PhonemeTranscription> street) {
            this.street = PhonemeTranscriptionListCopier.copy(street);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder street(PhonemeTranscription... street) {
            street(Arrays.asList(street));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder street(Consumer<PhonemeTranscription.Builder>... street) {
            street(Stream.of(street).map(c -> PhonemeTranscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AddressComponentPhonemes build() {
            return new AddressComponentPhonemes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
