/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>Circle</code> that all results must be in.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterCircle implements SdkPojo, Serializable, ToCopyableBuilder<FilterCircle.Builder, FilterCircle> {
    private static final SdkField<List<Double>> CENTER_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Center")
            .getter(getter(FilterCircle::center))
            .setter(setter(Builder::center))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Center").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> RADIUS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Radius")
            .getter(getter(FilterCircle::radius)).setter(setter(Builder::radius))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Radius").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CENTER_FIELD, RADIUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Double> center;

    private final Long radius;

    private FilterCircle(BuilderImpl builder) {
        this.center = builder.center;
        this.radius = builder.radius;
    }

    /**
     * For responses, this returns true if the service returned a value for the Center property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCenter() {
        return center != null && !(center instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The center position, in longitude and latitude, of the <code>FilterCircle</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCenter} method.
     * </p>
     * 
     * @return The center position, in longitude and latitude, of the <code>FilterCircle</code>.
     */
    public final List<Double> center() {
        return center;
    }

    /**
     * <p>
     * The radius, in meters, of the <code>FilterCircle</code>.
     * </p>
     * 
     * @return The radius, in meters, of the <code>FilterCircle</code>.
     */
    public final Long radius() {
        return radius;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCenter() ? center() : null);
        hashCode = 31 * hashCode + Objects.hashCode(radius());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterCircle)) {
            return false;
        }
        FilterCircle other = (FilterCircle) obj;
        return hasCenter() == other.hasCenter() && Objects.equals(center(), other.center())
                && Objects.equals(radius(), other.radius());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterCircle").add("Center", center() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Radius", radius()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Center":
            return Optional.ofNullable(clazz.cast(center()));
        case "Radius":
            return Optional.ofNullable(clazz.cast(radius()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Center", CENTER_FIELD);
        map.put("Radius", RADIUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterCircle, T> g) {
        return obj -> g.apply((FilterCircle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterCircle> {
        /**
         * <p>
         * The center position, in longitude and latitude, of the <code>FilterCircle</code>.
         * </p>
         * 
         * @param center
         *        The center position, in longitude and latitude, of the <code>FilterCircle</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder center(Collection<Double> center);

        /**
         * <p>
         * The center position, in longitude and latitude, of the <code>FilterCircle</code>.
         * </p>
         * 
         * @param center
         *        The center position, in longitude and latitude, of the <code>FilterCircle</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder center(Double... center);

        /**
         * <p>
         * The radius, in meters, of the <code>FilterCircle</code>.
         * </p>
         * 
         * @param radius
         *        The radius, in meters, of the <code>FilterCircle</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radius(Long radius);
    }

    static final class BuilderImpl implements Builder {
        private List<Double> center = DefaultSdkAutoConstructList.getInstance();

        private Long radius;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterCircle model) {
            center(model.center);
            radius(model.radius);
        }

        public final Collection<Double> getCenter() {
            if (center instanceof SdkAutoConstructList) {
                return null;
            }
            return center;
        }

        public final void setCenter(Collection<Double> center) {
            this.center = PositionCopier.copy(center);
        }

        @Override
        public final Builder center(Collection<Double> center) {
            this.center = PositionCopier.copy(center);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder center(Double... center) {
            center(Arrays.asList(center));
            return this;
        }

        public final Long getRadius() {
            return radius;
        }

        public final void setRadius(Long radius) {
            this.radius = radius;
        }

        @Override
        public final Builder radius(Long radius) {
            this.radius = radius;
            return this;
        }

        @Override
        public FilterCircle build() {
            return new FilterCircle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
