/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPlaceRequest extends GeoPlacesRequest implements
        ToCopyableBuilder<GetPlaceRequest.Builder, GetPlaceRequest> {
    private static final SdkField<String> PLACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaceId").getter(getter(GetPlaceRequest::placeId)).setter(setter(Builder::placeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("PlaceId").build()).build();

    private static final SdkField<List<String>> ADDITIONAL_FEATURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalFeatures")
            .getter(getter(GetPlaceRequest::additionalFeaturesAsStrings))
            .setter(setter(Builder::additionalFeaturesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("additional-features").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Language").getter(getter(GetPlaceRequest::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("language").build()).build();

    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoliticalView").getter(getter(GetPlaceRequest::politicalView)).setter(setter(Builder::politicalView))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("political-view").build())
            .build();

    private static final SdkField<String> INTENDED_USE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntendedUse").getter(getter(GetPlaceRequest::intendedUseAsString)).setter(setter(Builder::intendedUse))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("intended-use").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(GetPlaceRequest::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACE_ID_FIELD,
            ADDITIONAL_FEATURES_FIELD, LANGUAGE_FIELD, POLITICAL_VIEW_FIELD, INTENDED_USE_FIELD, KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String placeId;

    private final List<String> additionalFeatures;

    private final String language;

    private final String politicalView;

    private final String intendedUse;

    private final String key;

    private GetPlaceRequest(BuilderImpl builder) {
        super(builder);
        this.placeId = builder.placeId;
        this.additionalFeatures = builder.additionalFeatures;
        this.language = builder.language;
        this.politicalView = builder.politicalView;
        this.intendedUse = builder.intendedUse;
        this.key = builder.key;
    }

    /**
     * <p>
     * The <code>PlaceId</code> of the place you wish to receive the information for.
     * </p>
     * 
     * @return The <code>PlaceId</code> of the place you wish to receive the information for.
     */
    public final String placeId() {
        return placeId;
    }

    /**
     * <p>
     * A list of optional additional parameters such as time zone that can be requested for each result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalFeatures} method.
     * </p>
     * 
     * @return A list of optional additional parameters such as time zone that can be requested for each result.
     */
    public final List<GetPlaceAdditionalFeature> additionalFeatures() {
        return GetPlaceAdditionalFeatureListCopier.copyStringToEnum(additionalFeatures);
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalFeatures property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalFeatures() {
        return additionalFeatures != null && !(additionalFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of optional additional parameters such as time zone that can be requested for each result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalFeatures} method.
     * </p>
     * 
     * @return A list of optional additional parameters such as time zone that can be requested for each result.
     */
    public final List<String> additionalFeaturesAsStrings() {
        return additionalFeatures;
    }

    /**
     * <p>
     * A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language codes for the
     * results to be rendered in. If there is no data for the result in the requested language, data will be returned in
     * the default language for the entry.
     * </p>
     * 
     * @return A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language codes
     *         for the results to be rendered in. If there is no data for the result in the requested language, data
     *         will be returned in the default language for the entry.
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * The alpha-2 or alpha-3 character code for the political view of a country. The political view applies to the
     * results of the request to represent unresolved territorial claims through the point of view of the specified
     * country.
     * </p>
     * 
     * @return The alpha-2 or alpha-3 character code for the political view of a country. The political view applies to
     *         the results of the request to represent unresolved territorial claims through the point of view of the
     *         specified country.
     */
    public final String politicalView() {
        return politicalView;
    }

    /**
     * <p>
     * Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intendedUse} will
     * return {@link GetPlaceIntendedUse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #intendedUseAsString}.
     * </p>
     * 
     * @return Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
     * @see GetPlaceIntendedUse
     */
    public final GetPlaceIntendedUse intendedUse() {
        return GetPlaceIntendedUse.fromValue(intendedUse);
    }

    /**
     * <p>
     * Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intendedUse} will
     * return {@link GetPlaceIntendedUse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #intendedUseAsString}.
     * </p>
     * 
     * @return Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
     * @see GetPlaceIntendedUse
     */
    public final String intendedUseAsString() {
        return intendedUse;
    }

    /**
     * <p>
     * Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be provided
     * when making a request.
     * </p>
     * 
     * @return Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
     *         provided when making a request.
     */
    public final String key() {
        return key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(placeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalFeatures() ? additionalFeaturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(intendedUseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPlaceRequest)) {
            return false;
        }
        GetPlaceRequest other = (GetPlaceRequest) obj;
        return Objects.equals(placeId(), other.placeId()) && hasAdditionalFeatures() == other.hasAdditionalFeatures()
                && Objects.equals(additionalFeaturesAsStrings(), other.additionalFeaturesAsStrings())
                && Objects.equals(language(), other.language()) && Objects.equals(politicalView(), other.politicalView())
                && Objects.equals(intendedUseAsString(), other.intendedUseAsString()) && Objects.equals(key(), other.key());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPlaceRequest").add("PlaceId", placeId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AdditionalFeatures", hasAdditionalFeatures() ? additionalFeaturesAsStrings() : null)
                .add("Language", language()).add("PoliticalView", politicalView()).add("IntendedUse", intendedUseAsString())
                .add("Key", key() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlaceId":
            return Optional.ofNullable(clazz.cast(placeId()));
        case "AdditionalFeatures":
            return Optional.ofNullable(clazz.cast(additionalFeaturesAsStrings()));
        case "Language":
            return Optional.ofNullable(clazz.cast(language()));
        case "PoliticalView":
            return Optional.ofNullable(clazz.cast(politicalView()));
        case "IntendedUse":
            return Optional.ofNullable(clazz.cast(intendedUseAsString()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PlaceId", PLACE_ID_FIELD);
        map.put("additional-features", ADDITIONAL_FEATURES_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("political-view", POLITICAL_VIEW_FIELD);
        map.put("intended-use", INTENDED_USE_FIELD);
        map.put("key", KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPlaceRequest, T> g) {
        return obj -> g.apply((GetPlaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GeoPlacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetPlaceRequest> {
        /**
         * <p>
         * The <code>PlaceId</code> of the place you wish to receive the information for.
         * </p>
         * 
         * @param placeId
         *        The <code>PlaceId</code> of the place you wish to receive the information for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placeId(String placeId);

        /**
         * <p>
         * A list of optional additional parameters such as time zone that can be requested for each result.
         * </p>
         * 
         * @param additionalFeatures
         *        A list of optional additional parameters such as time zone that can be requested for each result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalFeaturesWithStrings(Collection<String> additionalFeatures);

        /**
         * <p>
         * A list of optional additional parameters such as time zone that can be requested for each result.
         * </p>
         * 
         * @param additionalFeatures
         *        A list of optional additional parameters such as time zone that can be requested for each result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalFeaturesWithStrings(String... additionalFeatures);

        /**
         * <p>
         * A list of optional additional parameters such as time zone that can be requested for each result.
         * </p>
         * 
         * @param additionalFeatures
         *        A list of optional additional parameters such as time zone that can be requested for each result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalFeatures(Collection<GetPlaceAdditionalFeature> additionalFeatures);

        /**
         * <p>
         * A list of optional additional parameters such as time zone that can be requested for each result.
         * </p>
         * 
         * @param additionalFeatures
         *        A list of optional additional parameters such as time zone that can be requested for each result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalFeatures(GetPlaceAdditionalFeature... additionalFeatures);

        /**
         * <p>
         * A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language codes for
         * the results to be rendered in. If there is no data for the result in the requested language, data will be
         * returned in the default language for the entry.
         * </p>
         * 
         * @param language
         *        A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language
         *        codes for the results to be rendered in. If there is no data for the result in the requested language,
         *        data will be returned in the default language for the entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * The alpha-2 or alpha-3 character code for the political view of a country. The political view applies to the
         * results of the request to represent unresolved territorial claims through the point of view of the specified
         * country.
         * </p>
         * 
         * @param politicalView
         *        The alpha-2 or alpha-3 character code for the political view of a country. The political view applies
         *        to the results of the request to represent unresolved territorial claims through the point of view of
         *        the specified country.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder politicalView(String politicalView);

        /**
         * <p>
         * Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
         * </p>
         * 
         * @param intendedUse
         *        Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
         * @see GetPlaceIntendedUse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GetPlaceIntendedUse
         */
        Builder intendedUse(String intendedUse);

        /**
         * <p>
         * Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
         * </p>
         * 
         * @param intendedUse
         *        Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
         * @see GetPlaceIntendedUse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GetPlaceIntendedUse
         */
        Builder intendedUse(GetPlaceIntendedUse intendedUse);

        /**
         * <p>
         * Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
         * provided when making a request.
         * </p>
         * 
         * @param key
         *        Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
         *        provided when making a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GeoPlacesRequest.BuilderImpl implements Builder {
        private String placeId;

        private List<String> additionalFeatures = DefaultSdkAutoConstructList.getInstance();

        private String language;

        private String politicalView;

        private String intendedUse;

        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPlaceRequest model) {
            super(model);
            placeId(model.placeId);
            additionalFeaturesWithStrings(model.additionalFeatures);
            language(model.language);
            politicalView(model.politicalView);
            intendedUse(model.intendedUse);
            key(model.key);
        }

        public final String getPlaceId() {
            return placeId;
        }

        public final void setPlaceId(String placeId) {
            this.placeId = placeId;
        }

        @Override
        public final Builder placeId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        public final Collection<String> getAdditionalFeatures() {
            if (additionalFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalFeatures;
        }

        public final void setAdditionalFeatures(Collection<String> additionalFeatures) {
            this.additionalFeatures = GetPlaceAdditionalFeatureListCopier.copy(additionalFeatures);
        }

        @Override
        public final Builder additionalFeaturesWithStrings(Collection<String> additionalFeatures) {
            this.additionalFeatures = GetPlaceAdditionalFeatureListCopier.copy(additionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalFeaturesWithStrings(String... additionalFeatures) {
            additionalFeaturesWithStrings(Arrays.asList(additionalFeatures));
            return this;
        }

        @Override
        public final Builder additionalFeatures(Collection<GetPlaceAdditionalFeature> additionalFeatures) {
            this.additionalFeatures = GetPlaceAdditionalFeatureListCopier.copyEnumToString(additionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalFeatures(GetPlaceAdditionalFeature... additionalFeatures) {
            additionalFeatures(Arrays.asList(additionalFeatures));
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getPoliticalView() {
            return politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final String getIntendedUse() {
            return intendedUse;
        }

        public final void setIntendedUse(String intendedUse) {
            this.intendedUse = intendedUse;
        }

        @Override
        public final Builder intendedUse(String intendedUse) {
            this.intendedUse = intendedUse;
            return this;
        }

        @Override
        public final Builder intendedUse(GetPlaceIntendedUse intendedUse) {
            this.intendedUse(intendedUse == null ? null : intendedUse.toString());
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPlaceRequest build() {
            return new GetPlaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
