/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPlaceResponse extends GeoPlacesResponse implements
        ToCopyableBuilder<GetPlaceResponse.Builder, GetPlaceResponse> {
    private static final SdkField<String> PLACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaceId").getter(getter(GetPlaceResponse::placeId)).setter(setter(Builder::placeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceId").build()).build();

    private static final SdkField<String> PLACE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaceType").getter(getter(GetPlaceResponse::placeTypeAsString)).setter(setter(Builder::placeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceType").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(GetPlaceResponse::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> PRICING_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingBucket").getter(getter(GetPlaceResponse::pricingBucket)).setter(setter(Builder::pricingBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-geo-pricing-bucket").build())
            .build();

    private static final SdkField<Address> ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("Address").getter(getter(GetPlaceResponse::address)).setter(setter(Builder::address))
            .constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<Boolean> ADDRESS_NUMBER_CORRECTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AddressNumberCorrected").getter(getter(GetPlaceResponse::addressNumberCorrected))
            .setter(setter(Builder::addressNumberCorrected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressNumberCorrected").build())
            .build();

    private static final SdkField<List<PostalCodeDetails>> POSTAL_CODE_DETAILS_FIELD = SdkField
            .<List<PostalCodeDetails>> builder(MarshallingType.LIST)
            .memberName("PostalCodeDetails")
            .getter(getter(GetPlaceResponse::postalCodeDetails))
            .setter(setter(Builder::postalCodeDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCodeDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PostalCodeDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(PostalCodeDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Double>> POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Position")
            .getter(getter(GetPlaceResponse::position))
            .setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Double>> MAP_VIEW_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("MapView")
            .getter(getter(GetPlaceResponse::mapView))
            .setter(setter(Builder::mapView))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapView").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Category>> CATEGORIES_FIELD = SdkField
            .<List<Category>> builder(MarshallingType.LIST)
            .memberName("Categories")
            .getter(getter(GetPlaceResponse::categories))
            .setter(setter(Builder::categories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Category> builder(MarshallingType.SDK_POJO)
                                            .constructor(Category::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FoodType>> FOOD_TYPES_FIELD = SdkField
            .<List<FoodType>> builder(MarshallingType.LIST)
            .memberName("FoodTypes")
            .getter(getter(GetPlaceResponse::foodTypes))
            .setter(setter(Builder::foodTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FoodTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FoodType> builder(MarshallingType.SDK_POJO)
                                            .constructor(FoodType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BusinessChain>> BUSINESS_CHAINS_FIELD = SdkField
            .<List<BusinessChain>> builder(MarshallingType.LIST)
            .memberName("BusinessChains")
            .getter(getter(GetPlaceResponse::businessChains))
            .setter(setter(Builder::businessChains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessChains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BusinessChain> builder(MarshallingType.SDK_POJO)
                                            .constructor(BusinessChain::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Contacts> CONTACTS_FIELD = SdkField.<Contacts> builder(MarshallingType.SDK_POJO)
            .memberName("Contacts").getter(getter(GetPlaceResponse::contacts)).setter(setter(Builder::contacts))
            .constructor(Contacts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contacts").build()).build();

    private static final SdkField<List<OpeningHours>> OPENING_HOURS_FIELD = SdkField
            .<List<OpeningHours>> builder(MarshallingType.LIST)
            .memberName("OpeningHours")
            .getter(getter(GetPlaceResponse::openingHours))
            .setter(setter(Builder::openingHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpeningHours").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpeningHours> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpeningHours::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AccessPoint>> ACCESS_POINTS_FIELD = SdkField
            .<List<AccessPoint>> builder(MarshallingType.LIST)
            .memberName("AccessPoints")
            .getter(getter(GetPlaceResponse::accessPoints))
            .setter(setter(Builder::accessPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessPoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessPoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AccessRestriction>> ACCESS_RESTRICTIONS_FIELD = SdkField
            .<List<AccessRestriction>> builder(MarshallingType.LIST)
            .memberName("AccessRestrictions")
            .getter(getter(GetPlaceResponse::accessRestrictions))
            .setter(setter(Builder::accessRestrictions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessRestrictions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessRestriction> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessRestriction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TimeZone> TIME_ZONE_FIELD = SdkField.<TimeZone> builder(MarshallingType.SDK_POJO)
            .memberName("TimeZone").getter(getter(GetPlaceResponse::timeZone)).setter(setter(Builder::timeZone))
            .constructor(TimeZone::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()).build();

    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoliticalView").getter(getter(GetPlaceResponse::politicalView)).setter(setter(Builder::politicalView))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoliticalView").build()).build();

    private static final SdkField<PhonemeDetails> PHONEMES_FIELD = SdkField.<PhonemeDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Phonemes").getter(getter(GetPlaceResponse::phonemes)).setter(setter(Builder::phonemes))
            .constructor(PhonemeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phonemes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACE_ID_FIELD,
            PLACE_TYPE_FIELD, TITLE_FIELD, PRICING_BUCKET_FIELD, ADDRESS_FIELD, ADDRESS_NUMBER_CORRECTED_FIELD,
            POSTAL_CODE_DETAILS_FIELD, POSITION_FIELD, MAP_VIEW_FIELD, CATEGORIES_FIELD, FOOD_TYPES_FIELD, BUSINESS_CHAINS_FIELD,
            CONTACTS_FIELD, OPENING_HOURS_FIELD, ACCESS_POINTS_FIELD, ACCESS_RESTRICTIONS_FIELD, TIME_ZONE_FIELD,
            POLITICAL_VIEW_FIELD, PHONEMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String placeId;

    private final String placeType;

    private final String title;

    private final String pricingBucket;

    private final Address address;

    private final Boolean addressNumberCorrected;

    private final List<PostalCodeDetails> postalCodeDetails;

    private final List<Double> position;

    private final List<Double> mapView;

    private final List<Category> categories;

    private final List<FoodType> foodTypes;

    private final List<BusinessChain> businessChains;

    private final Contacts contacts;

    private final List<OpeningHours> openingHours;

    private final List<AccessPoint> accessPoints;

    private final List<AccessRestriction> accessRestrictions;

    private final TimeZone timeZone;

    private final String politicalView;

    private final PhonemeDetails phonemes;

    private GetPlaceResponse(BuilderImpl builder) {
        super(builder);
        this.placeId = builder.placeId;
        this.placeType = builder.placeType;
        this.title = builder.title;
        this.pricingBucket = builder.pricingBucket;
        this.address = builder.address;
        this.addressNumberCorrected = builder.addressNumberCorrected;
        this.postalCodeDetails = builder.postalCodeDetails;
        this.position = builder.position;
        this.mapView = builder.mapView;
        this.categories = builder.categories;
        this.foodTypes = builder.foodTypes;
        this.businessChains = builder.businessChains;
        this.contacts = builder.contacts;
        this.openingHours = builder.openingHours;
        this.accessPoints = builder.accessPoints;
        this.accessRestrictions = builder.accessRestrictions;
        this.timeZone = builder.timeZone;
        this.politicalView = builder.politicalView;
        this.phonemes = builder.phonemes;
    }

    /**
     * <p>
     * The <code>PlaceId</code> of the place you wish to receive the information for.
     * </p>
     * 
     * @return The <code>PlaceId</code> of the place you wish to receive the information for.
     */
    public final String placeId() {
        return placeId;
    }

    /**
     * <p>
     * A <code>PlaceType</code> is a category that the result place must belong to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #placeType} will
     * return {@link PlaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #placeTypeAsString}.
     * </p>
     * 
     * @return A <code>PlaceType</code> is a category that the result place must belong to.
     * @see PlaceType
     */
    public final PlaceType placeType() {
        return PlaceType.fromValue(placeType);
    }

    /**
     * <p>
     * A <code>PlaceType</code> is a category that the result place must belong to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #placeType} will
     * return {@link PlaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #placeTypeAsString}.
     * </p>
     * 
     * @return A <code>PlaceType</code> is a category that the result place must belong to.
     * @see PlaceType
     */
    public final String placeTypeAsString() {
        return placeType;
    }

    /**
     * <p>
     * The localized display name of this result item based on request parameter <code>language</code>.
     * </p>
     * 
     * @return The localized display name of this result item based on request parameter <code>language</code>.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The pricing bucket for which the query is charged at.
     * </p>
     * <p>
     * For more inforamtion on pricing, please visit <a href="https://aws.amazon.com/location/pricing/">Amazon Location
     * Service Pricing</a>.
     * </p>
     * 
     * @return The pricing bucket for which the query is charged at.</p>
     *         <p>
     *         For more inforamtion on pricing, please visit <a href="https://aws.amazon.com/location/pricing/">Amazon
     *         Location Service Pricing</a>.
     */
    public final String pricingBucket() {
        return pricingBucket;
    }

    /**
     * <p>
     * The place's address.
     * </p>
     * 
     * @return The place's address.
     */
    public final Address address() {
        return address;
    }

    /**
     * <p>
     * Boolean indicating if the address provided has been corrected.
     * </p>
     * 
     * @return Boolean indicating if the address provided has been corrected.
     */
    public final Boolean addressNumberCorrected() {
        return addressNumberCorrected;
    }

    /**
     * For responses, this returns true if the service returned a value for the PostalCodeDetails property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPostalCodeDetails() {
        return postalCodeDetails != null && !(postalCodeDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains details about the postal code of the place/result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPostalCodeDetails} method.
     * </p>
     * 
     * @return Contains details about the postal code of the place/result.
     */
    public final List<PostalCodeDetails> postalCodeDetails() {
        return postalCodeDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Position property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPosition() {
        return position != null && !(position instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The position, in longitude and latitude.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPosition} method.
     * </p>
     * 
     * @return The position, in longitude and latitude.
     */
    public final List<Double> position() {
        return position;
    }

    /**
     * For responses, this returns true if the service returned a value for the MapView property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMapView() {
        return mapView != null && !(mapView instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The bounding box enclosing the geometric shape (area or line) that an individual result covers.
     * </p>
     * <p>
     * The bounding box formed is defined as a set of four coordinates:
     * <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMapView} method.
     * </p>
     * 
     * @return The bounding box enclosing the geometric shape (area or line) that an individual result covers.</p>
     *         <p>
     *         The bounding box formed is defined as a set of four coordinates:
     *         <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
     */
    public final List<Double> mapView() {
        return mapView;
    }

    /**
     * For responses, this returns true if the service returned a value for the Categories property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCategories() {
        return categories != null && !(categories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Categories of results that results must belong to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategories} method.
     * </p>
     * 
     * @return Categories of results that results must belong to.
     */
    public final List<Category> categories() {
        return categories;
    }

    /**
     * For responses, this returns true if the service returned a value for the FoodTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFoodTypes() {
        return foodTypes != null && !(foodTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of food types offered by this result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFoodTypes} method.
     * </p>
     * 
     * @return List of food types offered by this result.
     */
    public final List<FoodType> foodTypes() {
        return foodTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the BusinessChains property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBusinessChains() {
        return businessChains != null && !(businessChains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Business Chains associated with the place.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBusinessChains} method.
     * </p>
     * 
     * @return The Business Chains associated with the place.
     */
    public final List<BusinessChain> businessChains() {
        return businessChains;
    }

    /**
     * <p>
     * List of potential contact methods for the result/place.
     * </p>
     * 
     * @return List of potential contact methods for the result/place.
     */
    public final Contacts contacts() {
        return contacts;
    }

    /**
     * For responses, this returns true if the service returned a value for the OpeningHours property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOpeningHours() {
        return openingHours != null && !(openingHours instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of opening hours objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOpeningHours} method.
     * </p>
     * 
     * @return List of opening hours objects.
     */
    public final List<OpeningHours> openingHours() {
        return openingHours;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessPoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessPoints() {
        return accessPoints != null && !(accessPoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Position of the access point in <code>(lng,lat)</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessPoints} method.
     * </p>
     * 
     * @return Position of the access point in <code>(lng,lat)</code>.
     */
    public final List<AccessPoint> accessPoints() {
        return accessPoints;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessRestrictions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessRestrictions() {
        return accessRestrictions != null && !(accessRestrictions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates known access restrictions on a vehicle access point. The index correlates to an access point and
     * indicates if access through this point has some form of restriction.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessRestrictions} method.
     * </p>
     * 
     * @return Indicates known access restrictions on a vehicle access point. The index correlates to an access point
     *         and indicates if access through this point has some form of restriction.
     */
    public final List<AccessRestriction> accessRestrictions() {
        return accessRestrictions;
    }

    /**
     * <p>
     * The time zone in which the place is located.
     * </p>
     * 
     * @return The time zone in which the place is located.
     */
    public final TimeZone timeZone() {
        return timeZone;
    }

    /**
     * <p>
     * The alpha-2 or alpha-3 character code for the political view of a country. The political view applies to the
     * results of the request to represent unresolved territorial claims through the point of view of the specified
     * country.
     * </p>
     * 
     * @return The alpha-2 or alpha-3 character code for the political view of a country. The political view applies to
     *         the results of the request to represent unresolved territorial claims through the point of view of the
     *         specified country.
     */
    public final String politicalView() {
        return politicalView;
    }

    /**
     * <p>
     * How the various components of the result's address are pronounced in various languages.
     * </p>
     * 
     * @return How the various components of the result's address are pronounced in various languages.
     */
    public final PhonemeDetails phonemes() {
        return phonemes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(placeId());
        hashCode = 31 * hashCode + Objects.hashCode(placeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(pricingBucket());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(addressNumberCorrected());
        hashCode = 31 * hashCode + Objects.hashCode(hasPostalCodeDetails() ? postalCodeDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPosition() ? position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMapView() ? mapView() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCategories() ? categories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFoodTypes() ? foodTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBusinessChains() ? businessChains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(contacts());
        hashCode = 31 * hashCode + Objects.hashCode(hasOpeningHours() ? openingHours() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessPoints() ? accessPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessRestrictions() ? accessRestrictions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(phonemes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPlaceResponse)) {
            return false;
        }
        GetPlaceResponse other = (GetPlaceResponse) obj;
        return Objects.equals(placeId(), other.placeId()) && Objects.equals(placeTypeAsString(), other.placeTypeAsString())
                && Objects.equals(title(), other.title()) && Objects.equals(pricingBucket(), other.pricingBucket())
                && Objects.equals(address(), other.address())
                && Objects.equals(addressNumberCorrected(), other.addressNumberCorrected())
                && hasPostalCodeDetails() == other.hasPostalCodeDetails()
                && Objects.equals(postalCodeDetails(), other.postalCodeDetails()) && hasPosition() == other.hasPosition()
                && Objects.equals(position(), other.position()) && hasMapView() == other.hasMapView()
                && Objects.equals(mapView(), other.mapView()) && hasCategories() == other.hasCategories()
                && Objects.equals(categories(), other.categories()) && hasFoodTypes() == other.hasFoodTypes()
                && Objects.equals(foodTypes(), other.foodTypes()) && hasBusinessChains() == other.hasBusinessChains()
                && Objects.equals(businessChains(), other.businessChains()) && Objects.equals(contacts(), other.contacts())
                && hasOpeningHours() == other.hasOpeningHours() && Objects.equals(openingHours(), other.openingHours())
                && hasAccessPoints() == other.hasAccessPoints() && Objects.equals(accessPoints(), other.accessPoints())
                && hasAccessRestrictions() == other.hasAccessRestrictions()
                && Objects.equals(accessRestrictions(), other.accessRestrictions())
                && Objects.equals(timeZone(), other.timeZone()) && Objects.equals(politicalView(), other.politicalView())
                && Objects.equals(phonemes(), other.phonemes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPlaceResponse").add("PlaceId", placeId()).add("PlaceType", placeTypeAsString())
                .add("Title", title()).add("PricingBucket", pricingBucket()).add("Address", address())
                .add("AddressNumberCorrected", addressNumberCorrected())
                .add("PostalCodeDetails", hasPostalCodeDetails() ? postalCodeDetails() : null)
                .add("Position", position() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MapView", mapView() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Categories", hasCategories() ? categories() : null).add("FoodTypes", hasFoodTypes() ? foodTypes() : null)
                .add("BusinessChains", hasBusinessChains() ? businessChains() : null).add("Contacts", contacts())
                .add("OpeningHours", hasOpeningHours() ? openingHours() : null)
                .add("AccessPoints", hasAccessPoints() ? accessPoints() : null)
                .add("AccessRestrictions", hasAccessRestrictions() ? accessRestrictions() : null).add("TimeZone", timeZone())
                .add("PoliticalView", politicalView()).add("Phonemes", phonemes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlaceId":
            return Optional.ofNullable(clazz.cast(placeId()));
        case "PlaceType":
            return Optional.ofNullable(clazz.cast(placeTypeAsString()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "PricingBucket":
            return Optional.ofNullable(clazz.cast(pricingBucket()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "AddressNumberCorrected":
            return Optional.ofNullable(clazz.cast(addressNumberCorrected()));
        case "PostalCodeDetails":
            return Optional.ofNullable(clazz.cast(postalCodeDetails()));
        case "Position":
            return Optional.ofNullable(clazz.cast(position()));
        case "MapView":
            return Optional.ofNullable(clazz.cast(mapView()));
        case "Categories":
            return Optional.ofNullable(clazz.cast(categories()));
        case "FoodTypes":
            return Optional.ofNullable(clazz.cast(foodTypes()));
        case "BusinessChains":
            return Optional.ofNullable(clazz.cast(businessChains()));
        case "Contacts":
            return Optional.ofNullable(clazz.cast(contacts()));
        case "OpeningHours":
            return Optional.ofNullable(clazz.cast(openingHours()));
        case "AccessPoints":
            return Optional.ofNullable(clazz.cast(accessPoints()));
        case "AccessRestrictions":
            return Optional.ofNullable(clazz.cast(accessRestrictions()));
        case "TimeZone":
            return Optional.ofNullable(clazz.cast(timeZone()));
        case "PoliticalView":
            return Optional.ofNullable(clazz.cast(politicalView()));
        case "Phonemes":
            return Optional.ofNullable(clazz.cast(phonemes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PlaceId", PLACE_ID_FIELD);
        map.put("PlaceType", PLACE_TYPE_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("x-amz-geo-pricing-bucket", PRICING_BUCKET_FIELD);
        map.put("Address", ADDRESS_FIELD);
        map.put("AddressNumberCorrected", ADDRESS_NUMBER_CORRECTED_FIELD);
        map.put("PostalCodeDetails", POSTAL_CODE_DETAILS_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("MapView", MAP_VIEW_FIELD);
        map.put("Categories", CATEGORIES_FIELD);
        map.put("FoodTypes", FOOD_TYPES_FIELD);
        map.put("BusinessChains", BUSINESS_CHAINS_FIELD);
        map.put("Contacts", CONTACTS_FIELD);
        map.put("OpeningHours", OPENING_HOURS_FIELD);
        map.put("AccessPoints", ACCESS_POINTS_FIELD);
        map.put("AccessRestrictions", ACCESS_RESTRICTIONS_FIELD);
        map.put("TimeZone", TIME_ZONE_FIELD);
        map.put("PoliticalView", POLITICAL_VIEW_FIELD);
        map.put("Phonemes", PHONEMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPlaceResponse, T> g) {
        return obj -> g.apply((GetPlaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GeoPlacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPlaceResponse> {
        /**
         * <p>
         * The <code>PlaceId</code> of the place you wish to receive the information for.
         * </p>
         * 
         * @param placeId
         *        The <code>PlaceId</code> of the place you wish to receive the information for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placeId(String placeId);

        /**
         * <p>
         * A <code>PlaceType</code> is a category that the result place must belong to.
         * </p>
         * 
         * @param placeType
         *        A <code>PlaceType</code> is a category that the result place must belong to.
         * @see PlaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlaceType
         */
        Builder placeType(String placeType);

        /**
         * <p>
         * A <code>PlaceType</code> is a category that the result place must belong to.
         * </p>
         * 
         * @param placeType
         *        A <code>PlaceType</code> is a category that the result place must belong to.
         * @see PlaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlaceType
         */
        Builder placeType(PlaceType placeType);

        /**
         * <p>
         * The localized display name of this result item based on request parameter <code>language</code>.
         * </p>
         * 
         * @param title
         *        The localized display name of this result item based on request parameter <code>language</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The pricing bucket for which the query is charged at.
         * </p>
         * <p>
         * For more inforamtion on pricing, please visit <a href="https://aws.amazon.com/location/pricing/">Amazon
         * Location Service Pricing</a>.
         * </p>
         * 
         * @param pricingBucket
         *        The pricing bucket for which the query is charged at.</p>
         *        <p>
         *        For more inforamtion on pricing, please visit <a
         *        href="https://aws.amazon.com/location/pricing/">Amazon Location Service Pricing</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingBucket(String pricingBucket);

        /**
         * <p>
         * The place's address.
         * </p>
         * 
         * @param address
         *        The place's address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(Address address);

        /**
         * <p>
         * The place's address.
         * </p>
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #address(Address)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(Address)
         */
        default Builder address(Consumer<Address.Builder> address) {
            return address(Address.builder().applyMutation(address).build());
        }

        /**
         * <p>
         * Boolean indicating if the address provided has been corrected.
         * </p>
         * 
         * @param addressNumberCorrected
         *        Boolean indicating if the address provided has been corrected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressNumberCorrected(Boolean addressNumberCorrected);

        /**
         * <p>
         * Contains details about the postal code of the place/result.
         * </p>
         * 
         * @param postalCodeDetails
         *        Contains details about the postal code of the place/result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCodeDetails(Collection<PostalCodeDetails> postalCodeDetails);

        /**
         * <p>
         * Contains details about the postal code of the place/result.
         * </p>
         * 
         * @param postalCodeDetails
         *        Contains details about the postal code of the place/result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCodeDetails(PostalCodeDetails... postalCodeDetails);

        /**
         * <p>
         * Contains details about the postal code of the place/result.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.PostalCodeDetails.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.geoplaces.model.PostalCodeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.PostalCodeDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #postalCodeDetails(List<PostalCodeDetails>)}.
         * 
         * @param postalCodeDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.PostalCodeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postalCodeDetails(java.util.Collection<PostalCodeDetails>)
         */
        Builder postalCodeDetails(Consumer<PostalCodeDetails.Builder>... postalCodeDetails);

        /**
         * <p>
         * The position, in longitude and latitude.
         * </p>
         * 
         * @param position
         *        The position, in longitude and latitude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Collection<Double> position);

        /**
         * <p>
         * The position, in longitude and latitude.
         * </p>
         * 
         * @param position
         *        The position, in longitude and latitude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Double... position);

        /**
         * <p>
         * The bounding box enclosing the geometric shape (area or line) that an individual result covers.
         * </p>
         * <p>
         * The bounding box formed is defined as a set of four coordinates:
         * <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
         * </p>
         * 
         * @param mapView
         *        The bounding box enclosing the geometric shape (area or line) that an individual result covers.</p>
         *        <p>
         *        The bounding box formed is defined as a set of four coordinates:
         *        <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapView(Collection<Double> mapView);

        /**
         * <p>
         * The bounding box enclosing the geometric shape (area or line) that an individual result covers.
         * </p>
         * <p>
         * The bounding box formed is defined as a set of four coordinates:
         * <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
         * </p>
         * 
         * @param mapView
         *        The bounding box enclosing the geometric shape (area or line) that an individual result covers.</p>
         *        <p>
         *        The bounding box formed is defined as a set of four coordinates:
         *        <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapView(Double... mapView);

        /**
         * <p>
         * Categories of results that results must belong to.
         * </p>
         * 
         * @param categories
         *        Categories of results that results must belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Collection<Category> categories);

        /**
         * <p>
         * Categories of results that results must belong to.
         * </p>
         * 
         * @param categories
         *        Categories of results that results must belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Category... categories);

        /**
         * <p>
         * Categories of results that results must belong to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.Category.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.Category#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.Category.Builder#build()} is called immediately and
         * its result is passed to {@link #categories(List<Category>)}.
         * 
         * @param categories
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.Category.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categories(java.util.Collection<Category>)
         */
        Builder categories(Consumer<Category.Builder>... categories);

        /**
         * <p>
         * List of food types offered by this result.
         * </p>
         * 
         * @param foodTypes
         *        List of food types offered by this result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder foodTypes(Collection<FoodType> foodTypes);

        /**
         * <p>
         * List of food types offered by this result.
         * </p>
         * 
         * @param foodTypes
         *        List of food types offered by this result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder foodTypes(FoodType... foodTypes);

        /**
         * <p>
         * List of food types offered by this result.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.FoodType.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.FoodType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.FoodType.Builder#build()} is called immediately and
         * its result is passed to {@link #foodTypes(List<FoodType>)}.
         * 
         * @param foodTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.FoodType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #foodTypes(java.util.Collection<FoodType>)
         */
        Builder foodTypes(Consumer<FoodType.Builder>... foodTypes);

        /**
         * <p>
         * The Business Chains associated with the place.
         * </p>
         * 
         * @param businessChains
         *        The Business Chains associated with the place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessChains(Collection<BusinessChain> businessChains);

        /**
         * <p>
         * The Business Chains associated with the place.
         * </p>
         * 
         * @param businessChains
         *        The Business Chains associated with the place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessChains(BusinessChain... businessChains);

        /**
         * <p>
         * The Business Chains associated with the place.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.BusinessChain.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.BusinessChain#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.BusinessChain.Builder#build()} is called immediately
         * and its result is passed to {@link #businessChains(List<BusinessChain>)}.
         * 
         * @param businessChains
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.BusinessChain.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #businessChains(java.util.Collection<BusinessChain>)
         */
        Builder businessChains(Consumer<BusinessChain.Builder>... businessChains);

        /**
         * <p>
         * List of potential contact methods for the result/place.
         * </p>
         * 
         * @param contacts
         *        List of potential contact methods for the result/place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contacts(Contacts contacts);

        /**
         * <p>
         * List of potential contact methods for the result/place.
         * </p>
         * This is a convenience method that creates an instance of the {@link Contacts.Builder} avoiding the need to
         * create one manually via {@link Contacts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Contacts.Builder#build()} is called immediately and its result is
         * passed to {@link #contacts(Contacts)}.
         * 
         * @param contacts
         *        a consumer that will call methods on {@link Contacts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contacts(Contacts)
         */
        default Builder contacts(Consumer<Contacts.Builder> contacts) {
            return contacts(Contacts.builder().applyMutation(contacts).build());
        }

        /**
         * <p>
         * List of opening hours objects.
         * </p>
         * 
         * @param openingHours
         *        List of opening hours objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openingHours(Collection<OpeningHours> openingHours);

        /**
         * <p>
         * List of opening hours objects.
         * </p>
         * 
         * @param openingHours
         *        List of opening hours objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openingHours(OpeningHours... openingHours);

        /**
         * <p>
         * List of opening hours objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.OpeningHours.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.OpeningHours#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.OpeningHours.Builder#build()} is called immediately
         * and its result is passed to {@link #openingHours(List<OpeningHours>)}.
         * 
         * @param openingHours
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.OpeningHours.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openingHours(java.util.Collection<OpeningHours>)
         */
        Builder openingHours(Consumer<OpeningHours.Builder>... openingHours);

        /**
         * <p>
         * Position of the access point in <code>(lng,lat)</code>.
         * </p>
         * 
         * @param accessPoints
         *        Position of the access point in <code>(lng,lat)</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPoints(Collection<AccessPoint> accessPoints);

        /**
         * <p>
         * Position of the access point in <code>(lng,lat)</code>.
         * </p>
         * 
         * @param accessPoints
         *        Position of the access point in <code>(lng,lat)</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPoints(AccessPoint... accessPoints);

        /**
         * <p>
         * Position of the access point in <code>(lng,lat)</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.AccessPoint.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.AccessPoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.AccessPoint.Builder#build()} is called immediately and
         * its result is passed to {@link #accessPoints(List<AccessPoint>)}.
         * 
         * @param accessPoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.AccessPoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPoints(java.util.Collection<AccessPoint>)
         */
        Builder accessPoints(Consumer<AccessPoint.Builder>... accessPoints);

        /**
         * <p>
         * Indicates known access restrictions on a vehicle access point. The index correlates to an access point and
         * indicates if access through this point has some form of restriction.
         * </p>
         * 
         * @param accessRestrictions
         *        Indicates known access restrictions on a vehicle access point. The index correlates to an access point
         *        and indicates if access through this point has some form of restriction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessRestrictions(Collection<AccessRestriction> accessRestrictions);

        /**
         * <p>
         * Indicates known access restrictions on a vehicle access point. The index correlates to an access point and
         * indicates if access through this point has some form of restriction.
         * </p>
         * 
         * @param accessRestrictions
         *        Indicates known access restrictions on a vehicle access point. The index correlates to an access point
         *        and indicates if access through this point has some form of restriction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessRestrictions(AccessRestriction... accessRestrictions);

        /**
         * <p>
         * Indicates known access restrictions on a vehicle access point. The index correlates to an access point and
         * indicates if access through this point has some form of restriction.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.AccessRestriction.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.geoplaces.model.AccessRestriction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.AccessRestriction.Builder#build()} is called
         * immediately and its result is passed to {@link #accessRestrictions(List<AccessRestriction>)}.
         * 
         * @param accessRestrictions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.AccessRestriction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessRestrictions(java.util.Collection<AccessRestriction>)
         */
        Builder accessRestrictions(Consumer<AccessRestriction.Builder>... accessRestrictions);

        /**
         * <p>
         * The time zone in which the place is located.
         * </p>
         * 
         * @param timeZone
         *        The time zone in which the place is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZone(TimeZone timeZone);

        /**
         * <p>
         * The time zone in which the place is located.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeZone.Builder} avoiding the need to
         * create one manually via {@link TimeZone#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeZone.Builder#build()} is called immediately and its result is
         * passed to {@link #timeZone(TimeZone)}.
         * 
         * @param timeZone
         *        a consumer that will call methods on {@link TimeZone.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeZone(TimeZone)
         */
        default Builder timeZone(Consumer<TimeZone.Builder> timeZone) {
            return timeZone(TimeZone.builder().applyMutation(timeZone).build());
        }

        /**
         * <p>
         * The alpha-2 or alpha-3 character code for the political view of a country. The political view applies to the
         * results of the request to represent unresolved territorial claims through the point of view of the specified
         * country.
         * </p>
         * 
         * @param politicalView
         *        The alpha-2 or alpha-3 character code for the political view of a country. The political view applies
         *        to the results of the request to represent unresolved territorial claims through the point of view of
         *        the specified country.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder politicalView(String politicalView);

        /**
         * <p>
         * How the various components of the result's address are pronounced in various languages.
         * </p>
         * 
         * @param phonemes
         *        How the various components of the result's address are pronounced in various languages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phonemes(PhonemeDetails phonemes);

        /**
         * <p>
         * How the various components of the result's address are pronounced in various languages.
         * </p>
         * This is a convenience method that creates an instance of the {@link PhonemeDetails.Builder} avoiding the need
         * to create one manually via {@link PhonemeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PhonemeDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #phonemes(PhonemeDetails)}.
         * 
         * @param phonemes
         *        a consumer that will call methods on {@link PhonemeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phonemes(PhonemeDetails)
         */
        default Builder phonemes(Consumer<PhonemeDetails.Builder> phonemes) {
            return phonemes(PhonemeDetails.builder().applyMutation(phonemes).build());
        }
    }

    static final class BuilderImpl extends GeoPlacesResponse.BuilderImpl implements Builder {
        private String placeId;

        private String placeType;

        private String title;

        private String pricingBucket;

        private Address address;

        private Boolean addressNumberCorrected;

        private List<PostalCodeDetails> postalCodeDetails = DefaultSdkAutoConstructList.getInstance();

        private List<Double> position = DefaultSdkAutoConstructList.getInstance();

        private List<Double> mapView = DefaultSdkAutoConstructList.getInstance();

        private List<Category> categories = DefaultSdkAutoConstructList.getInstance();

        private List<FoodType> foodTypes = DefaultSdkAutoConstructList.getInstance();

        private List<BusinessChain> businessChains = DefaultSdkAutoConstructList.getInstance();

        private Contacts contacts;

        private List<OpeningHours> openingHours = DefaultSdkAutoConstructList.getInstance();

        private List<AccessPoint> accessPoints = DefaultSdkAutoConstructList.getInstance();

        private List<AccessRestriction> accessRestrictions = DefaultSdkAutoConstructList.getInstance();

        private TimeZone timeZone;

        private String politicalView;

        private PhonemeDetails phonemes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPlaceResponse model) {
            super(model);
            placeId(model.placeId);
            placeType(model.placeType);
            title(model.title);
            pricingBucket(model.pricingBucket);
            address(model.address);
            addressNumberCorrected(model.addressNumberCorrected);
            postalCodeDetails(model.postalCodeDetails);
            position(model.position);
            mapView(model.mapView);
            categories(model.categories);
            foodTypes(model.foodTypes);
            businessChains(model.businessChains);
            contacts(model.contacts);
            openingHours(model.openingHours);
            accessPoints(model.accessPoints);
            accessRestrictions(model.accessRestrictions);
            timeZone(model.timeZone);
            politicalView(model.politicalView);
            phonemes(model.phonemes);
        }

        public final String getPlaceId() {
            return placeId;
        }

        public final void setPlaceId(String placeId) {
            this.placeId = placeId;
        }

        @Override
        public final Builder placeId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        public final String getPlaceType() {
            return placeType;
        }

        public final void setPlaceType(String placeType) {
            this.placeType = placeType;
        }

        @Override
        public final Builder placeType(String placeType) {
            this.placeType = placeType;
            return this;
        }

        @Override
        public final Builder placeType(PlaceType placeType) {
            this.placeType(placeType == null ? null : placeType.toString());
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getPricingBucket() {
            return pricingBucket;
        }

        public final void setPricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
        }

        @Override
        public final Builder pricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
            return this;
        }

        public final Address.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final Boolean getAddressNumberCorrected() {
            return addressNumberCorrected;
        }

        public final void setAddressNumberCorrected(Boolean addressNumberCorrected) {
            this.addressNumberCorrected = addressNumberCorrected;
        }

        @Override
        public final Builder addressNumberCorrected(Boolean addressNumberCorrected) {
            this.addressNumberCorrected = addressNumberCorrected;
            return this;
        }

        public final List<PostalCodeDetails.Builder> getPostalCodeDetails() {
            List<PostalCodeDetails.Builder> result = PostalCodeDetailsListCopier.copyToBuilder(this.postalCodeDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPostalCodeDetails(Collection<PostalCodeDetails.BuilderImpl> postalCodeDetails) {
            this.postalCodeDetails = PostalCodeDetailsListCopier.copyFromBuilder(postalCodeDetails);
        }

        @Override
        public final Builder postalCodeDetails(Collection<PostalCodeDetails> postalCodeDetails) {
            this.postalCodeDetails = PostalCodeDetailsListCopier.copy(postalCodeDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder postalCodeDetails(PostalCodeDetails... postalCodeDetails) {
            postalCodeDetails(Arrays.asList(postalCodeDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder postalCodeDetails(Consumer<PostalCodeDetails.Builder>... postalCodeDetails) {
            postalCodeDetails(Stream.of(postalCodeDetails).map(c -> PostalCodeDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<Double> getPosition() {
            if (position instanceof SdkAutoConstructList) {
                return null;
            }
            return position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double... position) {
            position(Arrays.asList(position));
            return this;
        }

        public final Collection<Double> getMapView() {
            if (mapView instanceof SdkAutoConstructList) {
                return null;
            }
            return mapView;
        }

        public final void setMapView(Collection<Double> mapView) {
            this.mapView = BoundingBoxCopier.copy(mapView);
        }

        @Override
        public final Builder mapView(Collection<Double> mapView) {
            this.mapView = BoundingBoxCopier.copy(mapView);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapView(Double... mapView) {
            mapView(Arrays.asList(mapView));
            return this;
        }

        public final List<Category.Builder> getCategories() {
            List<Category.Builder> result = CategoryListCopier.copyToBuilder(this.categories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategories(Collection<Category.BuilderImpl> categories) {
            this.categories = CategoryListCopier.copyFromBuilder(categories);
        }

        @Override
        public final Builder categories(Collection<Category> categories) {
            this.categories = CategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Category... categories) {
            categories(Arrays.asList(categories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Consumer<Category.Builder>... categories) {
            categories(Stream.of(categories).map(c -> Category.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FoodType.Builder> getFoodTypes() {
            List<FoodType.Builder> result = FoodTypeListCopier.copyToBuilder(this.foodTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFoodTypes(Collection<FoodType.BuilderImpl> foodTypes) {
            this.foodTypes = FoodTypeListCopier.copyFromBuilder(foodTypes);
        }

        @Override
        public final Builder foodTypes(Collection<FoodType> foodTypes) {
            this.foodTypes = FoodTypeListCopier.copy(foodTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder foodTypes(FoodType... foodTypes) {
            foodTypes(Arrays.asList(foodTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder foodTypes(Consumer<FoodType.Builder>... foodTypes) {
            foodTypes(Stream.of(foodTypes).map(c -> FoodType.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BusinessChain.Builder> getBusinessChains() {
            List<BusinessChain.Builder> result = BusinessChainListCopier.copyToBuilder(this.businessChains);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBusinessChains(Collection<BusinessChain.BuilderImpl> businessChains) {
            this.businessChains = BusinessChainListCopier.copyFromBuilder(businessChains);
        }

        @Override
        public final Builder businessChains(Collection<BusinessChain> businessChains) {
            this.businessChains = BusinessChainListCopier.copy(businessChains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder businessChains(BusinessChain... businessChains) {
            businessChains(Arrays.asList(businessChains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder businessChains(Consumer<BusinessChain.Builder>... businessChains) {
            businessChains(Stream.of(businessChains).map(c -> BusinessChain.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Contacts.Builder getContacts() {
            return contacts != null ? contacts.toBuilder() : null;
        }

        public final void setContacts(Contacts.BuilderImpl contacts) {
            this.contacts = contacts != null ? contacts.build() : null;
        }

        @Override
        public final Builder contacts(Contacts contacts) {
            this.contacts = contacts;
            return this;
        }

        public final List<OpeningHours.Builder> getOpeningHours() {
            List<OpeningHours.Builder> result = OpeningHoursListCopier.copyToBuilder(this.openingHours);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOpeningHours(Collection<OpeningHours.BuilderImpl> openingHours) {
            this.openingHours = OpeningHoursListCopier.copyFromBuilder(openingHours);
        }

        @Override
        public final Builder openingHours(Collection<OpeningHours> openingHours) {
            this.openingHours = OpeningHoursListCopier.copy(openingHours);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder openingHours(OpeningHours... openingHours) {
            openingHours(Arrays.asList(openingHours));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder openingHours(Consumer<OpeningHours.Builder>... openingHours) {
            openingHours(Stream.of(openingHours).map(c -> OpeningHours.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AccessPoint.Builder> getAccessPoints() {
            List<AccessPoint.Builder> result = AccessPointListCopier.copyToBuilder(this.accessPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessPoints(Collection<AccessPoint.BuilderImpl> accessPoints) {
            this.accessPoints = AccessPointListCopier.copyFromBuilder(accessPoints);
        }

        @Override
        public final Builder accessPoints(Collection<AccessPoint> accessPoints) {
            this.accessPoints = AccessPointListCopier.copy(accessPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPoints(AccessPoint... accessPoints) {
            accessPoints(Arrays.asList(accessPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPoints(Consumer<AccessPoint.Builder>... accessPoints) {
            accessPoints(Stream.of(accessPoints).map(c -> AccessPoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AccessRestriction.Builder> getAccessRestrictions() {
            List<AccessRestriction.Builder> result = AccessRestrictionListCopier.copyToBuilder(this.accessRestrictions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessRestrictions(Collection<AccessRestriction.BuilderImpl> accessRestrictions) {
            this.accessRestrictions = AccessRestrictionListCopier.copyFromBuilder(accessRestrictions);
        }

        @Override
        public final Builder accessRestrictions(Collection<AccessRestriction> accessRestrictions) {
            this.accessRestrictions = AccessRestrictionListCopier.copy(accessRestrictions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessRestrictions(AccessRestriction... accessRestrictions) {
            accessRestrictions(Arrays.asList(accessRestrictions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessRestrictions(Consumer<AccessRestriction.Builder>... accessRestrictions) {
            accessRestrictions(Stream.of(accessRestrictions).map(c -> AccessRestriction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TimeZone.Builder getTimeZone() {
            return timeZone != null ? timeZone.toBuilder() : null;
        }

        public final void setTimeZone(TimeZone.BuilderImpl timeZone) {
            this.timeZone = timeZone != null ? timeZone.build() : null;
        }

        @Override
        public final Builder timeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final String getPoliticalView() {
            return politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final PhonemeDetails.Builder getPhonemes() {
            return phonemes != null ? phonemes.toBuilder() : null;
        }

        public final void setPhonemes(PhonemeDetails.BuilderImpl phonemes) {
            this.phonemes = phonemes != null ? phonemes.build() : null;
        }

        @Override
        public final Builder phonemes(PhonemeDetails phonemes) {
            this.phonemes = phonemes;
            return this;
        }

        @Override
        public GetPlaceResponse build() {
            return new GetPlaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
