/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List of opening hours objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpeningHours implements SdkPojo, Serializable, ToCopyableBuilder<OpeningHours.Builder, OpeningHours> {
    private static final SdkField<List<String>> DISPLAY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Display")
            .getter(getter(OpeningHours::display))
            .setter(setter(Builder::display))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Display").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> OPEN_NOW_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OpenNow").getter(getter(OpeningHours::openNow)).setter(setter(Builder::openNow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenNow").build()).build();

    private static final SdkField<List<OpeningHoursComponents>> COMPONENTS_FIELD = SdkField
            .<List<OpeningHoursComponents>> builder(MarshallingType.LIST)
            .memberName("Components")
            .getter(getter(OpeningHours::components))
            .setter(setter(Builder::components))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Components").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpeningHoursComponents> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpeningHoursComponents::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Category>> CATEGORIES_FIELD = SdkField
            .<List<Category>> builder(MarshallingType.LIST)
            .memberName("Categories")
            .getter(getter(OpeningHours::categories))
            .setter(setter(Builder::categories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Category> builder(MarshallingType.SDK_POJO)
                                            .constructor(Category::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_FIELD, OPEN_NOW_FIELD,
            COMPONENTS_FIELD, CATEGORIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> display;

    private final Boolean openNow;

    private final List<OpeningHoursComponents> components;

    private final List<Category> categories;

    private OpeningHours(BuilderImpl builder) {
        this.display = builder.display;
        this.openNow = builder.openNow;
        this.components = builder.components;
        this.categories = builder.categories;
    }

    /**
     * For responses, this returns true if the service returned a value for the Display property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDisplay() {
        return display != null && !(display instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of opening hours in the format they are displayed in. This can vary by result and in most cases represents
     * how the result uniquely formats their opening hours.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisplay} method.
     * </p>
     * 
     * @return List of opening hours in the format they are displayed in. This can vary by result and in most cases
     *         represents how the result uniquely formats their opening hours.
     */
    public final List<String> display() {
        return display;
    }

    /**
     * <p>
     * Boolean which indicates if the result/place is currently open.
     * </p>
     * 
     * @return Boolean which indicates if the result/place is currently open.
     */
    public final Boolean openNow() {
        return openNow;
    }

    /**
     * For responses, this returns true if the service returned a value for the Components property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasComponents() {
        return components != null && !(components instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Components of the opening hours object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComponents} method.
     * </p>
     * 
     * @return Components of the opening hours object.
     */
    public final List<OpeningHoursComponents> components() {
        return components;
    }

    /**
     * For responses, this returns true if the service returned a value for the Categories property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCategories() {
        return categories != null && !(categories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Categories of results that results must belong too.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategories} method.
     * </p>
     * 
     * @return Categories of results that results must belong too.
     */
    public final List<Category> categories() {
        return categories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDisplay() ? display() : null);
        hashCode = 31 * hashCode + Objects.hashCode(openNow());
        hashCode = 31 * hashCode + Objects.hashCode(hasComponents() ? components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCategories() ? categories() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpeningHours)) {
            return false;
        }
        OpeningHours other = (OpeningHours) obj;
        return hasDisplay() == other.hasDisplay() && Objects.equals(display(), other.display())
                && Objects.equals(openNow(), other.openNow()) && hasComponents() == other.hasComponents()
                && Objects.equals(components(), other.components()) && hasCategories() == other.hasCategories()
                && Objects.equals(categories(), other.categories());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpeningHours").add("Display", hasDisplay() ? display() : null).add("OpenNow", openNow())
                .add("Components", hasComponents() ? components() : null)
                .add("Categories", hasCategories() ? categories() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Display":
            return Optional.ofNullable(clazz.cast(display()));
        case "OpenNow":
            return Optional.ofNullable(clazz.cast(openNow()));
        case "Components":
            return Optional.ofNullable(clazz.cast(components()));
        case "Categories":
            return Optional.ofNullable(clazz.cast(categories()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Display", DISPLAY_FIELD);
        map.put("OpenNow", OPEN_NOW_FIELD);
        map.put("Components", COMPONENTS_FIELD);
        map.put("Categories", CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpeningHours, T> g) {
        return obj -> g.apply((OpeningHours) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpeningHours> {
        /**
         * <p>
         * List of opening hours in the format they are displayed in. This can vary by result and in most cases
         * represents how the result uniquely formats their opening hours.
         * </p>
         * 
         * @param display
         *        List of opening hours in the format they are displayed in. This can vary by result and in most cases
         *        represents how the result uniquely formats their opening hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder display(Collection<String> display);

        /**
         * <p>
         * List of opening hours in the format they are displayed in. This can vary by result and in most cases
         * represents how the result uniquely formats their opening hours.
         * </p>
         * 
         * @param display
         *        List of opening hours in the format they are displayed in. This can vary by result and in most cases
         *        represents how the result uniquely formats their opening hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder display(String... display);

        /**
         * <p>
         * Boolean which indicates if the result/place is currently open.
         * </p>
         * 
         * @param openNow
         *        Boolean which indicates if the result/place is currently open.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openNow(Boolean openNow);

        /**
         * <p>
         * Components of the opening hours object.
         * </p>
         * 
         * @param components
         *        Components of the opening hours object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(Collection<OpeningHoursComponents> components);

        /**
         * <p>
         * Components of the opening hours object.
         * </p>
         * 
         * @param components
         *        Components of the opening hours object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(OpeningHoursComponents... components);

        /**
         * <p>
         * Components of the opening hours object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.OpeningHoursComponents.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.OpeningHoursComponents#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.OpeningHoursComponents.Builder#build()} is called
         * immediately and its result is passed to {@link #components(List<OpeningHoursComponents>)}.
         * 
         * @param components
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.OpeningHoursComponents.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #components(java.util.Collection<OpeningHoursComponents>)
         */
        Builder components(Consumer<OpeningHoursComponents.Builder>... components);

        /**
         * <p>
         * Categories of results that results must belong too.
         * </p>
         * 
         * @param categories
         *        Categories of results that results must belong too.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Collection<Category> categories);

        /**
         * <p>
         * Categories of results that results must belong too.
         * </p>
         * 
         * @param categories
         *        Categories of results that results must belong too.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Category... categories);

        /**
         * <p>
         * Categories of results that results must belong too.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.Category.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.Category#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.Category.Builder#build()} is called immediately and
         * its result is passed to {@link #categories(List<Category>)}.
         * 
         * @param categories
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.Category.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categories(java.util.Collection<Category>)
         */
        Builder categories(Consumer<Category.Builder>... categories);
    }

    static final class BuilderImpl implements Builder {
        private List<String> display = DefaultSdkAutoConstructList.getInstance();

        private Boolean openNow;

        private List<OpeningHoursComponents> components = DefaultSdkAutoConstructList.getInstance();

        private List<Category> categories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpeningHours model) {
            display(model.display);
            openNow(model.openNow);
            components(model.components);
            categories(model.categories);
        }

        public final Collection<String> getDisplay() {
            if (display instanceof SdkAutoConstructList) {
                return null;
            }
            return display;
        }

        public final void setDisplay(Collection<String> display) {
            this.display = OpeningHoursDisplayListCopier.copy(display);
        }

        @Override
        public final Builder display(Collection<String> display) {
            this.display = OpeningHoursDisplayListCopier.copy(display);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder display(String... display) {
            display(Arrays.asList(display));
            return this;
        }

        public final Boolean getOpenNow() {
            return openNow;
        }

        public final void setOpenNow(Boolean openNow) {
            this.openNow = openNow;
        }

        @Override
        public final Builder openNow(Boolean openNow) {
            this.openNow = openNow;
            return this;
        }

        public final List<OpeningHoursComponents.Builder> getComponents() {
            List<OpeningHoursComponents.Builder> result = OpeningHoursComponentsListCopier.copyToBuilder(this.components);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponents(Collection<OpeningHoursComponents.BuilderImpl> components) {
            this.components = OpeningHoursComponentsListCopier.copyFromBuilder(components);
        }

        @Override
        public final Builder components(Collection<OpeningHoursComponents> components) {
            this.components = OpeningHoursComponentsListCopier.copy(components);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(OpeningHoursComponents... components) {
            components(Arrays.asList(components));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(Consumer<OpeningHoursComponents.Builder>... components) {
            components(Stream.of(components).map(c -> OpeningHoursComponents.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Category.Builder> getCategories() {
            List<Category.Builder> result = CategoryListCopier.copyToBuilder(this.categories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategories(Collection<Category.BuilderImpl> categories) {
            this.categories = CategoryListCopier.copyFromBuilder(categories);
        }

        @Override
        public final Builder categories(Collection<Category> categories) {
            this.categories = CategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Category... categories) {
            categories(Arrays.asList(categories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Consumer<Category.Builder>... categories) {
            categories(Stream.of(categories).map(c -> Category.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public OpeningHours build() {
            return new OpeningHours(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
