/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * SearchNearby structure which contains a set of inclusion/exclusion properties that results must posses in order to be
 * returned as a result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchNearbyFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchNearbyFilter.Builder, SearchNearbyFilter> {
    private static final SdkField<List<Double>> BOUNDING_BOX_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("BoundingBox")
            .getter(getter(SearchNearbyFilter::boundingBox))
            .setter(setter(Builder::boundingBox))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INCLUDE_COUNTRIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IncludeCountries")
            .getter(getter(SearchNearbyFilter::includeCountries))
            .setter(setter(Builder::includeCountries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeCountries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INCLUDE_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IncludeCategories")
            .getter(getter(SearchNearbyFilter::includeCategories))
            .setter(setter(Builder::includeCategories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDE_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludeCategories")
            .getter(getter(SearchNearbyFilter::excludeCategories))
            .setter(setter(Builder::excludeCategories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INCLUDE_BUSINESS_CHAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IncludeBusinessChains")
            .getter(getter(SearchNearbyFilter::includeBusinessChains))
            .setter(setter(Builder::includeBusinessChains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeBusinessChains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDE_BUSINESS_CHAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludeBusinessChains")
            .getter(getter(SearchNearbyFilter::excludeBusinessChains))
            .setter(setter(Builder::excludeBusinessChains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeBusinessChains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INCLUDE_FOOD_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IncludeFoodTypes")
            .getter(getter(SearchNearbyFilter::includeFoodTypes))
            .setter(setter(Builder::includeFoodTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeFoodTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDE_FOOD_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludeFoodTypes")
            .getter(getter(SearchNearbyFilter::excludeFoodTypes))
            .setter(setter(Builder::excludeFoodTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeFoodTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDING_BOX_FIELD,
            INCLUDE_COUNTRIES_FIELD, INCLUDE_CATEGORIES_FIELD, EXCLUDE_CATEGORIES_FIELD, INCLUDE_BUSINESS_CHAINS_FIELD,
            EXCLUDE_BUSINESS_CHAINS_FIELD, INCLUDE_FOOD_TYPES_FIELD, EXCLUDE_FOOD_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Double> boundingBox;

    private final List<String> includeCountries;

    private final List<String> includeCategories;

    private final List<String> excludeCategories;

    private final List<String> includeBusinessChains;

    private final List<String> excludeBusinessChains;

    private final List<String> includeFoodTypes;

    private final List<String> excludeFoodTypes;

    private SearchNearbyFilter(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.includeCountries = builder.includeCountries;
        this.includeCategories = builder.includeCategories;
        this.excludeCategories = builder.excludeCategories;
        this.includeBusinessChains = builder.includeBusinessChains;
        this.excludeBusinessChains = builder.excludeBusinessChains;
        this.includeFoodTypes = builder.includeFoodTypes;
        this.excludeFoodTypes = builder.excludeFoodTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the BoundingBox property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBoundingBox() {
        return boundingBox != null && !(boundingBox instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The bounding box enclosing the geometric shape (area or line) that an individual result covers.
     * </p>
     * <p>
     * The bounding box formed is defined as a set 4 coordinates:
     * <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBoundingBox} method.
     * </p>
     * 
     * @return The bounding box enclosing the geometric shape (area or line) that an individual result covers.</p>
     *         <p>
     *         The bounding box formed is defined as a set 4 coordinates:
     *         <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
     */
    public final List<Double> boundingBox() {
        return boundingBox;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncludeCountries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIncludeCountries() {
        return includeCountries != null && !(includeCountries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of countries that all results must be in. Countries are represented by either their alpha-2 or alpha-3
     * character codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludeCountries} method.
     * </p>
     * 
     * @return A list of countries that all results must be in. Countries are represented by either their alpha-2 or
     *         alpha-3 character codes.
     */
    public final List<String> includeCountries() {
        return includeCountries;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncludeCategories property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIncludeCategories() {
        return includeCategories != null && !(includeCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Categories of results that results must belong too.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludeCategories} method.
     * </p>
     * 
     * @return Categories of results that results must belong too.
     */
    public final List<String> includeCategories() {
        return includeCategories;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludeCategories property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludeCategories() {
        return excludeCategories != null && !(excludeCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Categories of results that results are excluded from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludeCategories} method.
     * </p>
     * 
     * @return Categories of results that results are excluded from.
     */
    public final List<String> excludeCategories() {
        return excludeCategories;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncludeBusinessChains property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIncludeBusinessChains() {
        return includeBusinessChains != null && !(includeBusinessChains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Business Chains associated with the place.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludeBusinessChains} method.
     * </p>
     * 
     * @return The Business Chains associated with the place.
     */
    public final List<String> includeBusinessChains() {
        return includeBusinessChains;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludeBusinessChains property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExcludeBusinessChains() {
        return excludeBusinessChains != null && !(excludeBusinessChains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Business Chains associated with the place.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludeBusinessChains} method.
     * </p>
     * 
     * @return The Business Chains associated with the place.
     */
    public final List<String> excludeBusinessChains() {
        return excludeBusinessChains;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncludeFoodTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIncludeFoodTypes() {
        return includeFoodTypes != null && !(includeFoodTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Food types that results are included from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludeFoodTypes} method.
     * </p>
     * 
     * @return Food types that results are included from.
     */
    public final List<String> includeFoodTypes() {
        return includeFoodTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludeFoodTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludeFoodTypes() {
        return excludeFoodTypes != null && !(excludeFoodTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Food types that results are excluded from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludeFoodTypes} method.
     * </p>
     * 
     * @return Food types that results are excluded from.
     */
    public final List<String> excludeFoodTypes() {
        return excludeFoodTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBoundingBox() ? boundingBox() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludeCountries() ? includeCountries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludeCategories() ? includeCategories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludeCategories() ? excludeCategories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludeBusinessChains() ? includeBusinessChains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludeBusinessChains() ? excludeBusinessChains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludeFoodTypes() ? includeFoodTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludeFoodTypes() ? excludeFoodTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchNearbyFilter)) {
            return false;
        }
        SearchNearbyFilter other = (SearchNearbyFilter) obj;
        return hasBoundingBox() == other.hasBoundingBox() && Objects.equals(boundingBox(), other.boundingBox())
                && hasIncludeCountries() == other.hasIncludeCountries()
                && Objects.equals(includeCountries(), other.includeCountries())
                && hasIncludeCategories() == other.hasIncludeCategories()
                && Objects.equals(includeCategories(), other.includeCategories())
                && hasExcludeCategories() == other.hasExcludeCategories()
                && Objects.equals(excludeCategories(), other.excludeCategories())
                && hasIncludeBusinessChains() == other.hasIncludeBusinessChains()
                && Objects.equals(includeBusinessChains(), other.includeBusinessChains())
                && hasExcludeBusinessChains() == other.hasExcludeBusinessChains()
                && Objects.equals(excludeBusinessChains(), other.excludeBusinessChains())
                && hasIncludeFoodTypes() == other.hasIncludeFoodTypes()
                && Objects.equals(includeFoodTypes(), other.includeFoodTypes())
                && hasExcludeFoodTypes() == other.hasExcludeFoodTypes()
                && Objects.equals(excludeFoodTypes(), other.excludeFoodTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchNearbyFilter")
                .add("BoundingBox", boundingBox() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IncludeCountries", hasIncludeCountries() ? includeCountries() : null)
                .add("IncludeCategories", hasIncludeCategories() ? includeCategories() : null)
                .add("ExcludeCategories", hasExcludeCategories() ? excludeCategories() : null)
                .add("IncludeBusinessChains", hasIncludeBusinessChains() ? includeBusinessChains() : null)
                .add("ExcludeBusinessChains", hasExcludeBusinessChains() ? excludeBusinessChains() : null)
                .add("IncludeFoodTypes", hasIncludeFoodTypes() ? includeFoodTypes() : null)
                .add("ExcludeFoodTypes", hasExcludeFoodTypes() ? excludeFoodTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BoundingBox":
            return Optional.ofNullable(clazz.cast(boundingBox()));
        case "IncludeCountries":
            return Optional.ofNullable(clazz.cast(includeCountries()));
        case "IncludeCategories":
            return Optional.ofNullable(clazz.cast(includeCategories()));
        case "ExcludeCategories":
            return Optional.ofNullable(clazz.cast(excludeCategories()));
        case "IncludeBusinessChains":
            return Optional.ofNullable(clazz.cast(includeBusinessChains()));
        case "ExcludeBusinessChains":
            return Optional.ofNullable(clazz.cast(excludeBusinessChains()));
        case "IncludeFoodTypes":
            return Optional.ofNullable(clazz.cast(includeFoodTypes()));
        case "ExcludeFoodTypes":
            return Optional.ofNullable(clazz.cast(excludeFoodTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BoundingBox", BOUNDING_BOX_FIELD);
        map.put("IncludeCountries", INCLUDE_COUNTRIES_FIELD);
        map.put("IncludeCategories", INCLUDE_CATEGORIES_FIELD);
        map.put("ExcludeCategories", EXCLUDE_CATEGORIES_FIELD);
        map.put("IncludeBusinessChains", INCLUDE_BUSINESS_CHAINS_FIELD);
        map.put("ExcludeBusinessChains", EXCLUDE_BUSINESS_CHAINS_FIELD);
        map.put("IncludeFoodTypes", INCLUDE_FOOD_TYPES_FIELD);
        map.put("ExcludeFoodTypes", EXCLUDE_FOOD_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchNearbyFilter, T> g) {
        return obj -> g.apply((SearchNearbyFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchNearbyFilter> {
        /**
         * <p>
         * The bounding box enclosing the geometric shape (area or line) that an individual result covers.
         * </p>
         * <p>
         * The bounding box formed is defined as a set 4 coordinates:
         * <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
         * </p>
         * 
         * @param boundingBox
         *        The bounding box enclosing the geometric shape (area or line) that an individual result covers.</p>
         *        <p>
         *        The bounding box formed is defined as a set 4 coordinates:
         *        <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(Collection<Double> boundingBox);

        /**
         * <p>
         * The bounding box enclosing the geometric shape (area or line) that an individual result covers.
         * </p>
         * <p>
         * The bounding box formed is defined as a set 4 coordinates:
         * <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
         * </p>
         * 
         * @param boundingBox
         *        The bounding box enclosing the geometric shape (area or line) that an individual result covers.</p>
         *        <p>
         *        The bounding box formed is defined as a set 4 coordinates:
         *        <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(Double... boundingBox);

        /**
         * <p>
         * A list of countries that all results must be in. Countries are represented by either their alpha-2 or alpha-3
         * character codes.
         * </p>
         * 
         * @param includeCountries
         *        A list of countries that all results must be in. Countries are represented by either their alpha-2 or
         *        alpha-3 character codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeCountries(Collection<String> includeCountries);

        /**
         * <p>
         * A list of countries that all results must be in. Countries are represented by either their alpha-2 or alpha-3
         * character codes.
         * </p>
         * 
         * @param includeCountries
         *        A list of countries that all results must be in. Countries are represented by either their alpha-2 or
         *        alpha-3 character codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeCountries(String... includeCountries);

        /**
         * <p>
         * Categories of results that results must belong too.
         * </p>
         * 
         * @param includeCategories
         *        Categories of results that results must belong too.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeCategories(Collection<String> includeCategories);

        /**
         * <p>
         * Categories of results that results must belong too.
         * </p>
         * 
         * @param includeCategories
         *        Categories of results that results must belong too.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeCategories(String... includeCategories);

        /**
         * <p>
         * Categories of results that results are excluded from.
         * </p>
         * 
         * @param excludeCategories
         *        Categories of results that results are excluded from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeCategories(Collection<String> excludeCategories);

        /**
         * <p>
         * Categories of results that results are excluded from.
         * </p>
         * 
         * @param excludeCategories
         *        Categories of results that results are excluded from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeCategories(String... excludeCategories);

        /**
         * <p>
         * The Business Chains associated with the place.
         * </p>
         * 
         * @param includeBusinessChains
         *        The Business Chains associated with the place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeBusinessChains(Collection<String> includeBusinessChains);

        /**
         * <p>
         * The Business Chains associated with the place.
         * </p>
         * 
         * @param includeBusinessChains
         *        The Business Chains associated with the place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeBusinessChains(String... includeBusinessChains);

        /**
         * <p>
         * The Business Chains associated with the place.
         * </p>
         * 
         * @param excludeBusinessChains
         *        The Business Chains associated with the place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeBusinessChains(Collection<String> excludeBusinessChains);

        /**
         * <p>
         * The Business Chains associated with the place.
         * </p>
         * 
         * @param excludeBusinessChains
         *        The Business Chains associated with the place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeBusinessChains(String... excludeBusinessChains);

        /**
         * <p>
         * Food types that results are included from.
         * </p>
         * 
         * @param includeFoodTypes
         *        Food types that results are included from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeFoodTypes(Collection<String> includeFoodTypes);

        /**
         * <p>
         * Food types that results are included from.
         * </p>
         * 
         * @param includeFoodTypes
         *        Food types that results are included from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeFoodTypes(String... includeFoodTypes);

        /**
         * <p>
         * Food types that results are excluded from.
         * </p>
         * 
         * @param excludeFoodTypes
         *        Food types that results are excluded from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeFoodTypes(Collection<String> excludeFoodTypes);

        /**
         * <p>
         * Food types that results are excluded from.
         * </p>
         * 
         * @param excludeFoodTypes
         *        Food types that results are excluded from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeFoodTypes(String... excludeFoodTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<Double> boundingBox = DefaultSdkAutoConstructList.getInstance();

        private List<String> includeCountries = DefaultSdkAutoConstructList.getInstance();

        private List<String> includeCategories = DefaultSdkAutoConstructList.getInstance();

        private List<String> excludeCategories = DefaultSdkAutoConstructList.getInstance();

        private List<String> includeBusinessChains = DefaultSdkAutoConstructList.getInstance();

        private List<String> excludeBusinessChains = DefaultSdkAutoConstructList.getInstance();

        private List<String> includeFoodTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> excludeFoodTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchNearbyFilter model) {
            boundingBox(model.boundingBox);
            includeCountries(model.includeCountries);
            includeCategories(model.includeCategories);
            excludeCategories(model.excludeCategories);
            includeBusinessChains(model.includeBusinessChains);
            excludeBusinessChains(model.excludeBusinessChains);
            includeFoodTypes(model.includeFoodTypes);
            excludeFoodTypes(model.excludeFoodTypes);
        }

        public final Collection<Double> getBoundingBox() {
            if (boundingBox instanceof SdkAutoConstructList) {
                return null;
            }
            return boundingBox;
        }

        public final void setBoundingBox(Collection<Double> boundingBox) {
            this.boundingBox = BoundingBoxCopier.copy(boundingBox);
        }

        @Override
        public final Builder boundingBox(Collection<Double> boundingBox) {
            this.boundingBox = BoundingBoxCopier.copy(boundingBox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder boundingBox(Double... boundingBox) {
            boundingBox(Arrays.asList(boundingBox));
            return this;
        }

        public final Collection<String> getIncludeCountries() {
            if (includeCountries instanceof SdkAutoConstructList) {
                return null;
            }
            return includeCountries;
        }

        public final void setIncludeCountries(Collection<String> includeCountries) {
            this.includeCountries = CountryCodeListCopier.copy(includeCountries);
        }

        @Override
        public final Builder includeCountries(Collection<String> includeCountries) {
            this.includeCountries = CountryCodeListCopier.copy(includeCountries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeCountries(String... includeCountries) {
            includeCountries(Arrays.asList(includeCountries));
            return this;
        }

        public final Collection<String> getIncludeCategories() {
            if (includeCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return includeCategories;
        }

        public final void setIncludeCategories(Collection<String> includeCategories) {
            this.includeCategories = FilterCategoryListCopier.copy(includeCategories);
        }

        @Override
        public final Builder includeCategories(Collection<String> includeCategories) {
            this.includeCategories = FilterCategoryListCopier.copy(includeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeCategories(String... includeCategories) {
            includeCategories(Arrays.asList(includeCategories));
            return this;
        }

        public final Collection<String> getExcludeCategories() {
            if (excludeCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return excludeCategories;
        }

        public final void setExcludeCategories(Collection<String> excludeCategories) {
            this.excludeCategories = FilterCategoryListCopier.copy(excludeCategories);
        }

        @Override
        public final Builder excludeCategories(Collection<String> excludeCategories) {
            this.excludeCategories = FilterCategoryListCopier.copy(excludeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeCategories(String... excludeCategories) {
            excludeCategories(Arrays.asList(excludeCategories));
            return this;
        }

        public final Collection<String> getIncludeBusinessChains() {
            if (includeBusinessChains instanceof SdkAutoConstructList) {
                return null;
            }
            return includeBusinessChains;
        }

        public final void setIncludeBusinessChains(Collection<String> includeBusinessChains) {
            this.includeBusinessChains = FilterBusinessChainListCopier.copy(includeBusinessChains);
        }

        @Override
        public final Builder includeBusinessChains(Collection<String> includeBusinessChains) {
            this.includeBusinessChains = FilterBusinessChainListCopier.copy(includeBusinessChains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeBusinessChains(String... includeBusinessChains) {
            includeBusinessChains(Arrays.asList(includeBusinessChains));
            return this;
        }

        public final Collection<String> getExcludeBusinessChains() {
            if (excludeBusinessChains instanceof SdkAutoConstructList) {
                return null;
            }
            return excludeBusinessChains;
        }

        public final void setExcludeBusinessChains(Collection<String> excludeBusinessChains) {
            this.excludeBusinessChains = FilterBusinessChainListCopier.copy(excludeBusinessChains);
        }

        @Override
        public final Builder excludeBusinessChains(Collection<String> excludeBusinessChains) {
            this.excludeBusinessChains = FilterBusinessChainListCopier.copy(excludeBusinessChains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeBusinessChains(String... excludeBusinessChains) {
            excludeBusinessChains(Arrays.asList(excludeBusinessChains));
            return this;
        }

        public final Collection<String> getIncludeFoodTypes() {
            if (includeFoodTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return includeFoodTypes;
        }

        public final void setIncludeFoodTypes(Collection<String> includeFoodTypes) {
            this.includeFoodTypes = FilterFoodTypeListCopier.copy(includeFoodTypes);
        }

        @Override
        public final Builder includeFoodTypes(Collection<String> includeFoodTypes) {
            this.includeFoodTypes = FilterFoodTypeListCopier.copy(includeFoodTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeFoodTypes(String... includeFoodTypes) {
            includeFoodTypes(Arrays.asList(includeFoodTypes));
            return this;
        }

        public final Collection<String> getExcludeFoodTypes() {
            if (excludeFoodTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return excludeFoodTypes;
        }

        public final void setExcludeFoodTypes(Collection<String> excludeFoodTypes) {
            this.excludeFoodTypes = FilterFoodTypeListCopier.copy(excludeFoodTypes);
        }

        @Override
        public final Builder excludeFoodTypes(Collection<String> excludeFoodTypes) {
            this.excludeFoodTypes = FilterFoodTypeListCopier.copy(excludeFoodTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeFoodTypes(String... excludeFoodTypes) {
            excludeFoodTypes(Arrays.asList(excludeFoodTypes));
            return this;
        }

        @Override
        public SearchNearbyFilter build() {
            return new SearchNearbyFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
