/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * SearchText structure which contains a set of inclusion/exclusion properties that results must posses in order to be
 * returned as a result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchTextFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchTextFilter.Builder, SearchTextFilter> {
    private static final SdkField<List<Double>> BOUNDING_BOX_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("BoundingBox")
            .getter(getter(SearchTextFilter::boundingBox))
            .setter(setter(Builder::boundingBox))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FilterCircle> CIRCLE_FIELD = SdkField.<FilterCircle> builder(MarshallingType.SDK_POJO)
            .memberName("Circle").getter(getter(SearchTextFilter::circle)).setter(setter(Builder::circle))
            .constructor(FilterCircle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Circle").build()).build();

    private static final SdkField<List<String>> INCLUDE_COUNTRIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IncludeCountries")
            .getter(getter(SearchTextFilter::includeCountries))
            .setter(setter(Builder::includeCountries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeCountries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDING_BOX_FIELD,
            CIRCLE_FIELD, INCLUDE_COUNTRIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Double> boundingBox;

    private final FilterCircle circle;

    private final List<String> includeCountries;

    private SearchTextFilter(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.circle = builder.circle;
        this.includeCountries = builder.includeCountries;
    }

    /**
     * For responses, this returns true if the service returned a value for the BoundingBox property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBoundingBox() {
        return boundingBox != null && !(boundingBox instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The bounding box enclosing the geometric shape (area or line) that an individual result covers.
     * </p>
     * <p>
     * The bounding box formed is defined as a set 4 coordinates:
     * <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBoundingBox} method.
     * </p>
     * 
     * @return The bounding box enclosing the geometric shape (area or line) that an individual result covers.</p>
     *         <p>
     *         The bounding box formed is defined as a set 4 coordinates:
     *         <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
     */
    public final List<Double> boundingBox() {
        return boundingBox;
    }

    /**
     * Returns the value of the Circle property for this object.
     * 
     * @return The value of the Circle property for this object.
     */
    public final FilterCircle circle() {
        return circle;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncludeCountries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIncludeCountries() {
        return includeCountries != null && !(includeCountries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of countries that all results must be in. Countries are represented by either their alpha-2 or alpha-3
     * character codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludeCountries} method.
     * </p>
     * 
     * @return A list of countries that all results must be in. Countries are represented by either their alpha-2 or
     *         alpha-3 character codes.
     */
    public final List<String> includeCountries() {
        return includeCountries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBoundingBox() ? boundingBox() : null);
        hashCode = 31 * hashCode + Objects.hashCode(circle());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludeCountries() ? includeCountries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTextFilter)) {
            return false;
        }
        SearchTextFilter other = (SearchTextFilter) obj;
        return hasBoundingBox() == other.hasBoundingBox() && Objects.equals(boundingBox(), other.boundingBox())
                && Objects.equals(circle(), other.circle()) && hasIncludeCountries() == other.hasIncludeCountries()
                && Objects.equals(includeCountries(), other.includeCountries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchTextFilter")
                .add("BoundingBox", boundingBox() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Circle", circle() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IncludeCountries", hasIncludeCountries() ? includeCountries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BoundingBox":
            return Optional.ofNullable(clazz.cast(boundingBox()));
        case "Circle":
            return Optional.ofNullable(clazz.cast(circle()));
        case "IncludeCountries":
            return Optional.ofNullable(clazz.cast(includeCountries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BoundingBox", BOUNDING_BOX_FIELD);
        map.put("Circle", CIRCLE_FIELD);
        map.put("IncludeCountries", INCLUDE_COUNTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchTextFilter, T> g) {
        return obj -> g.apply((SearchTextFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchTextFilter> {
        /**
         * <p>
         * The bounding box enclosing the geometric shape (area or line) that an individual result covers.
         * </p>
         * <p>
         * The bounding box formed is defined as a set 4 coordinates:
         * <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
         * </p>
         * 
         * @param boundingBox
         *        The bounding box enclosing the geometric shape (area or line) that an individual result covers.</p>
         *        <p>
         *        The bounding box formed is defined as a set 4 coordinates:
         *        <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(Collection<Double> boundingBox);

        /**
         * <p>
         * The bounding box enclosing the geometric shape (area or line) that an individual result covers.
         * </p>
         * <p>
         * The bounding box formed is defined as a set 4 coordinates:
         * <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
         * </p>
         * 
         * @param boundingBox
         *        The bounding box enclosing the geometric shape (area or line) that an individual result covers.</p>
         *        <p>
         *        The bounding box formed is defined as a set 4 coordinates:
         *        <code>[{westward lng}, {southern lat}, {eastward lng}, {northern lat}]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(Double... boundingBox);

        /**
         * Sets the value of the Circle property for this object.
         *
         * @param circle
         *        The new value for the Circle property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder circle(FilterCircle circle);

        /**
         * Sets the value of the Circle property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FilterCircle.Builder} avoiding the need
         * to create one manually via {@link FilterCircle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterCircle.Builder#build()} is called immediately and its
         * result is passed to {@link #circle(FilterCircle)}.
         * 
         * @param circle
         *        a consumer that will call methods on {@link FilterCircle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #circle(FilterCircle)
         */
        default Builder circle(Consumer<FilterCircle.Builder> circle) {
            return circle(FilterCircle.builder().applyMutation(circle).build());
        }

        /**
         * <p>
         * A list of countries that all results must be in. Countries are represented by either their alpha-2 or alpha-3
         * character codes.
         * </p>
         * 
         * @param includeCountries
         *        A list of countries that all results must be in. Countries are represented by either their alpha-2 or
         *        alpha-3 character codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeCountries(Collection<String> includeCountries);

        /**
         * <p>
         * A list of countries that all results must be in. Countries are represented by either their alpha-2 or alpha-3
         * character codes.
         * </p>
         * 
         * @param includeCountries
         *        A list of countries that all results must be in. Countries are represented by either their alpha-2 or
         *        alpha-3 character codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeCountries(String... includeCountries);
    }

    static final class BuilderImpl implements Builder {
        private List<Double> boundingBox = DefaultSdkAutoConstructList.getInstance();

        private FilterCircle circle;

        private List<String> includeCountries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTextFilter model) {
            boundingBox(model.boundingBox);
            circle(model.circle);
            includeCountries(model.includeCountries);
        }

        public final Collection<Double> getBoundingBox() {
            if (boundingBox instanceof SdkAutoConstructList) {
                return null;
            }
            return boundingBox;
        }

        public final void setBoundingBox(Collection<Double> boundingBox) {
            this.boundingBox = BoundingBoxCopier.copy(boundingBox);
        }

        @Override
        public final Builder boundingBox(Collection<Double> boundingBox) {
            this.boundingBox = BoundingBoxCopier.copy(boundingBox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder boundingBox(Double... boundingBox) {
            boundingBox(Arrays.asList(boundingBox));
            return this;
        }

        public final FilterCircle.Builder getCircle() {
            return circle != null ? circle.toBuilder() : null;
        }

        public final void setCircle(FilterCircle.BuilderImpl circle) {
            this.circle = circle != null ? circle.build() : null;
        }

        @Override
        public final Builder circle(FilterCircle circle) {
            this.circle = circle;
            return this;
        }

        public final Collection<String> getIncludeCountries() {
            if (includeCountries instanceof SdkAutoConstructList) {
                return null;
            }
            return includeCountries;
        }

        public final void setIncludeCountries(Collection<String> includeCountries) {
            this.includeCountries = CountryCodeListCopier.copy(includeCountries);
        }

        @Override
        public final Builder includeCountries(Collection<String> includeCountries) {
            this.includeCountries = CountryCodeListCopier.copy(includeCountries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeCountries(String... includeCountries) {
            includeCountries(Arrays.asList(includeCountries));
            return this;
        }

        @Override
        public SearchTextFilter build() {
            return new SearchTextFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
