/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuggestResponse extends GeoPlacesResponse implements
        ToCopyableBuilder<SuggestResponse.Builder, SuggestResponse> {
    private static final SdkField<String> PRICING_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingBucket").getter(getter(SuggestResponse::pricingBucket)).setter(setter(Builder::pricingBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-geo-pricing-bucket").build())
            .build();

    private static final SdkField<List<SuggestResultItem>> RESULT_ITEMS_FIELD = SdkField
            .<List<SuggestResultItem>> builder(MarshallingType.LIST)
            .memberName("ResultItems")
            .getter(getter(SuggestResponse::resultItems))
            .setter(setter(Builder::resultItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SuggestResultItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(SuggestResultItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<QueryRefinement>> QUERY_REFINEMENTS_FIELD = SdkField
            .<List<QueryRefinement>> builder(MarshallingType.LIST)
            .memberName("QueryRefinements")
            .getter(getter(SuggestResponse::queryRefinements))
            .setter(setter(Builder::queryRefinements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryRefinements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueryRefinement> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueryRefinement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICING_BUCKET_FIELD,
            RESULT_ITEMS_FIELD, QUERY_REFINEMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String pricingBucket;

    private final List<SuggestResultItem> resultItems;

    private final List<QueryRefinement> queryRefinements;

    private SuggestResponse(BuilderImpl builder) {
        super(builder);
        this.pricingBucket = builder.pricingBucket;
        this.resultItems = builder.resultItems;
        this.queryRefinements = builder.queryRefinements;
    }

    /**
     * <p>
     * The pricing bucket for which the query is charged at.
     * </p>
     * <p>
     * For more inforamtion on pricing, please visit <a href="https://aws.amazon.com/location/pricing/">Amazon Location
     * Service Pricing</a>.
     * </p>
     * 
     * @return The pricing bucket for which the query is charged at.</p>
     *         <p>
     *         For more inforamtion on pricing, please visit <a href="https://aws.amazon.com/location/pricing/">Amazon
     *         Location Service Pricing</a>.
     */
    public final String pricingBucket() {
        return pricingBucket;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResultItems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResultItems() {
        return resultItems != null && !(resultItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of places or results returned for a query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResultItems} method.
     * </p>
     * 
     * @return List of places or results returned for a query.
     */
    public final List<SuggestResultItem> resultItems() {
        return resultItems;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryRefinements property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQueryRefinements() {
        return queryRefinements != null && !(queryRefinements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Maximum number of query terms to be returned for use with a search text query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryRefinements} method.
     * </p>
     * 
     * @return Maximum number of query terms to be returned for use with a search text query.
     */
    public final List<QueryRefinement> queryRefinements() {
        return queryRefinements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pricingBucket());
        hashCode = 31 * hashCode + Objects.hashCode(hasResultItems() ? resultItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryRefinements() ? queryRefinements() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestResponse)) {
            return false;
        }
        SuggestResponse other = (SuggestResponse) obj;
        return Objects.equals(pricingBucket(), other.pricingBucket()) && hasResultItems() == other.hasResultItems()
                && Objects.equals(resultItems(), other.resultItems()) && hasQueryRefinements() == other.hasQueryRefinements()
                && Objects.equals(queryRefinements(), other.queryRefinements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuggestResponse").add("PricingBucket", pricingBucket())
                .add("ResultItems", hasResultItems() ? resultItems() : null)
                .add("QueryRefinements", hasQueryRefinements() ? queryRefinements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PricingBucket":
            return Optional.ofNullable(clazz.cast(pricingBucket()));
        case "ResultItems":
            return Optional.ofNullable(clazz.cast(resultItems()));
        case "QueryRefinements":
            return Optional.ofNullable(clazz.cast(queryRefinements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("x-amz-geo-pricing-bucket", PRICING_BUCKET_FIELD);
        map.put("ResultItems", RESULT_ITEMS_FIELD);
        map.put("QueryRefinements", QUERY_REFINEMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SuggestResponse, T> g) {
        return obj -> g.apply((SuggestResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GeoPlacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, SuggestResponse> {
        /**
         * <p>
         * The pricing bucket for which the query is charged at.
         * </p>
         * <p>
         * For more inforamtion on pricing, please visit <a href="https://aws.amazon.com/location/pricing/">Amazon
         * Location Service Pricing</a>.
         * </p>
         * 
         * @param pricingBucket
         *        The pricing bucket for which the query is charged at.</p>
         *        <p>
         *        For more inforamtion on pricing, please visit <a
         *        href="https://aws.amazon.com/location/pricing/">Amazon Location Service Pricing</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingBucket(String pricingBucket);

        /**
         * <p>
         * List of places or results returned for a query.
         * </p>
         * 
         * @param resultItems
         *        List of places or results returned for a query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultItems(Collection<SuggestResultItem> resultItems);

        /**
         * <p>
         * List of places or results returned for a query.
         * </p>
         * 
         * @param resultItems
         *        List of places or results returned for a query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultItems(SuggestResultItem... resultItems);

        /**
         * <p>
         * List of places or results returned for a query.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.SuggestResultItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.geoplaces.model.SuggestResultItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.SuggestResultItem.Builder#build()} is called
         * immediately and its result is passed to {@link #resultItems(List<SuggestResultItem>)}.
         * 
         * @param resultItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.SuggestResultItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultItems(java.util.Collection<SuggestResultItem>)
         */
        Builder resultItems(Consumer<SuggestResultItem.Builder>... resultItems);

        /**
         * <p>
         * Maximum number of query terms to be returned for use with a search text query.
         * </p>
         * 
         * @param queryRefinements
         *        Maximum number of query terms to be returned for use with a search text query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryRefinements(Collection<QueryRefinement> queryRefinements);

        /**
         * <p>
         * Maximum number of query terms to be returned for use with a search text query.
         * </p>
         * 
         * @param queryRefinements
         *        Maximum number of query terms to be returned for use with a search text query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryRefinements(QueryRefinement... queryRefinements);

        /**
         * <p>
         * Maximum number of query terms to be returned for use with a search text query.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.QueryRefinement.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.geoplaces.model.QueryRefinement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.QueryRefinement.Builder#build()} is called immediately
         * and its result is passed to {@link #queryRefinements(List<QueryRefinement>)}.
         * 
         * @param queryRefinements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.QueryRefinement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryRefinements(java.util.Collection<QueryRefinement>)
         */
        Builder queryRefinements(Consumer<QueryRefinement.Builder>... queryRefinements);
    }

    static final class BuilderImpl extends GeoPlacesResponse.BuilderImpl implements Builder {
        private String pricingBucket;

        private List<SuggestResultItem> resultItems = DefaultSdkAutoConstructList.getInstance();

        private List<QueryRefinement> queryRefinements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestResponse model) {
            super(model);
            pricingBucket(model.pricingBucket);
            resultItems(model.resultItems);
            queryRefinements(model.queryRefinements);
        }

        public final String getPricingBucket() {
            return pricingBucket;
        }

        public final void setPricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
        }

        @Override
        public final Builder pricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
            return this;
        }

        public final List<SuggestResultItem.Builder> getResultItems() {
            List<SuggestResultItem.Builder> result = SuggestResultItemListCopier.copyToBuilder(this.resultItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultItems(Collection<SuggestResultItem.BuilderImpl> resultItems) {
            this.resultItems = SuggestResultItemListCopier.copyFromBuilder(resultItems);
        }

        @Override
        public final Builder resultItems(Collection<SuggestResultItem> resultItems) {
            this.resultItems = SuggestResultItemListCopier.copy(resultItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(SuggestResultItem... resultItems) {
            resultItems(Arrays.asList(resultItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(Consumer<SuggestResultItem.Builder>... resultItems) {
            resultItems(Stream.of(resultItems).map(c -> SuggestResultItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<QueryRefinement.Builder> getQueryRefinements() {
            List<QueryRefinement.Builder> result = QueryRefinementListCopier.copyToBuilder(this.queryRefinements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryRefinements(Collection<QueryRefinement.BuilderImpl> queryRefinements) {
            this.queryRefinements = QueryRefinementListCopier.copyFromBuilder(queryRefinements);
        }

        @Override
        public final Builder queryRefinements(Collection<QueryRefinement> queryRefinements) {
            this.queryRefinements = QueryRefinementListCopier.copy(queryRefinements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryRefinements(QueryRefinement... queryRefinements) {
            queryRefinements(Arrays.asList(queryRefinements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryRefinements(Consumer<QueryRefinement.Builder>... queryRefinements) {
            queryRefinements(Stream.of(queryRefinements).map(c -> QueryRefinement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SuggestResponse build() {
            return new SuggestResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
