/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The USPS zip code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UspsZip implements SdkPojo, Serializable, ToCopyableBuilder<UspsZip.Builder, UspsZip> {
    private static final SdkField<String> ZIP_CLASSIFICATION_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ZipClassificationCode").getter(getter(UspsZip::zipClassificationCodeAsString))
            .setter(setter(Builder::zipClassificationCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZipClassificationCode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ZIP_CLASSIFICATION_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String zipClassificationCode;

    private UspsZip(BuilderImpl builder) {
        this.zipClassificationCode = builder.zipClassificationCode;
    }

    /**
     * <p>
     * The ZIP Classification Code, or in other words what type of postal code is it.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #zipClassificationCode} will return {@link ZipClassificationCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #zipClassificationCodeAsString}.
     * </p>
     * 
     * @return The ZIP Classification Code, or in other words what type of postal code is it.
     * @see ZipClassificationCode
     */
    public final ZipClassificationCode zipClassificationCode() {
        return ZipClassificationCode.fromValue(zipClassificationCode);
    }

    /**
     * <p>
     * The ZIP Classification Code, or in other words what type of postal code is it.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #zipClassificationCode} will return {@link ZipClassificationCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #zipClassificationCodeAsString}.
     * </p>
     * 
     * @return The ZIP Classification Code, or in other words what type of postal code is it.
     * @see ZipClassificationCode
     */
    public final String zipClassificationCodeAsString() {
        return zipClassificationCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(zipClassificationCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UspsZip)) {
            return false;
        }
        UspsZip other = (UspsZip) obj;
        return Objects.equals(zipClassificationCodeAsString(), other.zipClassificationCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UspsZip").add("ZipClassificationCode", zipClassificationCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ZipClassificationCode":
            return Optional.ofNullable(clazz.cast(zipClassificationCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ZipClassificationCode", ZIP_CLASSIFICATION_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UspsZip, T> g) {
        return obj -> g.apply((UspsZip) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UspsZip> {
        /**
         * <p>
         * The ZIP Classification Code, or in other words what type of postal code is it.
         * </p>
         * 
         * @param zipClassificationCode
         *        The ZIP Classification Code, or in other words what type of postal code is it.
         * @see ZipClassificationCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZipClassificationCode
         */
        Builder zipClassificationCode(String zipClassificationCode);

        /**
         * <p>
         * The ZIP Classification Code, or in other words what type of postal code is it.
         * </p>
         * 
         * @param zipClassificationCode
         *        The ZIP Classification Code, or in other words what type of postal code is it.
         * @see ZipClassificationCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZipClassificationCode
         */
        Builder zipClassificationCode(ZipClassificationCode zipClassificationCode);
    }

    static final class BuilderImpl implements Builder {
        private String zipClassificationCode;

        private BuilderImpl() {
        }

        private BuilderImpl(UspsZip model) {
            zipClassificationCode(model.zipClassificationCode);
        }

        public final String getZipClassificationCode() {
            return zipClassificationCode;
        }

        public final void setZipClassificationCode(String zipClassificationCode) {
            this.zipClassificationCode = zipClassificationCode;
        }

        @Override
        public final Builder zipClassificationCode(String zipClassificationCode) {
            this.zipClassificationCode = zipClassificationCode;
            return this;
        }

        @Override
        public final Builder zipClassificationCode(ZipClassificationCode zipClassificationCode) {
            this.zipClassificationCode(zipClassificationCode == null ? null : zipClassificationCode.toString());
            return this;
        }

        @Override
        public UspsZip build() {
            return new UspsZip(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
