/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * The Places API enables powerful location search and geocoding capabilities for your applications, offering global
 * coverage with rich, detailed information. Key features include:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Forward and reverse geocoding for addresses and coordinates
 * </p>
 * </li>
 * <li>
 * <p>
 * Comprehensive place searches with detailed information, including:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Business names and addresses
 * </p>
 * </li>
 * <li>
 * <p>
 * Contact information
 * </p>
 * </li>
 * <li>
 * <p>
 * Hours of operation
 * </p>
 * </li>
 * <li>
 * <p>
 * POI (Points of Interest) categories
 * </p>
 * </li>
 * <li>
 * <p>
 * Food types for restaurants
 * </p>
 * </li>
 * <li>
 * <p>
 * Chain affiliation for relevant businesses
 * </p>
 * </li>
 * </ul>
 * </li>
 * <li>
 * <p>
 * Global data coverage with a wide range of POI categories
 * </p>
 * </li>
 * <li>
 * <p>
 * Regular data updates to ensure accuracy and relevance
 * </p>
 * </li>
 * </ul>
 */
package software.amazon.awssdk.services.geoplaces;