/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.BoundingBoxCopier;
import software.amazon.awssdk.services.geoplaces.model.CountryCodeListCopier;
import software.amazon.awssdk.services.geoplaces.model.FilterBusinessChainListCopier;
import software.amazon.awssdk.services.geoplaces.model.FilterCategoryListCopier;
import software.amazon.awssdk.services.geoplaces.model.FilterFoodTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchNearbyFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchNearbyFilter> {
    private static final SdkField<List<Double>> BOUNDING_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BoundingBox").getter(SearchNearbyFilter.getter(SearchNearbyFilter::boundingBox)).setter(SearchNearbyFilter.setter(Builder::boundingBox)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUDE_COUNTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludeCountries").getter(SearchNearbyFilter.getter(SearchNearbyFilter::includeCountries)).setter(SearchNearbyFilter.setter(Builder::includeCountries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeCountries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUDE_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludeCategories").getter(SearchNearbyFilter.getter(SearchNearbyFilter::includeCategories)).setter(SearchNearbyFilter.setter(Builder::includeCategories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDE_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeCategories").getter(SearchNearbyFilter.getter(SearchNearbyFilter::excludeCategories)).setter(SearchNearbyFilter.setter(Builder::excludeCategories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUDE_BUSINESS_CHAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludeBusinessChains").getter(SearchNearbyFilter.getter(SearchNearbyFilter::includeBusinessChains)).setter(SearchNearbyFilter.setter(Builder::includeBusinessChains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeBusinessChains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDE_BUSINESS_CHAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeBusinessChains").getter(SearchNearbyFilter.getter(SearchNearbyFilter::excludeBusinessChains)).setter(SearchNearbyFilter.setter(Builder::excludeBusinessChains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeBusinessChains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUDE_FOOD_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludeFoodTypes").getter(SearchNearbyFilter.getter(SearchNearbyFilter::includeFoodTypes)).setter(SearchNearbyFilter.setter(Builder::includeFoodTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeFoodTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDE_FOOD_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeFoodTypes").getter(SearchNearbyFilter.getter(SearchNearbyFilter::excludeFoodTypes)).setter(SearchNearbyFilter.setter(Builder::excludeFoodTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeFoodTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDING_BOX_FIELD, INCLUDE_COUNTRIES_FIELD, INCLUDE_CATEGORIES_FIELD, EXCLUDE_CATEGORIES_FIELD, INCLUDE_BUSINESS_CHAINS_FIELD, EXCLUDE_BUSINESS_CHAINS_FIELD, INCLUDE_FOOD_TYPES_FIELD, EXCLUDE_FOOD_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchNearbyFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Double> boundingBox;
    private final List<String> includeCountries;
    private final List<String> includeCategories;
    private final List<String> excludeCategories;
    private final List<String> includeBusinessChains;
    private final List<String> excludeBusinessChains;
    private final List<String> includeFoodTypes;
    private final List<String> excludeFoodTypes;

    private SearchNearbyFilter(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.includeCountries = builder.includeCountries;
        this.includeCategories = builder.includeCategories;
        this.excludeCategories = builder.excludeCategories;
        this.includeBusinessChains = builder.includeBusinessChains;
        this.excludeBusinessChains = builder.excludeBusinessChains;
        this.includeFoodTypes = builder.includeFoodTypes;
        this.excludeFoodTypes = builder.excludeFoodTypes;
    }

    public final boolean hasBoundingBox() {
        return this.boundingBox != null && !(this.boundingBox instanceof SdkAutoConstructList);
    }

    public final List<Double> boundingBox() {
        return this.boundingBox;
    }

    public final boolean hasIncludeCountries() {
        return this.includeCountries != null && !(this.includeCountries instanceof SdkAutoConstructList);
    }

    public final List<String> includeCountries() {
        return this.includeCountries;
    }

    public final boolean hasIncludeCategories() {
        return this.includeCategories != null && !(this.includeCategories instanceof SdkAutoConstructList);
    }

    public final List<String> includeCategories() {
        return this.includeCategories;
    }

    public final boolean hasExcludeCategories() {
        return this.excludeCategories != null && !(this.excludeCategories instanceof SdkAutoConstructList);
    }

    public final List<String> excludeCategories() {
        return this.excludeCategories;
    }

    public final boolean hasIncludeBusinessChains() {
        return this.includeBusinessChains != null && !(this.includeBusinessChains instanceof SdkAutoConstructList);
    }

    public final List<String> includeBusinessChains() {
        return this.includeBusinessChains;
    }

    public final boolean hasExcludeBusinessChains() {
        return this.excludeBusinessChains != null && !(this.excludeBusinessChains instanceof SdkAutoConstructList);
    }

    public final List<String> excludeBusinessChains() {
        return this.excludeBusinessChains;
    }

    public final boolean hasIncludeFoodTypes() {
        return this.includeFoodTypes != null && !(this.includeFoodTypes instanceof SdkAutoConstructList);
    }

    public final List<String> includeFoodTypes() {
        return this.includeFoodTypes;
    }

    public final boolean hasExcludeFoodTypes() {
        return this.excludeFoodTypes != null && !(this.excludeFoodTypes instanceof SdkAutoConstructList);
    }

    public final List<String> excludeFoodTypes() {
        return this.excludeFoodTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBoundingBox() ? this.boundingBox() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeCountries() ? this.includeCountries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeCategories() ? this.includeCategories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeCategories() ? this.excludeCategories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeBusinessChains() ? this.includeBusinessChains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeBusinessChains() ? this.excludeBusinessChains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeFoodTypes() ? this.includeFoodTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeFoodTypes() ? this.excludeFoodTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchNearbyFilter)) {
            return false;
        }
        SearchNearbyFilter other = (SearchNearbyFilter)obj;
        return this.hasBoundingBox() == other.hasBoundingBox() && Objects.equals(this.boundingBox(), other.boundingBox()) && this.hasIncludeCountries() == other.hasIncludeCountries() && Objects.equals(this.includeCountries(), other.includeCountries()) && this.hasIncludeCategories() == other.hasIncludeCategories() && Objects.equals(this.includeCategories(), other.includeCategories()) && this.hasExcludeCategories() == other.hasExcludeCategories() && Objects.equals(this.excludeCategories(), other.excludeCategories()) && this.hasIncludeBusinessChains() == other.hasIncludeBusinessChains() && Objects.equals(this.includeBusinessChains(), other.includeBusinessChains()) && this.hasExcludeBusinessChains() == other.hasExcludeBusinessChains() && Objects.equals(this.excludeBusinessChains(), other.excludeBusinessChains()) && this.hasIncludeFoodTypes() == other.hasIncludeFoodTypes() && Objects.equals(this.includeFoodTypes(), other.includeFoodTypes()) && this.hasExcludeFoodTypes() == other.hasExcludeFoodTypes() && Objects.equals(this.excludeFoodTypes(), other.excludeFoodTypes());
    }

    public final String toString() {
        return ToString.builder((String)"SearchNearbyFilter").add("BoundingBox", (Object)(this.boundingBox() == null ? null : "*** Sensitive Data Redacted ***")).add("IncludeCountries", this.hasIncludeCountries() ? this.includeCountries() : null).add("IncludeCategories", this.hasIncludeCategories() ? this.includeCategories() : null).add("ExcludeCategories", this.hasExcludeCategories() ? this.excludeCategories() : null).add("IncludeBusinessChains", this.hasIncludeBusinessChains() ? this.includeBusinessChains() : null).add("ExcludeBusinessChains", this.hasExcludeBusinessChains() ? this.excludeBusinessChains() : null).add("IncludeFoodTypes", this.hasIncludeFoodTypes() ? this.includeFoodTypes() : null).add("ExcludeFoodTypes", this.hasExcludeFoodTypes() ? this.excludeFoodTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BoundingBox": {
                return Optional.ofNullable(clazz.cast(this.boundingBox()));
            }
            case "IncludeCountries": {
                return Optional.ofNullable(clazz.cast(this.includeCountries()));
            }
            case "IncludeCategories": {
                return Optional.ofNullable(clazz.cast(this.includeCategories()));
            }
            case "ExcludeCategories": {
                return Optional.ofNullable(clazz.cast(this.excludeCategories()));
            }
            case "IncludeBusinessChains": {
                return Optional.ofNullable(clazz.cast(this.includeBusinessChains()));
            }
            case "ExcludeBusinessChains": {
                return Optional.ofNullable(clazz.cast(this.excludeBusinessChains()));
            }
            case "IncludeFoodTypes": {
                return Optional.ofNullable(clazz.cast(this.includeFoodTypes()));
            }
            case "ExcludeFoodTypes": {
                return Optional.ofNullable(clazz.cast(this.excludeFoodTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BoundingBox", BOUNDING_BOX_FIELD);
        map.put("IncludeCountries", INCLUDE_COUNTRIES_FIELD);
        map.put("IncludeCategories", INCLUDE_CATEGORIES_FIELD);
        map.put("ExcludeCategories", EXCLUDE_CATEGORIES_FIELD);
        map.put("IncludeBusinessChains", INCLUDE_BUSINESS_CHAINS_FIELD);
        map.put("ExcludeBusinessChains", EXCLUDE_BUSINESS_CHAINS_FIELD);
        map.put("IncludeFoodTypes", INCLUDE_FOOD_TYPES_FIELD);
        map.put("ExcludeFoodTypes", EXCLUDE_FOOD_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchNearbyFilter, T> g) {
        return obj -> g.apply((SearchNearbyFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Double> boundingBox = DefaultSdkAutoConstructList.getInstance();
        private List<String> includeCountries = DefaultSdkAutoConstructList.getInstance();
        private List<String> includeCategories = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludeCategories = DefaultSdkAutoConstructList.getInstance();
        private List<String> includeBusinessChains = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludeBusinessChains = DefaultSdkAutoConstructList.getInstance();
        private List<String> includeFoodTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludeFoodTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchNearbyFilter model) {
            this.boundingBox(model.boundingBox);
            this.includeCountries(model.includeCountries);
            this.includeCategories(model.includeCategories);
            this.excludeCategories(model.excludeCategories);
            this.includeBusinessChains(model.includeBusinessChains);
            this.excludeBusinessChains(model.excludeBusinessChains);
            this.includeFoodTypes(model.includeFoodTypes);
            this.excludeFoodTypes(model.excludeFoodTypes);
        }

        public final Collection<Double> getBoundingBox() {
            if (this.boundingBox instanceof SdkAutoConstructList) {
                return null;
            }
            return this.boundingBox;
        }

        public final void setBoundingBox(Collection<Double> boundingBox) {
            this.boundingBox = BoundingBoxCopier.copy(boundingBox);
        }

        @Override
        public final Builder boundingBox(Collection<Double> boundingBox) {
            this.boundingBox = BoundingBoxCopier.copy(boundingBox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder boundingBox(Double ... boundingBox) {
            this.boundingBox(Arrays.asList(boundingBox));
            return this;
        }

        public final Collection<String> getIncludeCountries() {
            if (this.includeCountries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includeCountries;
        }

        public final void setIncludeCountries(Collection<String> includeCountries) {
            this.includeCountries = CountryCodeListCopier.copy(includeCountries);
        }

        @Override
        public final Builder includeCountries(Collection<String> includeCountries) {
            this.includeCountries = CountryCodeListCopier.copy(includeCountries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeCountries(String ... includeCountries) {
            this.includeCountries(Arrays.asList(includeCountries));
            return this;
        }

        public final Collection<String> getIncludeCategories() {
            if (this.includeCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includeCategories;
        }

        public final void setIncludeCategories(Collection<String> includeCategories) {
            this.includeCategories = FilterCategoryListCopier.copy(includeCategories);
        }

        @Override
        public final Builder includeCategories(Collection<String> includeCategories) {
            this.includeCategories = FilterCategoryListCopier.copy(includeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeCategories(String ... includeCategories) {
            this.includeCategories(Arrays.asList(includeCategories));
            return this;
        }

        public final Collection<String> getExcludeCategories() {
            if (this.excludeCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeCategories;
        }

        public final void setExcludeCategories(Collection<String> excludeCategories) {
            this.excludeCategories = FilterCategoryListCopier.copy(excludeCategories);
        }

        @Override
        public final Builder excludeCategories(Collection<String> excludeCategories) {
            this.excludeCategories = FilterCategoryListCopier.copy(excludeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeCategories(String ... excludeCategories) {
            this.excludeCategories(Arrays.asList(excludeCategories));
            return this;
        }

        public final Collection<String> getIncludeBusinessChains() {
            if (this.includeBusinessChains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includeBusinessChains;
        }

        public final void setIncludeBusinessChains(Collection<String> includeBusinessChains) {
            this.includeBusinessChains = FilterBusinessChainListCopier.copy(includeBusinessChains);
        }

        @Override
        public final Builder includeBusinessChains(Collection<String> includeBusinessChains) {
            this.includeBusinessChains = FilterBusinessChainListCopier.copy(includeBusinessChains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeBusinessChains(String ... includeBusinessChains) {
            this.includeBusinessChains(Arrays.asList(includeBusinessChains));
            return this;
        }

        public final Collection<String> getExcludeBusinessChains() {
            if (this.excludeBusinessChains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeBusinessChains;
        }

        public final void setExcludeBusinessChains(Collection<String> excludeBusinessChains) {
            this.excludeBusinessChains = FilterBusinessChainListCopier.copy(excludeBusinessChains);
        }

        @Override
        public final Builder excludeBusinessChains(Collection<String> excludeBusinessChains) {
            this.excludeBusinessChains = FilterBusinessChainListCopier.copy(excludeBusinessChains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeBusinessChains(String ... excludeBusinessChains) {
            this.excludeBusinessChains(Arrays.asList(excludeBusinessChains));
            return this;
        }

        public final Collection<String> getIncludeFoodTypes() {
            if (this.includeFoodTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includeFoodTypes;
        }

        public final void setIncludeFoodTypes(Collection<String> includeFoodTypes) {
            this.includeFoodTypes = FilterFoodTypeListCopier.copy(includeFoodTypes);
        }

        @Override
        public final Builder includeFoodTypes(Collection<String> includeFoodTypes) {
            this.includeFoodTypes = FilterFoodTypeListCopier.copy(includeFoodTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeFoodTypes(String ... includeFoodTypes) {
            this.includeFoodTypes(Arrays.asList(includeFoodTypes));
            return this;
        }

        public final Collection<String> getExcludeFoodTypes() {
            if (this.excludeFoodTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeFoodTypes;
        }

        public final void setExcludeFoodTypes(Collection<String> excludeFoodTypes) {
            this.excludeFoodTypes = FilterFoodTypeListCopier.copy(excludeFoodTypes);
        }

        @Override
        public final Builder excludeFoodTypes(Collection<String> excludeFoodTypes) {
            this.excludeFoodTypes = FilterFoodTypeListCopier.copy(excludeFoodTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeFoodTypes(String ... excludeFoodTypes) {
            this.excludeFoodTypes(Arrays.asList(excludeFoodTypes));
            return this;
        }

        public SearchNearbyFilter build() {
            return new SearchNearbyFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchNearbyFilter> {
        public Builder boundingBox(Collection<Double> var1);

        public Builder boundingBox(Double ... var1);

        public Builder includeCountries(Collection<String> var1);

        public Builder includeCountries(String ... var1);

        public Builder includeCategories(Collection<String> var1);

        public Builder includeCategories(String ... var1);

        public Builder excludeCategories(Collection<String> var1);

        public Builder excludeCategories(String ... var1);

        public Builder includeBusinessChains(Collection<String> var1);

        public Builder includeBusinessChains(String ... var1);

        public Builder excludeBusinessChains(Collection<String> var1);

        public Builder excludeBusinessChains(String ... var1);

        public Builder includeFoodTypes(Collection<String> var1);

        public Builder includeFoodTypes(String ... var1);

        public Builder excludeFoodTypes(Collection<String> var1);

        public Builder excludeFoodTypes(String ... var1);
    }
}

