/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.GeoPlacesRequest;
import software.amazon.awssdk.services.geoplaces.model.GeocodeAdditionalFeature;
import software.amazon.awssdk.services.geoplaces.model.GeocodeAdditionalFeatureListCopier;
import software.amazon.awssdk.services.geoplaces.model.GeocodeFilter;
import software.amazon.awssdk.services.geoplaces.model.GeocodeIntendedUse;
import software.amazon.awssdk.services.geoplaces.model.GeocodeQueryComponents;
import software.amazon.awssdk.services.geoplaces.model.PositionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeocodeRequest
extends GeoPlacesRequest
implements ToCopyableBuilder<Builder, GeocodeRequest> {
    private static final SdkField<String> QUERY_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryText").getter(GeocodeRequest.getter(GeocodeRequest::queryText)).setter(GeocodeRequest.setter(Builder::queryText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryText").build()}).build();
    private static final SdkField<GeocodeQueryComponents> QUERY_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryComponents").getter(GeocodeRequest.getter(GeocodeRequest::queryComponents)).setter(GeocodeRequest.setter(Builder::queryComponents)).constructor(GeocodeQueryComponents::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryComponents").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GeocodeRequest.getter(GeocodeRequest::maxResults)).setter(GeocodeRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<List<Double>> BIAS_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BiasPosition").getter(GeocodeRequest.getter(GeocodeRequest::biasPosition)).setter(GeocodeRequest.setter(Builder::biasPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BiasPosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GeocodeFilter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(GeocodeRequest.getter(GeocodeRequest::filter)).setter(GeocodeRequest.setter(Builder::filter)).constructor(GeocodeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalFeatures").getter(GeocodeRequest.getter(GeocodeRequest::additionalFeaturesAsStrings)).setter(GeocodeRequest.setter(Builder::additionalFeaturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalFeatures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Language").getter(GeocodeRequest.getter(GeocodeRequest::language)).setter(GeocodeRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()}).build();
    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoliticalView").getter(GeocodeRequest.getter(GeocodeRequest::politicalView)).setter(GeocodeRequest.setter(Builder::politicalView)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoliticalView").build()}).build();
    private static final SdkField<String> INTENDED_USE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntendedUse").getter(GeocodeRequest.getter(GeocodeRequest::intendedUseAsString)).setter(GeocodeRequest.setter(Builder::intendedUse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntendedUse").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(GeocodeRequest.getter(GeocodeRequest::key)).setter(GeocodeRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_TEXT_FIELD, QUERY_COMPONENTS_FIELD, MAX_RESULTS_FIELD, BIAS_POSITION_FIELD, FILTER_FIELD, ADDITIONAL_FEATURES_FIELD, LANGUAGE_FIELD, POLITICAL_VIEW_FIELD, INTENDED_USE_FIELD, KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GeocodeRequest.memberNameToFieldInitializer();
    private final String queryText;
    private final GeocodeQueryComponents queryComponents;
    private final Integer maxResults;
    private final List<Double> biasPosition;
    private final GeocodeFilter filter;
    private final List<String> additionalFeatures;
    private final String language;
    private final String politicalView;
    private final String intendedUse;
    private final String key;

    private GeocodeRequest(BuilderImpl builder) {
        super(builder);
        this.queryText = builder.queryText;
        this.queryComponents = builder.queryComponents;
        this.maxResults = builder.maxResults;
        this.biasPosition = builder.biasPosition;
        this.filter = builder.filter;
        this.additionalFeatures = builder.additionalFeatures;
        this.language = builder.language;
        this.politicalView = builder.politicalView;
        this.intendedUse = builder.intendedUse;
        this.key = builder.key;
    }

    public final String queryText() {
        return this.queryText;
    }

    public final GeocodeQueryComponents queryComponents() {
        return this.queryComponents;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasBiasPosition() {
        return this.biasPosition != null && !(this.biasPosition instanceof SdkAutoConstructList);
    }

    public final List<Double> biasPosition() {
        return this.biasPosition;
    }

    public final GeocodeFilter filter() {
        return this.filter;
    }

    public final List<GeocodeAdditionalFeature> additionalFeatures() {
        return GeocodeAdditionalFeatureListCopier.copyStringToEnum(this.additionalFeatures);
    }

    public final boolean hasAdditionalFeatures() {
        return this.additionalFeatures != null && !(this.additionalFeatures instanceof SdkAutoConstructList);
    }

    public final List<String> additionalFeaturesAsStrings() {
        return this.additionalFeatures;
    }

    public final String language() {
        return this.language;
    }

    public final String politicalView() {
        return this.politicalView;
    }

    public final GeocodeIntendedUse intendedUse() {
        return GeocodeIntendedUse.fromValue(this.intendedUse);
    }

    public final String intendedUseAsString() {
        return this.intendedUse;
    }

    public final String key() {
        return this.key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryText());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryComponents());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBiasPosition() ? this.biasPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalFeatures() ? this.additionalFeaturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(this.intendedUseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeocodeRequest)) {
            return false;
        }
        GeocodeRequest other = (GeocodeRequest)((Object)obj);
        return Objects.equals(this.queryText(), other.queryText()) && Objects.equals(this.queryComponents(), other.queryComponents()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasBiasPosition() == other.hasBiasPosition() && Objects.equals(this.biasPosition(), other.biasPosition()) && Objects.equals(this.filter(), other.filter()) && this.hasAdditionalFeatures() == other.hasAdditionalFeatures() && Objects.equals(this.additionalFeaturesAsStrings(), other.additionalFeaturesAsStrings()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.politicalView(), other.politicalView()) && Objects.equals(this.intendedUseAsString(), other.intendedUseAsString()) && Objects.equals(this.key(), other.key());
    }

    public final String toString() {
        return ToString.builder((String)"GeocodeRequest").add("QueryText", (Object)(this.queryText() == null ? null : "*** Sensitive Data Redacted ***")).add("QueryComponents", (Object)this.queryComponents()).add("MaxResults", (Object)this.maxResults()).add("BiasPosition", (Object)(this.biasPosition() == null ? null : "*** Sensitive Data Redacted ***")).add("Filter", (Object)this.filter()).add("AdditionalFeatures", this.hasAdditionalFeatures() ? this.additionalFeaturesAsStrings() : null).add("Language", (Object)this.language()).add("PoliticalView", (Object)this.politicalView()).add("IntendedUse", (Object)this.intendedUseAsString()).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryText": {
                return Optional.ofNullable(clazz.cast(this.queryText()));
            }
            case "QueryComponents": {
                return Optional.ofNullable(clazz.cast(this.queryComponents()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "BiasPosition": {
                return Optional.ofNullable(clazz.cast(this.biasPosition()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "AdditionalFeatures": {
                return Optional.ofNullable(clazz.cast(this.additionalFeaturesAsStrings()));
            }
            case "Language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "PoliticalView": {
                return Optional.ofNullable(clazz.cast(this.politicalView()));
            }
            case "IntendedUse": {
                return Optional.ofNullable(clazz.cast(this.intendedUseAsString()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("QueryText", QUERY_TEXT_FIELD);
        map.put("QueryComponents", QUERY_COMPONENTS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("BiasPosition", BIAS_POSITION_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("AdditionalFeatures", ADDITIONAL_FEATURES_FIELD);
        map.put("Language", LANGUAGE_FIELD);
        map.put("PoliticalView", POLITICAL_VIEW_FIELD);
        map.put("IntendedUse", INTENDED_USE_FIELD);
        map.put("key", KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeocodeRequest, T> g) {
        return obj -> g.apply((GeocodeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoPlacesRequest.BuilderImpl
    implements Builder {
        private String queryText;
        private GeocodeQueryComponents queryComponents;
        private Integer maxResults;
        private List<Double> biasPosition = DefaultSdkAutoConstructList.getInstance();
        private GeocodeFilter filter;
        private List<String> additionalFeatures = DefaultSdkAutoConstructList.getInstance();
        private String language;
        private String politicalView;
        private String intendedUse;
        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(GeocodeRequest model) {
            super(model);
            this.queryText(model.queryText);
            this.queryComponents(model.queryComponents);
            this.maxResults(model.maxResults);
            this.biasPosition(model.biasPosition);
            this.filter(model.filter);
            this.additionalFeaturesWithStrings(model.additionalFeatures);
            this.language(model.language);
            this.politicalView(model.politicalView);
            this.intendedUse(model.intendedUse);
            this.key(model.key);
        }

        public final String getQueryText() {
            return this.queryText;
        }

        public final void setQueryText(String queryText) {
            this.queryText = queryText;
        }

        @Override
        public final Builder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public final GeocodeQueryComponents.Builder getQueryComponents() {
            return this.queryComponents != null ? this.queryComponents.toBuilder() : null;
        }

        public final void setQueryComponents(GeocodeQueryComponents.BuilderImpl queryComponents) {
            this.queryComponents = queryComponents != null ? queryComponents.build() : null;
        }

        @Override
        public final Builder queryComponents(GeocodeQueryComponents queryComponents) {
            this.queryComponents = queryComponents;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<Double> getBiasPosition() {
            if (this.biasPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.biasPosition;
        }

        public final void setBiasPosition(Collection<Double> biasPosition) {
            this.biasPosition = PositionCopier.copy(biasPosition);
        }

        @Override
        public final Builder biasPosition(Collection<Double> biasPosition) {
            this.biasPosition = PositionCopier.copy(biasPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder biasPosition(Double ... biasPosition) {
            this.biasPosition(Arrays.asList(biasPosition));
            return this;
        }

        public final GeocodeFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(GeocodeFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(GeocodeFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Collection<String> getAdditionalFeatures() {
            if (this.additionalFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalFeatures;
        }

        public final void setAdditionalFeatures(Collection<String> additionalFeatures) {
            this.additionalFeatures = GeocodeAdditionalFeatureListCopier.copy(additionalFeatures);
        }

        @Override
        public final Builder additionalFeaturesWithStrings(Collection<String> additionalFeatures) {
            this.additionalFeatures = GeocodeAdditionalFeatureListCopier.copy(additionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalFeaturesWithStrings(String ... additionalFeatures) {
            this.additionalFeaturesWithStrings(Arrays.asList(additionalFeatures));
            return this;
        }

        @Override
        public final Builder additionalFeatures(Collection<GeocodeAdditionalFeature> additionalFeatures) {
            this.additionalFeatures = GeocodeAdditionalFeatureListCopier.copyEnumToString(additionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalFeatures(GeocodeAdditionalFeature ... additionalFeatures) {
            this.additionalFeatures(Arrays.asList(additionalFeatures));
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getPoliticalView() {
            return this.politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final String getIntendedUse() {
            return this.intendedUse;
        }

        public final void setIntendedUse(String intendedUse) {
            this.intendedUse = intendedUse;
        }

        @Override
        public final Builder intendedUse(String intendedUse) {
            this.intendedUse = intendedUse;
            return this;
        }

        @Override
        public final Builder intendedUse(GeocodeIntendedUse intendedUse) {
            this.intendedUse(intendedUse == null ? null : intendedUse.toString());
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GeocodeRequest build() {
            return new GeocodeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GeoPlacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GeocodeRequest> {
        public Builder queryText(String var1);

        public Builder queryComponents(GeocodeQueryComponents var1);

        default public Builder queryComponents(Consumer<GeocodeQueryComponents.Builder> queryComponents) {
            return this.queryComponents((GeocodeQueryComponents)((GeocodeQueryComponents.Builder)GeocodeQueryComponents.builder().applyMutation(queryComponents)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder biasPosition(Collection<Double> var1);

        public Builder biasPosition(Double ... var1);

        public Builder filter(GeocodeFilter var1);

        default public Builder filter(Consumer<GeocodeFilter.Builder> filter) {
            return this.filter((GeocodeFilter)((GeocodeFilter.Builder)GeocodeFilter.builder().applyMutation(filter)).build());
        }

        public Builder additionalFeaturesWithStrings(Collection<String> var1);

        public Builder additionalFeaturesWithStrings(String ... var1);

        public Builder additionalFeatures(Collection<GeocodeAdditionalFeature> var1);

        public Builder additionalFeatures(GeocodeAdditionalFeature ... var1);

        public Builder language(String var1);

        public Builder politicalView(String var1);

        public Builder intendedUse(String var1);

        public Builder intendedUse(GeocodeIntendedUse var1);

        public Builder key(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

