/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.GeoPlacesRequest;
import software.amazon.awssdk.services.geoplaces.model.GetPlaceAdditionalFeature;
import software.amazon.awssdk.services.geoplaces.model.GetPlaceAdditionalFeatureListCopier;
import software.amazon.awssdk.services.geoplaces.model.GetPlaceIntendedUse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPlaceRequest
extends GeoPlacesRequest
implements ToCopyableBuilder<Builder, GetPlaceRequest> {
    private static final SdkField<String> PLACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaceId").getter(GetPlaceRequest.getter(GetPlaceRequest::placeId)).setter(GetPlaceRequest.setter(Builder::placeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("PlaceId").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalFeatures").getter(GetPlaceRequest.getter(GetPlaceRequest::additionalFeaturesAsStrings)).setter(GetPlaceRequest.setter(Builder::additionalFeaturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("additional-features").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Language").getter(GetPlaceRequest.getter(GetPlaceRequest::language)).setter(GetPlaceRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("language").build()}).build();
    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoliticalView").getter(GetPlaceRequest.getter(GetPlaceRequest::politicalView)).setter(GetPlaceRequest.setter(Builder::politicalView)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("political-view").build()}).build();
    private static final SdkField<String> INTENDED_USE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntendedUse").getter(GetPlaceRequest.getter(GetPlaceRequest::intendedUseAsString)).setter(GetPlaceRequest.setter(Builder::intendedUse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("intended-use").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(GetPlaceRequest.getter(GetPlaceRequest::key)).setter(GetPlaceRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACE_ID_FIELD, ADDITIONAL_FEATURES_FIELD, LANGUAGE_FIELD, POLITICAL_VIEW_FIELD, INTENDED_USE_FIELD, KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPlaceRequest.memberNameToFieldInitializer();
    private final String placeId;
    private final List<String> additionalFeatures;
    private final String language;
    private final String politicalView;
    private final String intendedUse;
    private final String key;

    private GetPlaceRequest(BuilderImpl builder) {
        super(builder);
        this.placeId = builder.placeId;
        this.additionalFeatures = builder.additionalFeatures;
        this.language = builder.language;
        this.politicalView = builder.politicalView;
        this.intendedUse = builder.intendedUse;
        this.key = builder.key;
    }

    public final String placeId() {
        return this.placeId;
    }

    public final List<GetPlaceAdditionalFeature> additionalFeatures() {
        return GetPlaceAdditionalFeatureListCopier.copyStringToEnum(this.additionalFeatures);
    }

    public final boolean hasAdditionalFeatures() {
        return this.additionalFeatures != null && !(this.additionalFeatures instanceof SdkAutoConstructList);
    }

    public final List<String> additionalFeaturesAsStrings() {
        return this.additionalFeatures;
    }

    public final String language() {
        return this.language;
    }

    public final String politicalView() {
        return this.politicalView;
    }

    public final GetPlaceIntendedUse intendedUse() {
        return GetPlaceIntendedUse.fromValue(this.intendedUse);
    }

    public final String intendedUseAsString() {
        return this.intendedUse;
    }

    public final String key() {
        return this.key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.placeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalFeatures() ? this.additionalFeaturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(this.intendedUseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPlaceRequest)) {
            return false;
        }
        GetPlaceRequest other = (GetPlaceRequest)((Object)obj);
        return Objects.equals(this.placeId(), other.placeId()) && this.hasAdditionalFeatures() == other.hasAdditionalFeatures() && Objects.equals(this.additionalFeaturesAsStrings(), other.additionalFeaturesAsStrings()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.politicalView(), other.politicalView()) && Objects.equals(this.intendedUseAsString(), other.intendedUseAsString()) && Objects.equals(this.key(), other.key());
    }

    public final String toString() {
        return ToString.builder((String)"GetPlaceRequest").add("PlaceId", (Object)(this.placeId() == null ? null : "*** Sensitive Data Redacted ***")).add("AdditionalFeatures", this.hasAdditionalFeatures() ? this.additionalFeaturesAsStrings() : null).add("Language", (Object)this.language()).add("PoliticalView", (Object)this.politicalView()).add("IntendedUse", (Object)this.intendedUseAsString()).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlaceId": {
                return Optional.ofNullable(clazz.cast(this.placeId()));
            }
            case "AdditionalFeatures": {
                return Optional.ofNullable(clazz.cast(this.additionalFeaturesAsStrings()));
            }
            case "Language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "PoliticalView": {
                return Optional.ofNullable(clazz.cast(this.politicalView()));
            }
            case "IntendedUse": {
                return Optional.ofNullable(clazz.cast(this.intendedUseAsString()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PlaceId", PLACE_ID_FIELD);
        map.put("additional-features", ADDITIONAL_FEATURES_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("political-view", POLITICAL_VIEW_FIELD);
        map.put("intended-use", INTENDED_USE_FIELD);
        map.put("key", KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPlaceRequest, T> g) {
        return obj -> g.apply((GetPlaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoPlacesRequest.BuilderImpl
    implements Builder {
        private String placeId;
        private List<String> additionalFeatures = DefaultSdkAutoConstructList.getInstance();
        private String language;
        private String politicalView;
        private String intendedUse;
        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPlaceRequest model) {
            super(model);
            this.placeId(model.placeId);
            this.additionalFeaturesWithStrings(model.additionalFeatures);
            this.language(model.language);
            this.politicalView(model.politicalView);
            this.intendedUse(model.intendedUse);
            this.key(model.key);
        }

        public final String getPlaceId() {
            return this.placeId;
        }

        public final void setPlaceId(String placeId) {
            this.placeId = placeId;
        }

        @Override
        public final Builder placeId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        public final Collection<String> getAdditionalFeatures() {
            if (this.additionalFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalFeatures;
        }

        public final void setAdditionalFeatures(Collection<String> additionalFeatures) {
            this.additionalFeatures = GetPlaceAdditionalFeatureListCopier.copy(additionalFeatures);
        }

        @Override
        public final Builder additionalFeaturesWithStrings(Collection<String> additionalFeatures) {
            this.additionalFeatures = GetPlaceAdditionalFeatureListCopier.copy(additionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalFeaturesWithStrings(String ... additionalFeatures) {
            this.additionalFeaturesWithStrings(Arrays.asList(additionalFeatures));
            return this;
        }

        @Override
        public final Builder additionalFeatures(Collection<GetPlaceAdditionalFeature> additionalFeatures) {
            this.additionalFeatures = GetPlaceAdditionalFeatureListCopier.copyEnumToString(additionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalFeatures(GetPlaceAdditionalFeature ... additionalFeatures) {
            this.additionalFeatures(Arrays.asList(additionalFeatures));
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getPoliticalView() {
            return this.politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final String getIntendedUse() {
            return this.intendedUse;
        }

        public final void setIntendedUse(String intendedUse) {
            this.intendedUse = intendedUse;
        }

        @Override
        public final Builder intendedUse(String intendedUse) {
            this.intendedUse = intendedUse;
            return this;
        }

        @Override
        public final Builder intendedUse(GetPlaceIntendedUse intendedUse) {
            this.intendedUse(intendedUse == null ? null : intendedUse.toString());
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPlaceRequest build() {
            return new GetPlaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GeoPlacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPlaceRequest> {
        public Builder placeId(String var1);

        public Builder additionalFeaturesWithStrings(Collection<String> var1);

        public Builder additionalFeaturesWithStrings(String ... var1);

        public Builder additionalFeatures(Collection<GetPlaceAdditionalFeature> var1);

        public Builder additionalFeatures(GetPlaceAdditionalFeature ... var1);

        public Builder language(String var1);

        public Builder politicalView(String var1);

        public Builder intendedUse(String var1);

        public Builder intendedUse(GetPlaceIntendedUse var1);

        public Builder key(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

