/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.AccessPoint;
import software.amazon.awssdk.services.geoplaces.model.AccessPointListCopier;
import software.amazon.awssdk.services.geoplaces.model.AccessRestriction;
import software.amazon.awssdk.services.geoplaces.model.AccessRestrictionListCopier;
import software.amazon.awssdk.services.geoplaces.model.Address;
import software.amazon.awssdk.services.geoplaces.model.BoundingBoxCopier;
import software.amazon.awssdk.services.geoplaces.model.BusinessChain;
import software.amazon.awssdk.services.geoplaces.model.BusinessChainListCopier;
import software.amazon.awssdk.services.geoplaces.model.Category;
import software.amazon.awssdk.services.geoplaces.model.CategoryListCopier;
import software.amazon.awssdk.services.geoplaces.model.Contacts;
import software.amazon.awssdk.services.geoplaces.model.FoodType;
import software.amazon.awssdk.services.geoplaces.model.FoodTypeListCopier;
import software.amazon.awssdk.services.geoplaces.model.OpeningHours;
import software.amazon.awssdk.services.geoplaces.model.OpeningHoursListCopier;
import software.amazon.awssdk.services.geoplaces.model.PhonemeDetails;
import software.amazon.awssdk.services.geoplaces.model.PlaceType;
import software.amazon.awssdk.services.geoplaces.model.PositionCopier;
import software.amazon.awssdk.services.geoplaces.model.TimeZone;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchNearbyResultItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchNearbyResultItem> {
    private static final SdkField<String> PLACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaceId").getter(SearchNearbyResultItem.getter(SearchNearbyResultItem::placeId)).setter(SearchNearbyResultItem.setter(Builder::placeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceId").build()}).build();
    private static final SdkField<String> PLACE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaceType").getter(SearchNearbyResultItem.getter(SearchNearbyResultItem::placeTypeAsString)).setter(SearchNearbyResultItem.setter(Builder::placeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceType").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(SearchNearbyResultItem.getter(SearchNearbyResultItem::title)).setter(SearchNearbyResultItem.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<Address> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Address").getter(SearchNearbyResultItem.getter(SearchNearbyResultItem::address)).setter(SearchNearbyResultItem.setter(Builder::address)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final SdkField<Boolean> ADDRESS_NUMBER_CORRECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AddressNumberCorrected").getter(SearchNearbyResultItem.getter(SearchNearbyResultItem::addressNumberCorrected)).setter(SearchNearbyResultItem.setter(Builder::addressNumberCorrected)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressNumberCorrected").build()}).build();
    private static final SdkField<List<Double>> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Position").getter(SearchNearbyResultItem.getter(SearchNearbyResultItem::position)).setter(SearchNearbyResultItem.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Distance").getter(SearchNearbyResultItem.getter(SearchNearbyResultItem::distance)).setter(SearchNearbyResultItem.setter(Builder::distance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()}).build();
    private static final SdkField<List<Double>> MAP_VIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MapView").getter(SearchNearbyResultItem.getter(SearchNearbyResultItem::mapView)).setter(SearchNearbyResultItem.setter(Builder::mapView)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapView").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Category>> CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Categories").getter(SearchNearbyResultItem.getter(SearchNearbyResultItem::categories)).setter(SearchNearbyResultItem.setter(Builder::categories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Category::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FoodType>> FOOD_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FoodTypes").getter(SearchNearbyResultItem.getter(SearchNearbyResultItem::foodTypes)).setter(SearchNearbyResultItem.setter(Builder::foodTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FoodTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FoodType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BusinessChain>> BUSINESS_CHAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BusinessChains").getter(SearchNearbyResultItem.getter(SearchNearbyResultItem::businessChains)).setter(SearchNearbyResultItem.setter(Builder::businessChains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessChains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BusinessChain::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Contacts> CONTACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Contacts").getter(SearchNearbyResultItem.getter(SearchNearbyResultItem::contacts)).setter(SearchNearbyResultItem.setter(Builder::contacts)).constructor(Contacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contacts").build()}).build();
    private static final SdkField<List<OpeningHours>> OPENING_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OpeningHours").getter(SearchNearbyResultItem.getter(SearchNearbyResultItem::openingHours)).setter(SearchNearbyResultItem.setter(Builder::openingHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpeningHours").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpeningHours::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AccessPoint>> ACCESS_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessPoints").getter(SearchNearbyResultItem.getter(SearchNearbyResultItem::accessPoints)).setter(SearchNearbyResultItem.setter(Builder::accessPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AccessRestriction>> ACCESS_RESTRICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessRestrictions").getter(SearchNearbyResultItem.getter(SearchNearbyResultItem::accessRestrictions)).setter(SearchNearbyResultItem.setter(Builder::accessRestrictions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessRestrictions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessRestriction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TimeZone> TIME_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeZone").getter(SearchNearbyResultItem.getter(SearchNearbyResultItem::timeZone)).setter(SearchNearbyResultItem.setter(Builder::timeZone)).constructor(TimeZone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()}).build();
    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoliticalView").getter(SearchNearbyResultItem.getter(SearchNearbyResultItem::politicalView)).setter(SearchNearbyResultItem.setter(Builder::politicalView)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoliticalView").build()}).build();
    private static final SdkField<PhonemeDetails> PHONEMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Phonemes").getter(SearchNearbyResultItem.getter(SearchNearbyResultItem::phonemes)).setter(SearchNearbyResultItem.setter(Builder::phonemes)).constructor(PhonemeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phonemes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACE_ID_FIELD, PLACE_TYPE_FIELD, TITLE_FIELD, ADDRESS_FIELD, ADDRESS_NUMBER_CORRECTED_FIELD, POSITION_FIELD, DISTANCE_FIELD, MAP_VIEW_FIELD, CATEGORIES_FIELD, FOOD_TYPES_FIELD, BUSINESS_CHAINS_FIELD, CONTACTS_FIELD, OPENING_HOURS_FIELD, ACCESS_POINTS_FIELD, ACCESS_RESTRICTIONS_FIELD, TIME_ZONE_FIELD, POLITICAL_VIEW_FIELD, PHONEMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchNearbyResultItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String placeId;
    private final String placeType;
    private final String title;
    private final Address address;
    private final Boolean addressNumberCorrected;
    private final List<Double> position;
    private final Long distance;
    private final List<Double> mapView;
    private final List<Category> categories;
    private final List<FoodType> foodTypes;
    private final List<BusinessChain> businessChains;
    private final Contacts contacts;
    private final List<OpeningHours> openingHours;
    private final List<AccessPoint> accessPoints;
    private final List<AccessRestriction> accessRestrictions;
    private final TimeZone timeZone;
    private final String politicalView;
    private final PhonemeDetails phonemes;

    private SearchNearbyResultItem(BuilderImpl builder) {
        this.placeId = builder.placeId;
        this.placeType = builder.placeType;
        this.title = builder.title;
        this.address = builder.address;
        this.addressNumberCorrected = builder.addressNumberCorrected;
        this.position = builder.position;
        this.distance = builder.distance;
        this.mapView = builder.mapView;
        this.categories = builder.categories;
        this.foodTypes = builder.foodTypes;
        this.businessChains = builder.businessChains;
        this.contacts = builder.contacts;
        this.openingHours = builder.openingHours;
        this.accessPoints = builder.accessPoints;
        this.accessRestrictions = builder.accessRestrictions;
        this.timeZone = builder.timeZone;
        this.politicalView = builder.politicalView;
        this.phonemes = builder.phonemes;
    }

    public final String placeId() {
        return this.placeId;
    }

    public final PlaceType placeType() {
        return PlaceType.fromValue(this.placeType);
    }

    public final String placeTypeAsString() {
        return this.placeType;
    }

    public final String title() {
        return this.title;
    }

    public final Address address() {
        return this.address;
    }

    public final Boolean addressNumberCorrected() {
        return this.addressNumberCorrected;
    }

    public final boolean hasPosition() {
        return this.position != null && !(this.position instanceof SdkAutoConstructList);
    }

    public final List<Double> position() {
        return this.position;
    }

    public final Long distance() {
        return this.distance;
    }

    public final boolean hasMapView() {
        return this.mapView != null && !(this.mapView instanceof SdkAutoConstructList);
    }

    public final List<Double> mapView() {
        return this.mapView;
    }

    public final boolean hasCategories() {
        return this.categories != null && !(this.categories instanceof SdkAutoConstructList);
    }

    public final List<Category> categories() {
        return this.categories;
    }

    public final boolean hasFoodTypes() {
        return this.foodTypes != null && !(this.foodTypes instanceof SdkAutoConstructList);
    }

    public final List<FoodType> foodTypes() {
        return this.foodTypes;
    }

    public final boolean hasBusinessChains() {
        return this.businessChains != null && !(this.businessChains instanceof SdkAutoConstructList);
    }

    public final List<BusinessChain> businessChains() {
        return this.businessChains;
    }

    public final Contacts contacts() {
        return this.contacts;
    }

    public final boolean hasOpeningHours() {
        return this.openingHours != null && !(this.openingHours instanceof SdkAutoConstructList);
    }

    public final List<OpeningHours> openingHours() {
        return this.openingHours;
    }

    public final boolean hasAccessPoints() {
        return this.accessPoints != null && !(this.accessPoints instanceof SdkAutoConstructList);
    }

    public final List<AccessPoint> accessPoints() {
        return this.accessPoints;
    }

    public final boolean hasAccessRestrictions() {
        return this.accessRestrictions != null && !(this.accessRestrictions instanceof SdkAutoConstructList);
    }

    public final List<AccessRestriction> accessRestrictions() {
        return this.accessRestrictions;
    }

    public final TimeZone timeZone() {
        return this.timeZone;
    }

    public final String politicalView() {
        return this.politicalView;
    }

    public final PhonemeDetails phonemes() {
        return this.phonemes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.placeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.placeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressNumberCorrected());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPosition() ? this.position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.distance());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMapView() ? this.mapView() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategories() ? this.categories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFoodTypes() ? this.foodTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBusinessChains() ? this.businessChains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOpeningHours() ? this.openingHours() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessPoints() ? this.accessPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessRestrictions() ? this.accessRestrictions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(this.phonemes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchNearbyResultItem)) {
            return false;
        }
        SearchNearbyResultItem other = (SearchNearbyResultItem)obj;
        return Objects.equals(this.placeId(), other.placeId()) && Objects.equals(this.placeTypeAsString(), other.placeTypeAsString()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.address(), other.address()) && Objects.equals(this.addressNumberCorrected(), other.addressNumberCorrected()) && this.hasPosition() == other.hasPosition() && Objects.equals(this.position(), other.position()) && Objects.equals(this.distance(), other.distance()) && this.hasMapView() == other.hasMapView() && Objects.equals(this.mapView(), other.mapView()) && this.hasCategories() == other.hasCategories() && Objects.equals(this.categories(), other.categories()) && this.hasFoodTypes() == other.hasFoodTypes() && Objects.equals(this.foodTypes(), other.foodTypes()) && this.hasBusinessChains() == other.hasBusinessChains() && Objects.equals(this.businessChains(), other.businessChains()) && Objects.equals(this.contacts(), other.contacts()) && this.hasOpeningHours() == other.hasOpeningHours() && Objects.equals(this.openingHours(), other.openingHours()) && this.hasAccessPoints() == other.hasAccessPoints() && Objects.equals(this.accessPoints(), other.accessPoints()) && this.hasAccessRestrictions() == other.hasAccessRestrictions() && Objects.equals(this.accessRestrictions(), other.accessRestrictions()) && Objects.equals(this.timeZone(), other.timeZone()) && Objects.equals(this.politicalView(), other.politicalView()) && Objects.equals(this.phonemes(), other.phonemes());
    }

    public final String toString() {
        return ToString.builder((String)"SearchNearbyResultItem").add("PlaceId", (Object)this.placeId()).add("PlaceType", (Object)this.placeTypeAsString()).add("Title", (Object)this.title()).add("Address", (Object)this.address()).add("AddressNumberCorrected", (Object)this.addressNumberCorrected()).add("Position", (Object)(this.position() == null ? null : "*** Sensitive Data Redacted ***")).add("Distance", (Object)this.distance()).add("MapView", (Object)(this.mapView() == null ? null : "*** Sensitive Data Redacted ***")).add("Categories", this.hasCategories() ? this.categories() : null).add("FoodTypes", this.hasFoodTypes() ? this.foodTypes() : null).add("BusinessChains", this.hasBusinessChains() ? this.businessChains() : null).add("Contacts", (Object)this.contacts()).add("OpeningHours", this.hasOpeningHours() ? this.openingHours() : null).add("AccessPoints", this.hasAccessPoints() ? this.accessPoints() : null).add("AccessRestrictions", this.hasAccessRestrictions() ? this.accessRestrictions() : null).add("TimeZone", (Object)this.timeZone()).add("PoliticalView", (Object)this.politicalView()).add("Phonemes", (Object)this.phonemes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlaceId": {
                return Optional.ofNullable(clazz.cast(this.placeId()));
            }
            case "PlaceType": {
                return Optional.ofNullable(clazz.cast(this.placeTypeAsString()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "AddressNumberCorrected": {
                return Optional.ofNullable(clazz.cast(this.addressNumberCorrected()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "Distance": {
                return Optional.ofNullable(clazz.cast(this.distance()));
            }
            case "MapView": {
                return Optional.ofNullable(clazz.cast(this.mapView()));
            }
            case "Categories": {
                return Optional.ofNullable(clazz.cast(this.categories()));
            }
            case "FoodTypes": {
                return Optional.ofNullable(clazz.cast(this.foodTypes()));
            }
            case "BusinessChains": {
                return Optional.ofNullable(clazz.cast(this.businessChains()));
            }
            case "Contacts": {
                return Optional.ofNullable(clazz.cast(this.contacts()));
            }
            case "OpeningHours": {
                return Optional.ofNullable(clazz.cast(this.openingHours()));
            }
            case "AccessPoints": {
                return Optional.ofNullable(clazz.cast(this.accessPoints()));
            }
            case "AccessRestrictions": {
                return Optional.ofNullable(clazz.cast(this.accessRestrictions()));
            }
            case "TimeZone": {
                return Optional.ofNullable(clazz.cast(this.timeZone()));
            }
            case "PoliticalView": {
                return Optional.ofNullable(clazz.cast(this.politicalView()));
            }
            case "Phonemes": {
                return Optional.ofNullable(clazz.cast(this.phonemes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PlaceId", PLACE_ID_FIELD);
        map.put("PlaceType", PLACE_TYPE_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Address", ADDRESS_FIELD);
        map.put("AddressNumberCorrected", ADDRESS_NUMBER_CORRECTED_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("Distance", DISTANCE_FIELD);
        map.put("MapView", MAP_VIEW_FIELD);
        map.put("Categories", CATEGORIES_FIELD);
        map.put("FoodTypes", FOOD_TYPES_FIELD);
        map.put("BusinessChains", BUSINESS_CHAINS_FIELD);
        map.put("Contacts", CONTACTS_FIELD);
        map.put("OpeningHours", OPENING_HOURS_FIELD);
        map.put("AccessPoints", ACCESS_POINTS_FIELD);
        map.put("AccessRestrictions", ACCESS_RESTRICTIONS_FIELD);
        map.put("TimeZone", TIME_ZONE_FIELD);
        map.put("PoliticalView", POLITICAL_VIEW_FIELD);
        map.put("Phonemes", PHONEMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchNearbyResultItem, T> g) {
        return obj -> g.apply((SearchNearbyResultItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String placeId;
        private String placeType;
        private String title;
        private Address address;
        private Boolean addressNumberCorrected;
        private List<Double> position = DefaultSdkAutoConstructList.getInstance();
        private Long distance;
        private List<Double> mapView = DefaultSdkAutoConstructList.getInstance();
        private List<Category> categories = DefaultSdkAutoConstructList.getInstance();
        private List<FoodType> foodTypes = DefaultSdkAutoConstructList.getInstance();
        private List<BusinessChain> businessChains = DefaultSdkAutoConstructList.getInstance();
        private Contacts contacts;
        private List<OpeningHours> openingHours = DefaultSdkAutoConstructList.getInstance();
        private List<AccessPoint> accessPoints = DefaultSdkAutoConstructList.getInstance();
        private List<AccessRestriction> accessRestrictions = DefaultSdkAutoConstructList.getInstance();
        private TimeZone timeZone;
        private String politicalView;
        private PhonemeDetails phonemes;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchNearbyResultItem model) {
            this.placeId(model.placeId);
            this.placeType(model.placeType);
            this.title(model.title);
            this.address(model.address);
            this.addressNumberCorrected(model.addressNumberCorrected);
            this.position(model.position);
            this.distance(model.distance);
            this.mapView(model.mapView);
            this.categories(model.categories);
            this.foodTypes(model.foodTypes);
            this.businessChains(model.businessChains);
            this.contacts(model.contacts);
            this.openingHours(model.openingHours);
            this.accessPoints(model.accessPoints);
            this.accessRestrictions(model.accessRestrictions);
            this.timeZone(model.timeZone);
            this.politicalView(model.politicalView);
            this.phonemes(model.phonemes);
        }

        public final String getPlaceId() {
            return this.placeId;
        }

        public final void setPlaceId(String placeId) {
            this.placeId = placeId;
        }

        @Override
        public final Builder placeId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        public final String getPlaceType() {
            return this.placeType;
        }

        public final void setPlaceType(String placeType) {
            this.placeType = placeType;
        }

        @Override
        public final Builder placeType(String placeType) {
            this.placeType = placeType;
            return this;
        }

        @Override
        public final Builder placeType(PlaceType placeType) {
            this.placeType(placeType == null ? null : placeType.toString());
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Address.Builder getAddress() {
            return this.address != null ? this.address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final Boolean getAddressNumberCorrected() {
            return this.addressNumberCorrected;
        }

        public final void setAddressNumberCorrected(Boolean addressNumberCorrected) {
            this.addressNumberCorrected = addressNumberCorrected;
        }

        @Override
        public final Builder addressNumberCorrected(Boolean addressNumberCorrected) {
            this.addressNumberCorrected = addressNumberCorrected;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (this.position instanceof SdkAutoConstructList) {
                return null;
            }
            return this.position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double ... position) {
            this.position(Arrays.asList(position));
            return this;
        }

        public final Long getDistance() {
            return this.distance;
        }

        public final void setDistance(Long distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Long distance) {
            this.distance = distance;
            return this;
        }

        public final Collection<Double> getMapView() {
            if (this.mapView instanceof SdkAutoConstructList) {
                return null;
            }
            return this.mapView;
        }

        public final void setMapView(Collection<Double> mapView) {
            this.mapView = BoundingBoxCopier.copy(mapView);
        }

        @Override
        public final Builder mapView(Collection<Double> mapView) {
            this.mapView = BoundingBoxCopier.copy(mapView);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapView(Double ... mapView) {
            this.mapView(Arrays.asList(mapView));
            return this;
        }

        public final List<Category.Builder> getCategories() {
            List<Category.Builder> result = CategoryListCopier.copyToBuilder(this.categories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategories(Collection<Category.BuilderImpl> categories) {
            this.categories = CategoryListCopier.copyFromBuilder(categories);
        }

        @Override
        public final Builder categories(Collection<Category> categories) {
            this.categories = CategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Category ... categories) {
            this.categories(Arrays.asList(categories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Consumer<Category.Builder> ... categories) {
            this.categories(Stream.of(categories).map(c -> (Category)((Category.Builder)Category.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FoodType.Builder> getFoodTypes() {
            List<FoodType.Builder> result = FoodTypeListCopier.copyToBuilder(this.foodTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFoodTypes(Collection<FoodType.BuilderImpl> foodTypes) {
            this.foodTypes = FoodTypeListCopier.copyFromBuilder(foodTypes);
        }

        @Override
        public final Builder foodTypes(Collection<FoodType> foodTypes) {
            this.foodTypes = FoodTypeListCopier.copy(foodTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder foodTypes(FoodType ... foodTypes) {
            this.foodTypes(Arrays.asList(foodTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder foodTypes(Consumer<FoodType.Builder> ... foodTypes) {
            this.foodTypes(Stream.of(foodTypes).map(c -> (FoodType)((FoodType.Builder)FoodType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BusinessChain.Builder> getBusinessChains() {
            List<BusinessChain.Builder> result = BusinessChainListCopier.copyToBuilder(this.businessChains);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBusinessChains(Collection<BusinessChain.BuilderImpl> businessChains) {
            this.businessChains = BusinessChainListCopier.copyFromBuilder(businessChains);
        }

        @Override
        public final Builder businessChains(Collection<BusinessChain> businessChains) {
            this.businessChains = BusinessChainListCopier.copy(businessChains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder businessChains(BusinessChain ... businessChains) {
            this.businessChains(Arrays.asList(businessChains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder businessChains(Consumer<BusinessChain.Builder> ... businessChains) {
            this.businessChains(Stream.of(businessChains).map(c -> (BusinessChain)((BusinessChain.Builder)BusinessChain.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Contacts.Builder getContacts() {
            return this.contacts != null ? this.contacts.toBuilder() : null;
        }

        public final void setContacts(Contacts.BuilderImpl contacts) {
            this.contacts = contacts != null ? contacts.build() : null;
        }

        @Override
        public final Builder contacts(Contacts contacts) {
            this.contacts = contacts;
            return this;
        }

        public final List<OpeningHours.Builder> getOpeningHours() {
            List<OpeningHours.Builder> result = OpeningHoursListCopier.copyToBuilder(this.openingHours);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOpeningHours(Collection<OpeningHours.BuilderImpl> openingHours) {
            this.openingHours = OpeningHoursListCopier.copyFromBuilder(openingHours);
        }

        @Override
        public final Builder openingHours(Collection<OpeningHours> openingHours) {
            this.openingHours = OpeningHoursListCopier.copy(openingHours);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder openingHours(OpeningHours ... openingHours) {
            this.openingHours(Arrays.asList(openingHours));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder openingHours(Consumer<OpeningHours.Builder> ... openingHours) {
            this.openingHours(Stream.of(openingHours).map(c -> (OpeningHours)((OpeningHours.Builder)OpeningHours.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AccessPoint.Builder> getAccessPoints() {
            List<AccessPoint.Builder> result = AccessPointListCopier.copyToBuilder(this.accessPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessPoints(Collection<AccessPoint.BuilderImpl> accessPoints) {
            this.accessPoints = AccessPointListCopier.copyFromBuilder(accessPoints);
        }

        @Override
        public final Builder accessPoints(Collection<AccessPoint> accessPoints) {
            this.accessPoints = AccessPointListCopier.copy(accessPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPoints(AccessPoint ... accessPoints) {
            this.accessPoints(Arrays.asList(accessPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPoints(Consumer<AccessPoint.Builder> ... accessPoints) {
            this.accessPoints(Stream.of(accessPoints).map(c -> (AccessPoint)((AccessPoint.Builder)AccessPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AccessRestriction.Builder> getAccessRestrictions() {
            List<AccessRestriction.Builder> result = AccessRestrictionListCopier.copyToBuilder(this.accessRestrictions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessRestrictions(Collection<AccessRestriction.BuilderImpl> accessRestrictions) {
            this.accessRestrictions = AccessRestrictionListCopier.copyFromBuilder(accessRestrictions);
        }

        @Override
        public final Builder accessRestrictions(Collection<AccessRestriction> accessRestrictions) {
            this.accessRestrictions = AccessRestrictionListCopier.copy(accessRestrictions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessRestrictions(AccessRestriction ... accessRestrictions) {
            this.accessRestrictions(Arrays.asList(accessRestrictions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessRestrictions(Consumer<AccessRestriction.Builder> ... accessRestrictions) {
            this.accessRestrictions(Stream.of(accessRestrictions).map(c -> (AccessRestriction)((AccessRestriction.Builder)AccessRestriction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TimeZone.Builder getTimeZone() {
            return this.timeZone != null ? this.timeZone.toBuilder() : null;
        }

        public final void setTimeZone(TimeZone.BuilderImpl timeZone) {
            this.timeZone = timeZone != null ? timeZone.build() : null;
        }

        @Override
        public final Builder timeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final String getPoliticalView() {
            return this.politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final PhonemeDetails.Builder getPhonemes() {
            return this.phonemes != null ? this.phonemes.toBuilder() : null;
        }

        public final void setPhonemes(PhonemeDetails.BuilderImpl phonemes) {
            this.phonemes = phonemes != null ? phonemes.build() : null;
        }

        @Override
        public final Builder phonemes(PhonemeDetails phonemes) {
            this.phonemes = phonemes;
            return this;
        }

        public SearchNearbyResultItem build() {
            return new SearchNearbyResultItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchNearbyResultItem> {
        public Builder placeId(String var1);

        public Builder placeType(String var1);

        public Builder placeType(PlaceType var1);

        public Builder title(String var1);

        public Builder address(Address var1);

        default public Builder address(Consumer<Address.Builder> address) {
            return this.address((Address)((Address.Builder)Address.builder().applyMutation(address)).build());
        }

        public Builder addressNumberCorrected(Boolean var1);

        public Builder position(Collection<Double> var1);

        public Builder position(Double ... var1);

        public Builder distance(Long var1);

        public Builder mapView(Collection<Double> var1);

        public Builder mapView(Double ... var1);

        public Builder categories(Collection<Category> var1);

        public Builder categories(Category ... var1);

        public Builder categories(Consumer<Category.Builder> ... var1);

        public Builder foodTypes(Collection<FoodType> var1);

        public Builder foodTypes(FoodType ... var1);

        public Builder foodTypes(Consumer<FoodType.Builder> ... var1);

        public Builder businessChains(Collection<BusinessChain> var1);

        public Builder businessChains(BusinessChain ... var1);

        public Builder businessChains(Consumer<BusinessChain.Builder> ... var1);

        public Builder contacts(Contacts var1);

        default public Builder contacts(Consumer<Contacts.Builder> contacts) {
            return this.contacts((Contacts)((Contacts.Builder)Contacts.builder().applyMutation(contacts)).build());
        }

        public Builder openingHours(Collection<OpeningHours> var1);

        public Builder openingHours(OpeningHours ... var1);

        public Builder openingHours(Consumer<OpeningHours.Builder> ... var1);

        public Builder accessPoints(Collection<AccessPoint> var1);

        public Builder accessPoints(AccessPoint ... var1);

        public Builder accessPoints(Consumer<AccessPoint.Builder> ... var1);

        public Builder accessRestrictions(Collection<AccessRestriction> var1);

        public Builder accessRestrictions(AccessRestriction ... var1);

        public Builder accessRestrictions(Consumer<AccessRestriction.Builder> ... var1);

        public Builder timeZone(TimeZone var1);

        default public Builder timeZone(Consumer<TimeZone.Builder> timeZone) {
            return this.timeZone((TimeZone)((TimeZone.Builder)TimeZone.builder().applyMutation(timeZone)).build());
        }

        public Builder politicalView(String var1);

        public Builder phonemes(PhonemeDetails var1);

        default public Builder phonemes(Consumer<PhonemeDetails.Builder> phonemes) {
            return this.phonemes((PhonemeDetails)((PhonemeDetails.Builder)PhonemeDetails.builder().applyMutation(phonemes)).build());
        }
    }
}

