/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.Category;
import software.amazon.awssdk.services.geoplaces.model.CategoryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessRestriction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessRestriction> {
    private static final SdkField<Boolean> RESTRICTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Restricted").getter(AccessRestriction.getter(AccessRestriction::restricted)).setter(AccessRestriction.setter(Builder::restricted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Restricted").build()}).build();
    private static final SdkField<List<Category>> CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Categories").getter(AccessRestriction.getter(AccessRestriction::categories)).setter(AccessRestriction.setter(Builder::categories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Category::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTRICTED_FIELD, CATEGORIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccessRestriction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean restricted;
    private final List<Category> categories;

    private AccessRestriction(BuilderImpl builder) {
        this.restricted = builder.restricted;
        this.categories = builder.categories;
    }

    public final Boolean restricted() {
        return this.restricted;
    }

    public final boolean hasCategories() {
        return this.categories != null && !(this.categories instanceof SdkAutoConstructList);
    }

    public final List<Category> categories() {
        return this.categories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restricted());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategories() ? this.categories() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessRestriction)) {
            return false;
        }
        AccessRestriction other = (AccessRestriction)obj;
        return Objects.equals(this.restricted(), other.restricted()) && this.hasCategories() == other.hasCategories() && Objects.equals(this.categories(), other.categories());
    }

    public final String toString() {
        return ToString.builder((String)"AccessRestriction").add("Restricted", (Object)this.restricted()).add("Categories", this.hasCategories() ? this.categories() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Restricted": {
                return Optional.ofNullable(clazz.cast(this.restricted()));
            }
            case "Categories": {
                return Optional.ofNullable(clazz.cast(this.categories()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Restricted", RESTRICTED_FIELD);
        map.put("Categories", CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessRestriction, T> g) {
        return obj -> g.apply((AccessRestriction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean restricted;
        private List<Category> categories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccessRestriction model) {
            this.restricted(model.restricted);
            this.categories(model.categories);
        }

        public final Boolean getRestricted() {
            return this.restricted;
        }

        public final void setRestricted(Boolean restricted) {
            this.restricted = restricted;
        }

        @Override
        public final Builder restricted(Boolean restricted) {
            this.restricted = restricted;
            return this;
        }

        public final List<Category.Builder> getCategories() {
            List<Category.Builder> result = CategoryListCopier.copyToBuilder(this.categories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategories(Collection<Category.BuilderImpl> categories) {
            this.categories = CategoryListCopier.copyFromBuilder(categories);
        }

        @Override
        public final Builder categories(Collection<Category> categories) {
            this.categories = CategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Category ... categories) {
            this.categories(Arrays.asList(categories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Consumer<Category.Builder> ... categories) {
            this.categories(Stream.of(categories).map(c -> (Category)((Category.Builder)Category.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AccessRestriction build() {
            return new AccessRestriction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessRestriction> {
        public Builder restricted(Boolean var1);

        public Builder categories(Collection<Category> var1);

        public Builder categories(Category ... var1);

        public Builder categories(Consumer<Category.Builder> ... var1);
    }
}

