/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.GeocodeParsedQueryAddressComponents;
import software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent;
import software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeocodeParsedQuery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeocodeParsedQuery> {
    private static final SdkField<List<ParsedQueryComponent>> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Title").getter(GeocodeParsedQuery.getter(GeocodeParsedQuery::title)).setter(GeocodeParsedQuery.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParsedQueryComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GeocodeParsedQueryAddressComponents> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Address").getter(GeocodeParsedQuery.getter(GeocodeParsedQuery::address)).setter(GeocodeParsedQuery.setter(Builder::address)).constructor(GeocodeParsedQueryAddressComponents::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, ADDRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GeocodeParsedQuery.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ParsedQueryComponent> title;
    private final GeocodeParsedQueryAddressComponents address;

    private GeocodeParsedQuery(BuilderImpl builder) {
        this.title = builder.title;
        this.address = builder.address;
    }

    public final boolean hasTitle() {
        return this.title != null && !(this.title instanceof SdkAutoConstructList);
    }

    public final List<ParsedQueryComponent> title() {
        return this.title;
    }

    public final GeocodeParsedQueryAddressComponents address() {
        return this.address;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTitle() ? this.title() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeocodeParsedQuery)) {
            return false;
        }
        GeocodeParsedQuery other = (GeocodeParsedQuery)obj;
        return this.hasTitle() == other.hasTitle() && Objects.equals(this.title(), other.title()) && Objects.equals(this.address(), other.address());
    }

    public final String toString() {
        return ToString.builder((String)"GeocodeParsedQuery").add("Title", this.hasTitle() ? this.title() : null).add("Address", (Object)this.address()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Title", TITLE_FIELD);
        map.put("Address", ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeocodeParsedQuery, T> g) {
        return obj -> g.apply((GeocodeParsedQuery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ParsedQueryComponent> title = DefaultSdkAutoConstructList.getInstance();
        private GeocodeParsedQueryAddressComponents address;

        private BuilderImpl() {
        }

        private BuilderImpl(GeocodeParsedQuery model) {
            this.title(model.title);
            this.address(model.address);
        }

        public final List<ParsedQueryComponent.Builder> getTitle() {
            List<ParsedQueryComponent.Builder> result = ParsedQueryComponentListCopier.copyToBuilder(this.title);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTitle(Collection<ParsedQueryComponent.BuilderImpl> title) {
            this.title = ParsedQueryComponentListCopier.copyFromBuilder(title);
        }

        @Override
        public final Builder title(Collection<ParsedQueryComponent> title) {
            this.title = ParsedQueryComponentListCopier.copy(title);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder title(ParsedQueryComponent ... title) {
            this.title(Arrays.asList(title));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder title(Consumer<ParsedQueryComponent.Builder> ... title) {
            this.title(Stream.of(title).map(c -> (ParsedQueryComponent)((ParsedQueryComponent.Builder)ParsedQueryComponent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final GeocodeParsedQueryAddressComponents.Builder getAddress() {
            return this.address != null ? this.address.toBuilder() : null;
        }

        public final void setAddress(GeocodeParsedQueryAddressComponents.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(GeocodeParsedQueryAddressComponents address) {
            this.address = address;
            return this;
        }

        public GeocodeParsedQuery build() {
            return new GeocodeParsedQuery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeocodeParsedQuery> {
        public Builder title(Collection<ParsedQueryComponent> var1);

        public Builder title(ParsedQueryComponent ... var1);

        public Builder title(Consumer<ParsedQueryComponent.Builder> ... var1);

        public Builder address(GeocodeParsedQueryAddressComponents var1);

        default public Builder address(Consumer<GeocodeParsedQueryAddressComponents.Builder> address) {
            return this.address((GeocodeParsedQueryAddressComponents)((GeocodeParsedQueryAddressComponents.Builder)GeocodeParsedQueryAddressComponents.builder().applyMutation(address)).build());
        }
    }
}

