/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes how the parts of the response element matched the input query by returning the sections of the response
 * which matched to input query terms.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutocompleteHighlights implements SdkPojo, Serializable,
        ToCopyableBuilder<AutocompleteHighlights.Builder, AutocompleteHighlights> {
    private static final SdkField<List<Highlight>> TITLE_FIELD = SdkField
            .<List<Highlight>> builder(MarshallingType.LIST)
            .memberName("Title")
            .getter(getter(AutocompleteHighlights::title))
            .setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Highlight> builder(MarshallingType.SDK_POJO)
                                            .constructor(Highlight::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutocompleteAddressHighlights> ADDRESS_FIELD = SdkField
            .<AutocompleteAddressHighlights> builder(MarshallingType.SDK_POJO).memberName("Address")
            .getter(getter(AutocompleteHighlights::address)).setter(setter(Builder::address))
            .constructor(AutocompleteAddressHighlights::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Highlight> title;

    private final AutocompleteAddressHighlights address;

    private AutocompleteHighlights(BuilderImpl builder) {
        this.title = builder.title;
        this.address = builder.address;
    }

    /**
     * For responses, this returns true if the service returned a value for the Title property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTitle() {
        return title != null && !(title instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates where the title field in the result matches the input query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTitle} method.
     * </p>
     * 
     * @return Indicates where the title field in the result matches the input query.
     */
    public final List<Highlight> title() {
        return title;
    }

    /**
     * <p>
     * Describes how part of the result address match the input query.
     * </p>
     * 
     * @return Describes how part of the result address match the input query.
     */
    public final AutocompleteAddressHighlights address() {
        return address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTitle() ? title() : null);
        hashCode = 31 * hashCode + Objects.hashCode(address());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutocompleteHighlights)) {
            return false;
        }
        AutocompleteHighlights other = (AutocompleteHighlights) obj;
        return hasTitle() == other.hasTitle() && Objects.equals(title(), other.title())
                && Objects.equals(address(), other.address());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutocompleteHighlights").add("Title", hasTitle() ? title() : null).add("Address", address())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Title", TITLE_FIELD);
        map.put("Address", ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutocompleteHighlights, T> g) {
        return obj -> g.apply((AutocompleteHighlights) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutocompleteHighlights> {
        /**
         * <p>
         * Indicates where the title field in the result matches the input query.
         * </p>
         * 
         * @param title
         *        Indicates where the title field in the result matches the input query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(Collection<Highlight> title);

        /**
         * <p>
         * Indicates where the title field in the result matches the input query.
         * </p>
         * 
         * @param title
         *        Indicates where the title field in the result matches the input query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(Highlight... title);

        /**
         * <p>
         * Indicates where the title field in the result matches the input query.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.Highlight#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder#build()} is called immediately and
         * its result is passed to {@link #title(List<Highlight>)}.
         * 
         * @param title
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #title(java.util.Collection<Highlight>)
         */
        Builder title(Consumer<Highlight.Builder>... title);

        /**
         * <p>
         * Describes how part of the result address match the input query.
         * </p>
         * 
         * @param address
         *        Describes how part of the result address match the input query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(AutocompleteAddressHighlights address);

        /**
         * <p>
         * Describes how part of the result address match the input query.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutocompleteAddressHighlights.Builder}
         * avoiding the need to create one manually via {@link AutocompleteAddressHighlights#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutocompleteAddressHighlights.Builder#build()} is called
         * immediately and its result is passed to {@link #address(AutocompleteAddressHighlights)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link AutocompleteAddressHighlights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(AutocompleteAddressHighlights)
         */
        default Builder address(Consumer<AutocompleteAddressHighlights.Builder> address) {
            return address(AutocompleteAddressHighlights.builder().applyMutation(address).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<Highlight> title = DefaultSdkAutoConstructList.getInstance();

        private AutocompleteAddressHighlights address;

        private BuilderImpl() {
        }

        private BuilderImpl(AutocompleteHighlights model) {
            title(model.title);
            address(model.address);
        }

        public final List<Highlight.Builder> getTitle() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.title);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTitle(Collection<Highlight.BuilderImpl> title) {
            this.title = HighlightListCopier.copyFromBuilder(title);
        }

        @Override
        public final Builder title(Collection<Highlight> title) {
            this.title = HighlightListCopier.copy(title);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder title(Highlight... title) {
            title(Arrays.asList(title));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder title(Consumer<Highlight.Builder>... title) {
            title(Stream.of(title).map(c -> Highlight.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutocompleteAddressHighlights.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        public final void setAddress(AutocompleteAddressHighlights.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(AutocompleteAddressHighlights address) {
            this.address = address;
            return this;
        }

        @Override
        public AutocompleteHighlights build() {
            return new AutocompleteHighlights(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
