/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A result matching the input query text.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutocompleteResultItem implements SdkPojo, Serializable,
        ToCopyableBuilder<AutocompleteResultItem.Builder, AutocompleteResultItem> {
    private static final SdkField<String> PLACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaceId").getter(getter(AutocompleteResultItem::placeId)).setter(setter(Builder::placeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceId").build()).build();

    private static final SdkField<String> PLACE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaceType").getter(getter(AutocompleteResultItem::placeTypeAsString)).setter(setter(Builder::placeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceType").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(AutocompleteResultItem::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<Address> ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("Address").getter(getter(AutocompleteResultItem::address)).setter(setter(Builder::address))
            .constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<Long> DISTANCE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Distance")
            .getter(getter(AutocompleteResultItem::distance)).setter(setter(Builder::distance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Language").getter(getter(AutocompleteResultItem::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()).build();

    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoliticalView").getter(getter(AutocompleteResultItem::politicalView))
            .setter(setter(Builder::politicalView))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoliticalView").build()).build();

    private static final SdkField<AutocompleteHighlights> HIGHLIGHTS_FIELD = SdkField
            .<AutocompleteHighlights> builder(MarshallingType.SDK_POJO).memberName("Highlights")
            .getter(getter(AutocompleteResultItem::highlights)).setter(setter(Builder::highlights))
            .constructor(AutocompleteHighlights::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Highlights").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(PLACE_ID_FIELD, PLACE_TYPE_FIELD, TITLE_FIELD, ADDRESS_FIELD, DISTANCE_FIELD,
                    LANGUAGE_FIELD, POLITICAL_VIEW_FIELD, HIGHLIGHTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String placeId;

    private final String placeType;

    private final String title;

    private final Address address;

    private final Long distance;

    private final String language;

    private final String politicalView;

    private final AutocompleteHighlights highlights;

    private AutocompleteResultItem(BuilderImpl builder) {
        this.placeId = builder.placeId;
        this.placeType = builder.placeType;
        this.title = builder.title;
        this.address = builder.address;
        this.distance = builder.distance;
        this.language = builder.language;
        this.politicalView = builder.politicalView;
        this.highlights = builder.highlights;
    }

    /**
     * <p>
     * The PlaceId of the place associated with this result. This can be used to look up additional details about the
     * result via GetPlace.
     * </p>
     * 
     * @return The PlaceId of the place associated with this result. This can be used to look up additional details
     *         about the result via GetPlace.
     */
    public final String placeId() {
        return placeId;
    }

    /**
     * <p>
     * PlaceType describes the type of result entry returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #placeType} will
     * return {@link PlaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #placeTypeAsString}.
     * </p>
     * 
     * @return PlaceType describes the type of result entry returned.
     * @see PlaceType
     */
    public final PlaceType placeType() {
        return PlaceType.fromValue(placeType);
    }

    /**
     * <p>
     * PlaceType describes the type of result entry returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #placeType} will
     * return {@link PlaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #placeTypeAsString}.
     * </p>
     * 
     * @return PlaceType describes the type of result entry returned.
     * @see PlaceType
     */
    public final String placeTypeAsString() {
        return placeType;
    }

    /**
     * <p>
     * A formatted string for display when presenting this result to an end user.
     * </p>
     * 
     * @return A formatted string for display when presenting this result to an end user.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The address associated with this result.
     * </p>
     * 
     * @return The address associated with this result.
     */
    public final Address address() {
        return address;
    }

    /**
     * <p>
     * The distance in meters between the center of the search area and this result. Useful to evaluate how far away
     * from the original bias position the result is.
     * </p>
     * 
     * @return The distance in meters between the center of the search area and this result. Useful to evaluate how far
     *         away from the original bias position the result is.
     */
    public final Long distance() {
        return distance;
    }

    /**
     * <p>
     * A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language codes for the
     * results to be rendered in. If there is no data for the result in the requested language, data will be returned in
     * the default language for the entry.
     * </p>
     * 
     * @return A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language codes
     *         for the results to be rendered in. If there is no data for the result in the requested language, data
     *         will be returned in the default language for the entry.
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * The alpha-2 or alpha-3 character code for the political view of a country. The political view applies to the
     * results of the request to represent unresolved territorial claims through the point of view of the specified
     * country.
     * </p>
     * 
     * @return The alpha-2 or alpha-3 character code for the political view of a country. The political view applies to
     *         the results of the request to represent unresolved territorial claims through the point of view of the
     *         specified country.
     */
    public final String politicalView() {
        return politicalView;
    }

    /**
     * <p>
     * Indicates the starting and ending index of the place in the text query that match the found title.
     * </p>
     * 
     * @return Indicates the starting and ending index of the place in the text query that match the found title.
     */
    public final AutocompleteHighlights highlights() {
        return highlights;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(placeId());
        hashCode = 31 * hashCode + Objects.hashCode(placeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(distance());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(highlights());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutocompleteResultItem)) {
            return false;
        }
        AutocompleteResultItem other = (AutocompleteResultItem) obj;
        return Objects.equals(placeId(), other.placeId()) && Objects.equals(placeTypeAsString(), other.placeTypeAsString())
                && Objects.equals(title(), other.title()) && Objects.equals(address(), other.address())
                && Objects.equals(distance(), other.distance()) && Objects.equals(language(), other.language())
                && Objects.equals(politicalView(), other.politicalView()) && Objects.equals(highlights(), other.highlights());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutocompleteResultItem")
                .add("PlaceId", placeId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PlaceType", placeTypeAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Title", title() == null ? null : "*** Sensitive Data Redacted ***").add("Address", address())
                .add("Distance", distance() == null ? null : "*** Sensitive Data Redacted ***").add("Language", language())
                .add("PoliticalView", politicalView() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Highlights", highlights()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlaceId":
            return Optional.ofNullable(clazz.cast(placeId()));
        case "PlaceType":
            return Optional.ofNullable(clazz.cast(placeTypeAsString()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "Distance":
            return Optional.ofNullable(clazz.cast(distance()));
        case "Language":
            return Optional.ofNullable(clazz.cast(language()));
        case "PoliticalView":
            return Optional.ofNullable(clazz.cast(politicalView()));
        case "Highlights":
            return Optional.ofNullable(clazz.cast(highlights()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PlaceId", PLACE_ID_FIELD);
        map.put("PlaceType", PLACE_TYPE_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Address", ADDRESS_FIELD);
        map.put("Distance", DISTANCE_FIELD);
        map.put("Language", LANGUAGE_FIELD);
        map.put("PoliticalView", POLITICAL_VIEW_FIELD);
        map.put("Highlights", HIGHLIGHTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutocompleteResultItem, T> g) {
        return obj -> g.apply((AutocompleteResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutocompleteResultItem> {
        /**
         * <p>
         * The PlaceId of the place associated with this result. This can be used to look up additional details about
         * the result via GetPlace.
         * </p>
         * 
         * @param placeId
         *        The PlaceId of the place associated with this result. This can be used to look up additional details
         *        about the result via GetPlace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placeId(String placeId);

        /**
         * <p>
         * PlaceType describes the type of result entry returned.
         * </p>
         * 
         * @param placeType
         *        PlaceType describes the type of result entry returned.
         * @see PlaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlaceType
         */
        Builder placeType(String placeType);

        /**
         * <p>
         * PlaceType describes the type of result entry returned.
         * </p>
         * 
         * @param placeType
         *        PlaceType describes the type of result entry returned.
         * @see PlaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlaceType
         */
        Builder placeType(PlaceType placeType);

        /**
         * <p>
         * A formatted string for display when presenting this result to an end user.
         * </p>
         * 
         * @param title
         *        A formatted string for display when presenting this result to an end user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The address associated with this result.
         * </p>
         * 
         * @param address
         *        The address associated with this result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(Address address);

        /**
         * <p>
         * The address associated with this result.
         * </p>
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #address(Address)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(Address)
         */
        default Builder address(Consumer<Address.Builder> address) {
            return address(Address.builder().applyMutation(address).build());
        }

        /**
         * <p>
         * The distance in meters between the center of the search area and this result. Useful to evaluate how far away
         * from the original bias position the result is.
         * </p>
         * 
         * @param distance
         *        The distance in meters between the center of the search area and this result. Useful to evaluate how
         *        far away from the original bias position the result is.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distance(Long distance);

        /**
         * <p>
         * A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language codes for
         * the results to be rendered in. If there is no data for the result in the requested language, data will be
         * returned in the default language for the entry.
         * </p>
         * 
         * @param language
         *        A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language
         *        codes for the results to be rendered in. If there is no data for the result in the requested language,
         *        data will be returned in the default language for the entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * The alpha-2 or alpha-3 character code for the political view of a country. The political view applies to the
         * results of the request to represent unresolved territorial claims through the point of view of the specified
         * country.
         * </p>
         * 
         * @param politicalView
         *        The alpha-2 or alpha-3 character code for the political view of a country. The political view applies
         *        to the results of the request to represent unresolved territorial claims through the point of view of
         *        the specified country.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder politicalView(String politicalView);

        /**
         * <p>
         * Indicates the starting and ending index of the place in the text query that match the found title.
         * </p>
         * 
         * @param highlights
         *        Indicates the starting and ending index of the place in the text query that match the found title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder highlights(AutocompleteHighlights highlights);

        /**
         * <p>
         * Indicates the starting and ending index of the place in the text query that match the found title.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutocompleteHighlights.Builder} avoiding
         * the need to create one manually via {@link AutocompleteHighlights#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutocompleteHighlights.Builder#build()} is called immediately and
         * its result is passed to {@link #highlights(AutocompleteHighlights)}.
         * 
         * @param highlights
         *        a consumer that will call methods on {@link AutocompleteHighlights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #highlights(AutocompleteHighlights)
         */
        default Builder highlights(Consumer<AutocompleteHighlights.Builder> highlights) {
            return highlights(AutocompleteHighlights.builder().applyMutation(highlights).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String placeId;

        private String placeType;

        private String title;

        private Address address;

        private Long distance;

        private String language;

        private String politicalView;

        private AutocompleteHighlights highlights;

        private BuilderImpl() {
        }

        private BuilderImpl(AutocompleteResultItem model) {
            placeId(model.placeId);
            placeType(model.placeType);
            title(model.title);
            address(model.address);
            distance(model.distance);
            language(model.language);
            politicalView(model.politicalView);
            highlights(model.highlights);
        }

        public final String getPlaceId() {
            return placeId;
        }

        public final void setPlaceId(String placeId) {
            this.placeId = placeId;
        }

        @Override
        public final Builder placeId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        public final String getPlaceType() {
            return placeType;
        }

        public final void setPlaceType(String placeType) {
            this.placeType = placeType;
        }

        @Override
        public final Builder placeType(String placeType) {
            this.placeType = placeType;
            return this;
        }

        @Override
        public final Builder placeType(PlaceType placeType) {
            this.placeType(placeType == null ? null : placeType.toString());
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Address.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final Long getDistance() {
            return distance;
        }

        public final void setDistance(Long distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Long distance) {
            this.distance = distance;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getPoliticalView() {
            return politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final AutocompleteHighlights.Builder getHighlights() {
            return highlights != null ? highlights.toBuilder() : null;
        }

        public final void setHighlights(AutocompleteHighlights.BuilderImpl highlights) {
            this.highlights = highlights != null ? highlights.build() : null;
        }

        @Override
        public final Builder highlights(AutocompleteHighlights highlights) {
            this.highlights = highlights;
            return this;
        }

        @Override
        public AutocompleteResultItem build() {
            return new AutocompleteResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
