/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates how well the returned title and address components matches the input TextQuery. For each component a score
 * is provied with 1 indicating all tokens were matched and 0 indicating no tokens were matched.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentMatchScores implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentMatchScores.Builder, ComponentMatchScores> {
    private static final SdkField<Double> TITLE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Title")
            .getter(getter(ComponentMatchScores::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<AddressComponentMatchScores> ADDRESS_FIELD = SdkField
            .<AddressComponentMatchScores> builder(MarshallingType.SDK_POJO).memberName("Address")
            .getter(getter(ComponentMatchScores::address)).setter(setter(Builder::address))
            .constructor(AddressComponentMatchScores::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double title;

    private final AddressComponentMatchScores address;

    private ComponentMatchScores(BuilderImpl builder) {
        this.title = builder.title;
        this.address = builder.address;
    }

    /**
     * <p>
     * Indicates the match score of the title in the text query that match the found title.
     * </p>
     * 
     * @return Indicates the match score of the title in the text query that match the found title.
     */
    public final Double title() {
        return title;
    }

    /**
     * <p>
     * The place's address.
     * </p>
     * 
     * @return The place's address.
     */
    public final AddressComponentMatchScores address() {
        return address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentMatchScores)) {
            return false;
        }
        ComponentMatchScores other = (ComponentMatchScores) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(address(), other.address());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentMatchScores").add("Title", title()).add("Address", address()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Title", TITLE_FIELD);
        map.put("Address", ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentMatchScores, T> g) {
        return obj -> g.apply((ComponentMatchScores) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentMatchScores> {
        /**
         * <p>
         * Indicates the match score of the title in the text query that match the found title.
         * </p>
         * 
         * @param title
         *        Indicates the match score of the title in the text query that match the found title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(Double title);

        /**
         * <p>
         * The place's address.
         * </p>
         * 
         * @param address
         *        The place's address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(AddressComponentMatchScores address);

        /**
         * <p>
         * The place's address.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddressComponentMatchScores.Builder}
         * avoiding the need to create one manually via {@link AddressComponentMatchScores#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddressComponentMatchScores.Builder#build()} is called
         * immediately and its result is passed to {@link #address(AddressComponentMatchScores)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link AddressComponentMatchScores.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(AddressComponentMatchScores)
         */
        default Builder address(Consumer<AddressComponentMatchScores.Builder> address) {
            return address(AddressComponentMatchScores.builder().applyMutation(address).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Double title;

        private AddressComponentMatchScores address;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentMatchScores model) {
            title(model.title);
            address(model.address);
        }

        public final Double getTitle() {
            return title;
        }

        public final void setTitle(Double title) {
            this.title = title;
        }

        @Override
        public final Builder title(Double title) {
            this.title = title;
            return this;
        }

        public final AddressComponentMatchScores.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        public final void setAddress(AddressComponentMatchScores.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(AddressComponentMatchScores address) {
            this.address = address;
            return this;
        }

        @Override
        public ComponentMatchScores build() {
            return new ComponentMatchScores(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
