/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the starting and ending index of the country in the text query that match the found title.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CountryHighlights implements SdkPojo, Serializable,
        ToCopyableBuilder<CountryHighlights.Builder, CountryHighlights> {
    private static final SdkField<List<Highlight>> CODE_FIELD = SdkField
            .<List<Highlight>> builder(MarshallingType.LIST)
            .memberName("Code")
            .getter(getter(CountryHighlights::code))
            .setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Highlight> builder(MarshallingType.SDK_POJO)
                                            .constructor(Highlight::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Highlight>> NAME_FIELD = SdkField
            .<List<Highlight>> builder(MarshallingType.LIST)
            .memberName("Name")
            .getter(getter(CountryHighlights::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Highlight> builder(MarshallingType.SDK_POJO)
                                            .constructor(Highlight::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Highlight> code;

    private final List<Highlight> name;

    private CountryHighlights(BuilderImpl builder) {
        this.code = builder.code;
        this.name = builder.name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Code property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCode() {
        return code != null && !(code instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the starting and ending index of the country code in the text query that match the found title.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCode} method.
     * </p>
     * 
     * @return Indicates the starting and ending index of the country code in the text query that match the found title.
     */
    public final List<Highlight> code() {
        return code;
    }

    /**
     * For responses, this returns true if the service returned a value for the Name property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasName() {
        return name != null && !(name instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the starting and ending index of the country code in the text query that match the found title.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasName} method.
     * </p>
     * 
     * @return Indicates the starting and ending index of the country code in the text query that match the found title.
     */
    public final List<Highlight> name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCode() ? code() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasName() ? name() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CountryHighlights)) {
            return false;
        }
        CountryHighlights other = (CountryHighlights) obj;
        return hasCode() == other.hasCode() && Objects.equals(code(), other.code()) && hasName() == other.hasName()
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CountryHighlights").add("Code", hasCode() ? code() : null)
                .add("Name", hasName() ? name() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Code", CODE_FIELD);
        map.put("Name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CountryHighlights, T> g) {
        return obj -> g.apply((CountryHighlights) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CountryHighlights> {
        /**
         * <p>
         * Indicates the starting and ending index of the country code in the text query that match the found title.
         * </p>
         * 
         * @param code
         *        Indicates the starting and ending index of the country code in the text query that match the found
         *        title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(Collection<Highlight> code);

        /**
         * <p>
         * Indicates the starting and ending index of the country code in the text query that match the found title.
         * </p>
         * 
         * @param code
         *        Indicates the starting and ending index of the country code in the text query that match the found
         *        title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(Highlight... code);

        /**
         * <p>
         * Indicates the starting and ending index of the country code in the text query that match the found title.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.Highlight#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder#build()} is called immediately and
         * its result is passed to {@link #code(List<Highlight>)}.
         * 
         * @param code
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #code(java.util.Collection<Highlight>)
         */
        Builder code(Consumer<Highlight.Builder>... code);

        /**
         * <p>
         * Indicates the starting and ending index of the country code in the text query that match the found title.
         * </p>
         * 
         * @param name
         *        Indicates the starting and ending index of the country code in the text query that match the found
         *        title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(Collection<Highlight> name);

        /**
         * <p>
         * Indicates the starting and ending index of the country code in the text query that match the found title.
         * </p>
         * 
         * @param name
         *        Indicates the starting and ending index of the country code in the text query that match the found
         *        title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(Highlight... name);

        /**
         * <p>
         * Indicates the starting and ending index of the country code in the text query that match the found title.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.Highlight#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder#build()} is called immediately and
         * its result is passed to {@link #name(List<Highlight>)}.
         * 
         * @param name
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #name(java.util.Collection<Highlight>)
         */
        Builder name(Consumer<Highlight.Builder>... name);
    }

    static final class BuilderImpl implements Builder {
        private List<Highlight> code = DefaultSdkAutoConstructList.getInstance();

        private List<Highlight> name = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CountryHighlights model) {
            code(model.code);
            name(model.name);
        }

        public final List<Highlight.Builder> getCode() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.code);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCode(Collection<Highlight.BuilderImpl> code) {
            this.code = HighlightListCopier.copyFromBuilder(code);
        }

        @Override
        public final Builder code(Collection<Highlight> code) {
            this.code = HighlightListCopier.copy(code);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder code(Highlight... code) {
            code(Arrays.asList(code));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder code(Consumer<Highlight.Builder>... code) {
            code(Stream.of(code).map(c -> Highlight.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Highlight.Builder> getName() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.name);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setName(Collection<Highlight.BuilderImpl> name) {
            this.name = HighlightListCopier.copyFromBuilder(name);
        }

        @Override
        public final Builder name(Collection<Highlight> name) {
            this.name = HighlightListCopier.copy(name);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder name(Highlight... name) {
            name(Arrays.asList(name));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder name(Consumer<Highlight.Builder>... name) {
            name(Stream.of(name).map(c -> Highlight.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CountryHighlights build() {
            return new CountryHighlights(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
