/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class IntersectionHighlightsListCopier {
    static List<List<Highlight>> copy(Collection<? extends Collection<? extends Highlight>> intersectionHighlightsListParam) {
        List<List<Highlight>> list;
        if (intersectionHighlightsListParam == null || intersectionHighlightsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<List<Highlight>> modifiableList = new ArrayList<>(intersectionHighlightsListParam.size());
            intersectionHighlightsListParam.forEach(entry -> {
                List<Highlight> list1;
                if (entry == null || entry instanceof SdkAutoConstructList) {
                    list1 = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<Highlight> modifiableList1 = new ArrayList<>(entry.size());
                    entry.forEach(entry1 -> {
                        modifiableList1.add(entry1);
                    });
                    list1 = Collections.unmodifiableList(modifiableList1);
                }
                modifiableList.add(list1);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<List<Highlight>> copyFromBuilder(
            Collection<? extends Collection<? extends Highlight.Builder>> intersectionHighlightsListParam) {
        List<List<Highlight>> list;
        if (intersectionHighlightsListParam == null || intersectionHighlightsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<List<Highlight>> modifiableList = new ArrayList<>(intersectionHighlightsListParam.size());
            intersectionHighlightsListParam.forEach(entry -> {
                List<Highlight> list1;
                if (entry == null || entry instanceof SdkAutoConstructList) {
                    list1 = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<Highlight> modifiableList1 = new ArrayList<>(entry.size());
                    entry.forEach(entry1 -> {
                        Highlight member = entry1 == null ? null : entry1.build();
                        modifiableList1.add(member);
                    });
                    list1 = Collections.unmodifiableList(modifiableList1);
                }
                modifiableList.add(list1);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<List<Highlight.Builder>> copyToBuilder(
            Collection<? extends Collection<? extends Highlight>> intersectionHighlightsListParam) {
        List<List<Highlight.Builder>> list;
        if (intersectionHighlightsListParam == null || intersectionHighlightsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<List<Highlight.Builder>> modifiableList = new ArrayList<>(intersectionHighlightsListParam.size());
            intersectionHighlightsListParam.forEach(entry -> {
                List<Highlight.Builder> list1;
                if (entry == null || entry instanceof SdkAutoConstructList) {
                    list1 = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<Highlight.Builder> modifiableList1 = new ArrayList<>(entry.size());
                    entry.forEach(entry1 -> {
                        Highlight.Builder member = entry1 == null ? null : entry1.toBuilder();
                        modifiableList1.add(member);
                    });
                    list1 = Collections.unmodifiableList(modifiableList1);
                }
                modifiableList.add(list1);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
