/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Place that is related to the result item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelatedPlace implements SdkPojo, Serializable, ToCopyableBuilder<RelatedPlace.Builder, RelatedPlace> {
    private static final SdkField<String> PLACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaceId").getter(getter(RelatedPlace::placeId)).setter(setter(Builder::placeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceId").build()).build();

    private static final SdkField<String> PLACE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaceType").getter(getter(RelatedPlace::placeTypeAsString)).setter(setter(Builder::placeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceType").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(RelatedPlace::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<Address> ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("Address").getter(getter(RelatedPlace::address)).setter(setter(Builder::address))
            .constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<List<Double>> POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Position")
            .getter(getter(RelatedPlace::position))
            .setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AccessPoint>> ACCESS_POINTS_FIELD = SdkField
            .<List<AccessPoint>> builder(MarshallingType.LIST)
            .memberName("AccessPoints")
            .getter(getter(RelatedPlace::accessPoints))
            .setter(setter(Builder::accessPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessPoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessPoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACE_ID_FIELD,
            PLACE_TYPE_FIELD, TITLE_FIELD, ADDRESS_FIELD, POSITION_FIELD, ACCESS_POINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String placeId;

    private final String placeType;

    private final String title;

    private final Address address;

    private final List<Double> position;

    private final List<AccessPoint> accessPoints;

    private RelatedPlace(BuilderImpl builder) {
        this.placeId = builder.placeId;
        this.placeType = builder.placeType;
        this.title = builder.title;
        this.address = builder.address;
        this.position = builder.position;
        this.accessPoints = builder.accessPoints;
    }

    /**
     * <p>
     * The <code>PlaceId</code> of the place result.
     * </p>
     * 
     * @return The <code>PlaceId</code> of the place result.
     */
    public final String placeId() {
        return placeId;
    }

    /**
     * <p>
     * A <code>PlaceType</code> is a category that the result place must belong to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #placeType} will
     * return {@link PlaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #placeTypeAsString}.
     * </p>
     * 
     * @return A <code>PlaceType</code> is a category that the result place must belong to.
     * @see PlaceType
     */
    public final PlaceType placeType() {
        return PlaceType.fromValue(placeType);
    }

    /**
     * <p>
     * A <code>PlaceType</code> is a category that the result place must belong to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #placeType} will
     * return {@link PlaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #placeTypeAsString}.
     * </p>
     * 
     * @return A <code>PlaceType</code> is a category that the result place must belong to.
     * @see PlaceType
     */
    public final String placeTypeAsString() {
        return placeType;
    }

    /**
     * <p>
     * The localized display name of this result item based on request parameter <code>language</code>.
     * </p>
     * 
     * @return The localized display name of this result item based on request parameter <code>language</code>.
     */
    public final String title() {
        return title;
    }

    /**
     * Returns the value of the Address property for this object.
     * 
     * @return The value of the Address property for this object.
     */
    public final Address address() {
        return address;
    }

    /**
     * For responses, this returns true if the service returned a value for the Position property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPosition() {
        return position != null && !(position instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The position, in longitude and latitude.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPosition} method.
     * </p>
     * 
     * @return The position, in longitude and latitude.
     */
    public final List<Double> position() {
        return position;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessPoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessPoints() {
        return accessPoints != null && !(accessPoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Position of the access point represented by longitude and latitude.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessPoints} method.
     * </p>
     * 
     * @return Position of the access point represented by longitude and latitude.
     */
    public final List<AccessPoint> accessPoints() {
        return accessPoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(placeId());
        hashCode = 31 * hashCode + Objects.hashCode(placeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(hasPosition() ? position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessPoints() ? accessPoints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedPlace)) {
            return false;
        }
        RelatedPlace other = (RelatedPlace) obj;
        return Objects.equals(placeId(), other.placeId()) && Objects.equals(placeTypeAsString(), other.placeTypeAsString())
                && Objects.equals(title(), other.title()) && Objects.equals(address(), other.address())
                && hasPosition() == other.hasPosition() && Objects.equals(position(), other.position())
                && hasAccessPoints() == other.hasAccessPoints() && Objects.equals(accessPoints(), other.accessPoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelatedPlace").add("PlaceId", placeId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PlaceType", placeTypeAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Title", title() == null ? null : "*** Sensitive Data Redacted ***").add("Address", address())
                .add("Position", position() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AccessPoints", hasAccessPoints() ? accessPoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlaceId":
            return Optional.ofNullable(clazz.cast(placeId()));
        case "PlaceType":
            return Optional.ofNullable(clazz.cast(placeTypeAsString()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "Position":
            return Optional.ofNullable(clazz.cast(position()));
        case "AccessPoints":
            return Optional.ofNullable(clazz.cast(accessPoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PlaceId", PLACE_ID_FIELD);
        map.put("PlaceType", PLACE_TYPE_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Address", ADDRESS_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("AccessPoints", ACCESS_POINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelatedPlace, T> g) {
        return obj -> g.apply((RelatedPlace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelatedPlace> {
        /**
         * <p>
         * The <code>PlaceId</code> of the place result.
         * </p>
         * 
         * @param placeId
         *        The <code>PlaceId</code> of the place result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placeId(String placeId);

        /**
         * <p>
         * A <code>PlaceType</code> is a category that the result place must belong to.
         * </p>
         * 
         * @param placeType
         *        A <code>PlaceType</code> is a category that the result place must belong to.
         * @see PlaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlaceType
         */
        Builder placeType(String placeType);

        /**
         * <p>
         * A <code>PlaceType</code> is a category that the result place must belong to.
         * </p>
         * 
         * @param placeType
         *        A <code>PlaceType</code> is a category that the result place must belong to.
         * @see PlaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlaceType
         */
        Builder placeType(PlaceType placeType);

        /**
         * <p>
         * The localized display name of this result item based on request parameter <code>language</code>.
         * </p>
         * 
         * @param title
         *        The localized display name of this result item based on request parameter <code>language</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * Sets the value of the Address property for this object.
         *
         * @param address
         *        The new value for the Address property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(Address address);

        /**
         * Sets the value of the Address property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #address(Address)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(Address)
         */
        default Builder address(Consumer<Address.Builder> address) {
            return address(Address.builder().applyMutation(address).build());
        }

        /**
         * <p>
         * The position, in longitude and latitude.
         * </p>
         * 
         * @param position
         *        The position, in longitude and latitude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Collection<Double> position);

        /**
         * <p>
         * The position, in longitude and latitude.
         * </p>
         * 
         * @param position
         *        The position, in longitude and latitude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Double... position);

        /**
         * <p>
         * Position of the access point represented by longitude and latitude.
         * </p>
         * 
         * @param accessPoints
         *        Position of the access point represented by longitude and latitude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPoints(Collection<AccessPoint> accessPoints);

        /**
         * <p>
         * Position of the access point represented by longitude and latitude.
         * </p>
         * 
         * @param accessPoints
         *        Position of the access point represented by longitude and latitude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPoints(AccessPoint... accessPoints);

        /**
         * <p>
         * Position of the access point represented by longitude and latitude.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.AccessPoint.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.AccessPoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.AccessPoint.Builder#build()} is called immediately and
         * its result is passed to {@link #accessPoints(List<AccessPoint>)}.
         * 
         * @param accessPoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.AccessPoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPoints(java.util.Collection<AccessPoint>)
         */
        Builder accessPoints(Consumer<AccessPoint.Builder>... accessPoints);
    }

    static final class BuilderImpl implements Builder {
        private String placeId;

        private String placeType;

        private String title;

        private Address address;

        private List<Double> position = DefaultSdkAutoConstructList.getInstance();

        private List<AccessPoint> accessPoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedPlace model) {
            placeId(model.placeId);
            placeType(model.placeType);
            title(model.title);
            address(model.address);
            position(model.position);
            accessPoints(model.accessPoints);
        }

        public final String getPlaceId() {
            return placeId;
        }

        public final void setPlaceId(String placeId) {
            this.placeId = placeId;
        }

        @Override
        public final Builder placeId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        public final String getPlaceType() {
            return placeType;
        }

        public final void setPlaceType(String placeType) {
            this.placeType = placeType;
        }

        @Override
        public final Builder placeType(String placeType) {
            this.placeType = placeType;
            return this;
        }

        @Override
        public final Builder placeType(PlaceType placeType) {
            this.placeType(placeType == null ? null : placeType.toString());
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Address.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (position instanceof SdkAutoConstructList) {
                return null;
            }
            return position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double... position) {
            position(Arrays.asList(position));
            return this;
        }

        public final List<AccessPoint.Builder> getAccessPoints() {
            List<AccessPoint.Builder> result = AccessPointListCopier.copyToBuilder(this.accessPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessPoints(Collection<AccessPoint.BuilderImpl> accessPoints) {
            this.accessPoints = AccessPointListCopier.copyFromBuilder(accessPoints);
        }

        @Override
        public final Builder accessPoints(Collection<AccessPoint> accessPoints) {
            this.accessPoints = AccessPointListCopier.copy(accessPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPoints(AccessPoint... accessPoints) {
            accessPoints(Arrays.asList(accessPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPoints(Consumer<AccessPoint.Builder>... accessPoints) {
            accessPoints(Stream.of(accessPoints).map(c -> AccessPoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RelatedPlace build() {
            return new RelatedPlace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
