/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchNearbyRequest extends GeoPlacesRequest implements
        ToCopyableBuilder<SearchNearbyRequest.Builder, SearchNearbyRequest> {
    private static final SdkField<List<Double>> QUERY_POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("QueryPosition")
            .getter(getter(SearchNearbyRequest::queryPosition))
            .setter(setter(Builder::queryPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryPosition").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> QUERY_RADIUS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("QueryRadius").getter(getter(SearchNearbyRequest::queryRadius)).setter(setter(Builder::queryRadius))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryRadius").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(SearchNearbyRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<SearchNearbyFilter> FILTER_FIELD = SdkField
            .<SearchNearbyFilter> builder(MarshallingType.SDK_POJO).memberName("Filter")
            .getter(getter(SearchNearbyRequest::filter)).setter(setter(Builder::filter)).constructor(SearchNearbyFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<List<String>> ADDITIONAL_FEATURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalFeatures")
            .getter(getter(SearchNearbyRequest::additionalFeaturesAsStrings))
            .setter(setter(Builder::additionalFeaturesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Language").getter(getter(SearchNearbyRequest::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()).build();

    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoliticalView").getter(getter(SearchNearbyRequest::politicalView))
            .setter(setter(Builder::politicalView))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoliticalView").build()).build();

    private static final SdkField<String> INTENDED_USE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntendedUse").getter(getter(SearchNearbyRequest::intendedUseAsString))
            .setter(setter(Builder::intendedUse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntendedUse").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchNearbyRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(SearchNearbyRequest::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_POSITION_FIELD,
            QUERY_RADIUS_FIELD, MAX_RESULTS_FIELD, FILTER_FIELD, ADDITIONAL_FEATURES_FIELD, LANGUAGE_FIELD, POLITICAL_VIEW_FIELD,
            INTENDED_USE_FIELD, NEXT_TOKEN_FIELD, KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Double> queryPosition;

    private final Long queryRadius;

    private final Integer maxResults;

    private final SearchNearbyFilter filter;

    private final List<String> additionalFeatures;

    private final String language;

    private final String politicalView;

    private final String intendedUse;

    private final String nextToken;

    private final String key;

    private SearchNearbyRequest(BuilderImpl builder) {
        super(builder);
        this.queryPosition = builder.queryPosition;
        this.queryRadius = builder.queryRadius;
        this.maxResults = builder.maxResults;
        this.filter = builder.filter;
        this.additionalFeatures = builder.additionalFeatures;
        this.language = builder.language;
        this.politicalView = builder.politicalView;
        this.intendedUse = builder.intendedUse;
        this.nextToken = builder.nextToken;
        this.key = builder.key;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryPosition property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQueryPosition() {
        return queryPosition != null && !(queryPosition instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The position, in <code>[lng, lat]</code> for which you are querying nearby results for. Results closer to the
     * position will be ranked higher then results further away from the position
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryPosition} method.
     * </p>
     * 
     * @return The position, in <code>[lng, lat]</code> for which you are querying nearby results for. Results closer to
     *         the position will be ranked higher then results further away from the position
     */
    public final List<Double> queryPosition() {
        return queryPosition;
    }

    /**
     * <p>
     * The maximum distance in meters from the QueryPosition from which a result will be returned.
     * </p>
     * <note>
     * <p>
     * The fields <code>QueryText</code>, and <code>QueryID</code> are mutually exclusive.
     * </p>
     * </note>
     * 
     * @return The maximum distance in meters from the QueryPosition from which a result will be returned.</p> <note>
     *         <p>
     *         The fields <code>QueryText</code>, and <code>QueryID</code> are mutually exclusive.
     *         </p>
     */
    public final Long queryRadius() {
        return queryRadius;
    }

    /**
     * <p>
     * An optional limit for the number of results returned in a single call.
     * </p>
     * 
     * @return An optional limit for the number of results returned in a single call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A structure which contains a set of inclusion/exclusion properties that results must possess in order to be
     * returned as a result.
     * </p>
     * 
     * @return A structure which contains a set of inclusion/exclusion properties that results must possess in order to
     *         be returned as a result.
     */
    public final SearchNearbyFilter filter() {
        return filter;
    }

    /**
     * <p>
     * A list of optional additional parameters, such as time zone, that can be requested for each result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalFeatures} method.
     * </p>
     * 
     * @return A list of optional additional parameters, such as time zone, that can be requested for each result.
     */
    public final List<SearchNearbyAdditionalFeature> additionalFeatures() {
        return SearchNearbyAdditionalFeatureListCopier.copyStringToEnum(additionalFeatures);
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalFeatures property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalFeatures() {
        return additionalFeatures != null && !(additionalFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of optional additional parameters, such as time zone, that can be requested for each result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalFeatures} method.
     * </p>
     * 
     * @return A list of optional additional parameters, such as time zone, that can be requested for each result.
     */
    public final List<String> additionalFeaturesAsStrings() {
        return additionalFeatures;
    }

    /**
     * <p>
     * A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language codes for the
     * results to be rendered in. If there is no data for the result in the requested language, data will be returned in
     * the default language for the entry.
     * </p>
     * 
     * @return A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language codes
     *         for the results to be rendered in. If there is no data for the result in the requested language, data
     *         will be returned in the default language for the entry.
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * The alpha-2 or alpha-3 character code for the political view of a country. The political view applies to the
     * results of the request to represent unresolved territorial claims through the point of view of the specified
     * country.
     * </p>
     * 
     * @return The alpha-2 or alpha-3 character code for the political view of a country. The political view applies to
     *         the results of the request to represent unresolved territorial claims through the point of view of the
     *         specified country.
     */
    public final String politicalView() {
        return politicalView;
    }

    /**
     * <p>
     * Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
     * </p>
     * <note>
     * <p>
     * Storing the response of an SearchNearby query is required to comply with service terms, but charged at a higher
     * cost per request. Please review the <a href="https://aws.amazon.com/location/sla/">user agreement</a> and <a
     * href="https://aws.amazon.com/location/pricing/">service pricing structure</a> to determine the correct setting
     * for your use case.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intendedUse} will
     * return {@link SearchNearbyIntendedUse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #intendedUseAsString}.
     * </p>
     * 
     * @return Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.</p> <note>
     *         <p>
     *         Storing the response of an SearchNearby query is required to comply with service terms, but charged at a
     *         higher cost per request. Please review the <a href="https://aws.amazon.com/location/sla/">user
     *         agreement</a> and <a href="https://aws.amazon.com/location/pricing/">service pricing structure</a> to
     *         determine the correct setting for your use case.
     *         </p>
     * @see SearchNearbyIntendedUse
     */
    public final SearchNearbyIntendedUse intendedUse() {
        return SearchNearbyIntendedUse.fromValue(intendedUse);
    }

    /**
     * <p>
     * Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
     * </p>
     * <note>
     * <p>
     * Storing the response of an SearchNearby query is required to comply with service terms, but charged at a higher
     * cost per request. Please review the <a href="https://aws.amazon.com/location/sla/">user agreement</a> and <a
     * href="https://aws.amazon.com/location/pricing/">service pricing structure</a> to determine the correct setting
     * for your use case.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intendedUse} will
     * return {@link SearchNearbyIntendedUse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #intendedUseAsString}.
     * </p>
     * 
     * @return Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.</p> <note>
     *         <p>
     *         Storing the response of an SearchNearby query is required to comply with service terms, but charged at a
     *         higher cost per request. Please review the <a href="https://aws.amazon.com/location/sla/">user
     *         agreement</a> and <a href="https://aws.amazon.com/location/pricing/">service pricing structure</a> to
     *         determine the correct setting for your use case.
     *         </p>
     * @see SearchNearbyIntendedUse
     */
    public final String intendedUseAsString() {
        return intendedUse;
    }

    /**
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page.
     * </p>
     * 
     * @return If <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be provided
     * when making a request.
     * </p>
     * 
     * @return Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
     *         provided when making a request.
     */
    public final String key() {
        return key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryPosition() ? queryPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(queryRadius());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalFeatures() ? additionalFeaturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(intendedUseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchNearbyRequest)) {
            return false;
        }
        SearchNearbyRequest other = (SearchNearbyRequest) obj;
        return hasQueryPosition() == other.hasQueryPosition() && Objects.equals(queryPosition(), other.queryPosition())
                && Objects.equals(queryRadius(), other.queryRadius()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(filter(), other.filter()) && hasAdditionalFeatures() == other.hasAdditionalFeatures()
                && Objects.equals(additionalFeaturesAsStrings(), other.additionalFeaturesAsStrings())
                && Objects.equals(language(), other.language()) && Objects.equals(politicalView(), other.politicalView())
                && Objects.equals(intendedUseAsString(), other.intendedUseAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(key(), other.key());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchNearbyRequest")
                .add("QueryPosition", queryPosition() == null ? null : "*** Sensitive Data Redacted ***")
                .add("QueryRadius", queryRadius() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MaxResults", maxResults()).add("Filter", filter())
                .add("AdditionalFeatures", hasAdditionalFeatures() ? additionalFeaturesAsStrings() : null)
                .add("Language", language())
                .add("PoliticalView", politicalView() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IntendedUse", intendedUseAsString()).add("NextToken", nextToken())
                .add("Key", key() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryPosition":
            return Optional.ofNullable(clazz.cast(queryPosition()));
        case "QueryRadius":
            return Optional.ofNullable(clazz.cast(queryRadius()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "AdditionalFeatures":
            return Optional.ofNullable(clazz.cast(additionalFeaturesAsStrings()));
        case "Language":
            return Optional.ofNullable(clazz.cast(language()));
        case "PoliticalView":
            return Optional.ofNullable(clazz.cast(politicalView()));
        case "IntendedUse":
            return Optional.ofNullable(clazz.cast(intendedUseAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueryPosition", QUERY_POSITION_FIELD);
        map.put("QueryRadius", QUERY_RADIUS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("AdditionalFeatures", ADDITIONAL_FEATURES_FIELD);
        map.put("Language", LANGUAGE_FIELD);
        map.put("PoliticalView", POLITICAL_VIEW_FIELD);
        map.put("IntendedUse", INTENDED_USE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("key", KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchNearbyRequest, T> g) {
        return obj -> g.apply((SearchNearbyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GeoPlacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchNearbyRequest> {
        /**
         * <p>
         * The position, in <code>[lng, lat]</code> for which you are querying nearby results for. Results closer to the
         * position will be ranked higher then results further away from the position
         * </p>
         * 
         * @param queryPosition
         *        The position, in <code>[lng, lat]</code> for which you are querying nearby results for. Results closer
         *        to the position will be ranked higher then results further away from the position
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryPosition(Collection<Double> queryPosition);

        /**
         * <p>
         * The position, in <code>[lng, lat]</code> for which you are querying nearby results for. Results closer to the
         * position will be ranked higher then results further away from the position
         * </p>
         * 
         * @param queryPosition
         *        The position, in <code>[lng, lat]</code> for which you are querying nearby results for. Results closer
         *        to the position will be ranked higher then results further away from the position
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryPosition(Double... queryPosition);

        /**
         * <p>
         * The maximum distance in meters from the QueryPosition from which a result will be returned.
         * </p>
         * <note>
         * <p>
         * The fields <code>QueryText</code>, and <code>QueryID</code> are mutually exclusive.
         * </p>
         * </note>
         * 
         * @param queryRadius
         *        The maximum distance in meters from the QueryPosition from which a result will be returned.</p> <note>
         *        <p>
         *        The fields <code>QueryText</code>, and <code>QueryID</code> are mutually exclusive.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryRadius(Long queryRadius);

        /**
         * <p>
         * An optional limit for the number of results returned in a single call.
         * </p>
         * 
         * @param maxResults
         *        An optional limit for the number of results returned in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A structure which contains a set of inclusion/exclusion properties that results must possess in order to be
         * returned as a result.
         * </p>
         * 
         * @param filter
         *        A structure which contains a set of inclusion/exclusion properties that results must possess in order
         *        to be returned as a result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(SearchNearbyFilter filter);

        /**
         * <p>
         * A structure which contains a set of inclusion/exclusion properties that results must possess in order to be
         * returned as a result.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchNearbyFilter.Builder} avoiding the
         * need to create one manually via {@link SearchNearbyFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchNearbyFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(SearchNearbyFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link SearchNearbyFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(SearchNearbyFilter)
         */
        default Builder filter(Consumer<SearchNearbyFilter.Builder> filter) {
            return filter(SearchNearbyFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * A list of optional additional parameters, such as time zone, that can be requested for each result.
         * </p>
         * 
         * @param additionalFeatures
         *        A list of optional additional parameters, such as time zone, that can be requested for each result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalFeaturesWithStrings(Collection<String> additionalFeatures);

        /**
         * <p>
         * A list of optional additional parameters, such as time zone, that can be requested for each result.
         * </p>
         * 
         * @param additionalFeatures
         *        A list of optional additional parameters, such as time zone, that can be requested for each result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalFeaturesWithStrings(String... additionalFeatures);

        /**
         * <p>
         * A list of optional additional parameters, such as time zone, that can be requested for each result.
         * </p>
         * 
         * @param additionalFeatures
         *        A list of optional additional parameters, such as time zone, that can be requested for each result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalFeatures(Collection<SearchNearbyAdditionalFeature> additionalFeatures);

        /**
         * <p>
         * A list of optional additional parameters, such as time zone, that can be requested for each result.
         * </p>
         * 
         * @param additionalFeatures
         *        A list of optional additional parameters, such as time zone, that can be requested for each result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalFeatures(SearchNearbyAdditionalFeature... additionalFeatures);

        /**
         * <p>
         * A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language codes for
         * the results to be rendered in. If there is no data for the result in the requested language, data will be
         * returned in the default language for the entry.
         * </p>
         * 
         * @param language
         *        A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language
         *        codes for the results to be rendered in. If there is no data for the result in the requested language,
         *        data will be returned in the default language for the entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * The alpha-2 or alpha-3 character code for the political view of a country. The political view applies to the
         * results of the request to represent unresolved territorial claims through the point of view of the specified
         * country.
         * </p>
         * 
         * @param politicalView
         *        The alpha-2 or alpha-3 character code for the political view of a country. The political view applies
         *        to the results of the request to represent unresolved territorial claims through the point of view of
         *        the specified country.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder politicalView(String politicalView);

        /**
         * <p>
         * Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
         * </p>
         * <note>
         * <p>
         * Storing the response of an SearchNearby query is required to comply with service terms, but charged at a
         * higher cost per request. Please review the <a href="https://aws.amazon.com/location/sla/">user agreement</a>
         * and <a href="https://aws.amazon.com/location/pricing/">service pricing structure</a> to determine the correct
         * setting for your use case.
         * </p>
         * </note>
         * 
         * @param intendedUse
         *        Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.</p> <note>
         *        <p>
         *        Storing the response of an SearchNearby query is required to comply with service terms, but charged at
         *        a higher cost per request. Please review the <a href="https://aws.amazon.com/location/sla/">user
         *        agreement</a> and <a href="https://aws.amazon.com/location/pricing/">service pricing structure</a> to
         *        determine the correct setting for your use case.
         *        </p>
         * @see SearchNearbyIntendedUse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchNearbyIntendedUse
         */
        Builder intendedUse(String intendedUse);

        /**
         * <p>
         * Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.
         * </p>
         * <note>
         * <p>
         * Storing the response of an SearchNearby query is required to comply with service terms, but charged at a
         * higher cost per request. Please review the <a href="https://aws.amazon.com/location/sla/">user agreement</a>
         * and <a href="https://aws.amazon.com/location/pricing/">service pricing structure</a> to determine the correct
         * setting for your use case.
         * </p>
         * </note>
         * 
         * @param intendedUse
         *        Indicates if the results will be stored. Defaults to <code>SingleUse</code>, if left empty.</p> <note>
         *        <p>
         *        Storing the response of an SearchNearby query is required to comply with service terms, but charged at
         *        a higher cost per request. Please review the <a href="https://aws.amazon.com/location/sla/">user
         *        agreement</a> and <a href="https://aws.amazon.com/location/pricing/">service pricing structure</a> to
         *        determine the correct setting for your use case.
         *        </p>
         * @see SearchNearbyIntendedUse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchNearbyIntendedUse
         */
        Builder intendedUse(SearchNearbyIntendedUse intendedUse);

        /**
         * <p>
         * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code>
         * is a unique pagination token for each page.
         * </p>
         * 
         * @param nextToken
         *        If <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
         * provided when making a request.
         * </p>
         * 
         * @param key
         *        Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
         *        provided when making a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GeoPlacesRequest.BuilderImpl implements Builder {
        private List<Double> queryPosition = DefaultSdkAutoConstructList.getInstance();

        private Long queryRadius;

        private Integer maxResults;

        private SearchNearbyFilter filter;

        private List<String> additionalFeatures = DefaultSdkAutoConstructList.getInstance();

        private String language;

        private String politicalView;

        private String intendedUse;

        private String nextToken;

        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchNearbyRequest model) {
            super(model);
            queryPosition(model.queryPosition);
            queryRadius(model.queryRadius);
            maxResults(model.maxResults);
            filter(model.filter);
            additionalFeaturesWithStrings(model.additionalFeatures);
            language(model.language);
            politicalView(model.politicalView);
            intendedUse(model.intendedUse);
            nextToken(model.nextToken);
            key(model.key);
        }

        public final Collection<Double> getQueryPosition() {
            if (queryPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return queryPosition;
        }

        public final void setQueryPosition(Collection<Double> queryPosition) {
            this.queryPosition = PositionCopier.copy(queryPosition);
        }

        @Override
        public final Builder queryPosition(Collection<Double> queryPosition) {
            this.queryPosition = PositionCopier.copy(queryPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryPosition(Double... queryPosition) {
            queryPosition(Arrays.asList(queryPosition));
            return this;
        }

        public final Long getQueryRadius() {
            return queryRadius;
        }

        public final void setQueryRadius(Long queryRadius) {
            this.queryRadius = queryRadius;
        }

        @Override
        public final Builder queryRadius(Long queryRadius) {
            this.queryRadius = queryRadius;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final SearchNearbyFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(SearchNearbyFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(SearchNearbyFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Collection<String> getAdditionalFeatures() {
            if (additionalFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalFeatures;
        }

        public final void setAdditionalFeatures(Collection<String> additionalFeatures) {
            this.additionalFeatures = SearchNearbyAdditionalFeatureListCopier.copy(additionalFeatures);
        }

        @Override
        public final Builder additionalFeaturesWithStrings(Collection<String> additionalFeatures) {
            this.additionalFeatures = SearchNearbyAdditionalFeatureListCopier.copy(additionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalFeaturesWithStrings(String... additionalFeatures) {
            additionalFeaturesWithStrings(Arrays.asList(additionalFeatures));
            return this;
        }

        @Override
        public final Builder additionalFeatures(Collection<SearchNearbyAdditionalFeature> additionalFeatures) {
            this.additionalFeatures = SearchNearbyAdditionalFeatureListCopier.copyEnumToString(additionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalFeatures(SearchNearbyAdditionalFeature... additionalFeatures) {
            additionalFeatures(Arrays.asList(additionalFeatures));
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getPoliticalView() {
            return politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final String getIntendedUse() {
            return intendedUse;
        }

        public final void setIntendedUse(String intendedUse) {
            this.intendedUse = intendedUse;
        }

        @Override
        public final Builder intendedUse(String intendedUse) {
            this.intendedUse = intendedUse;
            return this;
        }

        @Override
        public final Builder intendedUse(SearchNearbyIntendedUse intendedUse) {
            this.intendedUse(intendedUse == null ? null : intendedUse.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchNearbyRequest build() {
            return new SearchNearbyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
