/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Match score for a secondary address component in the result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecondaryAddressComponentMatchScore implements SdkPojo, Serializable,
        ToCopyableBuilder<SecondaryAddressComponentMatchScore.Builder, SecondaryAddressComponentMatchScore> {
    private static final SdkField<Double> NUMBER_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Number")
            .getter(getter(SecondaryAddressComponentMatchScore::number)).setter(setter(Builder::number))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Number").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double number;

    private SecondaryAddressComponentMatchScore(BuilderImpl builder) {
        this.number = builder.number;
    }

    /**
     * <p>
     * Match score for the secondary address number.
     * </p>
     * 
     * @return Match score for the secondary address number.
     */
    public final Double number() {
        return number;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(number());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecondaryAddressComponentMatchScore)) {
            return false;
        }
        SecondaryAddressComponentMatchScore other = (SecondaryAddressComponentMatchScore) obj;
        return Objects.equals(number(), other.number());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecondaryAddressComponentMatchScore").add("Number", number()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Number":
            return Optional.ofNullable(clazz.cast(number()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Number", NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecondaryAddressComponentMatchScore, T> g) {
        return obj -> g.apply((SecondaryAddressComponentMatchScore) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecondaryAddressComponentMatchScore> {
        /**
         * <p>
         * Match score for the secondary address number.
         * </p>
         * 
         * @param number
         *        Match score for the secondary address number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder number(Double number);
    }

    static final class BuilderImpl implements Builder {
        private Double number;

        private BuilderImpl() {
        }

        private BuilderImpl(SecondaryAddressComponentMatchScore model) {
            number(model.number);
        }

        public final Double getNumber() {
            return number;
        }

        public final void setNumber(Double number) {
            this.number = number;
        }

        @Override
        public final Builder number(Double number) {
            this.number = number;
            return this;
        }

        @Override
        public SecondaryAddressComponentMatchScore build() {
            return new SecondaryAddressComponentMatchScore(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
