/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes how the parts of the textQuery matched the input query by returning the sections of the response which
 * matched to textQuery terms.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuggestAddressHighlights implements SdkPojo, Serializable,
        ToCopyableBuilder<SuggestAddressHighlights.Builder, SuggestAddressHighlights> {
    private static final SdkField<List<Highlight>> LABEL_FIELD = SdkField
            .<List<Highlight>> builder(MarshallingType.LIST)
            .memberName("Label")
            .getter(getter(SuggestAddressHighlights::label))
            .setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Highlight> builder(MarshallingType.SDK_POJO)
                                            .constructor(Highlight::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Highlight> label;

    private SuggestAddressHighlights(BuilderImpl builder) {
        this.label = builder.label;
    }

    /**
     * For responses, this returns true if the service returned a value for the Label property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasLabel() {
        return label != null && !(label instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the starting and ending indexes of the places in the result which were identified to match the
     * textQuery. This result is useful for providing emphasis to results where the user query directly matched to make
     * selecting the correct result from a list easier for an end user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabel} method.
     * </p>
     * 
     * @return Indicates the starting and ending indexes of the places in the result which were identified to match the
     *         textQuery. This result is useful for providing emphasis to results where the user query directly matched
     *         to make selecting the correct result from a list easier for an end user.
     */
    public final List<Highlight> label() {
        return label;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLabel() ? label() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestAddressHighlights)) {
            return false;
        }
        SuggestAddressHighlights other = (SuggestAddressHighlights) obj;
        return hasLabel() == other.hasLabel() && Objects.equals(label(), other.label());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuggestAddressHighlights").add("Label", hasLabel() ? label() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Label", LABEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SuggestAddressHighlights, T> g) {
        return obj -> g.apply((SuggestAddressHighlights) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuggestAddressHighlights> {
        /**
         * <p>
         * Indicates the starting and ending indexes of the places in the result which were identified to match the
         * textQuery. This result is useful for providing emphasis to results where the user query directly matched to
         * make selecting the correct result from a list easier for an end user.
         * </p>
         * 
         * @param label
         *        Indicates the starting and ending indexes of the places in the result which were identified to match
         *        the textQuery. This result is useful for providing emphasis to results where the user query directly
         *        matched to make selecting the correct result from a list easier for an end user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(Collection<Highlight> label);

        /**
         * <p>
         * Indicates the starting and ending indexes of the places in the result which were identified to match the
         * textQuery. This result is useful for providing emphasis to results where the user query directly matched to
         * make selecting the correct result from a list easier for an end user.
         * </p>
         * 
         * @param label
         *        Indicates the starting and ending indexes of the places in the result which were identified to match
         *        the textQuery. This result is useful for providing emphasis to results where the user query directly
         *        matched to make selecting the correct result from a list easier for an end user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(Highlight... label);

        /**
         * <p>
         * Indicates the starting and ending indexes of the places in the result which were identified to match the
         * textQuery. This result is useful for providing emphasis to results where the user query directly matched to
         * make selecting the correct result from a list easier for an end user.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.geoplaces.model.Highlight#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder#build()} is called immediately and
         * its result is passed to {@link #label(List<Highlight>)}.
         * 
         * @param label
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.Highlight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #label(java.util.Collection<Highlight>)
         */
        Builder label(Consumer<Highlight.Builder>... label);
    }

    static final class BuilderImpl implements Builder {
        private List<Highlight> label = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestAddressHighlights model) {
            label(model.label);
        }

        public final List<Highlight.Builder> getLabel() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.label);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLabel(Collection<Highlight.BuilderImpl> label) {
            this.label = HighlightListCopier.copyFromBuilder(label);
        }

        @Override
        public final Builder label(Collection<Highlight> label) {
            this.label = HighlightListCopier.copy(label);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder label(Highlight... label) {
            label(Arrays.asList(label));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder label(Consumer<Highlight.Builder>... label) {
            label(Stream.of(label).map(c -> Highlight.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SuggestAddressHighlights build() {
            return new SuggestAddressHighlights(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
