/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates how well the entire input matches the returned. It is equal to 1 if all input tokens are recognized and
 * matched.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddressComponentMatchScores implements SdkPojo, Serializable,
        ToCopyableBuilder<AddressComponentMatchScores.Builder, AddressComponentMatchScores> {
    private static final SdkField<Double> COUNTRY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Country")
            .getter(getter(AddressComponentMatchScores::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<Double> REGION_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Region")
            .getter(getter(AddressComponentMatchScores::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<Double> SUB_REGION_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("SubRegion").getter(getter(AddressComponentMatchScores::subRegion)).setter(setter(Builder::subRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubRegion").build()).build();

    private static final SdkField<Double> LOCALITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Locality").getter(getter(AddressComponentMatchScores::locality)).setter(setter(Builder::locality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locality").build()).build();

    private static final SdkField<Double> DISTRICT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("District").getter(getter(AddressComponentMatchScores::district)).setter(setter(Builder::district))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("District").build()).build();

    private static final SdkField<Double> SUB_DISTRICT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("SubDistrict").getter(getter(AddressComponentMatchScores::subDistrict))
            .setter(setter(Builder::subDistrict))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubDistrict").build()).build();

    private static final SdkField<Double> POSTAL_CODE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("PostalCode").getter(getter(AddressComponentMatchScores::postalCode)).setter(setter(Builder::postalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()).build();

    private static final SdkField<Double> BLOCK_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Block")
            .getter(getter(AddressComponentMatchScores::block)).setter(setter(Builder::block))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Block").build()).build();

    private static final SdkField<Double> SUB_BLOCK_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("SubBlock").getter(getter(AddressComponentMatchScores::subBlock)).setter(setter(Builder::subBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubBlock").build()).build();

    private static final SdkField<List<Double>> INTERSECTION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Intersection")
            .getter(getter(AddressComponentMatchScores::intersection))
            .setter(setter(Builder::intersection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Intersection").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> ADDRESS_NUMBER_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("AddressNumber").getter(getter(AddressComponentMatchScores::addressNumber))
            .setter(setter(Builder::addressNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressNumber").build()).build();

    private static final SdkField<Double> BUILDING_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Building").getter(getter(AddressComponentMatchScores::building)).setter(setter(Builder::building))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Building").build()).build();

    private static final SdkField<List<SecondaryAddressComponentMatchScore>> SECONDARY_ADDRESS_COMPONENTS_FIELD = SdkField
            .<List<SecondaryAddressComponentMatchScore>> builder(MarshallingType.LIST)
            .memberName("SecondaryAddressComponents")
            .getter(getter(AddressComponentMatchScores::secondaryAddressComponents))
            .setter(setter(Builder::secondaryAddressComponents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryAddressComponents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecondaryAddressComponentMatchScore> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecondaryAddressComponentMatchScore::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_FIELD, REGION_FIELD,
            SUB_REGION_FIELD, LOCALITY_FIELD, DISTRICT_FIELD, SUB_DISTRICT_FIELD, POSTAL_CODE_FIELD, BLOCK_FIELD,
            SUB_BLOCK_FIELD, INTERSECTION_FIELD, ADDRESS_NUMBER_FIELD, BUILDING_FIELD, SECONDARY_ADDRESS_COMPONENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double country;

    private final Double region;

    private final Double subRegion;

    private final Double locality;

    private final Double district;

    private final Double subDistrict;

    private final Double postalCode;

    private final Double block;

    private final Double subBlock;

    private final List<Double> intersection;

    private final Double addressNumber;

    private final Double building;

    private final List<SecondaryAddressComponentMatchScore> secondaryAddressComponents;

    private AddressComponentMatchScores(BuilderImpl builder) {
        this.country = builder.country;
        this.region = builder.region;
        this.subRegion = builder.subRegion;
        this.locality = builder.locality;
        this.district = builder.district;
        this.subDistrict = builder.subDistrict;
        this.postalCode = builder.postalCode;
        this.block = builder.block;
        this.subBlock = builder.subBlock;
        this.intersection = builder.intersection;
        this.addressNumber = builder.addressNumber;
        this.building = builder.building;
        this.secondaryAddressComponents = builder.secondaryAddressComponents;
    }

    /**
     * <p>
     * The alpha-2 or alpha-3 character code for the country that the results will be present in.
     * </p>
     * 
     * @return The alpha-2 or alpha-3 character code for the country that the results will be present in.
     */
    public final Double country() {
        return country;
    }

    /**
     * <p>
     * The region or state results should be to be present in.
     * </p>
     * <p>
     * Example: <code>North Rhine-Westphalia</code>.
     * </p>
     * 
     * @return The region or state results should be to be present in. </p>
     *         <p>
     *         Example: <code>North Rhine-Westphalia</code>.
     */
    public final Double region() {
        return region;
    }

    /**
     * <p>
     * The sub-region or county for which results should be present in.
     * </p>
     * 
     * @return The sub-region or county for which results should be present in.
     */
    public final Double subRegion() {
        return subRegion;
    }

    /**
     * <p>
     * The city or locality results should be present in.
     * </p>
     * <p>
     * Example: <code>Vancouver</code>.
     * </p>
     * 
     * @return The city or locality results should be present in. </p>
     *         <p>
     *         Example: <code>Vancouver</code>.
     */
    public final Double locality() {
        return locality;
    }

    /**
     * <p>
     * The district or division of a city the results should be present in.
     * </p>
     * 
     * @return The district or division of a city the results should be present in.
     */
    public final Double district() {
        return district;
    }

    /**
     * <p>
     * A subdivision of a district.
     * </p>
     * <p>
     * Example: <code>Minden-Lübbecke</code>
     * </p>
     * 
     * @return A subdivision of a district. </p>
     *         <p>
     *         Example: <code>Minden-Lübbecke</code>
     */
    public final Double subDistrict() {
        return subDistrict;
    }

    /**
     * <p>
     * An alphanumeric string included in a postal address to facilitate mail sorting, such as post code, postcode, or
     * ZIP code, for which the result should possess.
     * </p>
     * 
     * @return An alphanumeric string included in a postal address to facilitate mail sorting, such as post code,
     *         postcode, or ZIP code, for which the result should possess.
     */
    public final Double postalCode() {
        return postalCode;
    }

    /**
     * <p>
     * Name of the block.
     * </p>
     * <p>
     * Example: <code>Sunny Mansion 203 block: 2 Chome</code>
     * </p>
     * 
     * @return Name of the block. </p>
     *         <p>
     *         Example: <code>Sunny Mansion 203 block: 2 Chome</code>
     */
    public final Double block() {
        return block;
    }

    /**
     * <p>
     * Name of sub-block.
     * </p>
     * <p>
     * Example: <code>Sunny Mansion 203 sub-block: 4</code>
     * </p>
     * 
     * @return Name of sub-block. </p>
     *         <p>
     *         Example: <code>Sunny Mansion 203 sub-block: 4</code>
     */
    public final Double subBlock() {
        return subBlock;
    }

    /**
     * For responses, this returns true if the service returned a value for the Intersection property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIntersection() {
        return intersection != null && !(intersection instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Name of the streets in the intersection.
     * </p>
     * <p>
     * Example: <code>["Friedrichstraße","Unter den Linden"]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntersection} method.
     * </p>
     * 
     * @return Name of the streets in the intersection. </p>
     *         <p>
     *         Example: <code>["Friedrichstraße","Unter den Linden"]</code>
     */
    public final List<Double> intersection() {
        return intersection;
    }

    /**
     * <p>
     * The house number or address results should have.
     * </p>
     * 
     * @return The house number or address results should have.
     */
    public final Double addressNumber() {
        return addressNumber;
    }

    /**
     * <p>
     * The name of the building at the address.
     * </p>
     * 
     * @return The name of the building at the address.
     */
    public final Double building() {
        return building;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecondaryAddressComponents property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSecondaryAddressComponents() {
        return secondaryAddressComponents != null && !(secondaryAddressComponents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Match scores for the secondary address components in the result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecondaryAddressComponents} method.
     * </p>
     * 
     * @return Match scores for the secondary address components in the result.
     */
    public final List<SecondaryAddressComponentMatchScore> secondaryAddressComponents() {
        return secondaryAddressComponents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(subRegion());
        hashCode = 31 * hashCode + Objects.hashCode(locality());
        hashCode = 31 * hashCode + Objects.hashCode(district());
        hashCode = 31 * hashCode + Objects.hashCode(subDistrict());
        hashCode = 31 * hashCode + Objects.hashCode(postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(block());
        hashCode = 31 * hashCode + Objects.hashCode(subBlock());
        hashCode = 31 * hashCode + Objects.hashCode(hasIntersection() ? intersection() : null);
        hashCode = 31 * hashCode + Objects.hashCode(addressNumber());
        hashCode = 31 * hashCode + Objects.hashCode(building());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecondaryAddressComponents() ? secondaryAddressComponents() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressComponentMatchScores)) {
            return false;
        }
        AddressComponentMatchScores other = (AddressComponentMatchScores) obj;
        return Objects.equals(country(), other.country()) && Objects.equals(region(), other.region())
                && Objects.equals(subRegion(), other.subRegion()) && Objects.equals(locality(), other.locality())
                && Objects.equals(district(), other.district()) && Objects.equals(subDistrict(), other.subDistrict())
                && Objects.equals(postalCode(), other.postalCode()) && Objects.equals(block(), other.block())
                && Objects.equals(subBlock(), other.subBlock()) && hasIntersection() == other.hasIntersection()
                && Objects.equals(intersection(), other.intersection()) && Objects.equals(addressNumber(), other.addressNumber())
                && Objects.equals(building(), other.building())
                && hasSecondaryAddressComponents() == other.hasSecondaryAddressComponents()
                && Objects.equals(secondaryAddressComponents(), other.secondaryAddressComponents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddressComponentMatchScores").add("Country", country()).add("Region", region())
                .add("SubRegion", subRegion()).add("Locality", locality()).add("District", district())
                .add("SubDistrict", subDistrict()).add("PostalCode", postalCode()).add("Block", block())
                .add("SubBlock", subBlock()).add("Intersection", hasIntersection() ? intersection() : null)
                .add("AddressNumber", addressNumber()).add("Building", building())
                .add("SecondaryAddressComponents", hasSecondaryAddressComponents() ? secondaryAddressComponents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "SubRegion":
            return Optional.ofNullable(clazz.cast(subRegion()));
        case "Locality":
            return Optional.ofNullable(clazz.cast(locality()));
        case "District":
            return Optional.ofNullable(clazz.cast(district()));
        case "SubDistrict":
            return Optional.ofNullable(clazz.cast(subDistrict()));
        case "PostalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        case "Block":
            return Optional.ofNullable(clazz.cast(block()));
        case "SubBlock":
            return Optional.ofNullable(clazz.cast(subBlock()));
        case "Intersection":
            return Optional.ofNullable(clazz.cast(intersection()));
        case "AddressNumber":
            return Optional.ofNullable(clazz.cast(addressNumber()));
        case "Building":
            return Optional.ofNullable(clazz.cast(building()));
        case "SecondaryAddressComponents":
            return Optional.ofNullable(clazz.cast(secondaryAddressComponents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Country", COUNTRY_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("SubRegion", SUB_REGION_FIELD);
        map.put("Locality", LOCALITY_FIELD);
        map.put("District", DISTRICT_FIELD);
        map.put("SubDistrict", SUB_DISTRICT_FIELD);
        map.put("PostalCode", POSTAL_CODE_FIELD);
        map.put("Block", BLOCK_FIELD);
        map.put("SubBlock", SUB_BLOCK_FIELD);
        map.put("Intersection", INTERSECTION_FIELD);
        map.put("AddressNumber", ADDRESS_NUMBER_FIELD);
        map.put("Building", BUILDING_FIELD);
        map.put("SecondaryAddressComponents", SECONDARY_ADDRESS_COMPONENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddressComponentMatchScores, T> g) {
        return obj -> g.apply((AddressComponentMatchScores) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddressComponentMatchScores> {
        /**
         * <p>
         * The alpha-2 or alpha-3 character code for the country that the results will be present in.
         * </p>
         * 
         * @param country
         *        The alpha-2 or alpha-3 character code for the country that the results will be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(Double country);

        /**
         * <p>
         * The region or state results should be to be present in.
         * </p>
         * <p>
         * Example: <code>North Rhine-Westphalia</code>.
         * </p>
         * 
         * @param region
         *        The region or state results should be to be present in. </p>
         *        <p>
         *        Example: <code>North Rhine-Westphalia</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(Double region);

        /**
         * <p>
         * The sub-region or county for which results should be present in.
         * </p>
         * 
         * @param subRegion
         *        The sub-region or county for which results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subRegion(Double subRegion);

        /**
         * <p>
         * The city or locality results should be present in.
         * </p>
         * <p>
         * Example: <code>Vancouver</code>.
         * </p>
         * 
         * @param locality
         *        The city or locality results should be present in. </p>
         *        <p>
         *        Example: <code>Vancouver</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locality(Double locality);

        /**
         * <p>
         * The district or division of a city the results should be present in.
         * </p>
         * 
         * @param district
         *        The district or division of a city the results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder district(Double district);

        /**
         * <p>
         * A subdivision of a district.
         * </p>
         * <p>
         * Example: <code>Minden-Lübbecke</code>
         * </p>
         * 
         * @param subDistrict
         *        A subdivision of a district. </p>
         *        <p>
         *        Example: <code>Minden-Lübbecke</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subDistrict(Double subDistrict);

        /**
         * <p>
         * An alphanumeric string included in a postal address to facilitate mail sorting, such as post code, postcode,
         * or ZIP code, for which the result should possess.
         * </p>
         * 
         * @param postalCode
         *        An alphanumeric string included in a postal address to facilitate mail sorting, such as post code,
         *        postcode, or ZIP code, for which the result should possess.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(Double postalCode);

        /**
         * <p>
         * Name of the block.
         * </p>
         * <p>
         * Example: <code>Sunny Mansion 203 block: 2 Chome</code>
         * </p>
         * 
         * @param block
         *        Name of the block. </p>
         *        <p>
         *        Example: <code>Sunny Mansion 203 block: 2 Chome</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder block(Double block);

        /**
         * <p>
         * Name of sub-block.
         * </p>
         * <p>
         * Example: <code>Sunny Mansion 203 sub-block: 4</code>
         * </p>
         * 
         * @param subBlock
         *        Name of sub-block. </p>
         *        <p>
         *        Example: <code>Sunny Mansion 203 sub-block: 4</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subBlock(Double subBlock);

        /**
         * <p>
         * Name of the streets in the intersection.
         * </p>
         * <p>
         * Example: <code>["Friedrichstraße","Unter den Linden"]</code>
         * </p>
         * 
         * @param intersection
         *        Name of the streets in the intersection. </p>
         *        <p>
         *        Example: <code>["Friedrichstraße","Unter den Linden"]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intersection(Collection<Double> intersection);

        /**
         * <p>
         * Name of the streets in the intersection.
         * </p>
         * <p>
         * Example: <code>["Friedrichstraße","Unter den Linden"]</code>
         * </p>
         * 
         * @param intersection
         *        Name of the streets in the intersection. </p>
         *        <p>
         *        Example: <code>["Friedrichstraße","Unter den Linden"]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intersection(Double... intersection);

        /**
         * <p>
         * The house number or address results should have.
         * </p>
         * 
         * @param addressNumber
         *        The house number or address results should have.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressNumber(Double addressNumber);

        /**
         * <p>
         * The name of the building at the address.
         * </p>
         * 
         * @param building
         *        The name of the building at the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder building(Double building);

        /**
         * <p>
         * Match scores for the secondary address components in the result.
         * </p>
         * 
         * @param secondaryAddressComponents
         *        Match scores for the secondary address components in the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryAddressComponents(Collection<SecondaryAddressComponentMatchScore> secondaryAddressComponents);

        /**
         * <p>
         * Match scores for the secondary address components in the result.
         * </p>
         * 
         * @param secondaryAddressComponents
         *        Match scores for the secondary address components in the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryAddressComponents(SecondaryAddressComponentMatchScore... secondaryAddressComponents);

        /**
         * <p>
         * Match scores for the secondary address components in the result.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.SecondaryAddressComponentMatchScore.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.SecondaryAddressComponentMatchScore#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.SecondaryAddressComponentMatchScore.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #secondaryAddressComponents(List<SecondaryAddressComponentMatchScore>)}.
         * 
         * @param secondaryAddressComponents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.SecondaryAddressComponentMatchScore.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondaryAddressComponents(java.util.Collection<SecondaryAddressComponentMatchScore>)
         */
        Builder secondaryAddressComponents(Consumer<SecondaryAddressComponentMatchScore.Builder>... secondaryAddressComponents);
    }

    static final class BuilderImpl implements Builder {
        private Double country;

        private Double region;

        private Double subRegion;

        private Double locality;

        private Double district;

        private Double subDistrict;

        private Double postalCode;

        private Double block;

        private Double subBlock;

        private List<Double> intersection = DefaultSdkAutoConstructList.getInstance();

        private Double addressNumber;

        private Double building;

        private List<SecondaryAddressComponentMatchScore> secondaryAddressComponents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddressComponentMatchScores model) {
            country(model.country);
            region(model.region);
            subRegion(model.subRegion);
            locality(model.locality);
            district(model.district);
            subDistrict(model.subDistrict);
            postalCode(model.postalCode);
            block(model.block);
            subBlock(model.subBlock);
            intersection(model.intersection);
            addressNumber(model.addressNumber);
            building(model.building);
            secondaryAddressComponents(model.secondaryAddressComponents);
        }

        public final Double getCountry() {
            return country;
        }

        public final void setCountry(Double country) {
            this.country = country;
        }

        @Override
        public final Builder country(Double country) {
            this.country = country;
            return this;
        }

        public final Double getRegion() {
            return region;
        }

        public final void setRegion(Double region) {
            this.region = region;
        }

        @Override
        public final Builder region(Double region) {
            this.region = region;
            return this;
        }

        public final Double getSubRegion() {
            return subRegion;
        }

        public final void setSubRegion(Double subRegion) {
            this.subRegion = subRegion;
        }

        @Override
        public final Builder subRegion(Double subRegion) {
            this.subRegion = subRegion;
            return this;
        }

        public final Double getLocality() {
            return locality;
        }

        public final void setLocality(Double locality) {
            this.locality = locality;
        }

        @Override
        public final Builder locality(Double locality) {
            this.locality = locality;
            return this;
        }

        public final Double getDistrict() {
            return district;
        }

        public final void setDistrict(Double district) {
            this.district = district;
        }

        @Override
        public final Builder district(Double district) {
            this.district = district;
            return this;
        }

        public final Double getSubDistrict() {
            return subDistrict;
        }

        public final void setSubDistrict(Double subDistrict) {
            this.subDistrict = subDistrict;
        }

        @Override
        public final Builder subDistrict(Double subDistrict) {
            this.subDistrict = subDistrict;
            return this;
        }

        public final Double getPostalCode() {
            return postalCode;
        }

        public final void setPostalCode(Double postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(Double postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final Double getBlock() {
            return block;
        }

        public final void setBlock(Double block) {
            this.block = block;
        }

        @Override
        public final Builder block(Double block) {
            this.block = block;
            return this;
        }

        public final Double getSubBlock() {
            return subBlock;
        }

        public final void setSubBlock(Double subBlock) {
            this.subBlock = subBlock;
        }

        @Override
        public final Builder subBlock(Double subBlock) {
            this.subBlock = subBlock;
            return this;
        }

        public final Collection<Double> getIntersection() {
            if (intersection instanceof SdkAutoConstructList) {
                return null;
            }
            return intersection;
        }

        public final void setIntersection(Collection<Double> intersection) {
            this.intersection = AddressComponentMatchScoresIntersectionListCopier.copy(intersection);
        }

        @Override
        public final Builder intersection(Collection<Double> intersection) {
            this.intersection = AddressComponentMatchScoresIntersectionListCopier.copy(intersection);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intersection(Double... intersection) {
            intersection(Arrays.asList(intersection));
            return this;
        }

        public final Double getAddressNumber() {
            return addressNumber;
        }

        public final void setAddressNumber(Double addressNumber) {
            this.addressNumber = addressNumber;
        }

        @Override
        public final Builder addressNumber(Double addressNumber) {
            this.addressNumber = addressNumber;
            return this;
        }

        public final Double getBuilding() {
            return building;
        }

        public final void setBuilding(Double building) {
            this.building = building;
        }

        @Override
        public final Builder building(Double building) {
            this.building = building;
            return this;
        }

        public final List<SecondaryAddressComponentMatchScore.Builder> getSecondaryAddressComponents() {
            List<SecondaryAddressComponentMatchScore.Builder> result = SecondaryAddressComponentMatchScoreListCopier
                    .copyToBuilder(this.secondaryAddressComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondaryAddressComponents(
                Collection<SecondaryAddressComponentMatchScore.BuilderImpl> secondaryAddressComponents) {
            this.secondaryAddressComponents = SecondaryAddressComponentMatchScoreListCopier
                    .copyFromBuilder(secondaryAddressComponents);
        }

        @Override
        public final Builder secondaryAddressComponents(Collection<SecondaryAddressComponentMatchScore> secondaryAddressComponents) {
            this.secondaryAddressComponents = SecondaryAddressComponentMatchScoreListCopier.copy(secondaryAddressComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryAddressComponents(SecondaryAddressComponentMatchScore... secondaryAddressComponents) {
            secondaryAddressComponents(Arrays.asList(secondaryAddressComponents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryAddressComponents(
                Consumer<SecondaryAddressComponentMatchScore.Builder>... secondaryAddressComponents) {
            secondaryAddressComponents(Stream.of(secondaryAddressComponents)
                    .map(c -> SecondaryAddressComponentMatchScore.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AddressComponentMatchScores build() {
            return new AddressComponentMatchScores(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
