/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of potential contact methods for the result/place.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Contacts implements SdkPojo, Serializable, ToCopyableBuilder<Contacts.Builder, Contacts> {
    private static final SdkField<List<ContactDetails>> PHONES_FIELD = SdkField
            .<List<ContactDetails>> builder(MarshallingType.LIST)
            .memberName("Phones")
            .getter(getter(Contacts::phones))
            .setter(setter(Builder::phones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContactDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ContactDetails>> FAXES_FIELD = SdkField
            .<List<ContactDetails>> builder(MarshallingType.LIST)
            .memberName("Faxes")
            .getter(getter(Contacts::faxes))
            .setter(setter(Builder::faxes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Faxes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContactDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ContactDetails>> WEBSITES_FIELD = SdkField
            .<List<ContactDetails>> builder(MarshallingType.LIST)
            .memberName("Websites")
            .getter(getter(Contacts::websites))
            .setter(setter(Builder::websites))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Websites").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContactDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ContactDetails>> EMAILS_FIELD = SdkField
            .<List<ContactDetails>> builder(MarshallingType.LIST)
            .memberName("Emails")
            .getter(getter(Contacts::emails))
            .setter(setter(Builder::emails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Emails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContactDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONES_FIELD, FAXES_FIELD,
            WEBSITES_FIELD, EMAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ContactDetails> phones;

    private final List<ContactDetails> faxes;

    private final List<ContactDetails> websites;

    private final List<ContactDetails> emails;

    private Contacts(BuilderImpl builder) {
        this.phones = builder.phones;
        this.faxes = builder.faxes;
        this.websites = builder.websites;
        this.emails = builder.emails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Phones property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPhones() {
        return phones != null && !(phones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of phone numbers for the results contact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhones} method.
     * </p>
     * 
     * @return List of phone numbers for the results contact.
     */
    public final List<ContactDetails> phones() {
        return phones;
    }

    /**
     * For responses, this returns true if the service returned a value for the Faxes property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasFaxes() {
        return faxes != null && !(faxes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of fax addresses for the result contact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFaxes} method.
     * </p>
     * 
     * @return List of fax addresses for the result contact.
     */
    public final List<ContactDetails> faxes() {
        return faxes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Websites property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWebsites() {
        return websites != null && !(websites instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of website URLs that belong to the result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWebsites} method.
     * </p>
     * 
     * @return List of website URLs that belong to the result.
     */
    public final List<ContactDetails> websites() {
        return websites;
    }

    /**
     * For responses, this returns true if the service returned a value for the Emails property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEmails() {
        return emails != null && !(emails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of emails for contacts of the result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEmails} method.
     * </p>
     * 
     * @return List of emails for contacts of the result.
     */
    public final List<ContactDetails> emails() {
        return emails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPhones() ? phones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFaxes() ? faxes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWebsites() ? websites() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEmails() ? emails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Contacts)) {
            return false;
        }
        Contacts other = (Contacts) obj;
        return hasPhones() == other.hasPhones() && Objects.equals(phones(), other.phones()) && hasFaxes() == other.hasFaxes()
                && Objects.equals(faxes(), other.faxes()) && hasWebsites() == other.hasWebsites()
                && Objects.equals(websites(), other.websites()) && hasEmails() == other.hasEmails()
                && Objects.equals(emails(), other.emails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Contacts").add("Phones", hasPhones() ? phones() : null)
                .add("Faxes", hasFaxes() ? faxes() : null).add("Websites", hasWebsites() ? websites() : null)
                .add("Emails", hasEmails() ? emails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Phones":
            return Optional.ofNullable(clazz.cast(phones()));
        case "Faxes":
            return Optional.ofNullable(clazz.cast(faxes()));
        case "Websites":
            return Optional.ofNullable(clazz.cast(websites()));
        case "Emails":
            return Optional.ofNullable(clazz.cast(emails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Phones", PHONES_FIELD);
        map.put("Faxes", FAXES_FIELD);
        map.put("Websites", WEBSITES_FIELD);
        map.put("Emails", EMAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Contacts, T> g) {
        return obj -> g.apply((Contacts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Contacts> {
        /**
         * <p>
         * List of phone numbers for the results contact.
         * </p>
         * 
         * @param phones
         *        List of phone numbers for the results contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phones(Collection<ContactDetails> phones);

        /**
         * <p>
         * List of phone numbers for the results contact.
         * </p>
         * 
         * @param phones
         *        List of phone numbers for the results contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phones(ContactDetails... phones);

        /**
         * <p>
         * List of phone numbers for the results contact.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.ContactDetails.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.geoplaces.model.ContactDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.ContactDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #phones(List<ContactDetails>)}.
         * 
         * @param phones
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.ContactDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phones(java.util.Collection<ContactDetails>)
         */
        Builder phones(Consumer<ContactDetails.Builder>... phones);

        /**
         * <p>
         * List of fax addresses for the result contact.
         * </p>
         * 
         * @param faxes
         *        List of fax addresses for the result contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faxes(Collection<ContactDetails> faxes);

        /**
         * <p>
         * List of fax addresses for the result contact.
         * </p>
         * 
         * @param faxes
         *        List of fax addresses for the result contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faxes(ContactDetails... faxes);

        /**
         * <p>
         * List of fax addresses for the result contact.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.ContactDetails.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.geoplaces.model.ContactDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.ContactDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #faxes(List<ContactDetails>)}.
         * 
         * @param faxes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.ContactDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faxes(java.util.Collection<ContactDetails>)
         */
        Builder faxes(Consumer<ContactDetails.Builder>... faxes);

        /**
         * <p>
         * List of website URLs that belong to the result.
         * </p>
         * 
         * @param websites
         *        List of website URLs that belong to the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websites(Collection<ContactDetails> websites);

        /**
         * <p>
         * List of website URLs that belong to the result.
         * </p>
         * 
         * @param websites
         *        List of website URLs that belong to the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websites(ContactDetails... websites);

        /**
         * <p>
         * List of website URLs that belong to the result.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.ContactDetails.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.geoplaces.model.ContactDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.ContactDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #websites(List<ContactDetails>)}.
         * 
         * @param websites
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.ContactDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #websites(java.util.Collection<ContactDetails>)
         */
        Builder websites(Consumer<ContactDetails.Builder>... websites);

        /**
         * <p>
         * List of emails for contacts of the result.
         * </p>
         * 
         * @param emails
         *        List of emails for contacts of the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emails(Collection<ContactDetails> emails);

        /**
         * <p>
         * List of emails for contacts of the result.
         * </p>
         * 
         * @param emails
         *        List of emails for contacts of the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emails(ContactDetails... emails);

        /**
         * <p>
         * List of emails for contacts of the result.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.ContactDetails.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.geoplaces.model.ContactDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.ContactDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #emails(List<ContactDetails>)}.
         * 
         * @param emails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.ContactDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emails(java.util.Collection<ContactDetails>)
         */
        Builder emails(Consumer<ContactDetails.Builder>... emails);
    }

    static final class BuilderImpl implements Builder {
        private List<ContactDetails> phones = DefaultSdkAutoConstructList.getInstance();

        private List<ContactDetails> faxes = DefaultSdkAutoConstructList.getInstance();

        private List<ContactDetails> websites = DefaultSdkAutoConstructList.getInstance();

        private List<ContactDetails> emails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Contacts model) {
            phones(model.phones);
            faxes(model.faxes);
            websites(model.websites);
            emails(model.emails);
        }

        public final List<ContactDetails.Builder> getPhones() {
            List<ContactDetails.Builder> result = ContactDetailsListCopier.copyToBuilder(this.phones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhones(Collection<ContactDetails.BuilderImpl> phones) {
            this.phones = ContactDetailsListCopier.copyFromBuilder(phones);
        }

        @Override
        public final Builder phones(Collection<ContactDetails> phones) {
            this.phones = ContactDetailsListCopier.copy(phones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phones(ContactDetails... phones) {
            phones(Arrays.asList(phones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phones(Consumer<ContactDetails.Builder>... phones) {
            phones(Stream.of(phones).map(c -> ContactDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ContactDetails.Builder> getFaxes() {
            List<ContactDetails.Builder> result = ContactDetailsListCopier.copyToBuilder(this.faxes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFaxes(Collection<ContactDetails.BuilderImpl> faxes) {
            this.faxes = ContactDetailsListCopier.copyFromBuilder(faxes);
        }

        @Override
        public final Builder faxes(Collection<ContactDetails> faxes) {
            this.faxes = ContactDetailsListCopier.copy(faxes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faxes(ContactDetails... faxes) {
            faxes(Arrays.asList(faxes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faxes(Consumer<ContactDetails.Builder>... faxes) {
            faxes(Stream.of(faxes).map(c -> ContactDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ContactDetails.Builder> getWebsites() {
            List<ContactDetails.Builder> result = ContactDetailsListCopier.copyToBuilder(this.websites);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWebsites(Collection<ContactDetails.BuilderImpl> websites) {
            this.websites = ContactDetailsListCopier.copyFromBuilder(websites);
        }

        @Override
        public final Builder websites(Collection<ContactDetails> websites) {
            this.websites = ContactDetailsListCopier.copy(websites);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder websites(ContactDetails... websites) {
            websites(Arrays.asList(websites));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder websites(Consumer<ContactDetails.Builder>... websites) {
            websites(Stream.of(websites).map(c -> ContactDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ContactDetails.Builder> getEmails() {
            List<ContactDetails.Builder> result = ContactDetailsListCopier.copyToBuilder(this.emails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmails(Collection<ContactDetails.BuilderImpl> emails) {
            this.emails = ContactDetailsListCopier.copyFromBuilder(emails);
        }

        @Override
        public final Builder emails(Collection<ContactDetails> emails) {
            this.emails = ContactDetailsListCopier.copy(emails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emails(ContactDetails... emails) {
            emails(Arrays.asList(emails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emails(Consumer<ContactDetails.Builder>... emails) {
            emails(Stream.of(emails).map(c -> ContactDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Contacts build() {
            return new Contacts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
